<?php
/**
 * Kipya functions and definitions.
 *
 * @link https://afiego.org
 *
 * @package Kipya
 */
set_time_limit(300); // Set to a higher value if needed
if ( ! function_exists( 'kipya_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 */
	function kipya_setup() {
		// Make the theme available for translation.
		load_theme_textdomain( 'kipya', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

        //Upload Logo in website.
        add_theme_support('custom-logo');

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable support for Post Thumbnails on posts and pages.
		add_theme_support( 'post-thumbnails' );


		// Register navigation menus.
		register_nav_menus( array(
			'primary'   => esc_html__( 'Primary Menu', 'kipya' ),
			'top-menu'  => esc_html__( 'Top Menu', 'kipya' ),
            'sidebar'   => esc_html__( 'Sidebar Menu', 'kipya' ),
            'footer'    => esc_html__( 'Footer Menu', 'kipya' ),
		) );

		// Switch default core markup for search form, comment form, and comments to output valid HTML5.
		add_theme_support( 'kipya', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'kipya_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

        /**
		 * Enable support for the following post formats:
		 * aside, gallery, quote, image, and video
		 */
        add_theme_support( 'post-formats', array( 'aside', 'gallery', 'quote', 'image', 'video' ) );
	}
endif;
add_action( 'after_setup_theme', 'kipya_setup' );

// Enqueue styles.
function kipya_styles() {
    wp_register_style('kipya-style', get_template_directory_uri() . '/style.css', array(), '1.0.0', 'all');
    wp_register_style('custom', get_template_directory_uri() . '/assets/css/custom.css', array(), '1.0.0', 'all');
    wp_register_style('bootstrap.min', get_template_directory_uri() . '/assets/vendor/bootstrap/css/bootstrap.min.css', array(), '5.3.2', 'all');
    wp_register_style('bootstrap-icons', get_template_directory_uri() . '/assets/vendor/bootstrap-icons/font/bootstrap-icons.min.css', array(), '1.11.3', 'all');
    wp_register_style('aos', get_template_directory_uri() . '/assets/vendor/aos/aos.css', array(), '2.3.4', 'all');
    wp_register_style('swiper', get_template_directory_uri() . '/assets/vendor/swiper/swiper.min.css', array(), '5.4.5', 'all');
    wp_register_style('toastr.min', get_template_directory_uri() . '/assets/vendor/toastr/toastr.min.css', array(), '2.1.3', 'all');
    wp_register_style('datatables.min', get_template_directory_uri() . '/assets/vendor/DataTables/datatables.min.css', array(), '1.13.3', 'all');



    wp_enqueue_style( 'kipya-style');
    wp_enqueue_style( 'custom');
    wp_enqueue_style( 'bootstrap.min');
    wp_enqueue_style( 'bootstrap-icons');
    wp_enqueue_style( 'aos');
    wp_enqueue_style( 'swiper');
    wp_enqueue_style( 'toastr.min');
    wp_enqueue_style( 'datatables.min');
}
add_action( 'wp_enqueue_scripts', 'kipya_styles' );

// Enqueue scripts.
function kipya_scripts() {

    wp_enqueue_script( 'bootstrap-script', get_template_directory_uri() . '/assets/vendor/bootstrap/js/bootstrap.bundle.min.js', array(), '4.5.2', 'all');
    wp_enqueue_script( 'aos-script', get_template_directory_uri() . '/assets/vendor/aos/aos.js', array(), '2.3.4', 'all');
    wp_enqueue_script( 'swiper-script', get_template_directory_uri() . '/assets/vendor/swiper/swiper.min.js', array(), '5.4.5', 'all');
    wp_enqueue_script( 'toastr-script', get_template_directory_uri() . '/assets/vendor/toastr/toastr.min.js', array(), '2.1.3', 'all');
    wp_enqueue_script( 'jquery-script', get_template_directory_uri() . '/assets/vendor/jquery/jquery-3.7.1.min.js', array( ), '3.7.1', 'all');
    wp_enqueue_script( 'kipya-script', get_template_directory_uri() . '/assets/js/main.js', array(), '1.0.0', 'all');
    wp_enqueue_script( 'search-script', get_template_directory_uri() . '/assets/js/search.js', array(), '1.0.0', 'all');
    wp_enqueue_script( 'datatables.min', get_template_directory_uri() . '/assets/vendor/DataTables/datatables.min.js', array(), '1.13.3', 'all');

function enqueue_glightbox() {
    wp_enqueue_script('glightbox', 'https://cdn.jsdelivr.net/npm/glightbox/dist/js/glightbox.min.js', array(), null, true);
    wp_enqueue_style('glightbox-css', 'https://cdn.jsdelivr.net/npm/glightbox/dist/css/glightbox.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_glightbox');


function force_gallery_links_to_media($block_content, $block) {
    if ($block['blockName'] === 'core/gallery' && !empty($block['innerBlocks'])) {
        foreach ($block['innerBlocks'] as &$innerBlock) {
            if ($innerBlock['blockName'] === 'core/image' && isset($innerBlock['attrs']['id'])) {
                $image_id = $innerBlock['attrs']['id'];
                $image_url = wp_get_attachment_url($image_id);
                if ($image_url) {
                    $innerBlock['attrs']['linkDestination'] = 'media';
                    $innerBlock['attrs']['href'] = $image_url;
                }
            }
        }
    }
    return $block_content;
}
add_filter('render_block', 'force_gallery_links_to_media', 10, 2);



    // Pass the ajaxurl to search.js
    wp_localize_script('search-script', 'kipya_ajax_object', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
    ));
}
//add_action( 'wp_enqueue_scripts', 'kipya_scripts' );
add_action('wp_footer','kipya_scripts');

// ligtbox-gallery
function enqueue_custom_scripts() {
    // Enqueue lightbox library
    wp_enqueue_style('lightbox-css', 'https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/css/lightbox.min.css');
    wp_enqueue_script('lightbox-js', 'https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/js/lightbox.min.js', array('jquery'), null, true);

    // Enqueue custom JavaScript
    wp_enqueue_script('custom-gallery-lightbox', get_template_directory_uri() . '/assets/js/gallery-lightbox.js', array('jquery'), null, true);

    // Enqueue custom AJAX script for projects page
    if (is_page('projects-page')) {
        wp_enqueue_script('custom-ajax-script', get_template_directory_uri() . '/assets/js/custom-ajax-script.js', array('jquery'), null, true);
        wp_localize_script('custom-ajax-script', 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));
    }
}
add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');

// If Dynamic Sidebar Exists
if (function_exists('register_sidebar'))
{
    // Define Sidebar Widget Area 1
    register_sidebar(array(
        'name' => __('Widget Area 1', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'widget-area-1',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));

    // Define Sidebar Widget Area 2
    register_sidebar(array(
        'name' => __('Widget Area 2', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'widget-area-2',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    
    register_sidebar( array(
        'name'          => esc_html__( 'Top Left', 'kipya' ),
        'id'            => 'topl',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Top Right', 'kipya' ),
        'id'            => 'topr',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Search Area', 'kipya' ),
        'id'            => 'searchi',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Quick Number', 'kipya' ),
        'id'            => 'inno',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Menu Right', 'kipya' ),
        'id'            => 'nav-right',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar(array(
        'name' => __('Services Sidebar', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'servsidebar',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    register_sidebar( array(
        'name'          => esc_html__( 'Advert Top', 'kipya' ),
        'id'            => 'advtop',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
     register_sidebar( array(
        'name'          => esc_html__( 'Newsletter', 'kipya' ),
        'id'            => 'footernewz',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Starter', 'kipya' ),
        'id'            => 'footeri',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer A', 'kipya' ),
        'id'            => 'footera',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer B', 'kipya' ),
        'id'            => 'footerb',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer C', 'kipya' ),
        'id'            => 'footerc',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer D', 'kipya' ),
        'id'            => 'footerd',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
     register_sidebar( array(
        'name'          => esc_html__( 'Copyright Links', 'kipya' ),
        'id'            => 'footer-links',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
}

//Activate Excerpt in PAGES
function enable_page_excerpts() {
    add_post_type_support('page', 'excerpt');
}
add_action('init', 'enable_page_excerpts');




//Custom BOOTSTRAP Menu 
include get_template_directory() . '/inc/bootstrap-5-wordpress-navbar-walker.php';
include get_template_directory() . '/inc/custom-nav-walker.php';

//Custom Post Type :: SEO / SEARCH / PAGE CATS
include get_template_directory() . '/inc/seo-post-types.php';
include get_template_directory() . '/inc/accordion.php';
include get_template_directory() . '/inc/ajax-search.php';
include get_template_directory() . '/inc/add_page_category.php';

//Custom Post Type :: SLIDING PHOTOS 
//include get_template_directory() . '/inc/slides-post-types.php';
include get_template_directory() . '/inc/text-slider-post-type.php';

//Custom Post Type :: UPCOMING EVENTS
include get_template_directory() . '/inc/upcoming-events-post-types.php';
include get_template_directory() . '/inc/more-upcoming-events.php';
include get_template_directory() . '/inc/past-events.php';

//Custom Post Type :: DOWNLOADS
include get_template_directory() . '/inc/downloads-post-types.php';

//Custom Post Type :: TEAMS
include get_template_directory() . '/inc/team-post-types.php';

//Custom Post Type :: PARTNERS
include get_template_directory() . '/inc/partners-post-types.php';

// Shortcode :: AOS
include get_template_directory() . '/inc/aos-animation.php'; 
include get_template_directory() . '/inc/breadcrumbs.php'; 

//ALL News Shortcode
include get_template_directory() . '/inc/news_front.php'; 


//ALL Beaute Sauvage Safaris Shortcodes
include get_template_directory() . '/inc/beaute-home-shortcode.php';
include get_template_directory() . '/inc/beaute-sauvage-affiliations.php';
include get_template_directory() . '/inc/beaute-sauvage-overview.php';
include get_template_directory() . '/inc/airticketing.php';
include get_template_directory() . '/inc/visa_support_posttype.php';
include get_template_directory() . '/inc/visa-content.php';
// include get_template_directory() . '/inc/destinations-detail.php';
// include get_template_directory() . '/inc/travelportal-packages.php';
include get_template_directory() . '/inc/destinations-shortcode.php';
// include get_template_directory() . '/inc/destinations-posts.php';
include get_template_directory() . '/inc/travelportal-testimonials.php';
include get_template_directory() . '/inc/travel-packages-shortcode.php';
include get_template_directory() . '/inc/romantic_packages.php';



//Duplicate Pages
include get_template_directory() . '/inc/duplicate-page.php'; 

//ALL Associates Shortcode
include get_template_directory() . '/inc/all_partners-page.php'; 

//ALL Publications Shortcode
include get_template_directory() . '/inc/home-pubs-shortcode.php'; 

//ALL Contact Form
include get_template_directory() . '/inc/contact-form.php'; 
include get_template_directory() . '/inc/all-gallery-shortcode.php';

//ALL Single Gallery Shortcode
function load_custom_single_template($template) {
    if (is_single() && in_category('photo-gallery')) {
        $new_template = locate_template(array('single-gallery.php'));
        if ($new_template) {
            return $new_template;
        }
    }
    if (is_singular('events')) {
        $eve_template = locate_template(array('single-event.php'));
        if ($eve_template) {
            return $eve_template;
        }
    }
    return $template;
}
add_filter('single_template', 'load_custom_single_template');

// //FORM PROCESSOR
// include get_template_directory() . '/inc/process-form.php'; 

//BACK BUTTON (previous page)
add_action( 'back_button', 'kipya_back_button' );
function kipya_back_button() {
    if ( wp_get_referer() ) {
        $back_text = __( '&laquo; BACK' );
        $button    = "\n<button id='my-back-button' class='btn button my-back-button' onclick='javascript:history.back()'>$back_text</button>";
        echo ( $button );
    }
}

// Pagination for paged posts, Page 1, Page 2, Page 3, with Next and Previous Links, No plugin
function html5wp_pagination()
{
    global $wp_query;
    $big = 999999999;
    echo paginate_links(array(
        'base' => str_replace($big, '%#%', get_pagenum_link($big)),
        'format' => '?paged=%#%',
        'current' => max(1, get_query_var('paged')),
        'total' => $wp_query->max_num_pages
    ));
}
function enqueue_datatables_assets() {
    wp_enqueue_style('datatables-css', 'https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css');
    wp_enqueue_script('datatables-js', 'https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_datatables_assets');

// Custom Excerpts
function html5wp_index($length) // Create 20 Word Callback for Index page Excerpts, call using html5wp_excerpt('html5wp_index');
{
    return 50;
}

// Create 40 Word Callback for Custom Post Excerpts, call using html5wp_excerpt('html5wp_custom_post');
function html5wp_custom_post($length)
{
    return 50;
}

//Allow upload of SVG Images
function enable_svg_support($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'enable_svg_support');

// Create the Custom Excerpts callback
function html5wp_excerpt($length_callback = '', $more_callback = '')
{
    global $post;
    if (function_exists($length_callback)) {
        add_filter('excerpt_length', $length_callback);
    }
    if (function_exists($more_callback)) {
        add_filter('excerpt_more', $more_callback);
    }
    $output = get_the_excerpt();
    $output = apply_filters('wptexturize', $output);
    $output = apply_filters('convert_chars', $output);
    $output = '<p>' . $output . '</p>';
    echo $output;
}

// Custom View Article link to Post
function html5_blank_view_article($more)
{
    global $post;
    return '... <a class="view-article" href="' . get_permalink($post->ID) . '">' . __('Read More', 'kipya') . '</a>';
}

// Remove Admin bar
function remove_admin_bar() {
    return false;
}
add_filter('show_admin_bar', 'remove_admin_bar');

// Remove 'text/css' from our enqueued stylesheet
function html5_style_remove($tag)
{
    return preg_replace('~\s+type=["\'][^"\']++["\']~', '', $tag);
}

function enqueue_destination_styles() {
    wp_enqueue_style(
        'destination-custom-css',
        get_stylesheet_directory_uri() . '/assets/css/custom.css',
        array(),
        filemtime(get_stylesheet_directory() . '/assets/css/custom.css')
    );
}
add_action('wp_enqueue_scripts', 'enqueue_destination_styles');

add_filter('single_template', function($template) {
    global $post;
    if ($post->post_type === 'destination') {
        return locate_template('single-destination.php');
    }
    return $template;
});


// Remove thumbnail width and height dimensions that prevent fluid images in the_thumbnail
function remove_thumbnail_dimensions( $html )
{
    $html = preg_replace('/(width|height)=\"\d*\"\s/', "", $html);
    return $html;
}
function load_bootstrap_icons_footer() {
    ?>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" type="text/css" />
    <?php
}
add_action('wp_footer', 'load_bootstrap_icons_footer');



/**
 * Redirect both romantic_package and travel_package post types to use single-package.php template
 */
function load_custom_package_template($template) {
    global $post;
    
    // Check if we're viewing a single post of either package type
    if ($post && in_array($post->post_type, ['romantic_package', 'travel_package'])) {
        // Look for single-package.php in the active theme
        $custom_template = locate_template('single-package.php');
        
        if ($custom_template) {
            return $custom_template;
        }
    }
    
    return $template;
}
add_filter('template_include', 'load_custom_package_template');


function flush_package_rewrite_rules() {
    // Only flush if we haven't done it recently
    if (get_option('package_templates_flushed') !== '1') {
        flush_rewrite_rules();
        update_option('package_templates_flushed', '1');
    }
}
add_action('init', 'flush_package_rewrite_rules', 999);




// 1. Create database table
if (!function_exists('create_package_bookings_table')) {
    function create_package_bookings_table() {
        global $wpdb;
        
        $table_name = $wpdb->prefix . 'package_bookings';
        
        $charset_collate = $wpdb->get_charset_collate();
        
        $sql = "CREATE TABLE $table_name (
            id mediumint(9) NOT NULL AUTO_INCREMENT,
            package_id varchar(20),
            package_name varchar(255),
            customer_name varchar(255) NOT NULL,
            customer_email varchar(100) NOT NULL,
            customer_phone varchar(20) NOT NULL,
            customer_dob date NOT NULL,
            num_adults int(3) NOT NULL,
            num_children int(3) DEFAULT 0,
            departure_date date NOT NULL,
            budget_preference varchar(50) NOT NULL,
            special_requests text,
            status varchar(20) DEFAULT 'pending',
            created_at datetime DEFAULT CURRENT_TIMESTAMP,
            PRIMARY KEY (id)
        ) $charset_collate;";
        
        require_once(ABSPATH . 'wp-admin/includes/upgrade.php');
        dbDelta($sql);
    }
}

// Create table if it doesn't exist
function init_package_bookings_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'package_bookings';
    if($wpdb->get_var("SHOW TABLES LIKE '$table_name'") != $table_name) {
        create_package_bookings_table();
    }
}
add_action('init', 'init_package_bookings_table');

// 2. Handle AJAX form submission
function handle_package_booking_submission() {
    // Verify nonce for security
    if (!wp_verify_nonce($_POST['booking_nonce'], 'package_booking_nonce')) {
        wp_send_json(['success' => false, 'data' => 'Security check failed']);
        wp_die();
    }
    
    global $wpdb;
    $table_name = $wpdb->prefix . 'package_bookings';
    
    // Sanitize form data
    $package_id = sanitize_text_field($_POST['package_id']);
    $package_name = sanitize_text_field($_POST['package_name']);
    $customer_name = sanitize_text_field($_POST['customer_name']);
    $customer_email = sanitize_email($_POST['customer_email']);
    $customer_phone = sanitize_text_field($_POST['customer_phone']);
    $customer_dob = sanitize_text_field($_POST['customer_dob']);
    $num_adults = intval($_POST['num_adults']);
    $num_children = intval($_POST['num_children']);
    $departure_date = sanitize_text_field($_POST['departure_date']);
    $budget_preference = sanitize_text_field($_POST['budget_preference']);
    $special_requests = sanitize_textarea_field($_POST['special_requests']);
    
    // Validate required fields
    if (empty($customer_name) || empty($customer_email) || empty($customer_phone) || 
        empty($customer_dob) || empty($departure_date) || empty($budget_preference)) {
        wp_send_json(['success' => false, 'data' => 'Please fill in all required fields']);
        wp_die();
    }
    
    // Insert into database
    $result = $wpdb->insert(
        $table_name,
        [
            'package_id' => $package_id,
            'package_name' => $package_name,
            'customer_name' => $customer_name,
            'customer_email' => $customer_email,
            'customer_phone' => $customer_phone,
            'customer_dob' => $customer_dob,
            'num_adults' => $num_adults,
            'num_children' => $num_children,
            'departure_date' => $departure_date,
            'budget_preference' => $budget_preference,
            'special_requests' => $special_requests,
            'status' => 'pending'
        ],
        [
            '%s', '%s', '%s', '%s', '%s', '%s', '%d', '%d', '%s', '%s', '%s', '%s'
        ]
    );
    
    if ($result !== false) {
        // Send notification email
        $admin_email = get_option('admin_email');
        $subject = 'New Package Booking: ' . $package_name;
        $body = "New package booking received:\n\n";
        $body .= "Package: $package_name (ID: $package_id)\n";
        $body .= "Customer: $customer_name\n";
        $body .= "Email: $customer_email\n";
        $body .= "Phone: $customer_phone\n";
        $body .= "Date of Birth: $customer_dob\n";
        $body .= "Adults: $num_adults\n";
        $body .= "Children: $num_children\n";
        $body .= "Departure Date: $departure_date\n";
        $body .= "Budget: $budget_preference\n";
        $body .= "Special Requests: $special_requests\n\n";
        $body .= "View all bookings: " . admin_url('admin.php?page=package-bookings');
        
        wp_mail($admin_email, $subject, $body);
        
        wp_send_json(['success' => true, 'data' => 'Booking submitted successfully! We will contact you soon.']);
    } else {
        wp_send_json(['success' => false, 'data' => 'Database error occurred. Please try again.']);
    }
    
    wp_die();
}

// Register AJAX handlers
add_action('wp_ajax_submit_package_booking', 'handle_package_booking_submission');
add_action('wp_ajax_nopriv_submit_package_booking', 'handle_package_booking_submission');

// 3. Add admin menu
function add_package_bookings_admin_menu() {
    add_menu_page(
        'Bookings',                    // Page title
        'Bookings',                    // Menu title
        'manage_options',              // Capability
        'package-bookings',            // Menu slug
        'package_bookings_admin_page', // Function
        'dashicons-calendar-alt',      // Icon
        30                            // Position
    );
}
add_action('admin_menu', 'add_package_bookings_admin_menu');

// 4. Admin page content
function package_bookings_admin_page() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'package_bookings';
    
    // Handle status updates
    if (isset($_POST['update_status']) && isset($_POST['booking_id']) && isset($_POST['new_status'])) {
        $booking_id = intval($_POST['booking_id']);
        $new_status = sanitize_text_field($_POST['new_status']);
        
        $wpdb->update(
            $table_name,
            ['status' => $new_status],
            ['id' => $booking_id],
            ['%s'],
            ['%d']
        );
        
        echo '<div class="notice notice-success"><p>Booking status updated!</p></div>';
    }
    
    // Handle booking deletion
    if (isset($_GET['delete']) && wp_verify_nonce($_GET['_wpnonce'], 'delete_booking_' . $_GET['delete'])) {
        $booking_id = intval($_GET['delete']);
        $wpdb->delete($table_name, ['id' => $booking_id], ['%d']);
        echo '<div class="notice notice-success"><p>Booking deleted!</p></div>';
    }
    
    // Get all bookings with search functionality
    $search = isset($_GET['s']) ? sanitize_text_field($_GET['s']) : '';
    $where_clause = '';
    if (!empty($search)) {
        $where_clause = $wpdb->prepare(" WHERE customer_name LIKE %s OR customer_email LIKE %s OR package_name LIKE %s", 
            '%' . $search . '%', '%' . $search . '%', '%' . $search . '%');
    }
    
    $bookings = $wpdb->get_results("SELECT * FROM $table_name $where_clause ORDER BY created_at DESC");
    $total_bookings = count($bookings);
    ?>
    
    <div class="wrap">
        <h1>Package Bookings Management 
            <span class="subtitle">(<?php echo $total_bookings; ?> total)</span>
        </h1>
        
        <!-- Search Form -->
        <div class="tablenav top">
            <form method="get" style="float: right;">
                <input type="hidden" name="page" value="package-bookings">
                <input type="text" name="s" value="<?php echo esc_attr($search); ?>" placeholder="Search bookings...">
                <input type="submit" class="button" value="Search">
                <?php if (!empty($search)): ?>
                    <a href="<?php echo admin_url('admin.php?page=package-bookings'); ?>" class="button">Clear</a>
                <?php endif; ?>
            </form>
            <div class="clear"></div>
        </div>
        
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th style="width: 40px;">ID</th>
                    <th>Customer</th>
                    <th>Contact</th>
                    <th>Package</th>
                    <th>Travel Details</th>
                    <th>Budget</th>
                    <th>Status</th>
                    <th>Submitted</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php if ($bookings): ?>
                    <?php foreach ($bookings as $booking): ?>
                        <tr>
                            <td><?php echo $booking->id; ?></td>
                            <td>
                                <strong><?php echo esc_html($booking->customer_name); ?></strong><br>
                                <small>DOB: <?php echo date('M j, Y', strtotime($booking->customer_dob)); ?></small>
                            </td>
                            <td>
                                <a href="mailto:<?php echo esc_attr($booking->customer_email); ?>"><?php echo esc_html($booking->customer_email); ?></a><br>
                                <small><?php echo esc_html($booking->customer_phone); ?></small>
                            </td>
                            <td>
                                <strong><?php echo esc_html($booking->package_name); ?></strong><br>
                                <small>ID: <?php echo esc_html($booking->package_id); ?></small>
                            </td>
                            <td>
                                <strong>Departure:</strong> <?php echo date('M j, Y', strtotime($booking->departure_date)); ?><br>
                                <strong>Travelers:</strong> <?php echo $booking->num_adults; ?> Adult(s)
                                <?php if ($booking->num_children > 0): ?>
                                    + <?php echo $booking->num_children; ?> Child(ren)
                                <?php endif; ?>
                            </td>
                            <td>
                                <span class="budget-<?php echo strtolower($booking->budget_preference); ?>">
                                    <?php echo esc_html($booking->budget_preference); ?>
                                </span>
                            </td>
                            <td>
                                <form method="post" style="margin: 0;">
                                    <input type="hidden" name="booking_id" value="<?php echo $booking->id; ?>">
                                    <select name="new_status" onchange="this.form.submit()" style="width: 100px;">
                                        <option value="pending" <?php selected($booking->status, 'pending'); ?>>Pending</option>
                                        <option value="confirmed" <?php selected($booking->status, 'confirmed'); ?>>Confirmed</option>
                                        <option value="cancelled" <?php selected($booking->status, 'cancelled'); ?>>Cancelled</option>
                                        <option value="completed" <?php selected($booking->status, 'completed'); ?>>Completed</option>
                                    </select>
                                    <input type="hidden" name="update_status" value="1">
                                </form>
                            </td>
                            <td><?php echo date('M j, Y<\b\\r>g:i A', strtotime($booking->created_at)); ?></td>
                            <td>
                                <a href="#" onclick="showBookingDetails(<?php echo htmlspecialchars(json_encode($booking), ENT_QUOTES, 'UTF-8'); ?>)" class="button button-small">View</a><br>
                                <a href="<?php echo wp_nonce_url(admin_url('admin.php?page=package-bookings&delete=' . $booking->id), 'delete_booking_' . $booking->id); ?>" 
                                   onclick="return confirm('Are you sure you want to delete this booking?')" class="button button-small" style="margin-top: 2px;">Delete</a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr><td colspan="9" style="text-align: center; padding: 20px;">
                        <?php echo !empty($search) ? 'No bookings found matching your search.' : 'No bookings found.'; ?>
                    </td></tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Booking Details Modal -->
    <div id="booking-modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.8); z-index: 9999;">
        <div style="position: absolute; top: 50%; left: 50%; transform: translate(-50%, -50%); background: white; padding: 30px; border-radius: 8px; max-width: 600px; width: 90%; max-height: 80%; overflow-y: auto;">
            <h2 style="margin-top: 0;">Booking Details</h2>
            <div id="booking-details-content"></div>
            <div style="text-align: right; margin-top: 20px;">
                <button onclick="document.getElementById('booking-modal').style.display='none'" class="button button-primary">Close</button>
            </div>
        </div>
    </div>
    
    <style>
    .budget-budget { color: #28a745; }
    .budget-standard { color: #007cba; }
    .budget-premium { color: #dc3545; }
    .budget-luxury { color: #6f42c1; font-weight: bold; }
    </style>
    
    <script>
    function showBookingDetails(booking) {
        const formatDate = (dateStr) => {
            if (!dateStr) return 'N/A';
            const date = new Date(dateStr);
            return date.toLocaleDateString('en-US', { year: 'numeric', month: 'long', day: 'numeric' });
        };
        
        const content = `
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
                <div>
                    <h3>Customer Information</h3>
                    <p><strong>Name:</strong> ${booking.customer_name}</p>
                    <p><strong>Email:</strong> <a href="mailto:${booking.customer_email}">${booking.customer_email}</a></p>
                    <p><strong>Phone:</strong> ${booking.customer_phone}</p>
                    <p><strong>Date of Birth:</strong> ${formatDate(booking.customer_dob)}</p>
                    
                    <h3>Travel Details</h3>
                    <p><strong>Departure Date:</strong> ${formatDate(booking.departure_date)}</p>
                    <p><strong>Adults:</strong> ${booking.num_adults}</p>
                    <p><strong>Children:</strong> ${booking.num_children}</p>
                    <p><strong>Budget Preference:</strong> <span class="budget-${booking.budget_preference.toLowerCase()}">${booking.budget_preference}</span></p>
                </div>
                <div>
                    <h3>Package Information</h3>
                    <p><strong>Package Name:</strong> ${booking.package_name}</p>
                    <p><strong>Package ID:</strong> ${booking.package_id}</p>
                    
                    <h3>Booking Status</h3>
                    <p><strong>Status:</strong> ${booking.status.charAt(0).toUpperCase() + booking.status.slice(1)}</p>
                    <p><strong>Submitted:</strong> ${formatDate(booking.created_at)}</p>
                </div>
            </div>
            ${booking.special_requests ? `
                <div style="margin-top: 20px;">
                    <h3>Special Requests</h3>
                    <p style="background: #f9f9f9; padding: 15px; border-radius: 4px; border-left: 4px solid #007cba;">${booking.special_requests}</p>
                </div>
            ` : ''}
        `;
        document.getElementById('booking-details-content').innerHTML = content;
        document.getElementById('booking-modal').style.display = 'block';
    }
    
    // Close modal when clicking outside
    document.getElementById('booking-modal').addEventListener('click', function(e) {
        if (e.target === this) {
            this.style.display = 'none';
        }
    });
    </script>
    <?php
}
?>