<?php
/**
 * Template Name: Single Tour Package
 * Template Post Type: tour_package
 */

get_header(); 
include get_template_directory() . '/inc/menus/menu.php'; 

function render_inclusions_exclusions($items, $default_items = []) {
    if (!empty($items) && is_array($items)) {
        echo '<ul class="inclusions-exclusions-list">';
        foreach ($items as $item) {
            if (!empty($item['item'])) {
                echo '<li>' . esc_html($item['item']) . '</li>';
            }
        }
        echo '</ul>';
    } elseif (!empty($default_items)) {
        echo '<ul class="inclusions-exclusions-list">';
        foreach ($default_items as $item) {
            echo '<li>' . esc_html($item) . '</li>';
        }
        echo '</ul>';
    }
}


// -------------------
// Fetch post meta
// -------------------
$post_id = get_the_ID();
$duration       = get_post_meta($post_id, '_package_duration', true);
$destination    = get_post_meta($post_id, '_destination', true);
$price_adult    = get_post_meta($post_id, '_package_price_adult', true);
$price_child    = get_post_meta($post_id, '_package_price_child', true);
$price_ugandan  = get_post_meta($post_id, '_package_price_ugandan', true);
$discount       = get_post_meta($post_id, '_package_discount', true);
$itinerary      = get_post_meta($post_id, '_package_itinerary', true);
$inclusions     = get_post_meta($post_id, '_package_inclusions', true);
$exclusions     = get_post_meta($post_id, '_package_exclusions', true);
$contact_email  = get_post_meta($post_id, '_contact_email', true);
$contact_phone  = get_post_meta($post_id, '_contact_phone', true);
$bank_name      = get_post_meta($post_id, '_bank_name', true);
$account_name   = get_post_meta($post_id, '_account_name', true);
$account_number = get_post_meta($post_id, '_account_number', true);
$swift_code     = get_post_meta($post_id, '_swift_code', true);
$address        = get_post_meta($post_id, '_address', true);
$featured_image = get_the_post_thumbnail_url($post_id, 'full');

// Debug: Check what's actually stored in the inclusions/exclusions
// Remove these debug lines after testing
// echo "<!-- Inclusions raw: " . htmlspecialchars($inclusions) . " -->";
// echo "<!-- Exclusions raw: " . htmlspecialchars($exclusions) . " -->";
?>

<div class="explore-uganda-single-package">
    <?php while (have_posts()) : the_post(); ?>

    <!-- Hero Section -->
    <section class="package-hero">
        <img src="<?php echo $featured_image ? esc_url($featured_image) : 'https://via.placeholder.com/1200x400/006b3e/ffffff?text=' . urlencode(get_the_title()); ?>" alt="<?php the_title(); ?>" class="package-hero-image">
        <div class="hero-overlay">
            <div class="hero-content">
                <h1><?php the_title(); ?></h1>
                <div class="trip-meta">
                    <?php if($duration): ?><span>⏱ <?php echo esc_html($duration); ?></span><?php endif; ?>
                    <?php if($destination): ?><span>📍 <?php echo esc_html($destination); ?></span><?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    <div class="package-content">
        <div class="package-main">

            <!-- Overview Section -->
            <section class="package-section">
                <h2>Overview</h2>
                <div class="overview-content">
                    <?php the_content(); ?>
                </div>
            </section>

            <!-- Itinerary Section -->
            <?php if(!empty($itinerary) && is_array($itinerary)): ?>
            <section class="package-section">
                <h2>Itinerary</h2>
                <?php 
                $day_count = 0;
                foreach($itinerary as $index => $day): 
                    $day_count++;
                    if (empty($day['title']) && empty($day['description'])) continue;
                ?>
                <div class="itinerary-day">
                    <h3>Day <?php echo $day_count; ?>: <?php echo !empty($day['title']) ? esc_html($day['title']) : 'Day ' . $day_count; ?></h3>
                    <div class="day-content">
                        <?php if(!empty($day['description'])): ?>
                        <p><?php echo nl2br(esc_html($day['description'])); ?></p>
                        <?php endif; ?>
                        <?php if(!empty($day['meals'])): ?>
                        <p><strong>Meals:</strong> <?php echo esc_html($day['meals']); ?></p>
                        <?php endif; ?>
                        <?php if(!empty($day['accommodation'])): ?>
                        <p><strong>Accommodation:</strong> <?php echo esc_html($day['accommodation']); ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </section>
            <?php endif; ?>

            <!-- Inclusions & Exclusions -->
            <section class="package-section">
                <h2>What's Included</h2>
                <div class="includes-excludes">

                    <div class="includes">
                        <h3>Inclusions</h3>
                        <?php 
                            render_inclusions_exclusions(
                                $inclusions,
                                [
                                    
                                    'Professional English-speaking guide',
                                    'All transportation in suitable vehicle',
                                    'All entry fees',
                                    'Drinking water throughout the tour'
                                ]
                            );
                            ?>

                    </div>

                    <div class="excludes">
                        <h3>Exclusions</h3>
                        <?php 
                            render_inclusions_exclusions(
                                $exclusions,
                                [
                                    'International flights and visas',
                                    'Travel insurance',
                                    'Personal expenses (souvenirs, drinks, etc.)',
                                    'Tips for guides and drivers',
                                    'Optional activities not mentioned in itinerary'
                                ]
                            );
                            ?>
            
                    </div>

                </div>
            </section>
        </div>

        <div class="package-sidebar">
            <!-- Contact Details -->
            <?php if($contact_email || $contact_phone || $address): ?>
            <section class="package-section contact-details">
                <h2>Contact Information</h2>
                <div class="contact-info">
                    <?php if($address): ?><p><strong>Address:</strong> <?php echo esc_html($address); ?></p><?php endif; ?>
                    <?php if($contact_email): ?><p><strong>Email:</strong> <a href="mailto:<?php echo esc_attr($contact_email); ?>"><?php echo esc_html($contact_email); ?></a></p><?php endif; ?>
                    <?php if($contact_phone): ?><p><strong>Phone:</strong> <a href="tel:<?php echo esc_attr($contact_phone); ?>"><?php echo esc_html($contact_phone); ?></a></p><?php endif; ?>
                </div>
                
            </section>
            <?php endif; ?>
            
            <!-- Pricing Section (Button) -->
            <section class="package-section pricing-section">
                <h2>Pricing Information</h2>
                <p>Click the button below to view detailed pricing information for this tour package.</p>
                
                <button type="button" class="see-pricing-btn" id="seePricingBtn">
                    See Pricing
                </button>
            </section>
            
            <!-- Payment Details -->
            <section class="package-section payment-details">
                <h2>Payment Information</h2>
                <p>To secure your booking, a deposit of 50% is required. The balance is due 30 days before your travel date.</p>
                
                <?php if($bank_name || $account_number || $account_name): ?>
                <div class="bank-details">
                    <h3>Bank Transfer</h3>
                    <?php if($bank_name): ?><p><strong>Bank:</strong> <?php echo esc_html($bank_name); ?></p><?php endif; ?>
                    <?php if($account_name): ?><p><strong>Account Name:</strong> <?php echo esc_html($account_name); ?></p><?php endif; ?>
                    <?php if($account_number): ?><p><strong>Account Number:</strong> <?php echo esc_html($account_number); ?></p><?php endif; ?>
                    <?php if($swift_code): ?><p><strong>SWIFT Code:</strong> <?php echo esc_html($swift_code); ?></p><?php endif; ?>
                </div>
                <?php endif; ?>
            </section>
        </div>
    </div>

    <?php endwhile; ?>
</div>

<!-- Pricing Popup Modal -->
<div id="pricingPopup" class="pricing-popup">
    <div class="pricing-popup-content">
        <span class="close-popup">&times;</span>
        <h2>Pricing Details</h2>
        
        <table class="price-table">
            <tr><th>Category </th><th>Price (Per person)</th></tr>
            <?php if($price_adult): ?><tr><td>Non Ugandan </td><td><?php echo esc_html($price_adult); ?></td></tr><?php endif; ?>
            <?php if($price_ugandan): ?><tr><td>Ugandan </td><td><?php echo esc_html($price_ugandan); ?></td></tr><?php endif; ?>
            <?php if($price_child): ?><tr><td> Child</td><td><?php echo esc_html($price_child); ?></td></tr><?php endif; ?>
        </table>

        <?php if(!empty($discount)): ?>
        <div class="discount-banner">
            <strong>Special Offer: <?php echo esc_html($discount); ?>% Discount</strong>
        </div>
        <?php endif; ?>
        
        <div class="popup-contact-info">
            <p>Contact us on:</p>
            <?php if($contact_email): ?><p><strong>Email:</strong> <?php echo esc_html($contact_email); ?></p><?php endif; ?>
            <?php if($contact_phone): ?><p><strong>Phone:</strong> <?php echo esc_html($contact_phone); ?></p><?php endif; ?>
        </div>
    </div>
</div>

<style>
/* Pricing Popup Styles */
.pricing-popup{display:none;position:fixed;z-index:1000;left:0;top:0;width:100%;height:100%;background-color:rgba(0,0,0,0.5)}
.pricing-popup-content{background-color:#fefefe;margin:5% auto;padding:30px;border-radius:8px;width:90%;max-width:500px;position:relative;box-shadow:0 4px 8px rgba(0,0,0,0.2)}
.close-popup{color:#aaa;float:right;font-size:28px;font-weight:bold;cursor:pointer;line-height:1}.close-popup:hover{color:#000}
.see-pricing-btn{background-color:var(--kpy-secondary);color:#fff;border:none;padding:12px 24px;border-radius:4px;cursor:pointer;font-size:16px;font-weight:bold;width:100%;transition:background-color .3s}
.see-pricing-btn:hover{background-color:var(--kpy-primary)}
.price-table{width:100%;border-collapse:collapse;margin:20px 0}
.price-table th,.price-table td{border:1px solid #ddd;padding:12px;text-align:left}.price-table th{background-color:#f5f5f5;font-weight:bold}
.discount-banner{background-color:#ffeb3b;color:#333;padding:10px;border-radius:4px;text-align:center;margin:15px 0}
.popup-contact-info{margin-top:20px;padding-top:20px;border-top:1px solid #eee}


</style>

<script>
jQuery(document).ready(function($) {
    // Itinerary accordion
    $('.itinerary-day h3').click(function() {
        $('.itinerary-day h3').not(this).removeClass('active');
        $('.itinerary-day .day-content').not($(this).next()).slideUp();
        $(this).toggleClass('active');
        $(this).next('.day-content').slideToggle();
    });
    $('.itinerary-day:first-child h3').addClass('active');
    $('.itinerary-day:first-child .day-content').slideDown();

    // Pricing popup functionality
    var pricingPopup = $('#pricingPopup');
    var seePricingBtn = $('#seePricingBtn');
    var closePopup = $('.close-popup');

    // Open popup
    seePricingBtn.click(function() {
        pricingPopup.fadeIn(300);
    });

    // Close popup
    closePopup.click(function() {
        pricingPopup.fadeOut(300);
    });

    // Close when clicking outside popup content
    $(window).click(function(event) {
        if ($(event.target).is(pricingPopup)) {
            pricingPopup.fadeOut(300);
        }
    });

    // Close with ESC key
    $(document).keyup(function(e) {
        if (e.keyCode === 27) {
            pricingPopup.fadeOut(300);
        }
    });
});
</script>

<?php get_footer(); ?>