<?php
// ==============================================
// EXPLORE UGANDA TOUR PACKAGES PLUGIN 
// ==============================================

// 1️⃣ Register the Custom Post Type
function explore_uganda_register_package_cpt() {
    $labels = array(
        'name'               => 'Tour Packages',
        'singular_name'      => 'Tour Package',
        'menu_name'          => 'Tour Packages',
        'name_admin_bar'     => 'Tour Package',
        'add_new'            => 'Add New Package',
        'add_new_item'       => 'Add New Tour Package',
        'new_item'           => 'New Tour Package',
        'edit_item'          => 'Edit Tour Package',
        'view_item'          => 'View Tour Package',
        'all_items'          => 'All Tour Packages',
        'search_items'       => 'Search Tour Packages',
        'not_found'          => 'No packages found',
        'not_found_in_trash' => 'No packages found in trash',
        'featured_image'     => 'Package Image',
        'set_featured_image' => 'Set package image',
        'remove_featured_image' => 'Remove package image',
        'use_featured_image' => 'Use as package image'
    );

    $args = array(
        'labels'             => $labels,
        'public'             => true,
        'publicly_queryable' => true,
        'show_ui'            => true,
        'show_in_menu'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'travel-packages', 'with_front' => false),
        'has_archive'        => true,
        'hierarchical'       => false,
        'menu_position'      => 20,
        'supports'           => array('title', 'editor', 'thumbnail', 'excerpt', 'custom-fields'),
        'menu_icon'          => 'dashicons-palmtree',
        'show_in_rest'       => true,
    );

    register_post_type('tour_package', $args);
}
add_action('init', 'explore_uganda_register_package_cpt');





// 3️⃣ Add custom meta boxes for package details
function explore_uganda_add_meta_boxes() {
    add_meta_box('package_details', 'Package Details', 'explore_uganda_package_details_callback', 'tour_package', 'normal', 'high');
    add_meta_box('package_itinerary', 'Itinerary Details', 'explore_uganda_itinerary_callback', 'tour_package', 'normal', 'high');
    add_meta_box('package_includes_excludes', 'Includes & Excludes', 'explore_uganda_includes_excludes_callback', 'tour_package', 'normal', 'high');
    add_meta_box('package_pricing', 'Pricing Information', 'explore_uganda_pricing_callback', 'tour_package', 'normal', 'high');
    add_meta_box('package_booking_info', 'Booking Information', 'explore_uganda_booking_info_callback', 'tour_package', 'normal', 'high');
}
add_action('add_meta_boxes', 'explore_uganda_add_meta_boxes');

// 4️⃣ Register Tour Package Categories Taxonomy
function explore_uganda_register_package_categories() {
    $labels = array(
        'name'                       => 'Package Categories',
        'singular_name'              => 'Package Category',
        'search_items'               => 'Search Package Categories',
        'all_items'                  => 'All Package Categories',
        'parent_item'                => 'Parent Category',
        'parent_item_colon'          => 'Parent Category:',
        'edit_item'                  => 'Edit Category',
        'update_item'                => 'Update Category',
        'add_new_item'               => 'Add New Category',
        'new_item_name'              => 'New Category Name',
        'menu_name'                  => 'Package Categories',
    );

    $args = array(
        'hierarchical'          => true, // True makes it behave like categories, false = tags
        'labels'                => $labels,
        'show_ui'               => true,
        'show_admin_column'     => true,
        'query_var'             => true,
        'rewrite'               => array('slug' => 'package-category', 'with_front' => false),
        'show_in_rest'          => true, // Required for Gutenberg & REST API
    );

    register_taxonomy('package_category', array('tour_package'), $args);
}
add_action('init', 'explore_uganda_register_package_categories', 0);


// Package Details Meta Box
function explore_uganda_package_details_callback($post) {
    wp_nonce_field('save_uganda_package_details', 'uganda_package_nonce');
    
    $duration = get_post_meta($post->ID, '_package_duration', true);
    $destination = get_post_meta($post->ID, '_destination', true);
    
    ?>
    <table style="width:100%;">
        <tr>
            <td style="width:50%;padding-right:10px;">
                <p><label><strong>Duration:</strong></label><br>
                    <input type="text" name="package_duration" value="<?php echo esc_attr($duration); ?>" placeholder="e.g., 5 Days / 4 Nights" style="width:100%;">
                </p>
            </td>
            <td style="width:50%;">
                <p><label><strong>Destination:</strong></label><br>
                    <input type="text" name="destination" value="<?php echo esc_attr($destination); ?>" placeholder="e.g., Murchison Falls, Queen Elizabeth" style="width:100%;">
                </p>
            </td>
        </tr>
    </table>
    <?php
}

function explore_uganda_itinerary_callback($post) {
    wp_nonce_field('save_uganda_package_details', 'uganda_package_nonce');

    $itinerary_days = get_post_meta($post->ID, '_package_itinerary', true);
    if (empty($itinerary_days) || !is_array($itinerary_days)) {
        $itinerary_days = array(
            array('title' => '', 'description' => '', 'meals' => '', 'accommodation' => '')
        );
    }
    ?>
    
    <div id="itinerary-days">
        <?php foreach ($itinerary_days as $index => $day): ?>
            <div class="itinerary-day" style="border:1px solid #ddd;padding:15px;margin-bottom:15px;border-radius:5px;">
                <h3 style="margin-top:0;">Day <?php echo $index + 1; ?></h3>
                
                <p><label><strong>Day Title:</strong></label><br>
                    <input type="text" name="package_itinerary[<?php echo $index; ?>][title]" 
                        value="<?php echo esc_attr($day['title']); ?>" 
                        placeholder="e.g., Arrival at Murchison Falls" style="width:100%;">
                </p>
                
               <p><label><strong>Day Description:</strong></label><br>
                    <textarea name="package_itinerary[<?php echo $index; ?>][description]" 
                        style="width:100%;height:100px;" 
                        placeholder="Detailed description of the day's activities"><?php echo $day['description']; ?></textarea>
                </p>

                
                <p><label><strong>Meals:</strong></label><br>
                    <input type="text" name="package_itinerary[<?php echo $index; ?>][meals]" 
                        value="<?php echo esc_attr($day['meals']); ?>" 
                        placeholder="e.g., Breakfast, Lunch, Dinner" style="width:100%;">
                </p>
                
                <p><label><strong>Accommodation:</strong></label><br>
                    <input type="text" name="package_itinerary[<?php echo $index; ?>][accommodation]" 
                        value="<?php echo esc_attr($day['accommodation']); ?>" 
                        placeholder="e.g., Luxury Lodge" style="width:100%;">
                </p>
                
                <button type="button" class="remove-day" 
                    style="background:#dc3545;color:#fff;border:none;padding:5px 10px;border-radius:3px;margin-top:10px;">
                    Remove Day
                </button>
            </div>
        <?php endforeach; ?>
    </div>
    
    <button type="button" id="add-itinerary-day" class="button button-primary" style="margin-top:10px;">Add Another Day</button>
    <p><small><strong>Note:</strong> You can add up to 18 itinerary days maximum.</small></p>
    
    <script>
    jQuery(document).ready(function($) {
        let dayIndex = <?php echo count($itinerary_days); ?>;
        const MAX_DAYS = 18;
        
        // Add new itinerary day
        $('#add-itinerary-day').on('click', function() {
            if (dayIndex >= MAX_DAYS) {
                alert('Maximum ' + MAX_DAYS + ' itinerary days allowed.');
                return;
            }
            
            var html = '<div class="itinerary-day" style="border:1px solid #ddd;padding:15px;margin-bottom:15px;border-radius:5px;">' +
                '<h3 style="margin-top:0;">Day ' + (dayIndex + 1) + '</h3>' +
                '<p><label><strong>Day Title:</strong></label><br>' +
                '<input type="text" name="package_itinerary[' + dayIndex + '][title]" value="" placeholder="e.g., Arrival at Murchison Falls" style="width:100%;"></p>' +
                '<p><label><strong>Day Description:</strong></label><br>' +
                '<textarea name="package_itinerary[' + dayIndex + '][description]" style="width:100%;height:100px;" placeholder="Detailed description of the day\'s activities"></textarea></p>' +
                '<p><label><strong>Meals:</strong></label><br>' +
                '<input type="text" name="package_itinerary[' + dayIndex + '][meals]" value="" placeholder="e.g., Breakfast, Lunch, Dinner" style="width:100%;"></p>' +
                '<p><label><strong>Accommodation:</strong></label><br>' +
                '<input type="text" name="package_itinerary[' + dayIndex + '][accommodation]" value="" placeholder="e.g., Luxury Lodge" style="width:100%;"></p>' +
                '<button type="button" class="remove-day" style="background:#dc3545;color:#fff;border:none;padding:5px 10px;border-radius:3px;margin-top:10px;">Remove Day</button>' +
                '</div>';
            
            $('#itinerary-days').append(html);
            dayIndex++;
        });
        
        // Remove itinerary day
        $(document).on('click', '.remove-day', function() {
            if ($('.itinerary-day').length > 1) {
                $(this).closest('.itinerary-day').remove();
                // Renumber the days
                $('.itinerary-day').each(function(i) {
                    $(this).find('h3').text('Day ' + (i + 1));
                });
                dayIndex--;
            } else {
                alert('You need at least one itinerary day.');
            }
        });
    });
    </script>
    <?php
}


// ----------------------------
// Includes/Excludes Meta Box
// ----------------------------
function explore_uganda_includes_excludes_callback($post) {
    wp_nonce_field('save_uganda_package_details', 'uganda_package_nonce');

    $inclusions = get_post_meta($post->ID, '_package_inclusions', true);
    $exclusions = get_post_meta($post->ID, '_package_exclusions', true);

    // Make sure these are arrays
    if (empty($inclusions) || !is_array($inclusions)) {
        $inclusions = array(array('item' => ''));
    }
    if (empty($exclusions) || !is_array($exclusions)) {
        $exclusions = array(array('item' => ''));
    }
    ?>
    
    <div class="includes-excludes-grid">
        <div class="inclusions-section">
            <h3>✅ Price Includes</h3>
            <div id="inclusions-list">
                <?php foreach ($inclusions as $index => $inclusion): ?>
                    <div class="list-item">
                        <input type="text" name="package_inclusions[<?php echo $index; ?>][item]" 
                            value="<?php echo esc_attr($inclusion['item']); ?>" 
                            placeholder="e.g., Park fees, Accommodation, Professional guide">
                        <button type="button" class="remove-item button button-secondary">Remove</button>
                    </div>
                <?php endforeach; ?>
            </div>
            <button type="button" id="add-inclusion" class="button button-secondary">Add Inclusion</button>
        </div>
        
        <div class="exclusions-section" style="margin-top:20px;">
            <h3>❌ Price Excludes</h3>
            <div id="exclusions-list">
                <?php foreach ($exclusions as $index => $exclusion): ?>
                    <div class="list-item">
                        <input type="text" name="package_exclusions[<?php echo $index; ?>][item]" 
                            value="<?php echo esc_attr($exclusion['item']); ?>" 
                            placeholder="e.g., International flights, Travel insurance, Visa fees">
                        <button type="button" class="remove-item button button-secondary">Remove</button>
                    </div>
                <?php endforeach; ?>
            </div>
            <button type="button" id="add-exclusion" class="button button-secondary">Add Exclusion</button>
        </div>
    </div>
    
    <script>
    jQuery(document).ready(function($) {
        let inclusionIndex = <?php echo count($inclusions); ?>;
        let exclusionIndex = <?php echo count($exclusions); ?>;
        
        // Add new inclusion
        $('#add-inclusion').on('click', function() {
            var html = '<div class="list-item">' +
                '<input type="text" name="package_inclusions[' + inclusionIndex + '][item]" value="" placeholder="e.g., Park fees, Accommodation, Professional guide">' +
                '<button type="button" class="remove-item button button-secondary">Remove</button>' +
                '</div>';
            $('#inclusions-list').append(html);
            inclusionIndex++;
        });
        
        // Add new exclusion
        $('#add-exclusion').on('click', function() {
            var html = '<div class="list-item">' +
                '<input type="text" name="package_exclusions[' + exclusionIndex + '][item]" value="" placeholder="e.g., International flights, Travel insurance, Visa fees">' +
                '<button type="button" class="remove-item button button-secondary">Remove</button>' +
                '</div>';
            $('#exclusions-list').append(html);
            exclusionIndex++;
        });
        
        // Remove inclusion/exclusion
        $(document).on('click', '.remove-item', function() {
            if (
                $(this).closest('#inclusions-list').find('.list-item').length > 1 || 
                $(this).closest('#exclusions-list').find('.list-item').length > 1
            ) {
                $(this).closest('.list-item').remove();
            } else {
                alert('You need at least one item.');
            }
        });
    });
    </script>
    <?php
}
// Pricing Meta Box
function explore_uganda_pricing_callback($post) {
    wp_nonce_field('save_uganda_package_details', 'uganda_package_nonce');
    
    $price_adult = get_post_meta($post->ID, '_package_price_adult', true);
    $price_ugandan = get_post_meta($post->ID, '_package_price_ugandan', true);
    $price_child = get_post_meta($post->ID, '_package_price_child', true);
    $discount = get_post_meta($post->ID, '_package_discount', true);
    
    ?>
    <table style="width:100%;">
        <tr>
            <td style="width:25%;padding-right:10px;">
                <p><label><strong>Price per Adult (International):</strong></label><br>
                    <input type="text" name="package_price_adult" value="<?php echo esc_attr($price_adult); ?>" placeholder="e.g., $850" style="width:100%;">
                </p>
            </td>
            <td style="width:25%;padding:0 10px;">
                <p><label><strong>Price per Adult (Ugandan):</strong></label><br>
                    <input type="text" name="package_price_ugandan" value="<?php echo esc_attr($price_ugandan); ?>" placeholder="e.g., $600" style="width:100%;">
                </p>
            </td>
            <td style="width:25%;padding:0 10px;">
                <p><label><strong>Price per Child:</strong></label><br>
                    <input type="text" name="package_price_child" value="<?php echo esc_attr($price_child); ?>" placeholder="e.g., $400" style="width:100%;">
                </p>
            </td>
            <td style="width:25%;padding-left:10px;">
                <p><label><strong>Discount (%):</strong></label><br>
                    <input type="text" name="package_discount" value="<?php echo esc_attr($discount); ?>" placeholder="e.g., 5" style="width:100%;">
                    <small>Enter percentage number only</small>
                </p>
            </td>
        </tr>
    </table>
    <?php
}

// Booking Information Meta Box
function explore_uganda_booking_info_callback($post) {
    wp_nonce_field('save_uganda_package_details', 'uganda_package_nonce');
    
    $contact_email = get_post_meta($post->ID, '_contact_email', true);
    $contact_phone = get_post_meta($post->ID, '_contact_phone', true);
    $bank_name = get_post_meta($post->ID, '_bank_name', true);
    $account_name = get_post_meta($post->ID, '_account_name', true);
    $account_number = get_post_meta($post->ID, '_account_number', true);
    $swift_code = get_post_meta($post->ID, '_swift_code', true);
    $address = get_post_meta($post->ID, '_address', true);
    
    ?>
    <table style="width:100%;">
        <tr>
            <td style="width:50%;padding-right:10px;">
                <p><label><strong>Contact Email:</strong></label><br>
                    <input type="email" name="contact_email" value="<?php echo esc_attr($contact_email); ?>" placeholder="e.g., info@exploreuganda.com" style="width:100%;">
                </p>
            </td>
            <td style="width:50%;padding-left:10px;">
                <p><label><strong>Contact Phone:</strong></label><br>
                    <input type="text" name="contact_phone" value="<?php echo esc_attr($contact_phone); ?>" placeholder="e.g., +256 772 123456" style="width:100%;">
                </p>
            </td>
        </tr>
        <tr>
            <td colspan="2">
                <p><label><strong>Address:</strong></label><br>
                    <input type="text" name="address" value="<?php echo esc_attr($address); ?>" placeholder="e.g., Garuga, Entebbe Uganda" style="width:100%;">
                </p>
            </td>
        </tr>
        <tr>
            <td style="width:50%;padding-right:10px;">
                <p><label><strong>Bank Name:</strong></label><br>
                    <input type="text" name="bank_name" value="<?php echo esc_attr($bank_name); ?>" placeholder="e.g., STANBIC BANK UGANDA LIMITED" style="width:100%;">
                </p>
            </td>
            <td style="width:50%;padding-left:10px;">
                <p><label><strong>Account Name:</strong></label><br>
                    <input type="text" name="account_name" value="<?php echo esc_attr($account_name); ?>" placeholder="e.g., Ritah Nalaaki" style="width:100%;">
                </p>
            </td>
        </tr>
        <tr>
            <td style="width:50%;padding-right:10px;">
                <p><label><strong>Account Number:</strong></label><br>
                    <input type="text" name="account_number" value="<?php echo esc_attr($account_number); ?>" placeholder="e.g., 9030025773739" style="width:100%;">
                </p>
            </td>
            <td style="width:50%;padding-left:10px;">
                <p><label><strong>Swift Code:</strong></label><br>
                    <input type="text" name="swift_code" value="<?php echo esc_attr($swift_code); ?>" placeholder="e.g., SBICUGKXXXX" style="width:100%;">
                </p>
            </td>
        </tr>
    </table>
    <?php
}

// Save all package details - UPDATED VERSION
function explore_uganda_save_package_details($post_id) {
    if (!isset($_POST['uganda_package_nonce']) || !wp_verify_nonce($_POST['uganda_package_nonce'], 'save_uganda_package_details')) {
        return;
    }
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_post', $post_id)) return;
    if (get_post_type($post_id) != 'tour_package') return;

    // Save package details
    $fields = array(
        'package_duration' => '_package_duration',
        'destination' => '_destination',
        'package_price_adult' => '_package_price_adult',
        'package_price_ugandan' => '_package_price_ugandan',
        'package_price_child' => '_package_price_child',
        'package_discount' => '_package_discount',
        'contact_email' => '_contact_email',
        'contact_phone' => '_contact_phone',
        'bank_name' => '_bank_name',
        'account_name' => '_account_name',
        'account_number' => '_account_number',
        'swift_code' => '_swift_code',
        'address' => '_address'
    );
    
    foreach ($fields as $field => $meta_key) {
        if (isset($_POST[$field])) {
            update_post_meta($post_id, $meta_key, sanitize_text_field($_POST[$field]));
        }
    }
    
    // Save inclusions
    if (isset($_POST['package_inclusions']) && is_array($_POST['package_inclusions'])) {
        $inclusions = array();
        foreach ($_POST['package_inclusions'] as $inclusion) {
            if (!empty($inclusion['item'])) {
                $inclusions[] = array('item' => sanitize_text_field($inclusion['item']));
            }
        }
        update_post_meta($post_id, '_package_inclusions', $inclusions);
    }

    // Save exclusions
    if (isset($_POST['package_exclusions']) && is_array($_POST['package_exclusions'])) {
        $exclusions = array();
        foreach ($_POST['package_exclusions'] as $exclusion) {
            if (!empty($exclusion['item'])) {
                $exclusions[] = array('item' => sanitize_text_field($exclusion['item']));
            }
        }
        update_post_meta($post_id, '_package_exclusions', $exclusions);
    }

    // Save itinerary - SIMPLIFIED VERSION (saves whatever is submitted)
    if (isset($_POST['package_itinerary']) && is_array($_POST['package_itinerary'])) {
        $itinerary_days = array();
        
        // Loop through each day in the itinerary
        foreach ($_POST['package_itinerary'] as $day) {
            // Save all itinerary days that were submitted
            $itinerary_days[] = array(
                'title' => sanitize_text_field($day['title']),
                'description' => wp_kses_post($day['description']),
                'meals' => sanitize_text_field($day['meals']),
                'accommodation' => sanitize_text_field($day['accommodation'])
            );
        }
        
        update_post_meta($post_id, '_package_itinerary', $itinerary_days);
    }
}
add_action('save_post', 'explore_uganda_save_package_details');

// Display all packages in grid using same style as slider
function explore_uganda_all_packages($category = null) {
    $args = array(
            'post_type' => 'tour_package',
            'posts_per_page' => -1,
            'post_status' => 'publish'
        );
        
        if ($category) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'package_category', // <-- use your custom taxonomy here
                    'field'    => 'slug',
                    'terms'    => $category
                )
            );
        }
        
        $packages = new WP_Query($args);


    ob_start();

    if ($packages->have_posts()) :
        ?>
        <div class="explore-uganda-packages-grid-wrapper">
            <div class="packages-grid">
                <?php while ($packages->have_posts()) : $packages->the_post(); 
                    $package_id = get_the_ID();

                    // Meta fields
                    $duration   = get_post_meta($package_id, '_package_duration', true);
                    $destination = get_post_meta($package_id, '_destination', true);
                    $price_adult = get_post_meta($package_id, '_package_price_adult', true);
                    $discount   = get_post_meta($package_id, '_package_discount', true);

                    // Image
                    $image_id = get_post_thumbnail_id($package_id);
                    if ($image_id) {
                        $image = wp_get_attachment_image_url($image_id, 'large');
                    } else {
                        $image = 'https://images.unsplash.com/photo-1586375300773-8384e3e4916f?auto=format&fit=crop&w=1000&q=80';
                    }

                    // Demo ratings
                    $review_count = rand(5, 30);
                    $rating = rand(40, 50) / 10; // 4.0 - 5.0
                ?>
                <div class="package-slide">
                    <a href="<?php the_permalink(); ?>" class="package-card">
                        <div class="package-images" style="background-image:url('<?php echo esc_url($image); ?>');">
                            <?php if ($discount) : ?>
                            <div class="package-badge">
                                <?php echo esc_html($discount); ?>% OFF
                            </div>
                            <?php endif; ?>

                            <!--<div class="package-prices">-->
                            <!--    <?php echo esc_html($price_adult); ?>-->
                            <!--</div>-->
                        </div>

                        <div class="package-conten">
                            <h3><?php the_title(); ?></h3>

                            <?php if ($destination) : ?>
                            <div class="package-meta">
                                <span class="meta-icon">📍</span>
                                <span class="meta-text"><?php echo esc_html($destination); ?></span>
                            </div>
                            <?php endif; ?>

                            <?php if ($duration) : ?>
                            <div class="package-duration">
                                <span class="meta-icon">⏱</span>
                                <span class="meta-text"><?php echo esc_html($duration); ?></span>
                            </div>
                            <?php endif; ?>

                            

                            <div class="package-reviews">
                                <div class="stars">
                                    <?php
                                    $full_stars = floor($rating);
                                    $half_star = ($rating - $full_stars) >= 0.5;
                                    $empty_stars = 5 - $full_stars - ($half_star ? 1 : 0);

                                    for ($i = 0; $i < $full_stars; $i++) {
                                        echo '<i class="fas fa-star"></i>';
                                    }
                                    if ($half_star) {
                                        echo '<i class="fas fa-star-half-alt"></i>';
                                    }
                                    for ($i = 0; $i < $empty_stars; $i++) {
                                        echo '<i class="far fa-star"></i>';
                                    }
                                    ?>
                                </div>
                                <span class="review-count">(<?php echo $review_count; ?> reviews)</span>
                            </div>
                        </div>
                    </a>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
        <?php
    else :
        echo '<p>No travel packages found.</p>';
    endif;

    wp_reset_postdata();

    return ob_get_clean();
}

add_shortcode('explore_uganda_packages', 'explore_uganda_all_packages');



add_filter('manage_uganda_booking_posts_columns', 'explore_uganda_booking_columns');
function explore_uganda_booking_columns($columns) {
    unset($columns['date'], $columns['title']);
    $columns['package'] = 'Package';
    $columns['customer'] = 'Customer';
    $columns['email'] = 'Email';
    $columns['phone'] = 'Phone';
    $columns['participants'] = 'Participants';
    $columns['status'] = 'Status';
    $columns['date'] = 'Date';
    return $columns;
}

add_action('manage_uganda_booking_posts_custom_column', 'explore_uganda_booking_custom_column', 10, 2);
function explore_uganda_booking_custom_column($column, $post_id) {
    switch ($column) {
        case 'package':
            $package_id = get_post_meta($post_id, '_booking_package_id', true);
            echo $package_id ? '<a href="' . get_edit_post_link($package_id) . '">' . get_the_title($package_id) . '</a>' : '-';
            break;
        case 'customer':
            echo esc_html(get_post_meta($post_id, '_booking_name', true));
            break;
        case 'email':
            echo esc_html(get_post_meta($post_id, '_booking_email', true));
            break;
        case 'phone':
            echo esc_html(get_post_meta($post_id, '_booking_phone', true));
            break;
        case 'participants':
            $adults = (int) get_post_meta($post_id, '_booking_adults', true);
            $children = (int) get_post_meta($post_id, '_booking_children', true);
            echo "Adults: $adults<br>Children: $children";
            break;
        case 'status':
            echo ucfirst(get_post_meta($post_id, '_booking_status', true));
            break;
    }
}

add_action('manage_uganda_booking_posts_custom_column', 'explore_uganda_booking_column_data', 10, 2);


// Initialize AJAX functionality
function explore_uganda_enqueue_scripts() {
    // Only enqueue on frontend
    if (!is_admin()) {
        wp_enqueue_script('jquery');
        wp_localize_script('jquery', 'explore_uganda_ajax', array(
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('explore_uganda_booking')
        ));
    }
}
add_action('wp_enqueue_scripts', 'explore_uganda_enqueue_scripts');



// Add AJAX nonce to frontend
function explore_uganda_add_ajax_nonce() {
    wp_nonce_field('explore_uganda_booking', 'explore_uganda_booking_nonce');
}
add_action('wp_footer', 'explore_uganda_add_ajax_nonce');

// Register template for single tour package
function explore_uganda_single_template($template) {
    global $post;
    
    if ($post->post_type == 'tour_package' && is_single()) {
        // Check if theme has a template for single tour package
        $theme_template = locate_template(array('single-tour-package.php'));
        
        if ($theme_template) {
            return $theme_template;
        } else {
            // Use plugin's default template
            return plugin_dir_path(__FILE__) . 'templates/single-tour-package.php';
        }
    }
    
    return $template;
}
add_filter('single_template', 'explore_uganda_single_template');

