<?php 
$slider_query = new WP_Query(array(
    'post_type'      => 'text_slider', // Ensure this is the correct post type
    'posts_per_page' => 1, // Show only one slider
    'orderby'        => 'date',
    'order'          => 'DESC',
));
if ($slider_query->have_posts()): 
    while ($slider_query->have_posts()): 
        $slider_query->the_post();
        $post_id       = get_the_ID();
        $background    = get_the_post_thumbnail_url($post_id, 'full');
        $video         = get_post_meta($post_id, '_video_url', true);
        $title         = get_the_title();
        $video_subtitle = get_post_meta($post_id, '_video_subtitle', true); // ✅ Correct field
        $subtitles     = get_post_meta($post_id, '_subtitles', true);
        $link          = get_post_meta($post_id, '_slider_link', true);
        $descr         = get_the_content(null, false, $post_id);
?>
<section class="text-slider">
    <?php if ($video) : ?>
        <video autoplay loop muted playsinline class="slider-video">
            <source src="<?php echo esc_url($video); ?>" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <!-- Video Title Overlay -->
        <div class="video-title-overlay">
            <h1 class="video-main-title"><?php echo esc_html($title); ?></h1>
            <?php if (!empty($video_subtitle)) : ?>
                <p class="video-subtitle"><?php echo esc_html($video_subtitle); ?></p>
            <?php endif; ?>
        </div>
    <?php else : ?>
        <div class="slider-bg" style="background-image: url('<?php echo esc_url($background); ?>');"></div>
        <div class="overlay"></div>
        <div class="container-md">
            <div class="row">
                <div class="col">
                    <h2 class="main-title" data-aos="fade-up"><?php echo esc_html($title); ?></h2>
                    <h3 id="changing-subtitle" class="subtitle" data-aos="fade-up"></h3>
                    <p data-aos="fade-up" data-aos-delay="1000"><?php echo esc_html($descr); ?></p>
                    <?php if (!empty($link)) : ?>
                        <a href="<?php echo esc_url($link); ?>" class="btn btn-outline-warning slider-btn" data-aos="fade-up" data-aos-delay="1000">
                            LEARN MORE ABOUT <strong><?php echo date('Y'); ?></strong> EVENT
                        </a>
                    <?php endif; ?>
                </div>
            </div>
        </div><!-- container !-->
    <?php endif; ?>
</section>

<?php if (!$video) : ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
    let subtitles = <?php echo json_encode($subtitles); ?>;
    let subtitleElement = document.getElementById("changing-subtitle");
    let index = 0;

    function typeWriter(text, i, callback) {
        if (i < text.length) {
            subtitleElement.innerHTML += text.charAt(i);
            setTimeout(() => typeWriter(text, i + 1, callback), 100);
        } else {
            setTimeout(callback, 2000);
        }
    }

    function changeSubtitle() {
        subtitleElement.innerHTML = "";
        typeWriter(subtitles[index], 0, function() {
            index = (index + 1) % subtitles.length;
            setTimeout(changeSubtitle, 1000);
        });
    }

    if (subtitles && subtitles.length > 0) {
        changeSubtitle();
    }
});
</script>
<?php endif; ?>

<?php 
    endwhile; 
endif; 
wp_reset_postdata(); 
?>
