<?php
// Get current post ID to exclude it
$current_post_id = get_the_ID();

// Query for related galleries
$related_args = array(
    'post_type'      => 'post',
    'category_name'  => 'photo-gallery',
    'posts_per_page' => 5,           // Limit to 5 galleries
    'post__not_in'   => array($current_post_id),
    'orderby'        => 'rand',      // Random order
);

$related_query = new WP_Query($related_args);

if ($related_query->have_posts()) : ?>
    <div class="row g-2">
        <?php while ($related_query->have_posts()) : $related_query->the_post(); 
            // Get featured image or fallback
            $thumb_url = get_the_post_thumbnail_url(get_the_ID(), 'medium');
            if (!$thumb_url) {
                $thumb_url = 'https://via.placeholder.com/300x200?text=No+Image'; // fallback image
            }
        ?>
            <div class="col-12 mb-2">
                <a href="<?php the_permalink(); ?>" class="d-flex align-items-center text-decoration-none">
                    <img src="<?php echo esc_url($thumb_url); ?>" 
                         alt="<?php the_title_attribute(); ?>" 
                         class="img-fluid rounded me-2" 
                         style="width: 80px; height: 60px; object-fit: cover;">
                    <span class="text-dark"><?php the_title(); ?></span>
                </a>
            </div>
        <?php endwhile; ?>
    </div>
    <?php wp_reset_postdata(); ?>
<?php else : ?>
    <p>No related galleries found.</p>
<?php endif; ?>
