<footer class="site-footer">
  <!-- Main Footer Content -->
  <div class="footer-main py-5">
    <div class="container">
      <div class="row">
        
        <!-- Column 1: Company Info -->
        <div class="col-lg-3 col-md-6 mb-4 mb-md-0">
          <div class="footer-about">
            <a href="<?php echo esc_url(home_url('/')); ?>" class="footer-logo mb-3 d-inline-block">
              <?php
                $custom_logo_id = get_theme_mod('custom_logo');
                $logo = wp_get_attachment_image_src($custom_logo_id, 'full');
                if ($logo) {
                  echo '<img src="' . esc_url($logo[0]) . '" alt="' . get_bloginfo('name') . '" class="footer-logo-img">';
                } else {
                  echo '<span class="logo-text text-white fw-bold">' . get_bloginfo('name') . '</span>';
                }
              ?>
            </a>
            <p class="text-white mb-3">Discover the beauty of Uganda with our expertly crafted tours and safaris. Experience the pearl of Africa like never before.</p>
            
            <!-- Social Icons -->
            <div class="footer-social mb-3">
  <a href="https://www.facebook.com/share/1CsYUZBHBt/?mibextid=wwXIfr" class="social-icon" target="_blank" rel="noopener noreferrer"><i class="bi bi-facebook"></i></a>
  <a href="https://www.instagram.com/exploreugandawithus?igsh=dGE0aWs2ZzZqZ2Rw&utm_source=qr" class="social-icon" target="_blank" rel="noopener noreferrer"><i class="bi bi-instagram"></i></a>
  <a href="#" class="social-icon" target="_blank" rel="noopener noreferrer"><i class="bi bi-twitter-x"></i></a>
  <a href="#" class="social-icon" target="_blank" rel="noopener noreferrer"><i class="bi bi-youtube"></i></a>
</div>

          </div>
        </div>
        
        <!-- Column 2: Contact Info -->
        <div class="col-lg-3 col-md-6 mb-4 mb-md-0">
          <h5 class="footer-title text-white mb-3">Contact Us</h5>
          <ul class="footer-contact list-unstyled">
            <li class="mb-2"><i class="bi bi-geo-alt-fill me-2"></i><span>Kampala Road, Kampala, Uganda</span></li>
            <li class="mb-2"><i class="bi bi-telephone-fill me-2"></i><span>+4745003286</span></li>
            <li class="mb-2"><i class="bi bi-envelope-fill me-2"></i><span>info@exploreuganda.com</span></li>
            <li class="mb-2"><i class="bi bi-clock-fill me-2"></i><span>Mon - Fri: 8:00 AM - 5:00 PM</span></li>
          </ul>
        </div>

        <!-- Column 3: Destinations -->
        <div class="col-lg-3 col-md-6 mb-4 mb-md-0">
          <h5 class="footer-title text-white mb-3">Destinations</h5>
          <ul class="footer-links list-unstyled">
            <li><a href="<?php echo home_url('/bwindi-impenetrable-forest'); ?>">Bwindi Impenetrable Forest</a></li>
            <li><a href="<?php echo home_url('/queen-elizabeth-national-park'); ?>">Queen Elizabeth National Park</a></li>
            <li><a href="<?php echo home_url('/murchison-falls-national-park'); ?>">Murchison Falls</a></li>
            <li><a href="<?php echo home_url('/lake-bunyonyi'); ?>">Lake Bunyonyi</a></li>
            <li><a href="<?php echo home_url('/city-tours'); ?>">City Tours</a></li>
          </ul>
        </div>

        <!-- Column 4: Quick Links -->
        <div class="col-lg-3 col-md-6 mb-4 mb-md-0">
          <h5 class="footer-title text-white mb-3">Explore</h5>
          <ul class="footer-links list-unstyled">
            <li><a href="<?php echo esc_url(home_url('/')); ?>">Home</a></li>
            <li><a href="<?php echo home_url('/who-we-are'); ?>">About Us</a></li>
            <li><a href="<?php echo home_url('/tours'); ?>">Packages</a></li>
            <li><a href="<?php echo home_url('blog'); ?>">Blog</a></li>
            <li><a href="<?php echo home_url('/destinations'); ?>">Destinations</a></li>
          </ul>
        </div>

      </div>
    </div>
  </div>

  <!-- Footer Bottom -->
  <div class="footer-bottom py-3">
    <div class="container">
      <div class="d-flex flex-column flex-md-row justify-content-between align-items-center">
        <div class="copyright-text small text-center text-md-start text-white-50 mb-2 mb-md-0">
          &copy; <?php echo date('Y'); ?> Explore Uganda. All rights reserved.
        </div>
        <div class="footer-legal-links">
          <a href="https://lwegatech.com/" class="small text-white-50 me-3">Designed by Lwegatech</a>
          <a href="#" class="small text-white-50">Cookie Policy</a>
        </div>
      </div>
    </div>
  </div>
</footer>


