<?php 
get_header(); 
include get_template_directory() . '/inc/menus/menu.php'; 
?>

<main role="main">

    <?php $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>

    <!-- Header Banner -->
    <div class="spp-header-banner" style="background:url('<?php echo $backgroundImg[0]; ?>') no-repeat center center; background-size: cover;">
        <div class="container">
            <h1><?php the_title(); ?></h1>
        </div>
    </div>


    <!-- Main Content -->
    <div class="container-xxl spp-content-container">
        <!-- Post Main -->
        <div class="spp-post-main">
            <?php if (have_posts()): while (have_posts()) : the_post(); ?>
            
            <!-- Post Meta -->
            <div class="spp-post-meta">
                <span>Published by <strong>ACB</strong></span>
                <span class="spp-author-email"><a href="mailto:<?php the_author_meta('email'); ?>"><i class="bi bi-envelope-check"></i></a></span>
                <span><i class="bi bi-calendar3"></i> <?php the_time('F j, Y'); ?></span>
            </div>

            <!-- Thumbnail -->
            <?php if(has_post_thumbnail()): ?>
                <div class="spp-post-thumbnail">
                    <?php the_post_thumbnail('large', ['class' => 'spp-post-img']); ?>
                </div>
            <?php endif; ?>

            <!-- Post Content -->
            <div class="spp-post-body">
                <?php the_content(); ?>
            </div>

            <!-- Social Share -->
            <div class="spp-social-share">
                <div><small>Share this article</small></div>
                <a href="https://www.facebook.com/sharer/sharer.php?u=<?= esc_url(get_permalink()); ?>" class="spp-social-btn spp-social-btn-facebook" target="_blank"><i class="bi bi-facebook"></i> Facebook</a>
                <a href="https://twitter.com/intent/tweet?url=<?= esc_url(get_permalink()); ?>&text=<?= the_title(); ?>" class="spp-social-btn spp-social-btn-twitter" target="_blank"><i class="bi bi-twitter"></i> Twitter</a>
                <a href="whatsapp://send?text=Check out this article: <?= the_title(); ?> - <?= esc_url(get_permalink()); ?>" class="spp-social-btn spp-social-btn-whatsapp" target="_blank"><i class="bi bi-whatsapp"></i> WhatsApp</a>
            </div>

            <?php endwhile; else: ?>
                <p>Sorry, nothing to display.</p>
            <?php endif; ?>

            <?php edit_post_link(); ?>
        </div>

        <!-- Sidebar -->
        <div class="spp-sidebar">
            <h3>Latest Stories</h3>
            <?php include get_template_directory() . '/inc/related-news.php'; ?>
        </div>
    </div>

</main>

<?php get_footer(); ?>

