<?php
$current_post_id = get_the_ID();

// Get 3 random news posts excluding the current one
$news_args = array(
    'post_type' => 'post',
    'posts_per_page' => 3,
    'category_name' => 'news, blog',
    'order' => 'RAND',
    'post__not_in' => array($current_post_id),
);

$news_query = new WP_Query($news_args);

if ($news_query->have_posts()) :
?>
<div class="explore-news-horizontal">
    <?php while ($news_query->have_posts()) : $news_query->the_post(); ?>
        <div class="explore-news-horizontal-card">
            <a href="<?= esc_url(get_permalink()); ?>" class="explore-news-horizontal-link">
                <div class="explore-news-horizontal-thumb">
                    <?php if (has_post_thumbnail()) {
                        the_post_thumbnail('medium', ['class' => 'explore-news-horizontal-img']);
                    } else {
                        echo '<img src="' . get_template_directory_uri() . '/assets/images/placeholder-image.jpg" alt="News Image" class="explore-news-horizontal-img"/>';
                    } ?>
                </div>
                <div class="explore-news-horizontal-body">
                    <h5 class="explore-news-horizontal-title"><?php the_title(); ?></h5>
                    <div class="explore-news-horizontal-meta">
                        <i class="bi bi-calendar-check"></i> <?= get_the_date(); ?>
                    </div>
                    
                </div>
            </a>
        </div>
    <?php endwhile; wp_reset_postdata(); ?>
</div>
<?php else: ?>
<p class="explore-no-news">No news found.</p>
<?php endif; ?>
