<?php
// Add this to your functions.php or plugin file
// Shortcode to display destination pages as cards
function destination_cards_shortcode() {
    // Query pages with category "destination"
    $args = array(
        'post_type'      => 'page',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'category',
                'field'    => 'slug',
                'terms'    => 'destination',
            ),
        ),
    );
    $query = new WP_Query($args);

    ob_start();

    if ($query->have_posts()) {
        echo '<div class="destination-cards">';
        while ($query->have_posts()) {
            $query->the_post();
            $thumb = get_the_post_thumbnail_url(get_the_ID(), 'medium');
            $title = get_the_title();
            $link  = get_permalink();

            echo '<div class="destination-card">';
            if ($thumb) {
                echo '<a href="' . esc_url($link) . '"><img src="' . esc_url($thumb) . '" alt="' . esc_attr($title) . '"></a>';
            }
            echo '<p>' . esc_html($title) . '</p>';
            echo '</div>';
        }
        echo '</div>';
    }

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('destination_cards', 'destination_cards_shortcode');

function destination_card_shortcode() {
    // Query pages with category "destination"
    $args = array(
        'post_type'      => 'page',
        'posts_per_page' => -1,
        'tax_query' => array(
            array(
                'taxonomy' => 'category',
                'field'    => 'slug',
                'terms'    => 'destination',
            ),
        ),
    );
    $query = new WP_Query($args);

    ob_start();

    if ($query->have_posts()) {
        echo '<div class="travel-cards-grid">';
        while ($query->have_posts()) {
            $query->the_post();
            $thumb = get_the_post_thumbnail_url(get_the_ID(), 'large');
            $title = get_the_title();
            $link  = get_permalink();

            // ✅ Example: replace this with your actual logic for counting tours
            $tours_count = rand(0,5);

            echo '<div class="travel-card">';
            echo '<a href="' . esc_url($link) . '">';
            if ($thumb) {
                echo '<div class="travel-image" style="background-image:url(' . esc_url($thumb) . ');"></div>';
            }
            echo '<div class="travel-overlay">';
            echo '<h3>' . esc_html($title) . ' </h3>';
            echo '</div>';
            echo '</a>';
            echo '</div>';
        }
        echo '</div>';
    }

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('destinations', 'destination_card_shortcode');



function explore_uganda_packages_slider_shortcode($atts) {
   $atts = shortcode_atts(array(
            'category' => '',
            'limit' => 6,
            'title' => 'Our Packages',
            'show_dots' => true,
            'show_nav' => true,
            'auto_play' => false
        ), $atts);
        
        ob_start();
        
        // Query packages
        $args = array(
            'post_type' => 'tour_package',
            'posts_per_page' => $atts['limit'],
            'post_status' => 'publish',
            'orderby' => 'date',
            'order' => 'DESC'
        );
        
        // Filter by Tour Package Category (custom taxonomy)
        if (!empty($atts['category'])) {
            $args['tax_query'] = array(
                array(
                    'taxonomy' => 'package_category', // <-- use your custom taxonomy
                    'field'    => 'slug',
                    'terms'    => $atts['category']
                )
            );
        }
        
        $packages = new WP_Query($args);

    if ($packages->have_posts()) :
    ?>
    <div class="explore-uganda-packages-slider-wrapper">
        <div class="packages-slider-header">
            <h2><?php echo esc_html($atts['title']); ?></h2>
            <p>Discover the beauty of Uganda with our expertly crafted travel experiences</p>
        </div>
        
        <div class="packages-slider-container">
            <?php if ($atts['show_nav'] == 'true') : ?>
            <div class="slider-nav prev">
                <i class="fas fa-chevron-left"></i>
            </div>
            <?php endif; ?>
            
            <div class="packages-slider" id="packages-slider-<?php echo uniqid(); ?>">
                <?php 
                while ($packages->have_posts()) : $packages->the_post(); 
                    $package_id = get_the_ID();
                    
                    // Get meta fields
                    $duration = get_post_meta($package_id, '_package_duration', true);
                    $destination = get_post_meta($package_id, '_destination', true);
                    $price_adult = get_post_meta($package_id, '_package_price_adult', true);
                    $price_ugandan = get_post_meta($package_id, '_package_price_ugandan', true);
                    $price_child = get_post_meta($package_id, '_package_price_child', true);
                    $discount = get_post_meta($package_id, '_package_discount', true);
                    
                    // Get featured image
                    $image_id = get_post_thumbnail_id($package_id);
                    if ($image_id) {
                        $image = wp_get_attachment_image_url($image_id, 'large');
                    } else {
                        $image = 'https://images.unsplash.com/photo-1586375300773-8384e3e4916f?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1000&q=80';
                    }
                    
                    // Generate star ratings (random for demo)
                    $review_count = rand(5, 30);
                    $rating = rand(40, 50) / 10; // Ratings between 4.0 and 5.0
                    ?>
                    
                    <div class="package-slide">
                        <a href="<?php the_permalink(); ?>" class="package-card">
                            <div class="package-images" style="background-image:url('<?php echo esc_url($image); ?>');">
                                <?php if ($discount) : ?>
                                <div class="package-badge">
                                    <?php echo esc_html($discount); ?>% OFF
                                </div>
                                <?php endif; ?>
                                
                                <!--<div class="package-prices">-->
                                <!--    <?php echo esc_html($price_adult); ?>-->
                                <!--</div>-->
                            </div>
                            
                            <div class="package-conten">
                                <h3><?php the_title(); ?></h3>
                                
                                <?php if ($destination) : ?>
                                <div class="package-meta">
                                    <span class="meta-icon">📍</span>
                                    <span class="meta-text"><?php echo esc_html($destination); ?></span>
                                </div>
                                <?php endif; ?>
                                    
                                <?php if ($duration) : ?>
                                <div class="package-duration">
                                    <span class="meta-icon">⏱</span>
                                    <span class="meta-text"><?php echo esc_html($duration); ?></span>
                                </div>
                                <?php endif; ?>
                                
                                
                                
                                <div class="package-reviews">
                                    <div class="stars">
                                        <?php
                                        // Display star rating
                                        $full_stars = floor($rating);
                                        $half_star = ($rating - $full_stars) >= 0.5;
                                        $empty_stars = 5 - $full_stars - ($half_star ? 1 : 0);
                                        
                                        for ($i = 0; $i < $full_stars; $i++) {
                                            echo '<i class="fas fa-star"></i>';
                                        }
                                        
                                        if ($half_star) {
                                            echo '<i class="fas fa-star-half-alt"></i>';
                                        }
                                        
                                        for ($i = 0; $i < $empty_stars; $i++) {
                                            echo '<i class="far fa-star"></i>';
                                        }
                                        ?>
                                    </div>
                                    <span class="review-count">(<?php echo $review_count; ?> reviews)</span>
                                </div>
                            </div>
                        </a>
                    </div>
                    
                <?php endwhile; ?>
            </div>
            
            <?php if ($atts['show_nav'] == 'true') : ?>
            <div class="slider-nav next">
                <i class="fas fa-chevron-right"></i>
            </div>
            <?php endif; ?>
        </div>
        
        <?php if ($atts['show_dots'] == 'true') : ?>
        <div class="slider-controls">
            <div class="slider-dots">
                <?php 
                $slide_count = $packages->post_count;
                $dots_count = ceil($slide_count / 3); // Assuming 3 slides per view
                for ($i = 0; $i < $dots_count; $i++) : 
                ?>
                <div class="slider-dot <?php echo $i === 0 ? 'active' : ''; ?>" data-slide="<?php echo $i; ?>"></div>
                <?php endfor; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
    
   
<script>
document.addEventListener("DOMContentLoaded", function() {
  const slider = document.querySelector(".packages-slider");
  const prevBtn = document.querySelector(".slider-nav.prev");
  const nextBtn = document.querySelector(".slider-nav.next");
  
  if (!slider || !prevBtn || !nextBtn) return;

  let currentIndex = 0;
  const slides = slider.querySelectorAll(".package-slide");
  const slideGap = 30; // matches your CSS gap
  const slideWidth = slides[0].offsetWidth + slideGap;

  function getVisibleCount() {
    return Math.floor(slider.parentElement.offsetWidth / slideWidth);
  }

  function getMaxIndex() {
    return Math.max(0, slides.length - getVisibleCount());
  }

  function updateSlider() {
    slider.style.transform = `translateX(-${currentIndex * slideWidth}px)`;

    // Keep both buttons visible if there are more than 3 cards
    prevBtn.style.display = currentIndex <= 0 ? "none" : "flex";
    nextBtn.style.display = currentIndex >= getMaxIndex() ? "none" : "flex";
  }

  prevBtn.addEventListener("click", () => {
    if (currentIndex > 0) {
      currentIndex--;
      updateSlider();
    }
  });

  nextBtn.addEventListener("click", () => {
    if (currentIndex < getMaxIndex()) {
      currentIndex++;
      updateSlider();
    }
  });

  // Recalculate on resize
  window.addEventListener("resize", updateSlider);

  // Init
  updateSlider();
});
</script>



    <?php
    else :
        echo '<p>No travel packages found.</p>';
    endif;
    
    wp_reset_postdata();
    
    return ob_get_clean();
}
add_shortcode('uganda_packages_slider', 'explore_uganda_packages_slider_shortcode');

// Enqueue necessary scripts and styles
function explore_uganda_slider_scripts() {
    // Font Awesome
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css');
    
    // Google Fonts
    wp_enqueue_style('google-fonts', 'https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&family=Playfair+Display:wght@400;600;700&display=swap');
    
    // jQuery (should already be included in WordPress)
    wp_enqueue_script('jquery');
}
add_action('wp_enqueue_scripts', 'explore_uganda_slider_scripts');