<?php wp_head(); ?>
<body <?php body_class(); ?>>

<!-- Top Bar -->
<div class="top-bar py-2">
  <div class="container d-flex flex-column flex-md-row justify-content-between align-items-center">
    <!-- Contact Info -->
    <div class="top-contact text-white small mb-2 mb-md-0">
      <span class="me-4"><i class="bi bi-telephone me-1"></i> +256 700 000 000</span>
      <span><i class="bi bi-envelope me-1"></i> info@exploreug.com</span>
    </div>

    <!-- Social Icons -->
    <div class="top-social">
  <a href="https://www.facebook.com/share/1CsYUZBHBt/?mibextid=wwXIfr" class="text-white me-3" target="_blank" rel="noopener noreferrer"><i class="bi bi-facebook"></i></a>
  <a href="https://www.instagram.com/exploreugandawithus?igsh=dGE0aWs2ZzZqZ2Rw&utm_source=qr" class="text-white me-3" target="_blank" rel="noopener noreferrer"><i class="bi bi-instagram"></i></a>
  <a href="#" class="text-white" target="_blank" rel="noopener noreferrer"><i class="bi bi-youtube"></i></a>
</div>

  </div>
</div>

<!-- Main Header -->
<header class="transparent-header" id="transparentHeader">
  <div class="container">
    <nav class="navbar navbar-expand-lg navbar-dark">

      <!-- Logo -->
      <a class="navbar-brand fw-bold text-white" href="<?php echo esc_url(home_url('/')); ?>">
        <?php
          $custom_logo_id = get_theme_mod('custom_logo');
          $logo = wp_get_attachment_image_src($custom_logo_id, 'full');
          if ($logo) {
            echo '<img src="' . esc_url($logo[0]) . '" alt="' . get_bloginfo('name') . '" class="main-logo">';
          } else {
            echo '<span class="logo-text">' . get_bloginfo('name') . '</span>';
          }
        ?>
      </a>

      <!-- Mobile Toggle -->
      <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#mobileMenu" aria-controls="mobileMenu" aria-label="Toggle navigation">
        <span class="navbar-toggler-icon"></span>
      </button>

      <!-- Desktop Menu -->
      <div class="collapse navbar-collapse justify-content-end d-none d-lg-flex">
        <?php
          wp_nav_menu(array(
            'theme_location' => 'primary',
            'container'      => false,
            'menu_class'     => 'navbar-nav mb-2 mb-lg-0',
            'fallback_cb'    => '__return_false',
            'depth'          => 3,
            'walker'         => new Custom_Nav_Walker()
          ));
        ?>
        <!-- Desktop CTA -->
        <div class="ms-3">
          <a href="<?php echo home_url('/tours'); ?>" class="btn btn-primary">Book Now</a>
        </div>
      </div>

    </nav>
  </div>
</header>

<!-- Offcanvas Mobile Menu -->
<div class="offcanvas offcanvas-end" tabindex="-1" id="mobileMenu" aria-labelledby="mobileMenuLabel">
  <div class="offcanvas-header">
    <h5 class="offcanvas-title" id="mobileMenuLabel">Menu</h5>
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
  </div>
  <div class="offcanvas-body">
    <?php
      wp_nav_menu(array(
        'theme_location' => 'primary',
        'container'      => false,
        'menu_class'     => 'navbar-nav',
        'fallback_cb'    => '__return_false',
        'depth'          => 3,
        'walker'         => new Custom_Nav_Walker()
      ));
    ?>
    <div class="mt-3">
      <a href="<?php echo home_url('/tours'); ?>" class="btn btn-primary w-100">Book Now</a>
    </div>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<!-- Scroll Behavior -->
<script>
document.addEventListener('DOMContentLoaded', function() {
  const header = document.getElementById('transparentHeader');
  const topBar = document.querySelector('.top-bar');
  const logo = document.querySelector('.main-logo');

  window.addEventListener('scroll', function() {
    if (window.scrollY > 100) {
      topBar.classList.add('hidden');
      header.classList.add('scrolled');
      logo?.style.setProperty('max-height', '60px', 'important');
    } else {
      topBar.classList.remove('hidden');
      header.classList.remove('scrolled');
      logo?.style.setProperty('max-height', '100px', 'important');
    }
  });
});
</script>
