<?php
/**
 * Template Name: Rate Your Tour
 */

get_header();

// Retrieve booking and token
$booking_id = isset($_GET['booking']) ? intval($_GET['booking']) : 0;
$token = isset($_GET['token']) ? sanitize_text_field($_GET['token']) : '';

$valid_booking = false;
$booking_details = [];
$rating_submitted = false;

// Validate booking
if ($booking_id > 0 && !empty($token)) {
    $stored_token = get_post_meta($booking_id, '_rating_token', true);
    $booking_status = get_post_status($booking_id);

    if ($token === $stored_token && $booking_status === 'publish') {
        $valid_booking = true;
        $booking_details = [
            'customer_name'   => get_post_meta($booking_id, '_customer_name', true),
            'tour_package'    => get_post_meta($booking_id, '_tour_package', true),
            'tour_date'       => get_post_meta($booking_id, '_tour_date', true),
            'booking_number'  => get_post_meta($booking_id, '_booking_number', true)
        ];

        if (get_post_meta($booking_id, '_tour_rating', true)) {
            $valid_booking = false;
            $rating_submitted = true;
        }
    }
}

// Handle rating submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['submit_rating']) && $valid_booking) {
    $rating = intval($_POST['rating']);
    $review = sanitize_textarea_field($_POST['review']);

    if ($rating >= 1 && $rating <= 5) {
        update_post_meta($booking_id, '_tour_rating', $rating);
        update_post_meta($booking_id, '_tour_review', $review);
        update_post_meta($booking_id, '_rating_date', current_time('mysql'));
        delete_post_meta($booking_id, '_rating_token');
        $rating_success = true;
    } else {
        $rating_error = 'Please select a valid rating.';
    }
}
?>

<div class="rating-page-container">
    <div class="rating-form-wrapper">
        <?php if (!$valid_booking && !$rating_submitted && !isset($rating_success)): ?>
            <div class="rating-error">
                <h2>Invalid Rating Link</h2>
                <p>The rating link is invalid or has expired. Please contact us if you believe this is an error.</p>
                <a href="<?php echo esc_url(home_url('/contact-us/')); ?>" class="button">Contact Us</a>
            </div>

        <?php elseif ($rating_submitted): ?>
            <div class="rating-success">
                <h2>✅ Thank You!</h2>
                <p>You have already submitted your rating for this tour. We appreciate your feedback!</p>
                <a href="<?php echo esc_url(home_url('/')); ?>" class="button">Return to Homepage</a>
            </div>

        <?php elseif (isset($rating_success)): ?>
            <div class="rating-success">
                <h2>✅ Thank You for Your Feedback!</h2>
                <p>Your rating has been submitted successfully.</p>
                <div class="rating-summary">
                    <p><strong>Your Rating:</strong>
                        <?php
                        $submitted_rating = get_post_meta($booking_id, '_tour_rating', true);
                        echo str_repeat('⭐', $submitted_rating) . " ({$submitted_rating}/5)";
                        ?>
                    </p>
                </div>
                <a href="<?php echo esc_url(home_url('/')); ?>" class="button">Return to Homepage</a>
            </div>

        <?php else: ?>
            <div class="rating-form">
                <h1>Rate Your Tour Experience</h1>
                <div class="booking-details">
                    <p><strong>Tour:</strong> <?php echo esc_html($booking_details['tour_package']); ?></p>
                    <p><strong>Date:</strong> <?php echo esc_html($booking_details['tour_date']); ?></p>
                    <p><strong>Booking Reference:</strong> <?php echo esc_html($booking_details['booking_number']); ?></p>
                </div>

                <?php if (isset($rating_error)): ?>
                    <div class="error-message"><?php echo esc_html($rating_error); ?></div>
                <?php endif; ?>

                <form method="post" class="rating-form-content">
                    <div class="form-group">
                        <label>How would you rate your overall experience? *</label>
                        <div class="star-rating">
                            <?php for ($i = 1; $i <= 5; $i++): ?>
                                <span class="star" data-value="<?php echo $i; ?>">&#9733;</span>
                            <?php endfor; ?>
                            <input type="hidden" name="rating" id="rating" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="review">Share your experience (optional)</label>
                        <textarea id="review" name="review" rows="5" placeholder="What did you enjoy most? Any suggestions for improvement?"></textarea>
                    </div>

                    <button type="submit" name="submit_rating" class="submit-rating">Submit Rating</button>
                </form>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.rating-page-container {
    max-width: 800px;
    margin: 50px auto;
    padding: 20px;
}
.rating-form-wrapper {
    background: #fff;
    border-radius: 12px;
    box-shadow: 0 4px 25px rgba(0,0,0,0.1);
    padding: 40px;
}
.rating-form h1 {
    color: #710b0d;
    text-align: center;
    margin-bottom: 30px;
}
.booking-details {
    background: #f8f9fa;
    padding: 20px;
    border-radius: 8px;
    margin-bottom: 30px;
    border-left: 4px solid #710b0d;
}

/* Stars look */
.star-rating {
    display: flex;
    gap: 10px;
    font-size: 2.5em;
    cursor: pointer;
    margin: 20px 0;
}
.star {
    color: #ccc; /* default gray */
    transition: color 0.2s, transform 0.2s;
}
.star:hover,
.star.hovered {
    color: gold; /* hover preview */
    transform: scale(1.1);
}
.star.selected {
    color: gold; /* selected stars */
}

/* Other styling */
.form-group {
    margin-bottom: 25px;
}
.form-group label {
    display: block;
    margin-bottom: 8px;
    font-weight: bold;
}
textarea {
    width: 100%;
    padding: 12px;
    border: 1px solid #ddd;
    border-radius: 5px;
    resize: vertical;
}
.submit-rating {
    background: plum;
    color: white;
    padding: 15px 30px;
    border: none;
    border-radius: 5px;
    font-size: 16px;
    cursor: pointer;
    width: 100%;
    transition: background 0.3s;
}
.submit-rating:hover { background: #219653; }
.button {
    display: inline-block;
    background: #710b0d;
    color: white;
    padding: 12px 25px;
    text-decoration: none;
    border-radius: 5px;
    margin-top: 20px;
}
.rating-success, .rating-error {
    text-align: center;
    padding: 40px;
}
.rating-success h2 { color: #27ae60; }
.rating-error h2 { color: #e74c3c; }
.rating-summary {
    background: #f8f9fa;
    padding: 15px;
    border-radius: 5px;
    margin: 20px 0;
}
.error-message {
    color: #e74c3c;
    margin-bottom: 15px;
}
</style>

<script>
jQuery(document).ready(function($) {
    let selectedRating = 0;

    // Hover preview
    $('.star').on('mouseenter', function() {
        const value = $(this).data('value');
        $('.star').each(function() {
            $(this).toggleClass('hovered', $(this).data('value') <= value);
        });
    }).on('mouseleave', function() {
        $('.star').removeClass('hovered');
    });

    // Select rating
    $('.star').on('click', function() {
        selectedRating = $(this).data('value');
        $('#rating').val(selectedRating);
        $('.star').each(function() {
            $(this).toggleClass('selected', $(this).data('value') <= selectedRating);
        });
    });
});
</script>

<?php get_footer(); ?>
