<?php get_header();
    include get_template_directory() . '/inc/menus/menu.php'; 
?>

<main role="main">
    <?php 
    // Store the original post data
    $original_post = $post;
    
    // Get the background image safely
    $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($original_post->ID), 'full'); 
    
    // Get excerpt or trimmed content
    $excerpt = $original_post->post_excerpt;
    if (empty($excerpt)) {
        $excerpt = wp_trim_words($original_post->post_content, 30, '...');
    }
    ?>
    
   <section class="parallax-hero">
  <div class="parallax-bg" 
       style="background-image:url('<?php echo $backgroundImg[0] ?: get_template_directory_uri().'/assets/images/default-hero.jpg'; ?>');">
  </div>

  <div class="hero-overlay"></div>

  <div class="container">
    <div class="row">
      <div class="col-lg-10 mx-auto">
        <div class="hero-content">
          <h1 class="hero-title fade-up"><?php echo esc_html($original_post->post_title); ?></h1>


          <div class="hero-breadcrumb fade-up">
            <?php if (function_exists('bcn_display')) : ?>
              <?php bcn_display(); ?> <!-- If Breadcrumb NavXT is installed -->
            <?php else : ?>
              <a href="<?php echo home_url(); ?>">Home</a> » 
              <span><?php echo esc_html($original_post->post_title); ?></span>
            <?php endif; ?>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>


    <!-- Rest of your content -->
    <?php 
    // Reset to original post
    $post = $original_post;
    setup_postdata($post);
    
    if (have_posts()): while (have_posts()) : the_post(); ?>
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <?php the_content(); ?>
        </article>
    <?php endwhile; ?>
    <?php else: ?>
        <article>
            <h2><?php _e('Sorry, nothing to display.', 'kipya'); ?></h2>
        </article>
    <?php endif; ?>

    <?php edit_post_link(); ?>
</main>

<script>
// Enhanced parallax effect with zoom
window.addEventListener('scroll', function() {
    const scrolled = window.pageYOffset;
    const parallaxBg = document.getElementById('parallax-bg');
    const rate = scrolled * -0.5;
    const zoom = 1 + (scrolled * 0.0005); // Subtle zoom on scroll
    
    if (parallaxBg) {
        parallaxBg.style.transform = `translate3d(0, ${rate}px, 0) scale(${Math.min(zoom, 1.2)})`;
    }
});

// Trigger fade-up animations immediately for hero content
document.addEventListener('DOMContentLoaded', function() {
    setTimeout(() => {
        document.querySelectorAll('.fade-up').forEach((el, index) => {
            setTimeout(() => {
                el.style.animationPlayState = 'running';
                el.classList.add('animate');
            }, index * 200); // Stagger the animations
        });
    }, 500); // Start after page load
});

// Additional smooth scroll effect for better performance
let ticking = false;
function updateParallax() {
    const scrolled = window.pageYOffset;
    const parallaxBg = document.getElementById('parallax-bg');
    const rate = scrolled * -0.3;
    
    if (parallaxBg) {
        parallaxBg.style.transform = `translate3d(0, ${rate}px, 0)`;
    }
    ticking = false;
}

function requestTick() {
    if (!ticking) {
        requestAnimationFrame(updateParallax);
        ticking = true;
    }
}

window.addEventListener('scroll', requestTick);
</script>

<?php get_footer(); ?>