<?php
// === Shortcode to Display Blog + News Posts in 4x1 Grid Cards ===
function explore_posts_shortcode() {
    ob_start();

    $args = array(
        'post_type'      => 'post',
        'posts_per_page' => 12,
        'category_name'  => 'blog,news', // posts in "blog" OR "news"
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) : ?>
        <div class="explore-posts-grid">
            <?php while ($query->have_posts()) : $query->the_post(); ?>
                <div class="explore-post-card">
                    
                    <!-- Featured Image -->
                    <div class="explore-post-thumb">
                        <a href="<?php the_permalink(); ?>">
                            <?php if (has_post_thumbnail()) {
                                the_post_thumbnail('medium_large', ['class' => 'explore-post-img']);
                            } else { ?>
                                <img src="<?php echo get_template_directory_uri(); ?>/assets/images/photo-placeholder.jpg" class="explore-post-img" alt="Post thumbnail">
                            <?php } ?>
                        </a>
                    </div>

                    <!-- Card Body -->
                    <div class="explore-post-body">
                        <div class="explore-post-meta">
                            <span><i class="bi bi-calendar-event"></i> <?php echo get_the_date(); ?></span>
                            <?php $cats = get_the_category(); 
                            if (!empty($cats)) : ?>
                                <span><i class="bi bi-folder"></i> <?php echo esc_html($cats[0]->name); ?></span>
                            <?php endif; ?>
                        </div>

                        <a href="<?php the_permalink(); ?>" class="explore-post-title-link">
                            <h3 class="explore-post-title"><?php the_title(); ?></h3>
                        </a>

                        <p class="explore-post-excerpt">
                            <?php echo wp_trim_words(get_the_excerpt(), 18, '...'); ?>
                        </p>

                        <a href="<?php the_permalink(); ?>" class="explore-read-more">
                            Read More <i class="bi bi-arrow-right"></i>
                        </a>
                    </div>
                </div>
            <?php endwhile; wp_reset_postdata(); ?>
        </div>

    <?php else :
        echo '<p>No posts found.</p>';
    endif;

    return ob_get_clean();
}
add_shortcode('explore_posts', 'explore_posts_shortcode');


/**
 *******************************
 *  gallery
 *******************************
**/
function gallery_cards_shortcode($atts) {
    ob_start();
    
    // Shortcode attributes
    $atts = shortcode_atts(array(
        'posts_per_page' => -1,
        'category' => 'photo-gallery'
    ), $atts);
    
    // Pagination
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    
    // Query arguments
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'category_name' => $atts['category'],
        'paged' => $paged
    );
    
    $gallery_query = new WP_Query($args);
    
    if ($gallery_query->have_posts()) : ?>
        <div class="gallery-cards-container">
            <div class="gallery-grid">
                <?php while ($gallery_query->have_posts()) : $gallery_query->the_post(); ?>
                    <div class="gallery-card">
                        <a href="<?php the_permalink(); ?>" class="gallery-card-link">
                            <div class="gallery-thumbnail-wrapper">
                                <?php if (has_post_thumbnail()) : ?>
                                    <?php the_post_thumbnail('large', array('class' => 'gallery-thumbnail')); ?>
                                <?php else : ?>
                                    <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/photo-placeholder.jpg'); ?>" 
                                         alt="<?php esc_attr(the_title()); ?>" 
                                         class="gallery-thumbnail">
                                <?php endif; ?>
                                <div class="gallery-title-overlay">
                                    <h3 class="gallery-title"><?php the_title(); ?></h3>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endwhile; ?>
            </div>
            
            <!-- Pagination -->
            <div class="gallery-pagination">
                <?php
                echo paginate_links(array(
                    'total' => $gallery_query->max_num_pages,
                    'current' => $paged,
                    'prev_text' => __('<span class="pagination-arrow">&larr;</span> Previous'),
                    'next_text' => __('Next <span class="pagination-arrow">&rarr;</span>'),
                    'type' => 'list',
                    'mid_size' => 2
                ));
                ?>
            </div>
        </div>
        
        
    <?php else : ?>
        <p class="no-galleries">No photo galleries found.</p>
    <?php endif;
    
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('gallery', 'gallery_cards_shortcode');

// Enhanced Fancybox initialization
function enqueue_lightbox_assets() {
    wp_enqueue_style('fancybox-css', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.css');
    wp_enqueue_script('fancybox-js', 'https://cdnjs.cloudflare.com/ajax/libs/fancybox/3.5.7/jquery.fancybox.min.js', array('jquery'), null, true);
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css');
    
    wp_add_inline_script('fancybox-js', '
        jQuery(document).ready(function($) {
            $("[data-fancybox]").fancybox({
                buttons: ["zoom", "slideShow", "thumbs", "close"],
                animationEffect: "fade",
                transitionEffect: "slide",
                loop: true,
                infobar: true,
                toolbar: true,
                protect: false,
                modal: false,
                touch: {
                    vertical: true,
                    momentum: true
                },
                thumbs: {
                    autoStart: false,
                    hideOnClose: true,
                    parentEl: ".fancybox-container",
                    axis: "y"
                },
                caption: function(instance, item) {
                    var caption = $(item.opts.$orig).data("caption");
                    return caption && caption.trim() ? 
                        "<div class=\"fancybox-caption-custom\">" + caption + "</div>" : 
                        "";
                },
                beforeShow: function(instance, current) {
                    // Enhanced caption styling
                    if (!$("#fancybox-caption-styles").length) {
                        $("head").append(`
                            <style id="fancybox-caption-styles">
                                .fancybox-caption-custom {
                                    color: #fff !important;
                                    font-size: 16px;
                                    line-height: 1.4;
                                    padding: 12px 20px;
                                    background: rgba(0,0,0,0.8);
                                    border-radius: 6px;
                                    text-align: center;
                                    margin: 10px auto 0;
                                    max-width: 80%;
                                    backdrop-filter: blur(10px);
                                }
                                .fancybox-caption {
                                    color: #fff !important;
                                    text-align: center !important;
                                }
                                .fancybox-toolbar {
                                    background: rgba(0,0,0,0.5) !important;
                                }
                                @media (max-width: 768px) {
                                    .fancybox-caption-custom {
                                        font-size: 14px;
                                        padding: 10px 15px;
                                        max-width: 90%;
                                    }
                                }
                            </style>
                        `);
                    }
                }
            });
        });
    ');
}
add_action('wp_enqueue_scripts', 'enqueue_lightbox_assets');


// AJAX handler for image data
add_action('wp_ajax_get_image_data', 'get_image_data_callback');
add_action('wp_ajax_nopriv_get_image_data', 'get_image_data_callback');

function get_image_data_callback() {
    $image_id = intval($_GET['id']);
    $image_url = wp_get_attachment_image_url($image_id, 'full');
    $image_caption = get_the_title($image_id);
    
    wp_send_json(array(
        'url' => $image_url,
        'caption' => $image_caption
    ));
}

?>
