


jQuery(document).ready(function($) {
    // Handle itinerary accordion
    $('.itinerary-day h3').click(function() {
        $(this).toggleClass('active');
        $(this).next('.day-content').slideToggle();
    });
    
    // Open first itinerary by default
    $('.itinerary-day:first-child h3').addClass('active');
    $('.itinerary-day:first-child .day-content').slideDown();

    // Handle booking form submission
    $('#uganda-booking-form').on('submit', function(e) {
        e.preventDefault();
        
        var form = $(this);
        var formData = form.serialize();
        var notice = form.find('.form-notice');
        
        // Show loading state
        form.find('button[type="submit"]').text('Processing...').prop('disabled', true);
        
        $.ajax({
            url: '<?php echo admin_url("admin-ajax.php"); ?>',
            type: 'POST',
            data: formData + '&action=explore_uganda_process_booking',
            success: function(response) {
                if (response.success) {
                    notice.removeClass('error').addClass('success').html(response.data).show();
                    form[0].reset();
                    
                    // Scroll to notice
                    $('html, body').animate({
                        scrollTop: notice.offset().top - 100
                    }, 500);
                } else {
                    notice.removeClass('success').addClass('error').html(response.data).show();
                }
            },
            error: function() {
                notice.removeClass('success').addClass('error').html('An error occurred. Please try again.').show();
            },
            complete: function() {
                form.find('button[type="submit"]').text('Submit Booking Request').prop('disabled', false);
            }
        });
    });
});

// Simple intersection observer for fade-up animations
        document.addEventListener('DOMContentLoaded', function() {
            const fadeElems = document.querySelectorAll('.fadeUp');
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.style.visibility = 'visible';
                        return;
                    }
                    entry.target.style.visibility = 'hidden';
                });
            });
            
            fadeElems.forEach(elem => {
                elem.style.visibility = 'hidden';
                observer.observe(elem);
            });
        });


/**====================================
* AOS
=====================================**/
     document.addEventListener('DOMContentLoaded', function () {
    // Initialize AOS for each column
    if (typeof AOS !== 'undefined') {
        AOS.init({
            duration: 1000,
            easing: 'ease-in-out',
            once: true,
            mirror: false,
        });
    }
});

