<?php
/**
 * Template Name: BORApos Landing Page
 * Description: Simple, Affordable & Reliable Cloud POS System
 */
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>BORApos | Simple, Affordable & Reliable Cloud POS System</title>
<meta name="description" content="BORApos is a simple, affordable, and reliable cloud-based POS system designed to streamline your business operations.">
<meta name="keywords" content="BORApos, point of sale, POS system, cloud POS, business management, retail software, Tanzania tech, inventory, billing, sales tracking">
<meta name="author" content="BORApos Team">
<link rel="icon" type="image/png" href="images/bora-fav.png">
<link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;600;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
:root{--primary:#b90000;--primary-light:#e32d2d;--white:#fff;--bg-light:#fff9f9;--text-dark:#1e1e1e;--gray-light:#f5f5f5;--gray-border:#e0e0e0;}
*{margin:0;padding:0;box-sizing:border-box;}
body{font-family:"Montserrat",sans-serif;background:var(--bg-light);color:var(--text-dark);scroll-behavior:smooth;}
#mainNav{position:fixed;top:0;width:100%;display:flex;justify-content:space-between;align-items:center;padding:18px 60px;z-index:1000;transition:all 0.3s ease;}
#mainNav.scrolled{background:var(--white);padding:12px 50px;}
.logo img{width:200px;}
.nav-menu{list-style:none;display:flex;align-items:center;gap:28px;}
.nav-menu li a{text-decoration:none;font-weight:600;color:var(--primary);transition:color 0.3s ease;}
.nav-menu li a:hover,.nav-menu li a.active{color:var(--primary-light);}
.btn-menu a,.btn-request a{text-decoration:none;font-weight:600;border-radius:30px;padding:10px 24px;transition:all 0.3s ease;}
.btn-menu a{background:var(--white);border:2px solid var(--primary);color:var(--primary);}
.btn-menu a:hover{background:var(--primary);color:var(--white)!important;}
.btn-request a{background:var(--primary);color:var(--white)!important;box-shadow:0 3px 10px rgba(185,0,0,0.25);}
.btn-request a:hover{background:var(--white);color:var(--primary)!important;}
.hero{background:var(--white);display:grid;grid-template-columns:1fr 1fr;align-items:center;min-height:100vh;padding:160px 80px 100px;gap:60px;position:relative;overflow:hidden;}
.hero::after{content:"";position:absolute;bottom:0;left:0;width:100%;height:120px;background:var(--primary);clip-path:polygon(0 80%,100% 0,100% 100%,0% 100%);}
.hero-content{z-index:2;}
.hero-content h1{font-size:50px;font-weight:800;color:var(--primary);line-height:1.2;margin-bottom:20px;}
.hero-content p{font-size:18px;color:#444;margin-bottom:40px;max-width:500px;}
.cta-section a{background:var(--primary);color:var(--white);padding:14px 30px;border-radius:50px;font-weight:600;text-decoration:none;transition:all 0.3s ease;margin-right:15px;display:inline-block;}
.cta-section a:hover{background:var(--primary-light);transform:translateY(-3px);}
.hero-img{max-width:100%;z-index:1;animation:float 4s ease-in-out infinite; height:480px;}
@keyframes float{0%,100%{transform:translateY(0);}50%{transform:translateY(-10px);}}
section{padding:20px 20px;text-align:center;}
section h2{color:var(--primary);margin-bottom:15px;font-size:32px;}
footer{background:var(--primary);color:var(--white);text-align:center;padding:30px 20px;}
.business-section{display:flex;justify-content:center;align-items:center;padding:80px 0;background:#fff;}
.business-content{display:flex;align-items:center;gap:60px;max-width:1100px;width:100%;padding:0 20px;}
.business-image{flex:1;display:flex;justify-content:center;}
.business-image img{width:100%;max-width:520px;border-radius:12px;}
.business-text{flex:1;text-align:left;}
.business-text h2{font-size:2.4rem;margin-bottom:20px;color:var(--primary);}
.business-text p{font-size:1.1rem;line-height:1.6;margin-bottom:30px;color:#333;}
.nav-buttons{display:flex;gap:16px;margin-top:40px; margin-left:150px;}
.nav-btn{width:48px;height:48px;border-radius:50%;border:1.5px solid #ddd;background:#f8f8f8;cursor:pointer;font-size:20px;transition:all 0.3s;}
.nav-btn:hover,.nav-btn.active{border-color:var(--primary-light);background:#ffecec;}
@media(max-width:992px){#mainNav{flex-wrap:wrap;padding:14px 25px;}.hero{grid-template-columns:1fr;text-align:center;padding:140px 30px 100px;}.hero-content{order:2;}.hero-img{order:1;margin-bottom:30px;max-width:90%;}.hero::after{height:80px;}.business-content{flex-direction:column;}.business-text{text-align:center;}}
/* ---------------------------- FAQ SECTION STYLING ----------------------------- */
.faq-section{background:#fff;color:#222;padding:80px 20px;}
.faq-header{text-align:center;margin-bottom:40px;}
.faq-header h3{font-size:2.5rem;color:#b50000;font-weight:700;margin-bottom:10px;}
.faq-header p{color:#555;font-size:1.1rem;}
.faq-accordion{max-width:800px;margin:0 auto;}
.faq-item{border:1px solid #eee;border-radius:10px;margin-bottom:15px;overflow:hidden;transition:box-shadow 0.3s ease;background:#fff;}
.faq-item:hover{box-shadow:0 4px 12px rgba(0,0,0,0.05);}
.faq-question{background:#fff;color:#222;font-weight:600;width:100%;text-align:left;padding:18px 24px;border:none;cursor:pointer;display:flex;justify-content:space-between;align-items:center;font-size:1.05rem;transition:background 0.3s ease;}
.faq-question:hover{background:#fff5f5;}
.faq-icon{font-size:1.5rem;color:#b50000;transition:transform 0.3s ease;}
.faq-answer{max-height:0;overflow:hidden;background:#fff9f9;padding:0 24px;transition:all 0.4s ease;line-height:1.6;color:#444;}
.faq-answer p{margin:15px 0;}
.faq-answer a.text-highlight{color:#b50000;font-weight:600;text-decoration:none;}
.faq-answer a.text-highlight:hover{text-decoration:underline;}
.faq-item.active .faq-answer{max-height:400px;padding:18px 24px;}
.faq-item.active .faq-icon{transform:rotate(45deg);}

/* ============================= Footer Styling - Red & Yellow ============================= */ 
.site-footer { background-color: #b30000; color: #fff; padding: 25px 0; font-family: "Poppins", sans-serif; border-top: 4px solid #ffc107; } 
.footer-copyright { background-color: #b30000; } 
.copyright { font-size: 15px; color: #fff; margin: 0; } 
.copyright a { color: #ffc107; font-weight: 600; text-decoration: none; transition: all 0.3s ease; } 
.copyright a:hover { color: #fff; text-decoration: underline; } 
.footer-menu { display: inline-block; } 
.footer-menu a { color: #fff; font-size: 15px; text-decoration: none; font-weight: 500; transition: all 0.3s ease; margin: 0 5px; } 
.footer-menu a:hover { color: #ffc107; } 
.footer-menu span { color: #ffc107; } 
@media (max-width: 767px) { .footer-menu { display: block; margin-top: 10px; } .footer-menu a { display: inline-block; margin: 5px 8px; } }

/* ============================= Subscription Section Styling ============================= */

.subscription-section { background: linear-gradient(135deg, #c3000021 0%, #c500001c 100%); padding: 80px 20px; position: relative; overflow: hidden; } 
.container { max-width: 1200px; margin: 0 auto; } 
.section-title { text-align: center; margin-bottom: 60px; } 
.section-title h3 { font-weight: 700; color: #b30000; font-size: 2.5rem; margin-bottom: 15px; position: relative; display: inline-block; } 
.section-title h3::after { content: ""; position: absolute; bottom: -10px; left: 50%; transform: translateX(-50%); width: 80px; height: 3px; background: #ffc107; border-radius: 2px; } 
.section-title img.feature { width: 200px; margin-right: 10px; vertical-align: middle; } 
.section-description { color: #666; font-size: 1.1rem; max-width: 600px; margin: 30px auto 0; line-height: 1.6; } 
.subscription-plans { display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 30px; margin-bottom: 40px; } 
.price-table { background: #ffffff; border-radius: 16px; box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08); text-align: center; transition: all 0.4s ease; position: relative; overflow: hidden; height: 100%; display: flex; flex-direction: column; } 
.price-table::before { content: ""; position: absolute; top: 0; left: 0; right: 0; height: 4px; background: #ffc107; } 
.price-table:hover { transform: translateY(-10px); box-shadow: 0 15px 40px rgba(179, 0, 0, 0.15); } 
.plan-header { padding: 30px 25px 20px; border-bottom: 1px solid #f0f0f0; } 
.plan-type { font-size: 1.5rem; color: #b30000; font-weight: 600; margin-bottom: 15px; } 
.plan-price { display: flex; align-items: baseline; justify-content: center; gap: 5px; margin-bottom: 10px; } 
.currency { font-size: 1rem; color: #666; font-weight: 500; } 
.amount { font-size: 2.5rem; font-weight: 700; color: #000; line-height: 1; } 
.period { font-size: 0.9rem; color: #777; font-weight: 500; } 
.plan-features { padding: 25px; flex-grow: 1; } 
.plan-list { list-style: none; font-size: 15px; color: #333; } 
.plan-list li { padding: 12px 0; border-bottom: 1px solid #f5f5f5; display: flex; align-items: center; justify-content: flex-start; text-align: left; } 
.plan-list li:last-child { border-bottom: none; } 
.plan-list i { color: #28a745; margin-right: 10px; font-size: 14px; } 
.plan-footer { padding: 0 25px 30px; } 
.btn-plan { display: inline-block; background: #ffc107; color: #b30000; font-weight: 600; text-transform: uppercase; border-radius: 50px; padding: 12px 30px; text-decoration: none; transition: all 0.3s ease; width: 100%; box-shadow: 0 4px 10px rgba(255, 193, 7, 0.3); } 
.btn-plan:hover { background: #b30000; color: #fff; transform: translateY(-2px); box-shadow: 0 6px 15px rgba(179, 0, 0, 0.3); } 
.popular { background: linear-gradient(135deg, #b30000 0%, #d10000 100%); color: #fff; box-shadow: 0 15px 40px rgba(179, 0, 0, 0.2); transform: scale(1.05); z-index: 1; } 
.popular:hover { transform: scale(1.05) translateY(-10px); } 
.popular .plan-header { border-color: rgba(255, 255, 255, 0.2); } 
.popular .plan-type { color: #fff; } 
.popular .plan-price .currency, .popular .plan-price .amount, .popular .plan-price .period { color: #fff; } 
.popular .plan-list li { border-color: rgba(255, 255, 255, 0.15); color: #fff; } 
.popular .plan-list i { color: #ffc107; } 
.popular-btn { background: #ffc107; color: #b30000; } 
.popular-btn:hover { background: #fff; color: #b30000; } 
.card-ribbon { position: absolute; top: 20px; right: -35px; transform: rotate(45deg); background: #ffc107; color: #b30000; font-weight: 700; padding: 5px 40px; font-size: 14px; box-shadow: 0 2px 5px rgba(0, 0, 0, 0.2); z-index: 2; } 
.plan-note { color: #777; font-size: 0.95rem; font-style: italic; text-align: center; } 
@media (max-width: 1024px) { .subscription-plans { grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); } } 
@media (max-width: 768px) { .subscription-section { padding: 60px 20px; } .section-title h3 { font-size: 2rem; } .plan-price { flex-direction: column; gap: 0; } .amount { font-size: 2rem; } .popular { transform: scale(1); } .popular:hover { transform: translateY(-10px); } } 
@media (max-width: 480px) { .subscription-plans { grid-template-columns: 1fr; } .section-title h3 { font-size: 1.8rem; } }


/* ---------------------------- BORA TREE SECTION ----------------------------- */
.bora-tree{background:var(--primary);color:#fff;text-align:center;font-family:'Poppins',sans-serif;padding:5px 0;position:relative;overflow:hidden;}
.bora-header h3{font-size:2rem;font-weight:700;margin-bottom:10px;}
.bora-header .logo{height:35px;margin-right:8px;vertical-align:middle;filter:brightness(0) invert(1);}
.bora-header p{font-size:1rem;opacity:0.9;}
.bora-network{position:relative;width:100%;max-width:1300px;margin:20px auto 0;height:550px;}
.bora-network svg.connections{position:absolute;width:100%;height:100%;top:0;left:0;fill:none;stroke:rgba(255,255,255,0.25);stroke-width:2;}
.hub{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);z-index:10;}
.hub img{width:520px;transition:transform 0.4s ease;}
.hub img:hover{transform:scale(1.05);}
.node{position:absolute;background:rgba(255,255,255,0.1);border:1px solid rgba(255,255,255,0.2);border-radius:16px;padding:16px;width:220px;backdrop-filter:blur(6px);box-shadow:0 6px 18px rgba(0,0,0,0.2);text-align:left;transition:transform 0.3s ease,box-shadow 0.3s ease;}
.node i{font-size:1.8rem;color:#fff;margin-bottom:6px;display:block;}
.node h4{font-size:1rem;font-weight:600;margin-bottom:4px;}
.node p{font-size:0.9rem;opacity:0.85;}
.node:hover{transform:translateY(-6px);box-shadow:0 10px 25px rgba(0,0,0,0.3);}
.node1{top:40px;left:120px;}
.node2{top:230px;left:60px;}
.node3{bottom:80px;left:120px;}
.node4{top:40px;right:120px;}
.node5{top:230px;right:60px;}
.node6{bottom:40px;right:120px;}
@media(max-width:992px){.bora-network{height:auto;}.bora-network svg.connections{display:none;}.hub{position:relative;transform:none;top:0;left:0;margin:0 auto 40px;}.node{position:relative;margin:20px auto;width:90%;text-align:center;}}
.business-section { display: flex; flex-direction: column; align-items: center; justify-content: center; padding: 80px 20px; background: #fff; }
.business-header { text-align: center; margin-bottom: 40px; }
.business-header h3 { position: relative; font-size: 2.5rem; color: #b50000; font-weight: 800; margin-bottom: 20px; display: inline-block; }
.business-header h3::after { content: ""; position: absolute; bottom: -10px; left: 50%; transform: translateX(-50%); width: 80px; height: 3px; background: #ffc107; border-radius: 2px; }
.business-header p { color: #555; max-width: 700px; margin: 0 auto; line-height: 1.6; }
.business-content { display: flex; align-items: center; justify-content: center; gap: 40px; flex-wrap: wrap; }


</style>
</head>

<body>

<div id="mainNav">
  <div class="logo"><a href="#home"><img src="images/bora-logo.png" alt="BORApos logo"></a></div>
  <ul class="nav-menu">
    <li><a href="#home" class="active">Home</a></li>
    <li><a href="#features">Features</a></li>
    <li><a href="#pricing">Pricing</a></li>
    <li><a href="#faqs">FAQs</a></li>
    <li class="btn-menu"><a href="https://app.borapos.cloud">My Account</a></li>
    <li class="btn-request"><a href="#pricing">Submit Request</a></li>
  </ul>
</div>

<section id="home" class="hero">
  <div class="hero-content">
    <h1>Empower Your Business with <span style="color:#e32d2d;">BORApos</span></h1>
    <p>Experience a simple, affordable, and reliable cloud-based POS system crafted for growing businesses across Tanzania.</p>
    <div class="cta-section">
      <a href="https://app.borapos.cloud">My Account</a>
      <a href="#pricing">Submit Request</a>
    </div>
  </div>
  <img src="images/slide.png" alt="BORApos dashboard" class="hero-img">
</section>



<section id="features" class="bora-tree">
  <div class="container">
    <!-- Title -->
    <div class="bora-header" data-aos="fade-down">
      <h3><img src="images/bora-logo.png" class="logo" alt="BORApos"> Modules</h3>
      <p>Simplify. Streamline. Succeed. With BORApos.</p>
    </div>

    <!-- Tree Canvas -->
    <div class="bora-network">
      <!-- SVG Connections -->
      <svg class="connections" viewBox="0 0 1000 550" preserveAspectRatio="xMidYMid meet">
        <!-- Left Connections -->
        <path d="M500 275 C360 140, 250 90, 150 140" />
        <path d="M500 275 C370 210, 260 200, 150 240" />
        <path d="M500 275 C360 330, 260 340, 150 380" />

        <!-- Right Connections -->
        <path d="M500 275 C640 140, 750 90, 850 140" />
        <path d="M500 275 C630 210, 740 200, 850 240" />
        <path d="M500 275 C640 330, 740 340, 850 380" />
      </svg>

      <!-- Center Hub -->
      <div class="hub" data-aos="zoom-in">
        <img src="images/Borapos-dashboard.png" alt="BORApos Hub">
      </div>

      <!-- Left Nodes -->
      <div class="node left node1" data-aos="fade-right">
        <i class="bi bi-card-checklist"></i>
        <h4>Sales Management</h4>
        <p>Effortlessly process transactions, track sales, and monitor performance.</p>
      </div>

      <div class="node left node2" data-aos="fade-right" data-aos-delay="100">
        <i class="bi bi-clipboard-data"></i>
        <h4>Stock Management</h4>
        <p>Maintain accurate inventory levels and avoid stockouts.</p>
      </div>

      <div class="node left node3" data-aos="fade-right" data-aos-delay="200">
        <i class="bi bi-cash-coin"></i>
        <h4>Expenses</h4>
        <p>Keep track of your expenditure in your daily business operations.</p>
      </div>

      <!-- Right Nodes -->
      <div class="node right node4" data-aos="fade-left">
        <i class="bi bi-people"></i>
        <h4>Staff Management</h4>
        <p>Efficiently manage schedules, track attendance, and empower your team.</p>
      </div>

      <div class="node right node5" data-aos="fade-left" data-aos-delay="100">
        <i class="bi bi-person-gear"></i>
        <h4>Customer Management</h4>
        <p>Build lasting connections with your customers through personalized interactions.</p>
      </div>

      <div class="node right node6" data-aos="fade-left" data-aos-delay="200">
        <i class="bi bi-file-pdf"></i>
        <h4>Reports / Insights</h4>
        <p>Access comprehensive analytics to make data-driven decisions and drive growth.</p>
      </div>
    </div>
  </div>
</section>



<section class="business-section">
  <!-- Section Heading -->
  <div class="business-header">
    <h3>Explore Our Business Solutions</h3>
    <p>Tailored tools to help your business thrive — from grocery stores to retail and more.</p>
  </div>

  <!-- Section Content -->
  <div class="business-content">
    <div class="business-image">
      <img id="biz-image" src="images/board.png" alt="Grocery">
    </div>

    <div class="business-text">
      <h2 id="biz-title">Grocery Stores</h2>
      <p id="biz-desc">
        Track stock, manage cashiers, and generate instant reports all in one dashboard. Ideal for supermarkets and minimarts.
      </p>
      <div class="nav-buttons">
        <button id="prev-btn" class="nav-btn">&#8592;</button>
        <button id="next-btn" class="nav-btn active">&#8594;</button>
      </div>
    </div>
  </div>
</section>




    <section id="pricing" class="subscription-section">
        <div class="container">
            <div class="section-title">
                <h3>
                    <img src="images/bora-logo.png" class="feature" alt="BORApos">
                    <span class="highlight">Subscription Plans</span>
                </h3>
                <p class="section-description">Choose the perfect plan for your business needs. All plans include full-time support and access to all modules.</p>
            </div>

            <div class="subscription-plans">
                <!-- Plan 1 -->
                <div class="price-table">
                    <div class="plan-header">
                        <h3 class="plan-type">Free</h3>
                        <div class="plan-price">
                            <span class="currency">UGX</span>
                            <span class="amount">0</span>
                            <span class="period">/Month</span>
                        </div>
                    </div>
                    <div class="plan-features">
                        <ul class="plan-list">
                            <li><i class="fas fa-check"></i> 500 Monthly Transactions</li>
                            <li><i class="fas fa-check"></i> 1 Branch</li>
                            <li><i class="fas fa-check"></i> 3 Users</li>
                            <li><i class="fas fa-check"></i> Full Modules Access</li>
                            <li><i class="fas fa-check"></i> Full Reports</li>
                            <li><i class="fas fa-check"></i> Full-time Support</li>
                        </ul>
                    </div>
                    <div class="plan-footer">
                        <a class="btn-plan" href="https://app.borapos.cloud/submit-request/6394538d41534b93a85f45857171cd09d16f1266">Get Started</a>
                    </div>
                </div>

                <!-- Plan 2 -->
                <div class="price-table popular">
                    <div class="card-ribbon"><span>Most Popular</span></div>
                    <div class="plan-header">
                        <h3 class="plan-type">Startup</h3>
                        <div class="plan-price">
                            <span class="currency">UGX</span>
                            <span class="amount">20,000</span>
                            <span class="period">/Month</span>
                        </div>
                    </div>
                    <div class="plan-features">
                        <ul class="plan-list">
                            <li><i class="fas fa-check"></i> Unlimited Transactions</li>
                            <li><i class="fas fa-check"></i> 2 Branches</li>
                            <li><i class="fas fa-check"></i> 5 Users</li>
                            <li><i class="fas fa-check"></i> Full Modules Access</li>
                            <li><i class="fas fa-check"></i> Full Reports</li>
                            <li><i class="fas fa-check"></i> Full-time Support</li>
                        </ul>
                    </div>
                    <div class="plan-footer">
                        <a class="btn-plan popular-btn" href="https://app.borapos.cloud/submit-request/326bff182ea18c459dff9443f757a7b9dcee0344">Get Started</a>
                    </div>
                </div>

                <!-- Plan 3 -->
                <div class="price-table">
                    <div class="plan-header">
                        <h3 class="plan-type">Business</h3>
                        <div class="plan-price">
                            <span class="currency">UGX</span>
                            <span class="amount">60,000</span>
                            <span class="period">/Month</span>
                        </div>
                    </div>
                    <div class="plan-features">
                        <ul class="plan-list">
                            <li><i class="fas fa-check"></i> Unlimited Orders</li>
                            <li><i class="fas fa-check"></i> 3 Branches</li>
                            <li><i class="fas fa-check"></i> 10 Users</li>
                            <li><i class="fas fa-check"></i> Full Modules Access</li>
                            <li><i class="fas fa-check"></i> Full Reports</li>
                            <li><i class="fas fa-check"></i> Full-time Support</li>
                        </ul>
                    </div>
                    <div class="plan-footer">
                        <a class="btn-plan" href="https://app.borapos.cloud/submit-request/3072b0dfc7df0a3b1a504fe1813c6a9c2b559ed7">Get Started</a>
                    </div>
                </div>
            </div>
            
            <p class="plan-note">All plans include a 14-day free trial. No credit card required.</p>
        </div>
    </section>

<section id="faqs" class="faq-section">
  <div class="container">
    <div class="faq-header">
      <h3>Frequently Asked Questions</h3>
      <p>Some of the common questions about BORApos.</p>
    </div>

    <div class="faq-accordion">

      <!-- Question 1 -->
      <div class="faq-item">
        <button class="faq-question">
          How do I get started?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>Simply submit your request through this link <a href="https://app.borapos.cloud/submit-request/326bff182ea18c459dff9443f757a7b9dcee0344" class="text-highlight">Submit Request</a>. Our team will reach out with a registration link and onboarding details.</p>
        </div>
      </div>

      <!-- Question 2 -->
      <div class="faq-item">
        <button class="faq-question">
          How does BORApos improve my business?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>BORApos gives you tools for sales, inventory, staff management, and detailed reports — helping you grow faster and smarter.</p>
        </div>
      </div>

      <!-- Question 3 -->
      <div class="faq-item">
        <button class="faq-question">
          Can I manage multiple branches?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p><strong>Yes</strong>. Our Startup and Business packages allow managing multiple branches from one account with separate views for each.</p>
        </div>
      </div>

      <!-- Question 4 -->
      <div class="faq-item">
        <button class="faq-question">
          Who can make sales and update stock?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>Attendants, Managers, and Administrators can make sales. Only Managers and Administrators can update stock, while Administrators have full access.</p>
        </div>
      </div>

      <!-- Question 5 -->
      <div class="faq-item">
        <button class="faq-question">
          Can I pay via Mobile Money?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p><strong>Yes</strong>, BORApos supports subscriptions via Flutterwave and SpringPesa — both allow Mobile Money payments.</p>
        </div>
      </div>

      <!-- Question 6 -->
      <div class="faq-item">
        <button class="faq-question">
          Can I use my account on multiple devices?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p><strong>No</strong>, each account can only be active on one device at a time to ensure business security.</p>
        </div>
      </div>

      <!-- Question 7 -->
      <div class="faq-item">
        <button class="faq-question">
          Is the FREE package for life?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p><strong>Yes</strong>, it’s free for life but limited to 500 transactions per month. Upgrade anytime if you grow beyond that.</p>
        </div>
      </div>

      <!-- Question 8 -->
      <div class="faq-item">
        <button class="faq-question">
          How can I contact the Sales Team?
          <span class="faq-icon">+</span>
        </button>
        <div class="faq-answer">
          <p>
            <a href="./" class="text-highlight">BORApos</a> is a product of 
            <a href="https://www.lwegatech.com" class="text-highlight" target="_blank">LWEGATECH LTD</a>.<br>
            <strong>Tel:</strong> +256 393 193 190<br>
            <strong>Email:</strong> sales@lwegatech.com<br>
            <strong>WhatsApp:</strong> +256 779 918835
          </p>
        </div>
      </div>

    </div>
  </div>
</section>

<script>
/* ----------------------------
   Plain JS Accordion Function
----------------------------- */
document.querySelectorAll(".faq-question").forEach(button => {
  button.addEventListener("click", () => {
    const item = button.parentElement;
    const openItem = document.querySelector(".faq-item.active");

    if (openItem && openItem !== item) {
      openItem.classList.remove("active");
    }

    item.classList.toggle("active");
  });
});
</script>


<footer class="site-footer">
  <div class="footer-copyright">
    <div class="container">
      <div class="row align-items-center">
        <!-- Left Side -->
        <div class="col-md-7 text-center text-md-start mb-3 mb-md-0">
          <p class="copyright mb-0">
            © 2023 <a href="https://borapos.cloud/register" target="_blank">BORApos</a>. All Rights Reserved.
          </p>
        </div>

        <!-- Right Side -->
        <div class="col-md-5 text-center text-md-end">
          <div class="footer-menu">
            <a href="#">Terms &amp; Conditions</a>
            <span>|</span>
            <a href="#">Privacy Policy</a>
            <span>|</span>
            <a href="#">Support</a>
            <span>|</span>
            <a href="#">Documentation</a>
          </div>
        </div>
      </div>
    </div>
  </div>
</footer>




<script>
const slides=[
{title:"Grocery Stores",desc:"Track stock, manage cashiers, and generate instant reports all in one dashboard. Ideal for supermarkets and minimarts.",img:"images/board.png"},
{title:"Cafés",desc:"Manage menus, customer orders, and expenses seamlessly with our POS designed for cafés and bakeries.",img:"images/dashboard.png"},
{title:"Restaurants",desc:"Empower staff with real-time order and billing management for tables and deliveries.",img:"images/dash.png"},
{title:"Bars & Pubs",desc:"Track beverage stock, manage tabs, and monitor sales in real time.",img:"images/hhh.png"},
{title:"Retail Shops",desc:"Handle transactions quickly, track performance, and manage multiple stores in one place.",img:"images/dashb.png"}
];
let index=0;
const title=document.getElementById("biz-title");
const desc=document.getElementById("biz-desc");
const img=document.getElementById("biz-image");
document.getElementById("next-btn").addEventListener("click",()=>{index=(index+1)%slides.length;updateSlide();});
document.getElementById("prev-btn").addEventListener("click",()=>{index=(index-1+slides.length)%slides.length;updateSlide();});
function updateSlide(){const slide=slides[index];title.textContent=slide.title;desc.textContent=slide.desc;img.src=slide.img;}
window.addEventListener("scroll",()=>{const nav=document.getElementById("mainNav");nav.classList.toggle("scrolled",window.scrollY>50);});
</script>

</body>
</html>
