<?php 
if (is_singular('events')) {
    get_header(); 
    include get_template_directory() . '/inc/menus/menu.php'; 
	
	$post_id = get_the_ID();
    $text = get_the_content();
    $url =  get_post_meta(get_the_ID(), '_link', true);
    $location =  get_post_meta(get_the_ID(), '_location', true);
    $start_date = get_post_meta(get_the_ID(), '_start_date', true);
	$end_date = get_post_meta(get_the_ID(), '_end_date', true);
    $formatted_start_date = date('jS, F Y', strtotime($start_date)); // Format for Date
    $formatted_start_month = date('F', strtotime($start_date)); // Format for Month
    $formatted_start_time = date('g:i A', strtotime($start_date)); // Format for Time
	$formatted_end_date = date('jS, F Y', strtotime($end_date)); // Format for Date

	?>
	<main role="main">
		<?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );?>
        <div class="header-wrap1" style="background: linear-gradient(90deg, rgba(0, 0, 0, 0.5), rgba(0, 0, 0, 0.2)), url('<?php echo $backgroundImg[0]; ?>') no-repeat;background-size: cover;background-position: center center;">
            <div class="container"><div class="row"><div class="col-lg-12 text-center">
            <h1 class="news-title aos-init aos-animate" data-aos="fade-up"><?php the_title(); ?></h1>
            <?php custom_breadcrumb(); ?>
            </div></div></div>
        </div>
		<div class="kpy_intro_curve">
				<svg viewBox="0 0 1440 120" xmlns="http://www.w3.org/2000/svg">
					<path fill="#Ffffff" d="M0,60 C360,120 1080,0 1440,60 L1440,120 L0,120 Z"></path>
				</svg>
		</div><!-- Header Section !-->
		<section>
		    <div class="container page-content2">
		        <div class="row">
		            <div class="col-lg-9 col-md-9 col-sm-9" data-aos="fade up">
		                <div class="alert alert-warning mb-3">
		                    <div class="row">
		                        <div class="col-md-4 mb-2">
		                            <h6>Date & Time</h6>
		                            <small>
		                            <?= esc_html($formatted_start_date); ?> 
		                            </small>
		                        </div>
		                        <div class="col-md-4 mb-2">
		                            <h6>Venue</h6>
		                            <small>
		                            <?= esc_html($location); ?>
		                            </small>
		                        </div>
		                        <div class="col-md-4 mb-2">
		                            <h6>Contact details</h6>
		                            <a href="/contact" class="btn btn-sm btn-danger">Talk to Us</a>
		                        </div>
		                    </div>
		                </div>
		                <div class="post-content">
		        <?php if (have_posts()): while (have_posts()) : the_post(); ?>
				<!-- article -->
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				
					<!-- post thumbnail -->
        			<div class="post-thumbnail mt-3">
        			<?php if ( has_post_thumbnail()) : // Check if Thumbnail exists ?>
        				<?php the_post_thumbnail(); // Fullsize image for the single post ?>
        			<?php endif; ?>
        			</div>
        			<!-- /post thumbnail -->
					<hr>
					<?php the_content(); ?>
				
				<!-- social media sharing !-->
				<div class="d-flex justify-content-center bd-highlight mb-1">
                            <div class="bd-highlight p-1">
                                <small class="text-muted">share this article</small>
                            </div>
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?= esc_url(get_permalink()); ?>" target="_blank" rel="noopener noreferrer" title="Facebook">
                                <small>Share on <i class="bi bi-facebook"></i> </small>
                                </a>
                            </div><!-- Facebook !-->
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-twitter" href="https://twitter.com/intent/tweet?url=<?= esc_url(get_permalink()); ?>&text=<?= the_title(); ?>" target="_blank" rel="noopener noreferrer" title="Twitter">
                                <small> Share on <i class="bi bi-twitter-x"></i></small>
                                </a>
                            </div><!-- Twitter !-->
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-whatsapp" href="whatsapp://send?text=Check out this product: <?= the_title(); ?> - <?= esc_url(get_permalink());?>" data-action="share/whatsapp/share" title="WhatsApp">
                                <small><i class="bi bi-whatsapp"></i> WhatsApp</small>
                                </a>
                            </div><!-- WhatsApp !-->
                        </div><!-- social sharing !-->
				<!-- End of Social Media sharing !-->
		        </div>
		        </div>
		        <div class="col-lg-3 col-md-3 col-sm-3">
		            <div class="about-side">
		                <h3>From News & Blog</h3>
		                <?php
                        include get_template_directory() . '/inc/related-news.php';
                        ?>

		            </div>
		        </div>
		        </div>
				<?php edit_post_link(); ?>

			</article>
			<!-- /article -->

		<?php endwhile; ?>

		<?php else: ?>

			<!-- article -->
			<article>

				<h2><?php _e( 'Sorry, nothing to display.', 'kipya' ); ?></h2>

			</article>
			<!-- /article -->

		<?php endif; ?>
		    </div>
		</section>
		<div class="mb-md-5 mt-3"></div>
		<!-- /section -->
 </main>
<?php 
} else {
    // If the post type is not "downloads", you can display a message or redirect to another page
    echo '<p>Sorry, this page is only for Events.</p>';
}
get_footer(); ?>