<?php

/**
 * Shortcode to display Contact Form
 */
function contact_inquiry_form_shortcode() {
    ob_start();

    // Honeypot Field (hidden from real users)
    $honeypot = '<input type="text" name="company_name" style="display:none">';

    // Handle Form Submission
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['contact_inquiry_submit'])) {
        $ip_address = $_SERVER['REMOTE_ADDR'];
        $form_time = $_POST['form_time'] ?? time();
        $current_time = time();

        // Simple rate limit: 1 submission per 60 seconds
        if (($current_time - intval($form_time)) < 60) {
            echo '<div class="alert alert-danger">Please wait before submitting again.</div>';
        } elseif (!empty($_POST['company_name'])) {
            echo '<div class="alert alert-danger">Spam detected.</div>';
        } else {
            $full_name = sanitize_text_field($_POST['full_name']);
            $inquiry_type = sanitize_text_field($_POST['inquiry_type']);
            $phone = sanitize_text_field($_POST['phone']);
            $email = sanitize_email($_POST['email']);
            $address = sanitize_text_field($_POST['address']);
            $message = sanitize_text_field($_POST['message']);

            // Save submission as a custom post type
            $post_id = wp_insert_post([
                'post_title' => $full_name . ' - ' . $inquiry_type,
                'post_type' => 'contact_inquiry',
                'post_status' => 'publish',
                'meta_input' => compact('full_name', 'inquiry_type', 'phone', 'email', 'address', 'message')
            ]);

            // Send Email Notification
            $to = 'admin@inyanainternationalschool.ac.ug';
            $subject = 'New IIS Online Inquiry';
            $message = "New Inquiry received:\n\nName: $full_name\nInquiry Type: $inquiry_type\nPhone: $phone\nEmail: $email\nAddress: $address\n\nMessage:\n $message";
            wp_mail($to, $subject, $message);

            echo '<div class="alert alert-success">Thank you for inquiry. We have received your submission.</div>';
        }
    }

    ?> 
    <form method="post" class="contact_inquiry-form mt-4">
        <?php echo $honeypot; ?>
        <input type="hidden" name="form_time" value="<?php echo time(); ?>">
        <div class="mb-3"><input type="text" name="full_name" class="form-control" placeholder="Full Name*" required></div>
        <div class="mb-3">
            <select name="inquiry_type" class="form-select" required>
                <option value="">-- Choose Inquiry Type --</option>
                <option value="Foundation Stage">Foundation Stage</option>
                <option value="Primary">Primary</option>
            </select>
        </div>
        <div class="row">
            <div class="col-md-6 mb-3"><input type="text" name="phone" class="form-control" placeholder="Phone Number*" required></div>
            <div class="col-md-6 mb-3"><input type="email" name="email" class="form-control" placeholder="Email*" required></div>
        </div>
        <div class="mb-3"><input type="text" name="address" class="form-control" placeholder="Address**"></div>
        <div class="mb-3"><textarea class="form-text-area" name="message" rows="5" required></textarea></div>
        <div class="mb-3 d-grid text-center">
            <button type="submit" name="contact_inquiry_submit" class="btn btn-lg btn-danger">Submit Your Inquiry</button>
        </div>
    </form>
    <style>
    .form-control, .form-select {
          height: 50px;
          border-radius: 15px;
        }
       .form-text-area{height:auto;border-radius: 15px;width:100%;display: block;padding:.375rem .75rem;background-color: #fff;
    background-clip: padding-box;
    border: 1px solid #ced4da;
    -webkit-appearance: none;
    -moz-appearance: none;
    appearance: none;}
    </style>
    <?php
    return ob_get_clean();
}
add_shortcode('contact_inquiry_form', 'contact_inquiry_form_shortcode');

// Register Custom Post Type for admin viewing
function contact_inquiry_cpt() {
    register_post_type('contact_inquiry', [
        'label' => 'Contact Inquiries',
        'public' => false,
        'show_ui' => true,
        'capability_type' => 'post',
        'supports' => ['title', 'custom-fields'],
        'menu_icon' => 'dashicons-forms',
    ]);
}
add_action('init', 'contact_inquiry_cpt');


