<?php
function allNews_shortcode() {
    ob_start(); // Start output buffering

	$news_args = array(
		'post_type' => array('post'),
		'posts_per_page' => 20,
		'category_name' => 'news, blog',
		);
	?>																
	<?php $news_query = new WP_Query($news_args);?>
		<?php if ($news_query->have_posts()) : ?>
		<div class="row">
			<?php while ($news_query->have_posts()) :
				$news_query->the_post();
				$categories = get_the_category();
			?>
			<div class="col-md-12 kpy-all-news">
				<article>
					<div class="card card-body mb-3 border-0" data-aos="fade-up">
						<a href="<?= esc_url(get_permalink()); ?>"><h3><?php the_title(); ?></h3></a>
							<div class="catz">
									<i class="bi bi-calendar-check"></i> <?php
									$post_date = get_the_date();
									echo $post_date;
									?>
								</div><!-- Date !-->
							<div class="post-thumbnail">
								<?php 
									if (has_post_thumbnail()) {
										the_post_thumbnail('full'); 
									}else{
										echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="NGO" class="img-fluid"/>';
									}
								?>
								
							</div>
							<div class="post-excerpt">
								<?php the_excerpt(); ?>	
							</div>	
						<a href="<?= esc_url(get_permalink()); ?>" class="read-more">Continue Reading </a>
					</div><!-- card !-->
				</article>
			</div><!-- col !-->
			<?php endwhile;
				wp_reset_postdata();
			else :
				echo 'No news found.';
			endif;
			?>
	</div><!-- Row !-->
    <?php

    return ob_get_clean(); // Return the buffered content
}

// Register the shortcode
add_shortcode('all_news', 'allNews_shortcode');

?>