<?php
/*
Template Name: Contact Thank You Page
Description: Thank you page displayed after contact form submission
*/

// Start session to retrieve form data
if (!session_id()) {
    session_start();
}

// Check if there's submission data, if not redirect to contact page
if (!isset($_SESSION['contact_submission'])) {
    wp_redirect(home_url('/contact'));
    exit;
}

$submission = $_SESSION['contact_submission'];

// Clear the session data after retrieving
unset($_SESSION['contact_submission']);

get_header();
include get_template_directory() . '/inc/menus/menu.php';
?>

<main role="main" class="thankyou-page">
    
    <!-- Success Hero Section -->
    <section class="thankyou-hero">
        <div class="container">
            <div class="thankyou-hero-content">
                <div class="success-icon">
                    <svg width="80" height="80" viewBox="0 0 24 24" fill="none">
                        <circle cx="12" cy="12" r="10" stroke="#4CAF50" stroke-width="2"/>
                        <path d="M8 12l3 3 5-5" stroke="#4CAF50" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                </div>
                <h1 class="thankyou-title">Thank You for Contacting Us!</h1>
                <p class="thankyou-subtitle">
                    We've received your message and will get back to you within 24 hours.
                </p>
                <p class="thankyou-description">
                    A confirmation email has been sent to <strong><?php echo esc_html($submission['email']); ?></strong>
                </p>
            </div>
        </div>
    </section>

    <!-- Submission Summary Section -->
    <section class="submission-summary">
        <div class="container">
            <div class="summary-card">
                <div class="summary-header">
                    <h2>Your Submission Details</h2>
                    <p class="submission-time">Submitted on <?php echo esc_html($submission['submission_time']); ?></p>
                </div>
                
                <div class="summary-body">
                    <div class="summary-row">
                        <div class="summary-label">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                <path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <circle cx="12" cy="7" r="4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <span>Full Name</span>
                        </div>
                        <div class="summary-value"><?php echo esc_html($submission['full_name']); ?></div>
                    </div>
                    
                    <div class="summary-row">
                        <div class="summary-label">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <polyline points="22,6 12,13 2,6" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <span>Email</span>
                        </div>
                        <div class="summary-value"><?php echo esc_html($submission['email']); ?></div>
                    </div>
                    
                    <div class="summary-row">
                        <div class="summary-label">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <span>Phone</span>
                        </div>
                        <div class="summary-value"><?php echo esc_html($submission['phone']); ?></div>
                    </div>
                    
                    <div class="summary-row">
                        <div class="summary-label">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <circle cx="12" cy="10" r="3" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <span>Country</span>
                        </div>
                        <div class="summary-value"><?php echo esc_html($submission['country']); ?></div>
                    </div>
                    
                    <div class="summary-row">
                        <div class="summary-label">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <polyline points="14,2 14,8 20,8" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <span>Inquiry Type</span>
                        </div>
                        <div class="summary-value"><?php echo esc_html($submission['inquiry_type']); ?></div>
                    </div>
                    
                    <div class="summary-row full-width">
                        <div class="summary-label">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                                <path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                            <span>Your Message</span>
                        </div>
                        <div class="summary-value message-value"><?php echo nl2br(esc_html($submission['message'])); ?></div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Parallax Relaxer Section with CTA -->
    <section class="parallax-relaxer">
        <div class="parallax-relaxer-bg" style="background-image: url('https://images.unsplash.com/photo-1488646953014-85cb44e25828?ixlib=rb-4.0.3&auto=format&fit=crop&w=2070&q=80');"></div>
        <div class="parallax-overlay"></div>
        
        <div class="container">
            <div class="relaxer-content">
                <h2 class="relaxer-title">Explore Our Services</h2>
                <p class="relaxer-description">
                    While you wait for our response, discover how we can help you with travel management and visa support services.
                </p>
                
                <div class="cta-buttons">
                    <a href="<?php echo home_url('/travel-management'); ?>" class="cta-btn cta-primary">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                            <path d="M21 10c0 7-9 13-9 13s-9-6-9-13a9 9 0 0 1 18 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <circle cx="12" cy="10" r="3" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        <span>Travel Management</span>
                    </a>
                    
                    <a href="<?php echo home_url('/visa-support'); ?>" class="cta-btn cta-secondary">
                        <svg width="20" height="20" viewBox="0 0 24 24" fill="none">
                            <rect x="2" y="7" width="20" height="14" rx="2" ry="2" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M16 21V5a2 2 0 0 0-2-2h-4a2 2 0 0 0-2 2v16" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                        <span>Visa Support Services</span>
                    </a>
                </div>
            </div>
        </div>
    </section>

    <!-- Additional Information Section -->
    <section class="additional-info">
        <div class="container">
            <div class="info-grid">
                <div class="info-card">
                    <div class="info-icon">
                        <svg width="40" height="40" viewBox="0 0 24 24" fill="none">
                            <circle cx="12" cy="12" r="10" stroke="#2B5AA0" stroke-width="2"/>
                            <polyline points="12,6 12,12 16,14" stroke="#2B5AA0" stroke-width="2" stroke-linecap="round"/>
                        </svg>
                    </div>
                    <h3>Response Time</h3>
                    <p>We typically respond within 24 hours during business days</p>
                </div>
                
                <div class="info-card">
                    <div class="info-icon">
                        <svg width="40" height="40" viewBox="0 0 24 24" fill="none">
                            <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z" stroke="#2B5AA0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <h3>Need Urgent Help?</h3>
                    <p>Call us directly at +256 771 456146</p>
                </div>
                
                <div class="info-card">
                    <div class="info-icon">
                        <svg width="40" height="40" viewBox="0 0 24 24" fill="none">
                            <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z" stroke="#2B5AA0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <polyline points="22,6 12,13 2,6" stroke="#2B5AA0" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <h3>Check Your Email</h3>
                    <p>A confirmation has been sent to your inbox</p>
                </div>
            </div>
        </div>
    </section>

</main>

<style>
:root {
    --primary-blue: #2B5AA0;
    --primary-blue-rgb: 43, 90, 160;
    --accent-yellow: #FFC107;
    --accent-yellow-rgb: 255, 193, 7;
    --dark-blue: #1E3A5F;
    --success-green: #4CAF50;
    --text-dark: #2C2C2C;
    --text-light: #666666;
    --text-muted: #999999;
    --background-light: #F5F8FA;
    --white: #FFFFFF;
    --border-light: #E5E5E5;
    --transition: all 0.3s ease;
}

* {
    box-sizing: border-box;
}

.thankyou-page {
    background-color: var(--background-light);
}

/* Hero Section */
.thankyou-hero {
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%);
    padding: 100px 20px;
    text-align: center;
    position: relative;
    overflow: hidden;
}

.thankyou-hero::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><circle cx="50" cy="50" r="40" fill="rgba(255,255,255,0.05)"/></svg>');
    opacity: 0.1;
}

.thankyou-hero-content {
    position: relative;
    z-index: 2;
    max-width: 800px;
    margin: 0 auto;
    animation: fadeInUp 0.8s ease-out;
}

.success-icon {
    display: inline-block;
    margin-bottom: 30px;
    animation: scaleIn 0.6s ease-out;
}

.success-icon svg {
    filter: drop-shadow(0 4px 8px rgba(0,0,0,0.2));
}

.thankyou-title {
    font-size: 3rem;
    font-weight: 700;
    color: var(--white);
    margin: 0 0 20px 0;
    line-height: 1.2;
}

.thankyou-subtitle {
    font-size: 1.3rem;
    color: rgba(255, 255, 255, 0.95);
    margin: 0 0 15px 0;
    line-height: 1.6;
}

.thankyou-description {
    font-size: 1rem;
    color: rgba(255, 255, 255, 0.85);
    margin: 0;
}

.thankyou-description strong {
    color: var(--accent-yellow);
    font-weight: 600;
}

/* Submission Summary Section */
.submission-summary {
    padding: 80px 20px;
    background: var(--background-light);
}

.summary-card {
    max-width: 900px;
    margin: 0 auto;
    background: var(--white);
    border-radius: 16px;
    box-shadow: 0 10px 40px rgba(0, 0, 0, 0.08);
    overflow: hidden;
    animation: fadeInUp 0.8s ease-out 0.2s both;
}

.summary-header {
    background: linear-gradient(135deg, var(--primary-blue) 0%, var(--dark-blue) 100%);
    padding: 40px;
    color: var(--white);
    text-align: center;
}

.summary-header h2 {
    font-size: 2rem;
    margin: 0 0 10px 0;
    font-weight: 600;
}

.submission-time {
    font-size: 0.95rem;
    opacity: 0.9;
    margin: 0;
}

.summary-body {
    padding: 40px;
}

.summary-row {
    display: flex;
    padding: 20px 0;
    border-bottom: 1px solid var(--border-light);
    gap: 30px;
    align-items: flex-start;
}

.summary-row:last-child {
    border-bottom: none;
}

.summary-row.full-width {
    flex-direction: column;
    gap: 15px;
}

.summary-label {
    flex: 0 0 200px;
    display: flex;
    align-items: center;
    gap: 12px;
    font-weight: 600;
    color: var(--primary-blue);
    font-size: 0.95rem;
}

.summary-label svg {
    flex-shrink: 0;
    color: var(--primary-blue);
}

.summary-value {
    flex: 1;
    color: var(--text-dark);
    font-size: 1rem;
    line-height: 1.6;
    word-break: break-word;
}

.message-value {
    background: var(--background-light);
    padding: 20px;
    border-radius: 8px;
    border-left: 4px solid var(--accent-yellow);
}

/* Parallax Relaxer Section */
.parallax-relaxer {
    position: relative;
    min-height: 600px;
    display: flex;
    align-items: center;
    justify-content: center;
    overflow: hidden;
    padding: 100px 20px;
}

.parallax-relaxer-bg {
    position: absolute;
    top: -20%;
    left: 0;
    width: 100%;
    height: 140%;
    background-size: cover;
    background-position: center;
    background-repeat: no-repeat;
    background-attachment: fixed;
    z-index: 1;
    animation: slowZoom 20s ease-in-out infinite alternate;
}

.parallax-overlay {
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background: linear-gradient(135deg, rgba(30, 58, 95, 0.85) 0%, rgba(43, 90, 160, 0.75) 100%);
    z-index: 2;
}

.relaxer-content {
    position: relative;
    z-index: 3;
    text-align: center;
    max-width: 800px;
    margin: 0 auto;
    animation: fadeInUp 0.8s ease-out 0.4s both;
}

.relaxer-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--white);
    margin: 0 0 20px 0;
    line-height: 1.2;
}

.relaxer-description {
    font-size: 1.2rem;
    color: rgba(255, 255, 255, 0.95);
    margin: 0 0 50px 0;
    line-height: 1.6;
}

.cta-buttons {
    display: flex;
    gap: 20px;
    justify-content: center;
    flex-wrap: wrap;
}

.cta-btn {
    display: inline-flex;
    align-items: center;
    gap: 12px;
    padding: 18px 40px;
    font-size: 1.1rem;
    font-weight: 600;
    border-radius: 50px;
    text-decoration: none;
    transition: var(--transition);
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.2);
}

.cta-primary {
    background: var(--accent-yellow);
    color: var(--dark-blue);
}

.cta-primary:hover {
    background: #FFD54F;
    transform: translateY(-3px);
    box-shadow: 0 12px 35px rgba(255, 193, 7, 0.4);
}

.cta-secondary {
    background: var(--white);
    color: var(--primary-blue);
}

.cta-secondary:hover {
    background: var(--background-light);
    transform: translateY(-3px);
    box-shadow: 0 12px 35px rgba(255, 255, 255, 0.3);
}

.cta-btn svg {
    width: 20px;
    height: 20px;
}

/* Additional Info Section */
.additional-info {
    padding: 80px 20px;
    background: var(--white);
}

.info-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 40px;
    max-width: 1200px;
    margin: 0 auto;
}

.info-card {
    text-align: center;
    padding: 40px 30px;
    background: var(--background-light);
    border-radius: 12px;
    transition: var(--transition);
    animation: fadeInUp 0.8s ease-out both;
}

.info-card:nth-child(1) { animation-delay: 0.6s; }
.info-card:nth-child(2) { animation-delay: 0.7s; }
.info-card:nth-child(3) { animation-delay: 0.8s; }

.info-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 30px rgba(43, 90, 160, 0.15);
}

.info-icon {
    margin: 0 auto 20px;
    display: inline-block;
}

.info-card h3 {
    font-size: 1.3rem;
    color: var(--dark-blue);
    margin: 0 0 15px 0;
    font-weight: 600;
}

.info-card p {
    font-size: 1rem;
    color: var(--text-light);
    margin: 0;
    line-height: 1.6;
}

/* Animations */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes scaleIn {
    from {
        opacity: 0;
        transform: scale(0.5);
    }
    to {
        opacity: 1;
        transform: scale(1);
    }
}

@keyframes slowZoom {
    0% {
        transform: scale(1);
    }
    100% {
        transform: scale(1.1);
    }
}

/* Responsive Design */
@media (max-width: 768px) {
    .thankyou-title {
        font-size: 2.2rem;
    }
    
    .thankyou-subtitle {
        font-size: 1.1rem;
    }
    
    .summary-header {
        padding: 30px 20px;
    }
    
    .summary-header h2 {
        font-size: 1.6rem;
    }
    
    .summary-body {
        padding: 30px 20px;
    }
    
    .summary-row {
        flex-direction: column;
        gap: 15px;
    }
    
    .summary-label {
        flex: none;
    }
    
    .relaxer-title {
        font-size: 2rem;
    }
    
    .relaxer-description {
        font-size: 1rem;
    }
    
    .cta-buttons {
        flex-direction: column;
        align-items: stretch;
    }
    
    .cta-btn {
        justify-content: center;
        width: 100%;
    }
    
    .parallax-relaxer-bg {
        background-attachment: scroll;
    }
    
    .info-grid {
        grid-template-columns: 1fr;
        gap: 30px;
    }
}

@media (max-width: 480px) {
    .thankyou-hero {
        padding: 60px 20px;
    }
    
    .thankyou-title {
        font-size: 1.8rem;
    }
    
    .thankyou-subtitle {
        font-size: 1rem;
    }
    
    .thankyou-description {
        font-size: 0.9rem;
    }
    
    .success-icon svg {
        width: 60px;
        height: 60px;
    }
    
    .summary-header h2 {
        font-size: 1.4rem;
    }
    
    .submission-time {
        font-size: 0.85rem;
    }
    
    .summary-label {
        font-size: 0.9rem;
    }
    
    .summary-value {
        font-size: 0.95rem;
    }
    
    .relaxer-title {
        font-size: 1.6rem;
    }
    
    .relaxer-description {
        font-size: 0.95rem;
    }
    
    .cta-btn {
        padding: 16px 30px;
        font-size: 1rem;
    }
    
    .info-card {
        padding: 30px 20px;
    }
    
    .info-card h3 {
        font-size: 1.1rem;
    }
    
    .info-card p {
        font-size: 0.9rem;
    }
}

/* Print Styles */
@media print {
    .parallax-relaxer,
    .additional-info {
        display: none;
    }
    
    .thankyou-hero {
        background: var(--white);
        color: var(--text-dark);
    }
    
    .thankyou-title,
    .thankyou-subtitle,
    .thankyou-description {
        color: var(--text-dark);
    }
}
</style>

<script>
jQuery(document).ready(function($) {
    // Parallax effect for relaxer background
    $(window).scroll(function() {
        var scroll = $(window).scrollTop();
        var parallaxElement = $('.parallax-relaxer-bg');
        
        if (parallaxElement.length) {
            var offset = parallaxElement.offset().top;
            var height = parallaxElement.outerHeight();
            
            if (scroll + $(window).height() > offset && scroll < offset + height) {
                var yPos = -((scroll - offset) * 0.3);
                parallaxElement.css('transform', 'translateY(' + yPos + 'px)');
            }
        }
    });
    
    // Smooth scroll for CTA buttons
    $('.cta-btn').on('click', function(e) {
        // Only prevent default if it's an anchor link
        if ($(this).attr('href').indexOf('#') === 0) {
            e.preventDefault();
            var target = $($(this).attr('href'));
            if (target.length) {
                $('html, body').animate({
                    scrollTop: target.offset().top - 100
                }, 800);
            }
        }
    });
    
    // Add animation on scroll for elements
    function checkVisibility() {
        $('.info-card, .summary-card').each(function() {
            var elementTop = $(this).offset().top;
            var elementBottom = elementTop + $(this).outerHeight();
            var viewportTop = $(window).scrollTop();
            var viewportBottom = viewportTop + $(window).height();
            
            if (elementBottom > viewportTop && elementTop < viewportBottom) {
                $(this).addClass('visible');
            }
        });
    }
    
    $(window).on('scroll resize', checkVisibility);
    checkVisibility();
});
</script>

<?php get_footer(); ?>