<?php
/**
 * Template Name: Enhanced Package Detail Template
 * Template Post Type: romantic_package, travel_package
 */

 get_header();


// ==================== ITINERARY WITH VIDEO SUPPORT ====================
function add_itinerary_metabox() {
    add_meta_box(
        'itinerary_metabox',
        'Itinerary Days (with Images & Videos)',
        'itinerary_metabox_callback',
        array('romantic_package', 'travel_package'),
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'add_itinerary_metabox');

function itinerary_metabox_callback($post) {
    wp_nonce_field('itinerary_metabox', 'itinerary_nonce');
    $itinerary_days = get_post_meta($post->ID, '_itinerary_days', true);
    if (empty($itinerary_days)) $itinerary_days = array();
    ?>
    <div id="itinerary-container">
        <div id="itinerary-days-list">
            <?php foreach($itinerary_days as $index => $day): ?>
            <div class="itinerary-day-item" data-index="<?php echo $index; ?>" style="border:1px solid #ddd;padding:15px;margin-bottom:15px;background:#fafafa;">
                <h4>Day <?php echo ($index + 1); ?></h4>
                <table class="form-table">
                    <tr>
                        <th><label>Day Title *</label></th>
                        <td><input type="text" name="itinerary_days[<?php echo $index; ?>][day_title]" value="<?php echo esc_attr($day['day_title'] ?? ''); ?>" style="width:100%;" required /></td>
                    </tr>
                    <tr>
                        <th><label>Description *</label></th>
                        <td><textarea name="itinerary_days[<?php echo $index; ?>][day_description]" rows="4" style="width:100%;" required><?php echo esc_textarea($day['day_description'] ?? ''); ?></textarea></td>
                    </tr>
                    <tr>
                        <th><label>Images & Videos</label></th>
                        <td>
                            <div class="day-media-container">
                                <button type="button" class="button upload-day-media" data-day-index="<?php echo $index; ?>">Add Images/Videos</button>
                                <div class="day-media-preview" id="media-preview-<?php echo $index; ?>" style="margin-top:10px;display:flex;gap:10px;flex-wrap:wrap;">
                                    <?php 
                                    if (!empty($day['day_media']) && is_array($day['day_media'])) {
                                        foreach($day['day_media'] as $media_id) {
                                            $media_url = wp_get_attachment_url($media_id);
                                            $media_type = get_post_mime_type($media_id);
                                            $is_video = strpos($media_type, 'video') !== false;
                                            ?>
                                            <div class="media-item" style="position:relative;width:100px;height:100px;">
                                                <?php if ($is_video): ?>
                                                    <video src="<?php echo esc_url($media_url); ?>" style="width:100%;height:100%;object-fit:cover;"></video>
                                                    <span style="position:absolute;top:5px;left:5px;background:rgba(0,0,0,0.7);color:white;padding:2px 5px;font-size:10px;border-radius:3px;">VIDEO</span>
                                                <?php else: ?>
                                                    <img src="<?php echo esc_url($media_url); ?>" style="width:100%;height:100%;object-fit:cover;" />
                                                <?php endif; ?>
                                                <button type="button" class="remove-media" data-media-id="<?php echo $media_id; ?>" style="position:absolute;top:0;right:0;background:red;color:white;border:none;cursor:pointer;padding:2px 5px;">×</button>
                                                <input type="hidden" name="itinerary_days[<?php echo $index; ?>][day_media][]" value="<?php echo $media_id; ?>" />
                                            </div>
                                            <?php
                                        }
                                    }
                                    ?>
                                </div>
                            </div>
                            <p class="description">Upload images and videos for this day. Both will appear in a scrollable carousel.</p>
                        </td>
                    </tr>
                </table>
                <button type="button" class="button remove-itinerary-day">Remove Day</button>
            </div>
            <?php endforeach; ?>
        </div>
        <button type="button" id="add-itinerary-day" class="button button-primary">Add Day</button>
    </div>

    <script>
    jQuery(document).ready(function($) {
        var dayIndex = <?php echo count($itinerary_days); ?>;
        var currentMediaUploader;
        var currentDayIndex;

        $('#add-itinerary-day').click(function() {
            var html = '<div class="itinerary-day-item" data-index="' + dayIndex + '" style="border:1px solid #ddd;padding:15px;margin-bottom:15px;background:#fafafa;">';
            html += '<h4>Day ' + (dayIndex + 1) + '</h4>';
            html += '<table class="form-table">';
            html += '<tr><th><label>Day Title *</label></th>';
            html += '<td><input type="text" name="itinerary_days[' + dayIndex + '][day_title]" value="" style="width:100%;" required /></td></tr>';
            html += '<tr><th><label>Description *</label></th>';
            html += '<td><textarea name="itinerary_days[' + dayIndex + '][day_description]" rows="4" style="width:100%;" required></textarea></td></tr>';
            html += '<tr><th><label>Images & Videos</label></th>';
            html += '<td><div class="day-media-container">';
            html += '<button type="button" class="button upload-day-media" data-day-index="' + dayIndex + '">Add Images/Videos</button>';
            html += '<div class="day-media-preview" id="media-preview-' + dayIndex + '" style="margin-top:10px;display:flex;gap:10px;flex-wrap:wrap;"></div>';
            html += '</div><p class="description">Upload images and videos for this day.</p></td></tr>';
            html += '</table>';
            html += '<button type="button" class="button remove-itinerary-day">Remove Day</button>';
            html += '</div>';
            
            $('#itinerary-days-list').append(html);
            dayIndex++;
        });

        $(document).on('click', '.remove-itinerary-day', function() {
            $(this).closest('.itinerary-day-item').remove();
        });

        $(document).on('click', '.upload-day-media', function(e) {
            e.preventDefault();
            currentDayIndex = $(this).data('day-index');
            var button = $(this);
            var previewContainer = $('#media-preview-' + currentDayIndex);

            if (currentMediaUploader) {
                currentMediaUploader.open();
                return;
            }

            currentMediaUploader = wp.media({
                title: 'Select Images and Videos',
                button: { text: 'Add to Day' },
                multiple: true,
                library: { type: ['image', 'video'] }
            });

            currentMediaUploader.on('select', function() {
                var attachments = currentMediaUploader.state().get('selection').toJSON();
                
                attachments.forEach(function(attachment) {
                    var isVideo = attachment.type === 'video';
                    var mediaHtml = '<div class="media-item" style="position:relative;width:100px;height:100px;">';
                    
                    if (isVideo) {
                        mediaHtml += '<video src="' + attachment.url + '" style="width:100%;height:100%;object-fit:cover;"></video>';
                        mediaHtml += '<span style="position:absolute;top:5px;left:5px;background:rgba(0,0,0,0.7);color:white;padding:2px 5px;font-size:10px;border-radius:3px;">VIDEO</span>';
                    } else {
                        mediaHtml += '<img src="' + attachment.url + '" style="width:100%;height:100%;object-fit:cover;" />';
                    }
                    
                    mediaHtml += '<button type="button" class="remove-media" data-media-id="' + attachment.id + '" style="position:absolute;top:0;right:0;background:red;color:white;border:none;cursor:pointer;padding:2px 5px;">×</button>';
                    mediaHtml += '<input type="hidden" name="itinerary_days[' + currentDayIndex + '][day_media][]" value="' + attachment.id + '" />';
                    mediaHtml += '</div>';
                    
                    previewContainer.append(mediaHtml);
                });
            });

            currentMediaUploader.open();
        });

        $(document).on('click', '.remove-media', function() {
            $(this).closest('.media-item').remove();
        });
    });
    </script>
    <?php
}

function save_itinerary_metabox($post_id) {
    if (!isset($_POST['itinerary_nonce']) || !wp_verify_nonce($_POST['itinerary_nonce'], 'itinerary_metabox')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (!current_user_can('edit_post', $post_id)) {
        return;
    }

    if (isset($_POST['itinerary_days'])) {
        $itinerary_days = array();
        foreach($_POST['itinerary_days'] as $day_data) {
            if (!empty($day_data['day_title']) && !empty($day_data['day_description'])) {
                $itinerary_days[] = array(
                    'day_title' => sanitize_text_field($day_data['day_title']),
                    'day_description' => wp_kses_post($day_data['day_description']),
                    'day_media' => isset($day_data['day_media']) ? array_map('intval', $day_data['day_media']) : array()
                );
            }
        }
        update_post_meta($post_id, '_itinerary_days', $itinerary_days);
    } else {
        delete_post_meta($post_id, '_itinerary_days');
    }
}
add_action('save_post', 'save_itinerary_metabox');


// ==================== BRIEF DESCRIPTION METABOX ====================
function add_brief_description_metabox() {
    add_meta_box(
        'brief_description_metabox',
        'Brief Description (First 15 words for cards)',
        'brief_description_metabox_callback',
        array('romantic_package', 'travel_package'),
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'add_brief_description_metabox');

function brief_description_metabox_callback($post) {
    wp_nonce_field('brief_description_metabox', 'brief_description_nonce');
    $brief_description = get_post_meta($post->ID, '_brief_description', true);
    ?>
    <p>
        <label for="brief_description"><strong>Brief Description:</strong></label><br>
        <textarea id="brief_description" name="brief_description" rows="3" style="width:100%;" placeholder="Enter a brief description (first 15 words will show on package cards)"><?php echo esc_textarea($brief_description); ?></textarea>
    </p>
    <p class="description">This will appear after breadcrumbs on the detail page. The first 15 words will appear on package cards in archive views.</p>
    <?php
}

function save_brief_description_metabox($post_id) {
    if (!isset($_POST['brief_description_nonce']) || !wp_verify_nonce($_POST['brief_description_nonce'], 'brief_description_metabox')) {
        return;
    }
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }
    if (isset($_POST['brief_description'])) {
        update_post_meta($post_id, '_brief_description', sanitize_textarea_field($_POST['brief_description']));
    }
}
add_action('save_post', 'save_brief_description_metabox');


function add_bookings_admin_menu() {
    add_menu_page(
        'Bookings',
        'Bookings',
        'manage_options',
        'package-bookings',
        'display_bookings_page',
        'dashicons-calendar-alt',
        6
    );
}
add_action('admin_menu', 'add_bookings_admin_menu');

function display_bookings_page() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'package_bookings';
    
    if (isset($_POST['update_status']) && isset($_POST['booking_id']) && isset($_POST['new_status'])) {
        $booking_id = intval($_POST['booking_id']);
        $new_status = sanitize_text_field($_POST['new_status']);
        
        $wpdb->update(
            $table_name,
            array('status' => $new_status),
            array('id' => $booking_id),
            array('%s'),
            array('%d')
        );
        
        echo '<div class="notice notice-success"><p>Booking status updated successfully.</p></div>';
    }
    
    $bookings = $wpdb->get_results("SELECT * FROM $table_name ORDER BY booking_date DESC");
    
    ?>
    <div class="wrap">
        <h1>Package Bookings</h1>
        
        <?php if (empty($bookings)): ?>
            <p>No bookings found.</p>
        <?php else: ?>
        <table class="wp-list-table widefat fixed striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Package</th>
                    <th>Customer</th>
                    <th>Contact</th>
                    <th>Group Size</th>
                    <th>Departure</th>
                    <th>Budget</th>
                    <th>Status</th>
                    <th>Booking Date</th>
                    <th>Actions</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($bookings as $booking): ?>
                <tr>
                    <td><?php echo $booking->id; ?></td>
                    <td><strong><?php echo esc_html($booking->package_name); ?></strong></td>
                    <td><?php echo esc_html($booking->customer_name); ?><br><small>DOB: <?php echo esc_html($booking->customer_dob); ?></small></td>
                    <td>
                        <a href="mailto:<?php echo esc_attr($booking->customer_email); ?>"><?php echo esc_html($booking->customer_email); ?></a><br>
                        <a href="tel:<?php echo esc_attr($booking->customer_phone); ?>"><?php echo esc_html($booking->customer_phone); ?></a>
                    </td>
                    <td><?php echo $booking->num_adults; ?> Adults<?php if($booking->num_children > 0): ?><br><?php echo $booking->num_children; ?> Children<?php endif; ?></td>
                    <td><?php echo esc_html($booking->departure_date); ?></td>
                    <td><span class="budget-<?php echo strtolower($booking->budget_preference); ?>"><?php echo esc_html($booking->budget_preference); ?></span></td>
                    <td>
                        <span class="status-<?php echo $booking->status; ?>">
                            <?php echo ucfirst($booking->status); ?>
                        </span>
                    </td>
                    <td><?php echo date('M j, Y', strtotime($booking->booking_date)); ?></td>
                    <td>
                        <form method="post" style="display:inline;">
                            <input type="hidden" name="booking_id" value="<?php echo $booking->id; ?>">
                            <select name="new_status" onchange="this.form.submit()">
                                <option value="pending" <?php selected($booking->status, 'pending'); ?>>Pending</option>
                                <option value="confirmed" <?php selected($booking->status, 'confirmed'); ?>>Confirmed</option>
                                <option value="cancelled" <?php selected($booking->status, 'cancelled'); ?>>Cancelled</option>
                                <option value="completed" <?php selected($booking->status, 'completed'); ?>>Completed</option>
                            </select>
                            <input type="hidden" name="update_status" value="1">
                        </form>
                        <?php if (!empty($booking->special_requests)): ?>
                        <br><small><strong>Requests:</strong> <?php echo esc_html(wp_trim_words($booking->special_requests, 10)); ?></small>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
        <?php endif; ?>
    </div>
    
    <style>
    .status-pending { color:#f56565; }
    .status-confirmed { color:#48bb78; }
    .status-cancelled { color:#a0aec0; }
    .status-completed { color:#4299e1; }
    .budget-budget { background:#e2e8f0;padding:2px 8px;border-radius:4px; }
    .budget-standard { background:#bee3f8;padding:2px 8px;border-radius:4px; }
    .budget-premium { background:#d6f5d6;padding:2px 8px;border-radius:4px; }
    .budget-luxury { background:#fed7d7;padding:2px 8px;border-radius:4px; }
    </style>
    <?php
}

get_header(); 
include get_template_directory() . '/inc/menus/menu.php'; 

while (have_posts()) : the_post();
    $post_id = get_the_ID();
    $post_type = get_post_type();

    $trip_duration = get_post_meta($post_id, '_trip_duration', true);
    $best_season = get_post_meta($post_id, '_best_season', true);
    $trip_price = get_post_meta($post_id, '_price_usd', true);
    $accommodation = get_post_meta($post_id, '_accommodation', true);
    $brief_description = get_post_meta($post_id, '_brief_description', true);
    $package_overview = get_post_meta($post_id, '_package_overview', true);
    $itinerary_days = get_post_meta($post_id, '_itinerary_days', true);
    $price_includes = get_post_meta($post_id, '_price_includes', true);
    $price_excludes = get_post_meta($post_id, '_price_excludes', true);
    $gallery_images = get_post_meta($post_id, '_gallery_images', true);
    
    $destination = get_post_meta($post_id, '_destination', true);
    $reviews = get_post_meta($post_id, '_reviews', true);
    $price_ugx = get_post_meta($post_id, '_price_ugx', true);
    
    $budget_tier = get_post_meta($post_id, '_budget_tier', true);
    $starting_price = get_post_meta($post_id, '_starting_price', true);
    $duration_nights = get_post_meta($post_id, '_duration_nights', true);
    $default_adults = get_post_meta($post_id, '_default_adults', true) ?: '2';
    $default_children = get_post_meta($post_id, '_default_children', true) ?: '0';
    
    $budget_cards = get_post_meta($post_id, '_budget_cards', true);
    if (empty($budget_cards)) $budget_cards = array();
    
    if (empty($itinerary_days)) $itinerary_days = array();
    if (empty($price_includes)) $price_includes = array();
    if (empty($price_excludes)) $price_excludes = array();
    
    if (!empty($gallery_images) && !is_array($gallery_images)) {
        $gallery_images = explode(',', $gallery_images);
    }
    
    $featured_image = get_the_post_thumbnail_url($post_id, 'full');
    
    $archive_url = ($post_type === 'romantic_package') ? get_post_type_archive_link('romantic_package') : get_post_type_archive_link('travel_package');
    $archive_name = ($post_type === 'romantic_package') ? 'Romantic Packages' : 'Travel Packages';
?>

<style>
.breadcrumb-container { background:#f8f9fa;padding:1rem 2rem;border-bottom:1px solid #e0e0e0; }
.breadcrumb { max-width:1200px;margin:0 auto;display:flex;align-items:center;gap:0.5rem;font-size:0.9rem; }
.breadcrumb a { color:#e67e22;text-decoration:none;transition:color 0.3s; }
.breadcrumb a:hover { color:#d35400;text-decoration:underline; }
.breadcrumb-separator { color:#999; }
.breadcrumb-current { color:#555;font-weight:500; }
.parallax-hero { position:relative;height:350px;overflow:hidden;display:flex;align-items:center;justify-content:center; }
.parallax-bg { position:absolute;top:-20%;left:0;width:100%;height:120%;background-attachment:fixed;background-position:center center;background-repeat:no-repeat;background-size:cover;will-change:transform;z-index:1;animation:zoomIn 20s ease-out infinite alternate; }
@keyframes zoomIn { 0% { transform:scale(1); } 100% { transform:scale(1.1); } }
.hero-overlay { position:absolute;top:0;left:0;width:100%;height:100%;background:linear-gradient(135deg,rgba(0,0,0,0.4) 0%,rgba(0,0,0,0.2) 100%);z-index:2; }
.hero-content { position:relative;z-index:3;text-align:center;color:white;padding:2rem;max-width:800px;margin:0 auto; }
.hero-title { font-size:3rem;font-weight:700;margin-bottom:1rem;text-shadow:2px 2px 4px rgba(0,0,0,0.5);line-height:1.2;animation-duration:1.5s; }
.hero-excerpt { font-size:1.1rem;line-height:1.6;margin-bottom:1.5rem;text-shadow:1px 1px 2px rgba(0,0,0,0.5);opacity:1;animation-duration:1.3s; }
.hero-line { position:absolute;bottom:0;left:0;width:100%;height:1px;background-color:white;z-index:4; }
.romantic_package .hero-overlay { background:linear-gradient(135deg,rgba(255,20,147,0.3) 0%,rgba(0,0,0,0.4) 100%); }
.travel_package .hero-overlay { background:linear-gradient(135deg,rgba(0,0,0,0.4) 0%,rgba(0,0,0,0.2) 100%); }
.package-highlights { display:grid;grid-template-columns:repeat(auto-fit,minmax(200px,1fr));gap:1rem;margin-bottom:0; }
.highlight-item { text-align:center;padding:1rem;background:#f8f9fa;border-radius:10px; }
.highlight-item h4 { color:#2c3e50;margin-bottom:0.5rem;font-size:0.9rem;text-transform:uppercase; }
.highlight-value { font-size:1.2rem;font-weight:bold;color:#e67e22; }
.view-details-btn { background:linear-gradient(135deg,#e67e22 0%,#d35400 100%);color:white;padding:1rem 3rem;border:none;border-radius:30px;font-size:1.1rem;font-weight:bold;cursor:pointer;width:100%;transition:all 0.3s ease; }
.view-details-btn:hover { transform:translateY(-2px);box-shadow:0 5px 15px rgba(230,126,34,0.4); }
.budget-cards-section { max-width:1200px;margin:3rem auto;padding:0 2rem; }
.budget-cards-section h2 { text-align:center;color:#2c3e50;margin-bottom:2rem;font-size:2rem; }
.budget-cards { display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:1.5rem;margin-bottom:3rem; }
.budget-card { background:white;padding:1.8rem;border-radius:15px;box-shadow:0 8px 25px rgba(0,0,0,0.1);text-align:center;transition:all 0.3s ease;border:2px solid transparent;cursor:pointer;min-height:320px;display:flex;flex-direction:column;justify-content:space-between;position:relative;overflow:hidden; }
.budget-card::before { content:'';position:absolute;top:0;left:0;right:0;height:4px;background:linear-gradient(135deg,#e67e22 0%,#d35400 100%);transition:all 0.3s ease; }
.budget-card:hover { transform:translateY(-8px);box-shadow:0 15px 40px rgba(0,0,0,0.15); }
.budget-card.active { border-color:#e67e22;background:linear-gradient(135deg,#fff9f5 0%,#ffffff 100%);transform:translateY(-8px);box-shadow:0 15px 40px rgba(230,126,34,0.2); }
.budget-card.active::before { height:6px;background:linear-gradient(135deg,#f39c12 0%,#e67e22 100%); }
.budget-card h3 { color:#2c3e50;margin-bottom:1rem;font-size:1.4rem;font-weight:700;text-transform:uppercase;letter-spacing:0.5px; }
.budget-price { font-size:2rem;font-weight:900;color:#e67e22;margin-bottom:1.5rem;position:relative; }
.budget-price::before { content:'Starting From';font-size:0.6rem;position:absolute;top:-10px;left:0;color:#7f8c8d;text-transform:uppercase;font-weight:500; }
.budget-features { list-style:none;text-align:left;padding:0;margin:0;flex-grow:1; }
.budget-features li { margin-bottom:0.6rem;padding-left:1.5rem;position:relative;font-size:0.95rem;line-height:1.4;color:#34495e; }
.budget-features li::before { content:"✓";position:absolute;left:0;color:#27ae60;font-weight:bold;font-size:1rem; }
.destination-container { max-width:1200px;margin:0 auto;padding:2rem;display:grid;grid-template-columns:2fr 1fr;gap:3rem; }
.destination-content { background:white; }
.overview-section, .itinerary-section { margin-bottom:2rem; }
.overview-section h2, .itinerary-section h2 { color:#2c3e50;margin-bottom:1rem;font-size:1.8rem; }
.overview-content { margin-bottom:1.5rem;color:#555;line-height:1.7; }
.overview-content p { margin-bottom:1rem; }
.itinerary-day { margin-bottom:1rem;border:1px solid #e0e0e0;border-radius:10px;overflow:hidden;transition:all 0.3s ease; }
.itinerary-day:hover { box-shadow:0 5px 15px rgba(0,0,0,0.1); }
.day-header { padding:1.5rem;background:#f8f9fa;cursor:pointer;display:flex;align-items:center;gap:1rem; }
.day-media-thumb { width:60px;height:60px;border-radius:8px;object-fit:cover; }
.day-title { flex:1;font-weight:bold;color:#2c3e50;font-size:1.1rem; }
.toggle-icon { transition:transform 0.3s;color:#e67e22;font-size:1.2rem; }
.romantic_package .toggle-icon { color:#e91e63; }
.toggle-icon.rotated { transform:rotate(180deg); }
.day-content { display:none;padding:1.5rem;border-top:1px solid #e0e0e0; }
.day-content.active { display:block; }
.day-media { margin-bottom:1.5rem; }
.media-carousel { position:relative;background:#f8f9fa;border-radius:10px;overflow:hidden;max-width:100%; }
.media-items { display:flex;transition:transform 0.3s ease;width:100%; }
.media-item { min-width:100%;flex-shrink:0;height:300px;position:relative;cursor:pointer; }
.media-item img, .media-item video { width:100%;height:100%;object-fit:cover; }
.media-item video { background:#000; }
.carousel-controls { position:absolute;top:50%;transform:translateY(-50%);background:rgba(0,0,0,0.5);color:white;border:none;padding:15px;cursor:pointer;font-size:18px;z-index:10;transition:all 0.3s ease; }
.carousel-controls:hover { background:rgba(0,0,0,0.8); }
.carousel-controls.prev { left:10px; }
.carousel-controls.next { right:10px; }
.media-indicators { position:absolute;bottom:15px;left:0;right:0;display:flex;justify-content:center;gap:8px;z-index:10; }
.media-indicators .indicator { width:12px;height:12px;border-radius:50%;background:rgba(255,255,255,0.5);cursor:pointer;transition:all 0.3s ease; }
.media-indicators .indicator.active { background:white;transform:scale(1.2); }
.media-type-indicator { position:absolute;top:10px;right:10px;background:rgba(0,0,0,0.7);color:white;padding:4px 8px;border-radius:4px;font-size:0.8rem;text-transform:uppercase;z-index:5; }
.destination-sidebar { display:flex;flex-direction:column;gap:2rem; }
.booking-widget { color:#fff;padding:2rem;border-radius:10px;height:fit-content;background:linear-gradient(135deg,#c94b4b 0%,#4b134f 100%); }
.booking-widget h3 { color:#f39c12;margin-bottom:1.5rem;font-size:1.3rem;text-align:center; }
.romantic_package .booking-widget h3 { color:#ffb3d9; }
.booking-widget ul { list-style:none;margin-bottom:2rem; }
.booking-widget li { display:flex;justify-content:space-between;margin-bottom:1rem;padding-bottom:0.5rem;border-bottom:1px solid rgba(255,255,255,0.2); }
.booking-widget .info-label { font-weight:bold; }
.booking-form-container { background:linear-gradient(135deg,#f8f9fa 0%,#e9ecef 100%);padding:3rem 2rem;margin:3rem auto;border-radius:20px;box-shadow:0 15px 40px rgba(0,0,0,0.1);max-width:1200px;border:1px solid rgba(230,126,34,0.2);position:relative; }
.booking-form-container::before { content:'';position:absolute;top:0;left:0;right:0;height:4px;background:linear-gradient(135deg,#e67e22 0%,#d35400 100%);border-radius:20px 20px 0 0; }
.booking-form { background:white;padding:2rem;border-radius:15px;box-shadow:0 10px 30px rgba(0,0,0,0.1); }
.booking-form h3 { color:#2c3e50;margin-bottom:2rem;text-align:center;font-size:1.8rem; }
.form-row { display:grid;grid-template-columns:1fr 1fr;gap:1rem;margin-bottom:1rem; }
.form-group { margin-bottom:1rem; }
.form-group label { display:block;margin-bottom:0.5rem;color:#2c3e50;font-weight:bold; }
.form-group input, .form-group select, .form-group textarea { width:100%;padding:0.8rem;border:1px solid #ddd;border-radius:5px;font-size:1rem; }
.form-group input:focus, .form-group select:focus, .form-group textarea:focus { outline:none;border-color:#e67e22; }
.submit-booking { background:linear-gradient(135deg,#27ae60 0%,#2ecc71 100%);color:white;padding:1rem 2rem;border:none;border-radius:10px;font-size:1.1rem;font-weight:bold;cursor:pointer;width:40%;transition:all 0.3s ease; }
.submit-booking:hover { transform:translateY(-2px);box-shadow:0 5px 15px rgba(39,174,96,0.4); }
.book-now-btn { background:linear-gradient(135deg,#ffa500 0%,#ff8c00 100%);color:white;padding:1rem 2rem;border:none;border-radius:25px;font-weight:bold;cursor:pointer;width:100%;font-size:1rem;transition:all 0.3s ease; }
.book-now-btn:hover { transform:translateY(-2px);box-shadow:0 5px 15px rgba(255,165,0,0.4);background:linear-gradient(135deg,#ff8c00 0%,#ffa500 100%); }
.includes-excludes { display:grid;grid-template-columns:1fr 1fr;gap:2rem;margin-top:2rem; }
.includes, .excludes { background:#f8f9fa;padding:1.5rem;border-radius:8px; }
.includes h4, .excludes h4 { color:#2c3e50;margin-bottom:1rem;font-size:1.2rem;display:flex;align-items:center;gap:10px; }
.includes h4 { color:#27ae60; }
.excludes h4 { color:#e74c3c; }
.includes ul, .excludes ul { list-style:none; }
.includes li, .excludes li { margin-bottom:0.5rem;padding-left:1.5rem;position:relative;line-height:1.4; }
.includes li::before { content:"✓";position:absolute;left:0;color:#27ae60;font-weight:bold; }
.excludes li::before { content:"✗";position:absolute;left:0;color:#e74c3c;font-weight:bold; }
.destination-gallery { max-width:1200px;margin:3rem auto 0;padding:0 2rem; }
.destination-gallery h2 { color:#2c3e50;margin-bottom:2rem;font-size:2rem;text-align:center; }
.gallery-grid { display:grid;grid-template-columns:repeat(auto-fit,minmax(250px,1fr));gap:1rem; }
.gallery-image { width:100%;height:200px;object-fit:cover;border-radius:8px;transition:transform 0.3s;cursor:pointer; }
.gallery-image:hover { transform:scale(1.05); }
.lightbox { position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.95);display:none;align-items:center;justify-content:center;z-index:9999; }
.lightbox.active { display:flex; }
.lightbox-close { position:absolute;top:30px;right:30px;color:white;font-size:2.5rem;cursor:pointer;z-index:10000;transition:all 0.3s ease; }
.lightbox-close:hover { color:#e67e22;transform:scale(1.1); }
.lightbox-carousel { position:relative;max-width:90vw;max-height:90vh;display:flex;align-items:center;justify-content:center; }
.lightbox-item { display:none;text-align:center;max-width:100%;max-height:100%; }
.lightbox-item.active { display:block; }
.lightbox-item img, .lightbox-item video { max-width:100%;max-height:85vh;object-fit:contain;border-radius:8px; }
.lightbox-item video { background:#000; }
.lightbox-controls { position:absolute;top:50%;transform:translateY(-50%);background:rgba(0,0,0,0.7);color:white;border:none;padding:20px;cursor:pointer;font-size:28px;z-index:100;border-radius:50%;transition:all 0.3s ease; }
.lightbox-controls:hover { background:rgba(230,126,34,0.9);transform:translateY(-50%) scale(1.1); }
.lightbox-controls.prev { left:20px; }
.lightbox-controls.next { right:20px; }
.lightbox-indicators { position:absolute;bottom:30px;left:0;right:0;display:flex;justify-content:center;gap:12px; }
.lightbox-indicators .indicator { width:16px;height:16px;border-radius:50%;background:rgba(255,255,255,0.5);cursor:pointer;transition:all 0.3s ease; }
.lightbox-indicators .indicator.active { background:#e67e22;transform:scale(1.3); }
.lightbox-indicators .indicator:hover { background:white;transform:scale(1.1); }
.package-overview-content { padding:2rem 8rem;color:#555;line-height:1.7;font-size:1rem;text-align:center; }
.package-overview-content p { margin-bottom:1rem;text-align:center; }
.package-overview-content h1, .package-overview-content h2, .package-overview-content h3 { color:#2c3e50;margin-top:1.5rem;margin-bottom:1rem;text-align:center; }
.package-overview-content ul, .package-overview-content ol { margin-bottom:1rem;padding-left:0;list-style-position:inside;text-align:center; }
.package-overview-content li { margin-bottom:0.5rem;line-height:1.6;text-align:center; }
.fade-up { opacity:0;transform:translateY(50px);animation:fadeUp 1.2s ease-out forwards; }
.fade-up.delay-1 { animation-delay:0.3s; }
.fade-up.delay-2 { animation-delay:0.6s; }
@keyframes fadeUp { 0% { opacity:0;transform:translateY(50px); } 100% { opacity:1;transform:translateY(0); } }
@media (max-width:768px) {
    .parallax-hero { height:400px; }
    .hero-title { font-size:2.2rem; }
    .hero-excerpt { font-size:1rem; }
    .parallax-bg { background-attachment:scroll; }
    .destination-container { grid-template-columns:1fr;padding:1rem;gap:2rem; }
    .includes-excludes { grid-template-columns:1fr; }
    .form-row { grid-template-columns:1fr; }
    .budget-cards { grid-template-columns:repeat(auto-fit,minmax(280px,1fr));gap:1rem; }
    .budget-card { min-height:300px;padding:1.5rem; }
    .package-highlights { grid-template-columns:1fr; }
    .media-item { height:250px; }
    .booking-form-container { padding:2rem 1rem;margin:2rem 1rem; }
    .package-overview-content { padding:1.5rem; }
    .lightbox-controls { padding:15px;font-size:24px; }
    .lightbox-indicators { bottom:20px;gap:8px; }
    .breadcrumb-container { padding:0.8rem 1rem; }
}
@media (max-width:480px) {
    .parallax-hero { height:350px; }
    .hero-title { font-size:1.8rem; }
    .hero-excerpt { font-size:0.9rem; }
    .media-item { height:200px; }
    .budget-cards { grid-template-columns:1fr; }
    .lightbox-controls { padding:10px;font-size:20px; }
}
</style>

<div class="<?php echo esc_attr($post_type); ?>">

    <section class="parallax-hero">
        <div class="parallax-bg" style="background-image:url('<?php echo $featured_image ? esc_url($featured_image) : 'https://via.placeholder.com/1200x350/2c3e50/ffffff?text=' . urlencode(get_the_title()); ?>');"></div>
        <div class="hero-overlay"></div>
        <div class="hero-line"></div>
        
        <div class="hero-content">
            <h1 class="hero-title fade-up"><?php the_title(); ?></h1>
        </div>
    </section>
    
    <div class="breadcrumb-container">
    <div class="breadcrumb">
        <a href="<?php echo home_url(); ?>">Home</a>
        <span class="breadcrumb-separator">›</span>
        <?php
        // Determine the correct breadcrumb link and label based on post type
        if ($post_type === 'romantic_package') {
            $parent_url = 'https://lwegatech.net/beaute-sauvage-safaris/honeymoon-getaways/';
            $parent_name = 'Honeymoon Getaways';
        } else {
            // Assuming 'travel_package' and any other types go to the Travel Packages page
            $parent_url = 'https://lwegatech.net/beaute-sauvage-safaris/packages/';
            $parent_name = 'Travel Packages';
        }
        ?>
        <a href="<?php echo esc_url($parent_url); ?>"><?php echo esc_html($parent_name); ?></a>
        <span class="breadcrumb-separator">›</span>
        <span class="breadcrumb-current"><?php the_title(); ?></span>
    </div>
</div>



    <div class="package-info-box">
       <?php if($package_overview): ?>
        <div class="package-overview-section">
            <div class="package-overview-content">
                <?php echo wp_kses_post(wpautop($package_overview)); ?>
            </div>
        </div>
        <?php endif; ?>
        
        <div class="package-highlights">
            
            <?php if($starting_price): ?>
            <div class="highlight-item">
                <h4>Starting At</h4>
                <div class="highlight-value">$<?php echo esc_html($starting_price); ?></div>
            </div>
            <?php endif; ?>
            
            <?php if($trip_duration && $duration_nights): ?>
            <div class="highlight-item">
                <h4>Duration</h4>
                <div class="highlight-value"><?php echo esc_html($trip_duration); ?>/<?php echo esc_html($duration_nights); ?> Nights</div>
            </div>
            <?php endif; ?>
        </div>
    </div>

    <?php if(!empty($budget_cards) && is_array($budget_cards)): ?>
    <div class="budget-cards-section">
        <h2>Choose Your Experience Level</h2>
        <div class="budget-cards">
            <?php foreach($budget_cards as $index => $card): ?>
                <?php if(isset($card['card_name']) && isset($card['card_price'])): ?>
                <div class="budget-card <?php echo $index === 0 ? 'active' : ''; ?>" data-tier="<?php echo esc_attr(strtoupper($card['card_name'])); ?>" data-index="<?php echo $index; ?>">
                    <div>
                        <h3><?php echo esc_html($card['card_name']); ?></h3>
                        <div class="budget-price">$<?php echo esc_html($card['card_price']); ?></div>
                    </div>
                    
                    <?php if(!empty($card['card_benefits']) && is_array($card['card_benefits'])): ?>
                    <ul class="budget-features">
                        <?php foreach($card['card_benefits'] as $benefit): ?>
                            <?php if(!empty($benefit)): ?>
                            <li><?php echo esc_html($benefit); ?></li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </ul>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            <?php endforeach; ?>
        </div>
    </div>
    <?php endif; ?>

    <div class="destination-container">
        <div class="destination-content">
            <?php if(!empty($itinerary_days) && is_array($itinerary_days)): ?>
            <section class="itinerary-section">
                <h2>DETAILED ITINERARY</h2>
                <?php foreach($itinerary_days as $index => $day): ?>
                    <?php if(isset($day['day_title']) && isset($day['day_description'])): ?>
                    <div class="itinerary-day">
                        <div class="day-header" onclick="toggleDay(<?php echo $index; ?>)">
                            <?php 
                            $day_media = isset($day['day_media']) ? $day['day_media'] : [];
                            $has_media = !empty($day_media) && is_array($day_media);
                            
                            if ($has_media && !empty($day_media[0])):
                                $first_media_id = $day_media[0];
                                $media_type = get_post_mime_type($first_media_id);
                                $is_video = strpos($media_type, 'video') !== false;
                                
                                if ($is_video):
                                    $video_thumb = wp_get_attachment_image_url($first_media_id, 'thumbnail');
                                    if ($video_thumb):
                            ?>
                            <img src="<?php echo esc_url($video_thumb); ?>" alt="Day <?php echo ($index + 1); ?> Video" class="day-media-thumb">
                            <?php else: ?>
                            <div class="day-media-thumb" style="background:#2c3e50;display:flex;align-items:center;justify-content:center;color:white;font-size:24px;">▶</div>
                            <?php endif; ?>
                            <?php else: 
                                $first_image = wp_get_attachment_image_url($first_media_id, 'thumbnail');
                                if ($first_image):
                            ?>
                            <img src="<?php echo esc_url($first_image); ?>" alt="Day <?php echo ($index + 1); ?>" class="day-media-thumb">
                            <?php endif; ?>
                            <?php endif; ?>
                            <?php endif; ?>
                            
                            <div class="day-title">
                                Day <?php echo ($index + 1); ?>: <?php echo esc_html($day['day_title']); ?>
                            </div>
                            <span class="toggle-icon" id="icon-<?php echo $index; ?>">▼</span>
                        </div>
                        
                        <div class="day-content" id="content-<?php echo $index; ?>">
                            <?php if ($has_media): ?>
                            <div class="day-media">
                                <div class="media-carousel" id="carousel-<?php echo $index; ?>">
                                    <div class="media-items" id="media-items-<?php echo $index; ?>" data-current-index="0">
                                        <?php 
                                        $media_data = [];
                                        foreach($day_media as $media_index => $media_id) {
                                            $media_url = wp_get_attachment_url($media_id);
                                            $media_type = get_post_mime_type($media_id);
                                            $is_video = strpos($media_type, 'video') !== false;
                                            $media_data[] = array(
                                                'id' => $media_id,
                                                'url' => $media_url,
                                                'type' => $is_video ? 'video' : 'image'
                                            );
                                        ?>
                                        <div class="media-item" data-index="<?php echo $media_index; ?>" onclick="openLightbox(<?php echo $index; ?>, <?php echo $media_index; ?>)">
                                            <?php if ($is_video): ?>
                                                <video src="<?php echo esc_url($media_url); ?>" muted></video>
                                                <div class="media-type-indicator">VIDEO</div>
                                            <?php else: ?>
                                                <img src="<?php echo esc_url($media_url); ?>" alt="Day <?php echo ($index + 1); ?>" />
                                                <div class="media-type-indicator">IMAGE</div>
                                            <?php endif; ?>
                                        </div>
                                        <?php } ?>
                                    </div>
                                    
                                    <?php if (count($media_data) > 1): ?>
                                    <button class="carousel-controls prev" onclick="event.stopPropagation(); moveCarousel(<?php echo $index; ?>, -1)">‹</button>
                                    <button class="carousel-controls next" onclick="event.stopPropagation(); moveCarousel(<?php echo $index; ?>, 1)">›</button>
                                    <div class="media-indicators">
                                        <?php foreach($media_data as $ind => $item): ?>
                                        <div class="indicator <?php echo $ind === 0 ? 'active' : ''; ?>" onclick="event.stopPropagation(); showCarouselItem(<?php echo $index; ?>, <?php echo $ind; ?>)"></div>
                                        <?php endforeach; ?>
                                    </div>
                                    <?php endif; ?>
                                </div>
                                
                                <script>
                                    if (typeof window.itineraryMediaData === 'undefined') {
                                        window.itineraryMediaData = {};
                                    }
                                    window.itineraryMediaData[<?php echo $index; ?>] = <?php echo json_encode($media_data); ?>;
                                </script>
                            </div>
                            <?php endif; ?>
                            
                            <div class="day-description">
                                <?php echo wp_kses_post(wpautop($day['day_description'])); ?>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </section>
            <?php endif; ?>

            <div class="lightbox" id="lightbox">
                <div class="lightbox-close" onclick="closeLightbox()">×</div>
                <div class="lightbox-carousel">
                    <button class="lightbox-controls prev" onclick="changeLightboxItem(-1)">‹</button>
                    <div id="lightbox-items"></div>
                    <button class="lightbox-controls next" onclick="changeLightboxItem(1)">›</button>
                    <div class="lightbox-indicators" id="lightbox-indicators"></div>
                </div>
            </div>

            <?php if(!empty($price_includes) || !empty($price_excludes)): ?>
            <div class="includes-excludes">
                <?php if(!empty($price_includes)): ?>
                <div class="includes">
                    <h4>✅ What's Included</h4>
                    <ul>
                        <?php foreach($price_includes as $include): ?>
                            <?php if(!empty($include)): ?>
                            <li><?php echo esc_html($include); ?></li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>
                
                <?php if(!empty($price_excludes)): ?>
                <div class="excludes">
                    <h4>❌ What's Not Included</h4>
                    <ul>
                        <?php foreach($price_excludes as $exclude): ?>
                            <?php if(!empty($exclude)): ?>
                            <li><?php echo esc_html($exclude); ?></li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>

        <div class="destination-sidebar">
            <div class="booking-widget">
    <h3>Quick Facts</h3>
    <ul>
        <?php 
        // Use the correct meta keys that match your CPT metaboxes
        $country = get_post_meta($post_id, '_country', true);
        $city = get_post_meta($post_id, '_city', true);
        $group_size = get_post_meta($post_id, '_group_size', true);
        $accommodation = get_post_meta($post_id, '_accommodation', true);
        ?>
        
        <?php if($country): ?>
        <li>
            <span class="info-label">Country:</span>
            <span><?php echo esc_html($country); ?></span>
        </li>
        <?php endif; ?>
        
        <?php if($city): ?>
        <li>
            <span class="info-label">City:</span>
            <span><?php echo esc_html($city); ?></span>
        </li>
        <?php endif; ?>
        
        <?php if($trip_duration): ?>
        <li>
            <span class="info-label">Duration:</span>
            <span><?php echo esc_html($trip_duration); ?></span>
        </li>
        <?php endif; ?>
        
        <?php if($group_size): ?>
        <li>
            <span class="info-label">Group Size:</span>
            <span><?php echo esc_html($group_size); ?></span>
        </li>
        <?php endif; ?>
        
        <?php if($accommodation): ?>
        <li>
            <span class="info-label">Accommodation:</span>
            <span><?php echo esc_html($accommodation); ?></span>
        </li>
        <?php endif; ?>
        
        <?php if($best_season): ?>
        <li>
            <span class="info-label">Best Season:</span>
            <span><?php echo esc_html($best_season); ?></span>
        </li>
        <?php endif; ?>
        
        <?php if($starting_price): ?>
        <li>
            <span class="info-label">Starting From:</span>
            <span>$<?php echo esc_html(number_format($starting_price, 0)); ?></span>
        </li>
        <?php endif; ?>
    </ul>
    <button class="book-now-btn" onclick="scrollToBookingForm()">Book Now</button>
</div>
        </div>
    </div>

    <div class="booking-form-container">
        <form class="booking-form" id="package-booking-form" method="post">
            <h3>Book This Package</h3>
            
            <div class="form-row">
                <div class="form-group">
                    <label for="customer_name">Full Name *</label>
                    <input type="text" id="customer_name" name="customer_name" required>
                </div>
                <div class="form-group">
                    <label for="customer_email">Email *</label>
                    <input type="email" id="customer_email" name="customer_email" required>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label for="customer_phone">Phone *</label>
                    <input type="tel" id="customer_phone" name="customer_phone" required>
                </div>
                <div class="form-group">
                    <label for="customer_dob">Date of Birth *</label>
                    <input type="date" id="customer_dob" name="customer_dob" required>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label for="num_adults">Number of Adults *</label>
                    <select id="num_adults" name="num_adults" required>
                        <option value="1">1 Adult</option>
                        <option value="2" selected>2 Adults</option>
                        <option value="3">3 Adults</option>
                        <option value="4">4 Adults</option>
                        <option value="5">5 Adults</option>
                        <option value="6">6+ Adults</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="num_children">Number of Children</label>
                    <select id="num_children" name="num_children">
                        <option value="0" selected>0 Children</option>
                        <option value="1">1 Child</option>
                        <option value="2">2 Children</option>
                        <option value="3">3 Children</option>
                        <option value="4">4+ Children</option>
                    </select>
                </div>
            </div>
            
            <div class="form-row">
                <div class="form-group">
                    <label for="departure_date">Preferred Departure Date *</label>
                    <input type="date" id="departure_date" name="departure_date" required>
                </div>
                <div class="form-group">
                    <label for="budget_preference">Budget Preference *</label>
                    <select id="budget_preference" name="budget_preference" required>
                        <option value="">Select Budget Tier</option>
                        <?php foreach($budget_cards as $card): ?>
                            <?php if(isset($card['card_name'])): ?>
                            <option value="<?php echo esc_attr($card['card_name']); ?>"><?php echo esc_html($card['card_name']); ?></option>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            
            <div class="form-group">
                <label for="special_requests">Any Additional Information</label>
                <textarea id="special_requests" name="special_requests" rows="4" placeholder="Any special requirements or preferences..."></textarea>
            </div>
            
            <input type="hidden" name="package_id" value="<?php echo $post_id; ?>">
            <input type="hidden" name="package_name" value="<?php the_title(); ?>">
            <input type="hidden" name="action" value="submit_package_booking">
            
            <?php wp_nonce_field('package_booking_nonce', 'booking_nonce'); ?>
            
            <div style="text-align: center;">
                <button type="submit" class="submit-booking">Submit Booking Request</button>
            </div>
        </form>
    </div>

    <?php if(!empty($gallery_images) && is_array($gallery_images)): ?>
    <div class="destination-gallery">
        <h2>Gallery</h2>
        <div class="gallery-grid">
            <?php foreach($gallery_images as $image_id): 
                $image_url = wp_get_attachment_url($image_id);
                if($image_url):
            ?>
            <img src="<?php echo esc_url($image_url); ?>" alt="Gallery Image" class="gallery-image" onclick="openGalleryLightbox('<?php echo esc_url($image_url); ?>')">
            <?php endif; endforeach; ?>
        </div>
    </div>
    <?php endif; ?>
</div>

<script>
// Initialize all carousels on page load
document.addEventListener('DOMContentLoaded', function() {
    if (typeof window.itineraryMediaData !== 'undefined') {
        Object.keys(window.itineraryMediaData).forEach(dayIndex => {
            showCarouselItem(parseInt(dayIndex), 0);
        });
    }
});

// Itinerary day toggle functionality
function toggleDay(index) {
    const content = document.getElementById('content-' + index);
    const icon = document.getElementById('icon-' + index);
    
    if (content.style.display === 'block' || content.classList.contains('active')) {
        content.style.display = 'none';
        content.classList.remove('active');
        icon.classList.remove('rotated');
    } else {
        content.style.display = 'block';
        content.classList.add('active');
        icon.classList.add('rotated');
    }
}

// Carousel navigation using transform
function moveCarousel(dayIndex, direction) {
    const mediaData = window.itineraryMediaData[dayIndex];
    if (!mediaData) return;
    
    const carousel = document.getElementById('media-items-' + dayIndex);
    const currentIndex = parseInt(carousel.dataset.currentIndex || 0);
    let newIndex = currentIndex + direction;
    
    if (newIndex < 0) newIndex = mediaData.length - 1;
    if (newIndex >= mediaData.length) newIndex = 0;
    
    showCarouselItem(dayIndex, newIndex);
}

function showCarouselItem(dayIndex, itemIndex) {
    const carousel = document.getElementById('media-items-' + dayIndex);
    const indicators = document.getElementById('carousel-' + dayIndex).querySelectorAll('.indicator');
    
    if (!carousel) return;
    
    // Use transform instead of display toggling
    const translateX = -100 * itemIndex;
    carousel.style.transform = `translateX(${translateX}%)`;
    carousel.dataset.currentIndex = itemIndex;
    
    // Update indicators
    indicators.forEach((indicator, index) => {
        indicator.classList.toggle('active', index === itemIndex);
    });
}

// Lightbox with proper media data
let currentLightboxDay = -1;
let currentLightboxIndex = 0;
let lightboxMediaItems = [];

function openLightbox(dayIndex, mediaIndex) {
    const mediaData = window.itineraryMediaData[dayIndex];
    if (!mediaData) return;
    
    currentLightboxDay = dayIndex;
    currentLightboxIndex = mediaIndex;
    lightboxMediaItems = mediaData;
    
    updateLightboxContent();
    document.getElementById('lightbox').classList.add('active');
    document.body.style.overflow = 'hidden';
}

function updateLightboxContent() {
    const lightboxItems = document.getElementById('lightbox-items');
    const lightboxIndicators = document.getElementById('lightbox-indicators');
    
    lightboxItems.innerHTML = '';
    lightboxIndicators.innerHTML = '';
    
    lightboxMediaItems.forEach((media, index) => {
        const isActive = index === currentLightboxIndex;
        
        const item = document.createElement('div');
        item.className = `lightbox-item ${isActive ? 'active' : ''}`;
        
        if (media.type === 'video') {
            item.innerHTML = `<video src="${media.url}" controls ${isActive ? 'autoplay' : ''}></video>`;
        } else {
            item.innerHTML = `<img src="${media.url}" alt="Gallery Image">`;
        }
        
        lightboxItems.appendChild(item);
        
        const indicator = document.createElement('div');
        indicator.className = `indicator ${isActive ? 'active' : ''}`;
        indicator.onclick = () => changeLightboxItemTo(index);
        lightboxIndicators.appendChild(indicator);
    });
}

function changeLightboxItem(direction) {
    currentLightboxIndex += direction;
    
    if (currentLightboxIndex < 0) {
        currentLightboxIndex = lightboxMediaItems.length - 1;
    } else if (currentLightboxIndex >= lightboxMediaItems.length) {
        currentLightboxIndex = 0;
    }
    
    updateLightboxContent();
}

function changeLightboxItemTo(index) {
    currentLightboxIndex = index;
    updateLightboxContent();
}

function closeLightbox() {
    document.getElementById('lightbox').classList.remove('active');
    document.body.style.overflow = 'auto';
    
    // Stop any playing videos
    const videos = document.querySelectorAll('#lightbox video');
    videos.forEach(video => {
        video.pause();
        video.currentTime = 0;
    });
}

// Close lightbox on ESC key
document.addEventListener('keydown', function(e) {
    if (e.key === 'Escape') {
        closeLightbox();
    }
});

// Simple gallery lightbox
function openGalleryLightbox(imageUrl) {
    const lightbox = document.getElementById('lightbox');
    const lightboxItems = document.getElementById('lightbox-items');
    
    lightboxItems.innerHTML = `
        <div class="lightbox-item active">
            <img src="${imageUrl}" alt="Gallery Image">
        </div>
    `;
    
    document.getElementById('lightbox-indicators').innerHTML = '';
    lightbox.classList.add('active');
    document.body.style.overflow = 'hidden';
}

// Budget card selection
document.addEventListener('DOMContentLoaded', function() {
    const budgetCards = document.querySelectorAll('.budget-card');
    
    budgetCards.forEach(card => {
        card.addEventListener('click', function() {
            budgetCards.forEach(c => c.classList.remove('active'));
            this.classList.add('active');
            
            const selectedTier = this.getAttribute('data-tier');
            const budgetSelect = document.getElementById('budget_preference');
            if (budgetSelect) {
                budgetSelect.value = selectedTier;
            }
        });
    });
});

// Scroll to booking form
function scrollToBookingForm() {
    const form = document.getElementById('package-booking-form');
    if (form) {
        form.scrollIntoView({ behavior: 'smooth' });
    }
}

// Form submission handling with redirect
const bookingForm = document.getElementById('package-booking-form');
if (bookingForm) {
    bookingForm.addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Disable submit button to prevent double submission
        const submitButton = this.querySelector('.submit-booking');
        const originalText = submitButton.textContent;
        submitButton.disabled = true;
        submitButton.textContent = 'Processing...';
        
        const formData = new FormData(this);
        
        fetch('<?php echo admin_url('admin-ajax.php'); ?>', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                // Redirect to thank you page
                window.location.href = data.data.redirect_url;
            } else {
                alert('Error: ' + (data.data || 'Please try again.'));
                submitButton.disabled = false;
                submitButton.textContent = originalText;
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error submitting booking. Please try again.');
            submitButton.disabled = false;
            submitButton.textContent = originalText;
        });
    });
}
</script>

<?php endwhile; get_footer(); ?>