<?php
/**
 * Template Name: Travel Packages Page
 * Description: Display all travel package categories with sidebar layout
 */
get_header();

// Get all categories for travel packages
$categories = get_categories(array(
    'taxonomy' => 'category',
    'orderby' => 'name',
    'order' => 'ASC',
    'hide_empty' => false, // Show even empty categories
));

// Get all destinations
$destinations = array("Uganda", "Kenya", "Tanzania", "Rwanda", "Dubai", "Zanzibar");
?>

<div class="travel-packages-page">
    <div class="container">
        <div class="row">
            <!-- Sidebar with categories and filters -->
            <div class="col-md-3">
                <div class="package-sidebar">
                    <h3>Package Categories</h3>
                    <ul class="package-categories">
                        <?php foreach ($categories as $category) : ?>
                            <li>
                                <a href="#<?php echo esc_attr($category->slug); ?>" data-category="<?php echo esc_attr($category->term_id); ?>">
                                    <?php echo esc_html($category->name); ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                    
                    <h3>Filter by Destination</h3>
                    <select class="destination-filter">
                        <option value="">All Destinations</option>
                        <?php foreach ($destinations as $destination) : ?>
                            <option value="<?php echo esc_attr($destination); ?>"><?php echo esc_html($destination); ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
            </div>
            
            <!-- Main content area -->
            <div class="col-md-9">
                <div class="package-categories-container">
                    <?php 
                    // Display packages by category
                    foreach ($categories as $category) : 
                        $packages = new WP_Query(array(
                            'post_type' => 'travel_package',
                            'posts_per_page' => -1,
                            'category__in' => array($category->term_id),
                            'orderby' => 'title',
                            'order' => 'ASC'
                        ));
                        
                        if ($packages->have_posts()) :
                    ?>
                    <section id="<?php echo esc_attr($category->slug); ?>" class="package-category-section">
                        <h2 class="category-title"><?php echo esc_html($category->name); ?></h2>
                        <div class="row package-grid">
                            <?php while ($packages->have_posts()) : $packages->the_post(); 
                                $price_usd = get_post_meta(get_the_ID(), '_price_usd', true);
                                $destination = get_post_meta(get_the_ID(), '_destination', true);
                                $reviews = get_post_meta(get_the_ID(), '_reviews', true);
                                $brief_description = get_post_meta(get_the_ID(), '_brief_description', true);
                            ?>
                            <div class="col-md-4 package-item" data-destination="<?php echo esc_attr($destination); ?>">
                                <div class="package-card">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <div class="package-image">
                                            <?php the_post_thumbnail('medium', array('class' => 'img-fluid')); ?>
                                        </div>
                                    <?php endif; ?>
                                    
                                    <div class="package-content">
                                        <h3><?php the_title(); ?></h3>
                                        <?php if ($brief_description) : ?>
                                            <p class="package-excerpt"><?php echo esc_html($brief_description); ?></p>
                                        <?php endif; ?>
                                        
                                        <div class="package-meta">
                                            <?php if ($destination) : ?>
                                                <span class="destination"><i class="fas fa-map-marker-alt"></i> <?php echo esc_html($destination); ?></span>
                                            <?php endif; ?>
                                            
                                            <?php if ($price_usd) : ?>
                                                <span class="price"><?php echo esc_html($price_usd); ?></span>
                                            <?php endif; ?>
                                            
                                            <?php if ($reviews) : ?>
                                                <span class="reviews"><i class="fas fa-star"></i> <?php echo esc_html($reviews); ?> reviews</span>
                                            <?php endif; ?>
                                        </div>
                                        
                                        <a href="<?php the_permalink(); ?>" class="btn btn-primary view-details-btn">View Details</a>
                                    </div>
                                </div>
                            </div>
                            <?php endwhile; ?>
                        </div>
                    </section>
                    <?php else: ?>
                    <section id="<?php echo esc_attr($category->slug); ?>" class="package-category-section">
                        <h2 class="category-title"><?php echo esc_html($category->name); ?></h2>
                        <p class="no-packages">No packages available in this category yet.</p>
                    </section>
                    <?php 
                        endif;
                        wp_reset_postdata();
                    endforeach; 
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
jQuery(document).ready(function($) {
    // Filter by destination
    $('.destination-filter').on('change', function() {
        var destination = $(this).val();
        
        if (destination) {
            $('.package-item').hide();
            $('.package-item[data-destination="' + destination + '"]').show();
        } else {
            $('.package-item').show();
        }
    });
    
    // Smooth scroll to category
    $('.package-categories a').on('click', function(e) {
        e.preventDefault();
        var target = $(this).attr('href');
        $('html, body').animate({
            scrollTop: $(target).offset().top - 50
        }, 500);
    });
});
</script>

<?php get_footer(); ?>