<?php 
$slider_query = new WP_Query(array(
    'post_type'      => 'text_slider', // Ensure this is the correct post type
    'posts_per_page' => 1, // Show only one slider
    'orderby'        => 'date',
    'order'          => 'DESC',
));
if ($slider_query->have_posts()): 
    while ($slider_query->have_posts()): 
        $slider_query->the_post();
        $background = get_the_post_thumbnail_url(get_the_ID(), 'full');
        $video = get_post_meta(get_the_ID(), '_video_url', true);
        $title = get_the_title();
        $subtitles = get_post_meta(get_the_ID(), '_subtitles', true);
        $link = get_post_meta(get_the_ID(), '_slider_link', true);
        $descr = get_the_content(get_the_ID(), 'content');
?>
<section class="text-slider">
    <?php if ($video) : ?>
        <video autoplay loop muted playsinline class="slider-video">
            <source src="<?php echo esc_url($video); ?>" type="video/mp4">
            Your browser does not support the video tag.
        </video>
        <!-- Video Title Overlay -->
        <div class="video-title-overlay">
            <h1 class="video-main-title"><?php echo esc_html($title); ?></h1>
        </div>
    <?php else : ?>
        <div class="slider-bg" style="background-image: url('<?php echo esc_url($background); ?>');"></div>
        <div class="overlay"></div>
        <div class="container-md">
            <div class="row">
                <div class="col">
                    <h2 class="main-title" data-aos="fade-up"><?php echo esc_html($title); ?></h2>
                    <h3 id="changing-subtitle" class="subtitle" data-aos="fade-up"></h3>
                    <p data-aos="fade-up" data-aos-delay="1000"><?php echo esc_html($descr); ?></p>
                    <?php if (!empty($link)) : ?>
                        <a href="<?php echo esc_url($link); ?>" class="btn btn-outline-warning slider-btn" data-aos="fade-up" data-aos-delay="1000">LEARN MORE ABOUT <strong><?= date('Y');?></strong> EVENT</a>
                    <?php endif; ?>
                </div>
            </div>
        </div><!-- container !-->
    <?php endif; ?>
</section>

<?php if (!$video) : ?>
<script>
document.addEventListener("DOMContentLoaded", function() {
    let subtitles = <?php echo json_encode($subtitles); ?>;
    let subtitleElement = document.getElementById("changing-subtitle");
    let index = 0;
    function typeWriter(text, i, callback) {
        if (i < text.length) {
            subtitleElement.innerHTML += text.charAt(i);
            setTimeout(() => typeWriter(text, i + 1, callback), 100);
        } else {
            setTimeout(callback, 2000);
        }
    }
    function changeSubtitle() {
        subtitleElement.innerHTML = "";
        typeWriter(subtitles[index], 0, function() {
            index = (index + 1) % subtitles.length;
            setTimeout(changeSubtitle, 1000);
        });
    }
    if (subtitles.length > 0) {
        changeSubtitle();
    }
});
</script>
<?php endif; ?>

<style>
@import url('https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&display=swap');

.text-slider {
    position: relative;
    width: 100%;
    height: 700px;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
    text-align: center;
    color: white;
}

.slider-bg {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-size: cover;
    background-position: center;
}

.slider-video {
    position: absolute;
    z-index: -1;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* Video Title Overlay - ASmallWorld Style */
.video-title-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 10;
    background: rgba(0, 0, 0, 0.3);
    pointer-events: none;
}

.video-main-title {
    font-family: 'Playfair Display', serif;
    font-size: clamp(3rem, 8vw, 8rem);
    font-weight: 400;
    color: white;
    text-align: center;
    line-height: 1.1;
    letter-spacing: 0.02em;
    text-shadow: 2px 2px 8px rgba(0, 0, 0, 0.8);
    margin: 0;
    padding: 0 2rem;
    max-width: 90%;
    word-spacing: 0.3em;
    z-index: 100;
    position: relative;
}

.overlay {
    position: absolute;
    z-index: 2;
    background: rgba(0, 0, 0, 0.10);
    width: 100%;
    height: 100%;
}

.container-md {
    position: relative;
    z-index: 3;
    width: 800px;
}

.main-title {
    font-size: 70px;
    margin-top: 100px;
    margin-bottom: 10px;
    font-weight: 700;
    display: block; /* Show for image sliders */
}

.subtitle {
    font-size: 36px;
    height: 50px;
    display: block; /* Show for image sliders */
}

.slider-btn {
    border-radius: 20px;
    padding: calc(.667em + 2px) calc(1.333em + 2px);
    transition: 2s ease-in;
    display: inline-block; /* Show for image sliders */
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .video-main-title {
        font-size: clamp(2rem, 10vw, 4rem);
        padding: 0 1rem;
    }
    
    .text-slider {
        height: 500px;
    }
    
    .container-md {
        width: 95%;
        max-width: 600px;
    }
    
    .main-title {
        font-size: 50px;
        margin-top: 50px;
    }
    
    .subtitle {
        font-size: 28px;
    }
}

@media (max-width: 480px) {
    .video-main-title {
        font-size: clamp(1.5rem, 12vw, 3rem);
        word-spacing: 0.2em;
    }
    
    .main-title {
        font-size: 40px;
    }
    
    .subtitle {
        font-size: 24px;
    }
}
</style>

<?php 
    endwhile; 
endif; 
wp_reset_postdata(); 
?>