<?php
// Get current page for active menu highlighting
$current_page = basename($_SERVER['PHP_SELF'], '.php');

// Menu configuration
$desktop_menu_items = array(
    'about-us' => array(
        'title' => 'ABOUT US',
        'url' => '#',
        'children' => array(
            'overview' => array('title' => 'Overview', 'url' => home_url('/about-us/overview')),
            'affiliations' => array('title' => 'Affiliations', 'url' => home_url('/about-us/affiliations'))
        )
    ),
    'destinations' => array(
        'title' => 'DESTINATIONS',
        'url' => '#',
        'children' => array(
            'uganda' => array('title' => 'Uganda', 'url' => home_url('/destinations/uganda')),
            'dubai' => array('title' => 'Dubai', 'url' => home_url('/destinations/dubai'))
        )
    ),
    'packages' => array('title' => 'TRAVEL PACKAGES', 'url' => home_url('/packages')),
    'honeymoon' => array('title' => 'HONEYMOON GETAWAYS', 'url' => home_url('/honeymoon-getaways')),
    'travel' => array('title' => 'TRAVEL MANAGEMENT', 'url' => home_url('/travel-management')),
    'visa' => array('title' => 'VISA SUPPORT', 'url' => home_url('/visa-support')),
    'contact' => array('title' => 'GET IN TOUCH', 'url' => home_url('/contact'))
);

$mobile_menu_items = array_merge(
    array('home' => array('title' => 'HOME', 'url' => home_url('/'))),
    $desktop_menu_items
);
?>

<!-- Top Info Bar -->
<div class="top-header d-none d-md-block">
    <div class="top-info-container">
        <div class="top-left-contact">
            <a href="tel:+256770506083" class="top-contact-item"><i class="bi bi-telephone-fill"></i><span>+256 771 456146‬
</span></a>
            <a href="mailto:info@thetravelerportal.com" class="top-contact-item"><i class="bi bi-envelope-fill"></i><span>info@thetravelerportal.com</span></a>
            <a href="https://wa.me/256705143550" class="top-contact-item"><i class="bi bi-whatsapp"></i><span>+256 771 456146‬
</span></a>
        </div>
        <div class="top-right-social">
            <span class="social-text">Our Socials</span>
            <div class="top-social-links">
                <a href="#" class="top-social-link" title="Facebook"><i class="bi bi-facebook"></i></a>
                <a href="#" class="top-social-link" title="Twitter"><i class="bi bi-twitter"></i></a>
                <a href="#" class="top-social-link" title="YouTube"><i class="bi bi-youtube"></i></a>
                <a href="#" class="top-social-link" title="Instagram"><i class="bi bi-instagram"></i></a>
            </div>
        </div>
    </div>
</div>

<!-- Main Header -->
<div class="main-header">
    <div class="header-container">
        <div class="logo-section">
            <?php
                $custom_logo_id = get_theme_mod('custom_logo');
                $logo_url = wp_get_attachment_image_src($custom_logo_id, 'full');
                if ($logo_url) {
                    echo '<a href="' . esc_url(home_url('/')) . '"><img src="' . esc_url($logo_url[0]) . '" class="img-fluid logo" alt="' . get_bloginfo('name') . '"></a>';
                } else {
                    echo '<a href="' . esc_url(home_url('/')) . '"><h1>' . get_bloginfo('name') . '</h1></a>';
                }
            ?>
        </div>
        <div class="navigation-section d-none d-lg-block">
            <nav class="main-nav">
                <?php if (has_nav_menu('main-menu')): ?>
                    <?php wp_nav_menu(array(
                        'theme_location' => 'main-menu',
                        'container' => false,
                        'menu_class' => 'navbar-nav',
                        'fallback_cb' => false,
                        'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                        'depth' => 2,
                        'walker' => new Desktop_Menu_Walker()
                    )); ?>
                <?php else: ?>
                    <ul class="navbar-nav">
                        <?php foreach ($desktop_menu_items as $key => $item): ?>
                            <li class="nav-item <?php echo !empty($item['children']) ? 'custom-dropdown' : ''; ?>">
                                <a class="nav-link <?php echo !empty($item['children']) ? 'dropdown-parent' : ''; ?>" href="<?php echo esc_url($item['url']); ?>" <?php echo !empty($item['children']) ? 'onclick="return false;"' : ''; ?>>
                                    <?php echo esc_html($item['title']); ?>
                                    <?php if (!empty($item['children'])): ?><i class="bi bi-chevron-down dropdown-arrow"></i><?php endif; ?>
                                </a>
                                <?php if (!empty($item['children'])): ?>
                                    <ul class="custom-dropdown-menu">
                                        <?php foreach ($item['children'] as $child_key => $child): ?>
                                            <li><a class="dropdown-item" href="<?php echo esc_url($child['url']); ?>"><?php echo esc_html($child['title']); ?></a></li>
                                        <?php endforeach; ?>
                                    </ul>
                                <?php endif; ?>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php endif; ?>
            </nav>
        </div>
        <button class="mobile-menu-toggle d-lg-none" onclick="toggleMobileMenu()" type="button" aria-label="Toggle navigation">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 -960 960 960" fill="currentColor"><path d="M120-240v-80h720v80H120Zm0-200v-80h720v80H120Zm0-200v-80h720v80H120Z"/></svg>
        </button>
    </div>
</div>

<!-- Mobile Offcanvas Menu - Simplified -->
<div class="mobile-offcanvas" id="mobileOffcanvas">
    <div class="mobile-offcanvas-overlay" onclick="closeMobileMenu()"></div>
    <div class="mobile-offcanvas-content">
        <div class="mobile-offcanvas-header">
            <h5 class="mobile-offcanvas-title">Menu</h5>
            <button type="button" class="mobile-close-btn" onclick="closeMobileMenu()" aria-label="Close">×</button>
        </div>
        <div class="mobile-offcanvas-body">
            <nav class="mobile-nav">
                <ul class="mobile-nav-list">
                    <?php foreach ($mobile_menu_items as $key => $item): ?>
                        <li class="mobile-nav-item <?php echo !empty($item['children']) ? 'has-children' : ''; ?>">
                            <?php if (!empty($item['children'])): ?>
                                <div class="mobile-nav-link-wrapper">
                                    <span class="mobile-nav-link"><?php echo esc_html($item['title']); ?></span>
                                    <button class="mobile-dropdown-btn" onclick="toggleMobileDropdown(this)" aria-label="Toggle submenu">
                                        <i class="bi bi-chevron-down"></i>
                                    </button>
                                </div>
                                <ul class="mobile-submenu">
                                    <?php foreach ($item['children'] as $child_key => $child): ?>
                                        <li><a class="mobile-submenu-link" href="<?php echo esc_url($child['url']); ?>"><?php echo esc_html($child['title']); ?></a></li>
                                    <?php endforeach; ?>
                                </ul>
                            <?php else: ?>
                                <a class="mobile-nav-link" href="<?php echo esc_url($item['url']); ?>"><?php echo esc_html($item['title']); ?></a>
                            <?php endif; ?>
                        </li>
                    <?php endforeach; ?>
                </ul>
            </nav>
            <div class="mobile-book-now">
                <a href="<?php echo esc_url(home_url('/get-in-touch/')); ?>" class="btn-book-now">BOOK YOUR TRIP</a>
            </div>
        </div>
    </div>
</div>

<?php
class Desktop_Menu_Walker extends Walker_Nav_Menu {
    function start_lvl(&$output, $depth = 0, $args = null) { $output .= '<ul class="dropdown-menu">'; }
    function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
        $classes = empty($item->classes) ? array() : (array) $item->classes;
        $classes[] = 'nav-item';
        if (in_array('menu-item-has-children', $classes)) { $classes[] = 'dropdown'; $classes[] = 'hover-dropdown'; }
        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
        $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
        $output .= '<li' . $class_names . '>';
        $attributes = '';
        $attributes .= !empty($item->attr_title) ? ' title="' . esc_attr($item->attr_title) . '"' : '';
        $attributes .= !empty($item->target) ? ' target="' . esc_attr($item->target) . '"' : '';
        $attributes .= !empty($item->xfn) ? ' rel="' . esc_attr($item->xfn) . '"' : '';
        $attributes .= !empty($item->url) ? ' href="' . esc_attr($item->url) . '"' : '';
        $item_output = $args->before ?? '';
        $link_class = 'nav-link';
        $onclick_attr = '';
        if (in_array('menu-item-has-children', $classes)) {
            $link_class .= ' dropdown-parent';
            $onclick_attr = ' onclick="return false;"';
            $attributes = str_replace($item->url, '#', $attributes);
        }
        $item_output .= '<a class="' . $link_class . '"' . $attributes . $onclick_attr . '>';
        $item_output .= ($args->link_before ?? '') . apply_filters('the_title', $item->title, $item->ID) . ($args->link_after ?? '');
        if (in_array('menu-item-has-children', $classes)) { $item_output .= '<i class="bi bi-chevron-down dropdown-arrow"></i>'; }
        $item_output .= '</a>';
        $item_output .= $args->after ?? '';
        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    }
}
?>

<style>
/* Mobile Menu Toggle Button */
.mobile-menu-toggle { background: #1e3a8a !important; color: #fff !important; border: 2px solid #1e3a8a !important; border-radius: 50%; padding: 12px; font-size: 18px; transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1); width: 50px; height: 50px; display: flex; align-items: center; justify-content: center; position: relative; overflow: hidden; box-shadow: 0 4px 12px rgba(30, 58, 138, 0.3); cursor: pointer; }
.mobile-menu-toggle:hover { background: #1e40af !important; border-color: #1e40af !important; transform: scale(1.1); box-shadow: 0 6px 20px rgba(30, 58, 138, 0.4); }
.mobile-menu-toggle svg { width: 22px; height: 22px; transition: all 0.3s ease; }

/* Mobile Offcanvas */
.mobile-offcanvas { position: fixed; top: 0; right: 0; width: 100%; height: 100%; z-index: 9999; visibility: hidden; transition: visibility 0.3s; }
.mobile-offcanvas.show { visibility: visible; }
.mobile-offcanvas-overlay { position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0, 0, 0, 0.5); opacity: 0; transition: opacity 0.3s; cursor: pointer; }
.mobile-offcanvas.show .mobile-offcanvas-overlay { opacity: 1; }
.mobile-offcanvas-content { position: absolute; top: 0; right: 0; width: 85%; max-width: 400px; height: 100%; background: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%); box-shadow: -10px 0 30px rgba(0, 0, 0, 0.15); transform: translateX(100%); transition: transform 0.3s ease-in-out; overflow-y: auto; display: flex; flex-direction: column; }
.mobile-offcanvas.show .mobile-offcanvas-content { transform: translateX(0); }
.mobile-offcanvas-header { background: #1e3a8a; color: #fff; padding: 20px 25px; border-bottom: 3px solid #fbbf24; position: relative; display: flex; justify-content: space-between; align-items: center; flex-shrink: 0; }
.mobile-offcanvas-title { font-size: 20px; font-weight: 600; color: #fff; margin: 0; }
.mobile-close-btn { background: transparent; border: none; color: #fff; font-size: 32px; padding: 0; width: 32px; height: 32px; border-radius: 50%; transition: all 0.3s ease; cursor: pointer; display: flex; align-items: center; justify-content: center; line-height: 1; }
.mobile-close-btn:hover { background: rgba(255, 255, 255, 0.2); transform: rotate(90deg); }
.mobile-offcanvas-body { padding: 25px; flex: 1; overflow-y: auto; }

/* Mobile Navigation */
.mobile-nav-list { list-style: none; padding: 0; margin: 0; }
.mobile-nav-item { border-bottom: 1px solid rgba(30, 58, 138, 0.1); margin: 0; }
.mobile-nav-item:last-child { border-bottom: none; }
.mobile-nav-link-wrapper { display: flex; align-items: center; justify-content: space-between; padding: 18px 15px; }
.mobile-nav-link { color: #1e3a8a !important; text-decoration: none; font-weight: 500; font-size: 16px; display: block; padding: 18px 15px; border-radius: 8px; transition: all 0.3s ease; position: relative; }
.mobile-nav-item.has-children .mobile-nav-link { padding: 0; cursor: default; }
.mobile-nav-link-wrapper .mobile-nav-link { padding: 0; flex: 1; }
a.mobile-nav-link:hover { color: #fff !important; background: linear-gradient(135deg, #1e3a8a, #1e40af); padding-left: 25px; }
.mobile-dropdown-btn { background: transparent; border: none; color: #64748b; font-size: 20px; padding: 0 10px; cursor: pointer; transition: all 0.3s ease; display: flex; align-items: center; justify-content: center; }
.mobile-dropdown-btn i { transition: transform 0.3s ease; }
.mobile-nav-item.active .mobile-dropdown-btn i { transform: rotate(180deg); color: #fbbf24; }
.mobile-submenu { list-style: none; padding: 0; margin: 0 0 0 20px; max-height: 0; overflow: hidden; transition: max-height 0.3s ease; }
.mobile-nav-item.active .mobile-submenu { max-height: 500px; padding: 10px 0; }
.mobile-submenu-link { color: #475569 !important; padding: 12px 20px; font-size: 14px; display: block; border-radius: 6px; transition: all 0.3s ease; text-decoration: none; position: relative; }
.mobile-submenu-link::before { content: '→'; position: absolute; left: 8px; opacity: 0; transition: all 0.3s ease; color: #fbbf24; }
.mobile-submenu-link:hover { color: #fff !important; background: linear-gradient(135deg, #fbbf24, #f59e0b); padding-left: 28px; transform: translateX(5px); }
.mobile-submenu-link:hover::before { opacity: 1; left: 12px; }
.mobile-book-now { padding: 25px 0 15px; border-top: 2px solid rgba(30, 58, 138, 0.1); margin-top: 25px; }
.btn-book-now { background: linear-gradient(135deg, #fbbf24, #f59e0b); border: none; color: #1e3a8a; font-weight: 600; font-size: 16px; padding: 15px 30px; border-radius: 25px; width: 100%; transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1); text-transform: uppercase; letter-spacing: 1px; box-shadow: 0 4px 15px rgba(251, 191, 36, 0.3); display: block; text-decoration: none; text-align: center; }
.btn-book-now:hover { background: linear-gradient(135deg, #f59e0b, #fbbf24); color: #1e3a8a; transform: translateY(-3px); box-shadow: 0 8px 25px rgba(251, 191, 36, 0.4); }

/* Sticky Header */
.header-sticky .main-header { position: fixed; top: 0; left: 0; width: 100%; z-index: 1000; background: rgba(255, 255, 255, 0.95); backdrop-filter: blur(10px); box-shadow: 0 4px 20px rgba(0, 0, 0, 0.1); animation: slideDownHeader 0.3s ease-out; }
.header-sticky .top-header { display: none; }
.header-sticky .main-header .header-container { padding: 10px 0; }
.header-sticky .logo-section img { height: 50px; transition: all 0.3s ease; }
@keyframes slideDownHeader { from { transform: translateY(-100%); } to { transform: translateY(0); } }

/* Prevent body scroll when menu is open */
body.mobile-menu-open { overflow: hidden; }

.mobile-offcanvas { 
  display: none;
}

.mobile-offcanvas.show { 
  display: block; 
}

</style>

<script>
// Simple mobile menu functions
function toggleMobileMenu() {
    const menu = document.getElementById('mobileOffcanvas');
    const body = document.body;
    
    if (menu.classList.contains('show')) {
        closeMobileMenu();
    } else {
        menu.classList.add('show');
        body.classList.add('mobile-menu-open');
    }
}

function closeMobileMenu() {
    const menu = document.getElementById('mobileOffcanvas');
    const body = document.body;
    
    menu.classList.remove('show');
    body.classList.remove('mobile-menu-open');
    
    // Close all dropdowns
    document.querySelectorAll('.mobile-nav-item.active').forEach(item => {
        item.classList.remove('active');
    });
}

function toggleMobileDropdown(button) {
    const navItem = button.closest('.mobile-nav-item');
    const isActive = navItem.classList.contains('active');
    
    // Close all other dropdowns
    document.querySelectorAll('.mobile-nav-item.active').forEach(item => {
        if (item !== navItem) {
            item.classList.remove('active');
        }
    });
    
    // Toggle current dropdown
    if (isActive) {
        navItem.classList.remove('active');
    } else {
        navItem.classList.add('active');
    }
}

// Sticky header effect
let lastScrollTop = 0;
window.addEventListener('scroll', function() {
    const currentScroll = window.pageYOffset || document.documentElement.scrollTop;
    const header = document.querySelector('.main-header');
    if (header && header.parentElement) {
        if (currentScroll > 50) {
            header.parentElement.classList.add('header-sticky');
        } else {
            header.parentElement.classList.remove('header-sticky');
        }
    }
    lastScrollTop = currentScroll <= 0 ? 0 : currentScroll;
}, false);

// Desktop dropdown functionality
document.addEventListener('DOMContentLoaded', function() {
    document.querySelectorAll('.navbar-nav .dropdown, .navbar-nav .hover-dropdown').forEach(item => {
        const dropdown = item.querySelector('.dropdown-menu');
        if (dropdown) {
            item.addEventListener('mouseenter', function() {
                dropdown.style.opacity = '1';
                dropdown.style.visibility = 'visible';
                dropdown.style.transform = 'translateY(0) translateX(-50%)';
                dropdown.style.display = 'block';
            });
            item.addEventListener('mouseleave', function() {
                dropdown.style.opacity = '0';
                dropdown.style.visibility = 'hidden';
                dropdown.style.transform = 'translateY(10px) translateX(-50%)';
                setTimeout(() => {
                    if (dropdown.style.opacity === '0') {
                        dropdown.style.display = 'none';
                    }
                }, 300);
            });
        }
    });
});
</script>