<?php
function homeServ_shortcode() {
    ob_start(); // Start output buffering

    // Enqueue Swiper.js if not already added
    wp_enqueue_style('swiper-css', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.css');
    wp_enqueue_script('swiper-js', 'https://cdn.jsdelivr.net/npm/swiper@11/swiper-bundle.min.js', array('jquery'), '', true);

    $news_args = array(
        'post_type'      => 'page',
        'posts_per_page' => 6, // Fetch more posts to allow sliding
        'category_name'  => 'services',
        'order'          => 'desc',
    );

    $news_query = new WP_Query($news_args);
    
    if ($news_query->have_posts()) : ?>

        <div class="swiper-container home-services-slider">
            <div class="swiper-wrapper">
                <?php while ($news_query->have_posts()) : $news_query->the_post(); ?>
                    <div class="swiper-slide">
                        <article class="kpy-services">
                            <a href="<?= esc_url(get_permalink()); ?>" class="p-0">
                                <div class="card shadow-sm mb-3 border-0" data-aos="fade-up">
                                    <div class="post-thumbnail">
                                        <?php 
                                        if (has_post_thumbnail()) {
                                            the_post_thumbnail('medium'); 
                                        } else {
                                            echo '<img src="'. get_template_directory_uri() .'/assets/images/default-featured.jpg" alt="NH Platform" class="img-fluid"/>';
                                        }
                                        ?>
                                    </div>
                                    <div class="card-body">
                                        <h3><?php the_title(); ?></h3>
                                        <a href="<?= esc_url(get_permalink()); ?>" class="read-more">Read More <i class="bi bi-arrow-right-circle-fill"></i></a>
                                    </div>
                                </div>
                            </a>
                        </article>
                    </div>
                <?php endwhile; wp_reset_postdata(); ?>
            </div>

            <!-- Navigation Arrows -->
            <div class="swiper-button-prev"></div>
            <div class="swiper-button-next"></div>

            <!-- Pagination -->
            <div class="swiper-pagination"></div>
        </div>

        <script>
        document.addEventListener("DOMContentLoaded", function() {
            var swiper = new Swiper(".home-services-slider", {
                slidesPerView: 3,
                spaceBetween: 20,
                loop: true,
                autoplay: {
                    delay: 5000,
                    disableOnInteraction: false
                },
                pagination: {
                    el: ".swiper-pagination",
                    clickable: true,
                },
                navigation: {
                    nextEl: ".swiper-button-next",
                    prevEl: ".swiper-button-prev",
                },
                breakpoints: {
                    1024: { slidesPerView: 3 },
                    768: { slidesPerView: 2 },
                    0: { slidesPerView: 1 },
                }
            });
        });
        </script>

        <style>
            .swiper-container {
                width: 100%;
                padding: 20px 0;
            }
            .swiper-slide {
                display: flex;
                justify-content: center;
            }
            .swiper-button-prev, .swiper-button-next {
                color: #333; /* Arrow color */
               
            }
            .swiper-pagination {
                position: relative;
                bottom: 10px;
                display: none;
            }
        </style>

    <?php endif;

    return ob_get_clean(); // Return the buffered content
}

// Register the shortcode
add_shortcode('home-service', 'homeServ_shortcode');
