<?php
/**
 * Enhanced Travel Portal Overview Page Shortcode
 */
function travel_portal_overview_shortcode($atts) {
    $atts = shortcode_atts(array(
        'title' => 'Your Journey, Our Expertise',
        'tagline' => 'Your trusted partner in business travel'
    ), $atts, 'travel_portal_overview');

    ob_start();
    ?>
    
    <div class="tp-overview-portal">

        <!-- About Section -->
<section class="tp-overview-about-section">
    <div class="tp-overview-container">
        <!-- Top Section -->
        <div class="tp-overview-about-top">
            <div class="tp-overview-about-left">
                <div class="tp-about-avatar-container">
                    <img src="https://i.pinimg.com/736x/42/eb/e9/42ebe995fffc2400e5a9875b22accfcd.jpg" alt="Travel Portal Team Member" class="tp-about-avatar">
                </div>
            </div>
            <div class="tp-overview-about-right">
                <h2 class="tp-about-title">A <span class="tp-about-highlight">human-led</span> service, backed by tech</h2>
                <p class="tp-about-description">
                                        With over 15 years of professional service, Travel Portal is one of Uganda’s leading
                    travel management company, delivering end-to-end and policy-aligned travel solutions
                    to corporates, NGOs, government agencies, international institutions and individual
                    travellers. Headquartered in Kampala, we manage journeys across the globe with
                    precision, efficiency, and personalised care.
                </p>
                <p class="tp-about-description">
                    Our USP is that we genuinely care about the quality of your corporate travel not just in terms of precision but also as an individual experience.
                </p>
                <div class="tp-about-badge">
                    <div class="tp-badge-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div class="tp-badge-text">
                        <span class="tp-badge-main">We have been affiliated with IATA</span>
                        <span class="tp-badge-sub">since <strong>2009</strong></span>
                    </div>
                    <div class="tp-badge-logo">
                        <span class="tp-iata-logo">IATA</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Bottom Section -->
        <div class="tp-overview-about-bottom">
            <div class="tp-overview-about-bottom-left">
                <h3 class="tp-about-promise-title">When the travellers are happy, so are their management teams, which is why we promise all of the following when booking your trips. Our Core Services Include:</h3>
                
                <div class="tp-about-promises">
                    <div class="tp-promise-item">
                        <div class="tp-promise-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="tp-promise-text">Air Ticketing & Reservation Management</span>
                    </div>
                    
                    <div class="tp-promise-item">
                        <div class="tp-promise-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="tp-promise-text">Hotel & Extended-Stay Solutions</span>
                    </div>
                    
                    <div class="tp-promise-item">
                        <div class="tp-promise-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="tp-promise-text">Tailor-Made Holidays & Group Travel</span>
                    </div>
                    
                    <div class="tp-promise-item">
                        <div class="tp-promise-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="tp-promise-text">Visa & Travel Insurance Support</span>
                    </div>
                    
                    <div class="tp-promise-item">
                        <div class="tp-promise-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="tp-promise-text">Traveller Profiling & Data Management</span>
                    </div>
                    
                    <div class="tp-promise-item">
                        <div class="tp-promise-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="tp-promise-text">24/7 Global Travel Support</span>
                    </div>
                </div>
                
                <div class="tp-about-founded">
                    <div class="tp-founded-badge">
                        <div class="tp-founded-icon">
                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <span class="tp-founded-text">We were founded <strong>15 years</strong> ago!</span>
                    </div>
                </div>
            </div>
            
            <div class="tp-overview-about-bottom-right">
                <div class="tp-about-tech-visual">
                    <div class="tp-tech-circle">
                        <div class="tp-tech-phone">
                            <img src="https://images.unsplash.com/photo-1512941937669-90a1b58e7e9c?w=200&h=400&fit=crop" alt="Travel App Interface" class="tp-phone-screen">
                        </div>
                        <div class="tp-tech-charts">
                            <div class="tp-chart tp-chart-1">
                                <div class="tp-chart-bars">
                                    <div class="tp-bar" style="height: 20%"></div>
                                    <div class="tp-bar" style="height: 40%"></div>
                                    <div class="tp-bar" style="height: 60%"></div>
                                    <div class="tp-bar" style="height: 30%"></div>
                                    <div class="tp-bar" style="height: 80%"></div>
                                </div>
                            </div>
                            <div class="tp-chart tp-chart-2">
                                <div class="tp-chart-lines">
                                    <svg width="100" height="60" viewBox="0 0 100 60">
                                        <path d="M5,45 Q25,25 45,35 T85,15" stroke="#3498db" stroke-width="2" fill="none"/>
                                        <path d="M5,50 Q25,35 45,40 T85,25" stroke="#e74c3c" stroke-width="2" fill="none"/>
                                    </svg>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

        <!-- Why Choose Us Section -->
        <section class="tp-overview-values-section">
            <div class="tp-overview-container">
                <div class="tp-overview-values-header">
                    <h2>Why Travel Portal Stands Out</h2>
                </div>
                
                <div class="tp-overview-values-grid">
                    <div class="tp-overview-value-card tp-overview-people">
                        <div class="tp-overview-value-icon">👥</div>
                        <h3>Our Team of Experts</h3>
                        <p>At the heart of Travel Portal is a highly trained team of travel consultants and client service professionals. Their deep industry knowledge ensures that every itinerary, from complex multi-leg corporate travel to tailor-made leisure journeys, is professionally managed.</p>
                        <div class="tp-overview-value-images">
                            <img src="https://i.pinimg.com/1200x/06/b9/64/06b9645cbb29f2902f5e71c267e921f2.jpg" alt="African team collaboration">
                            <img src="https://i.pinimg.com/736x/e1/c0/ba/e1c0ba5d2e8eea9e428c9a78cc65605e.jpg" alt="African business meeting">
                        </div>
                    </div>
                    
                    <div class="tp-overview-value-card tp-overview-planet">
                        <div class="tp-overview-value-icon">🤝</div>
                        <h3>Global Partnerships</h3>
                        <p>We work closely with leading airlines, international hotel chains and destination management companies (DMCs) worldwide to secure the best routes, accommodations and experiences. These partnerships enable us to offer exclusive benefits and priority access.</p>
                        <div class="tp-overview-value-images">
                            <img src="https://i.pinimg.com/736x/23/88/4f/23884fc13c8a44d2fcc15b439b688ea9.jpg" alt="Partnership handshake">
                            <img src="https://i.pinimg.com/736x/ab/c3/39/abc339d60faee90e61fa74560fb4399d.jpg" alt="Global connections">
                        </div>
                    </div>
                    
                    <div class="tp-overview-value-card tp-overview-performance">
                        <div class="tp-overview-value-icon">⭐</div>
                        <h3>Accreditations</h3>
                        <p>Travel Portal is a proud member of International Air Transport Association (IATA) and Uganda Tourism Board (UTB). These affiliations reflect our commitment to professionalism, ethical standards and operational excellence.</p>
                        <div class="tp-overview-value-images">
                            <img src="https://i.pinimg.com/736x/34/77/86/347786d61091cf60b8581e721061d796.jpg" alt="Accreditations">
                            <img src="https://i.pinimg.com/736x/29/f5/ee/29f5ee7f256dfe0abad1e7c366b3536a.jpg" alt="Certifications">
                        </div>
                    </div>
                </div>
            </div>
        </section>

       

        <!-- Commitment Section -->
        <section class="tp-overview-tech-section">
            <div class="tp-overview-container">
                <div class="tp-overview-tech-content">
                    <div class="tp-overview-tech-image">
                        <img src="https://i.pinimg.com/1200x/48/84/8c/48848c07829ed9fbb312540f3628ae85.jpg" alt="Travel commitment">
                    </div>
                    <div class="tp-overview-tech-text">
                        <h2><span class="tp-overview-accent">Our Commitment</span></h2>
                        <p>We pledge to provide strategically managed journeys backed by expertise, partnerships and industry credibility. Our highly trained team of travel professionals works closely with leading airlines, hotels and destination management partners worldwide to ensure every itinerary is optimised, compliant and seamless.</p>
                        <p>As IATA members and with recognised affiliations to the Uganda Tourism Board (UTB) and the Association of Uganda Tour Operators (AUTO), we uphold the highest standards in travel management.</p>
                        <p>Whether for corporate missions, NGO operations or bespoke leisure experiences, we combine precision planning, proactive support and personalised service to deliver reliable, stress-free and world-class travel solutions.</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- CTA Section -->
        <section class="tp-overview-cta-section">
            <div class="tp-overview-container">
                <div class="tp-overview-cta-content">
                    <div class="tp-overview-cta-images">
                        <img src="https://images.unsplash.com/photo-1540569876033-6e5d046a1d77?w=400&h=300&fit=crop" alt="African business woman">
                        <img src="https://images.unsplash.com/photo-1511632765486-a01980e01a18?w=400&h=300&fit=crop" alt="African business team">
                    </div>
                    <div class="tp-overview-cta-overlay">
                        <h2>Start the Journey with Us</h2>
                        <p>From Uganda to the world—Travel Portal is your trusted partner for professional, seamless, and memorable journeys.</p>
                        <button class="tp-overview-cta-btn">Get Started</button>
                    </div>
                </div>
            </div>
        </section>


<!-- Timeline Section -->
<section class="tp-overview-timeline-section">
    <div class="tp-overview-container">
        <div class="tp-overview-timeline-content">
            <div class="tp-overview-timeline-left">
                <h2 class="tp-overview-timeline-title">We Have Been In <span class="tp-timeline-highlight">Operation </span>Since 2011 </h2>
                <p class="tp-overview-timeline-description">
                    Our USP is that we genuinely care about the quality of  your travel not just in terms of precision but also as an individual experience.
                </p>
                <div class="tp-overview-timeline-images">
                    <img src="https://i.pinimg.com/736x/e8/0b/66/e80b66a12f4421cceec4b93aa6e4ddfb.jpg" alt="Business meeting" class="tp-timeline-image tp-timeline-image-1">
                    <img src="https://i.pinimg.com/736x/32/c0/10/32c010f48e377869c7f8f57dcc1be7a2.jpg" alt="Professional woman" class="tp-timeline-image tp-timeline-image-main">
                    <img src="https://i.pinimg.com/736x/85/69/69/8569696493d94b0963c36ab380ac9b9f.jpg" alt="Business travel" class="tp-timeline-image tp-timeline-image-2">
                    <img src="https://i.pinimg.com/736x/05/f9/54/05f954f40fe9a802108c4e94bf757c86.jpg" alt="Travel planning" class="tp-timeline-image tp-timeline-image-3">
                    <img src="https://i.pinimg.com/736x/14/b8/7a/14b87acdae880298f9988ea4786862d1.jpg" alt="Airport lounge" class="tp-timeline-image tp-timeline-image-4">
                </div>
            </div>
            
            <div class="tp-overview-timeline-right">
                <div class="tp-overview-timeline-track">
                    <div class="tp-timeline-item">
                        <div class="tp-timeline-dot"></div>
                        <div class="tp-timeline-content">
                            <h3 class="tp-timeline-heading">Visa Support? Expert guidance all the way.</h3>
                            <div class="tp-timeline-profile">
                                <img src="https://i.pinimg.com/736x/88/aa/fe/88aafe0e110e8a020798a19d9fac9be4.jpg" alt="Team member" class="tp-timeline-avatar">
                                <p class="tp-timeline-text">We provide end to end assistance with visa applications from advising on documentation, processes, appointment with embassies and consulates.</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tp-timeline-item">
                        <div class="tp-timeline-dot"></div>
                        <div class="tp-timeline-content">
                            <h3 class="tp-timeline-heading">Smooth Journeys? Always on track.</h3>
                            <div class="tp-timeline-profile">
                                <img src="https://i.pinimg.com/736x/bc/23/8d/bc238d311725da576e5795ec1e17fbdc.jpg" alt="Team member" class="tp-timeline-avatar">
                                <p class="tp-timeline-text">From booking to onboarding and everything in between, <span class="tp-timeline-sme">we manage the details</span> so that your team stays focused on business not travel stress.</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tp-timeline-item">
                        <div class="tp-timeline-dot"></div>
                        <div class="tp-timeline-content">
                            <h3 class="tp-timeline-heading">24/7 Support? Just a call away!</h3>
                            <div class="tp-timeline-profile">
                                <img src="https://i.pinimg.com/736x/f8/e5/01/f8e501a52d9c48aa02264f6a659b11b5.jpg" alt="Team member" class="tp-timeline-avatar">
                                <p class="tp-timeline-text">Travel doesn't stop at 5:30pm -and neither do we. Our round-the-clock support ensures help is always there, wherever you are in the world.</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tp-timeline-item">
                        <div class="tp-timeline-dot"></div>
                        <div class="tp-timeline-content">
                            <h3 class="tp-timeline-heading">Duty of care? Consider it covered.</h3>
                            <div class="tp-timeline-profile">
                                <img src="https://i.pinimg.com/1200x/ce/94/ab/ce94ab2cc52e3e54392678a20e082492.jpg" alt="Team member" class="tp-timeline-avatar">
                                <p class="tp-timeline-text">We track, monitor and support your travelers every step of the way, giving your company the peace of mind that everyone is safe and accounted for.</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tp-timeline-item">
                        <div class="tp-timeline-dot"></div>
                        <div class="tp-timeline-content">
                            <h3 class="tp-timeline-heading">Sustainability? We've got you!</h3>
                            <div class="tp-timeline-profile">
                                <img src="https://i.pinimg.com/736x/1f/9e/c8/1f9ec8fef69fbc89c997c933511b44dc.jpg" alt="Team member" class="tp-timeline-avatar">
                                <p class="tp-timeline-text">We help your business travel smarter with eco-friendly options. carbon tracking and greener choices that match your company values.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="tp-overview-timeline-cta">
            <h3 class="tp-timeline-cta-text">Ready to book your trip?</h3>
            <a href="https://lwegatech.net/beaute-sauvage-safaris/get-in-touch/" class="tp-timeline-cta-button">Get In Touch</a>
        </div>
    </div>
</section>
            </div>

    <style>
    
    /* About Section Styles */
.tp-overview-about-section { background: #f8f9fa; padding: 80px 0; }
.tp-overview-about-top { display: grid; grid-template-columns: 400px 1fr; gap: 60px; align-items: center; margin-bottom: 80px; }
.tp-about-avatar-container { position: relative; }
.tp-about-avatar { width: 350px; height: 350px; border-radius: 5%; object-fit: cover; box-shadow: 0 20px 40px rgba(0,0,0,0.1); }
.tp-about-title { font-size: 2.2rem; font-weight: 400; line-height: 1.3; margin-bottom: 24px; color: #2c3e50; }
.tp-about-highlight { color: #e74c3c; font-weight: 500; }
.tp-about-description { font-size: 1.05rem; line-height: 1.6; color: #5a6c7d; margin-bottom: 20px; }
.tp-about-badge { display: flex; align-items: center; gap: 16px; background: #2c3e50; color: white; padding: 16px 24px; border-radius: 50px; margin-top: 30px; max-width: fit-content; }
.tp-badge-icon { color: #2ecc71; }
.tp-badge-text { flex: 1; }
.tp-badge-main { display: block; font-size: 0.9rem; }
.tp-badge-sub { display: block; font-size: 0.85rem; opacity: 0.8; }
.tp-badge-logo { background: white; color: #2c3e50; padding: 8px 12px; border-radius: 6px; font-weight: bold; font-size: 0.85rem; }

.tp-overview-about-bottom { display: grid; grid-template-columns: 1fr 400px; gap: 60px; align-items: flex-start; }
.tp-about-promise-title { font-size: 1.3rem; font-weight: 500; line-height: 1.4; color: #2c3e50; margin-bottom: 32px; }
.tp-about-promises { margin-bottom: 40px; }
.tp-promise-item { display: flex; align-items: center; gap: 12px; margin-bottom: 16px; }
.tp-promise-icon { color: #e74c3c; flex-shrink: 0; }
.tp-promise-text { font-size: 1rem; color: #5a6c7d; }
.tp-about-founded { margin-top: 20px; }
.tp-founded-badge { display: flex; align-items: center; gap: 12px; background: #2c3e50; color: white; padding: 14px 24px; border-radius: 50px; max-width: fit-content; }
.tp-founded-icon { color: #2ecc71; }
.tp-founded-text { font-size: 0.95rem; }

.tp-about-tech-visual { position: relative; height: 400px; }
.tp-tech-circle { position: relative; width: 350px; height: 350px; background: linear-gradient(135deg, #ffeaa7, #fab1a0); border-radius: 50%; display: flex; align-items: center; justify-content: center; }
.tp-tech-phone { position: relative; z-index: 3; width: 160px; height: 280px; background: #2c3e50; border-radius: 25px; padding: 12px; box-shadow: 0 10px 30px rgba(0,0,0,0.2); }
.tp-phone-screen { width: 100%; height: 100%; border-radius: 18px; object-fit: cover; }
.tp-tech-charts { position: absolute; inset: 0; }
.tp-chart { position: absolute; background: white; border-radius: 12px; box-shadow: 0 8px 20px rgba(0,0,0,0.1); padding: 12px; }
.tp-chart-1 { top: 20px; right: 20px; width: 80px; height: 60px; }
.tp-chart-2 { bottom: 20px; left: 20px; width: 100px; height: 70px; }
.tp-chart-bars { display: flex; align-items: flex-end; gap: 4px; height: 100%; }
.tp-bar { background: linear-gradient(to top, #3498db, #74b9ff); width: 8px; border-radius: 2px; }
.tp-chart-lines { width: 100%; height: 100%; }

@media (max-width: 968px) {
.tp-overview-about-top { grid-template-columns: 1fr; gap: 40px; text-align: center; }
.tp-about-avatar { width: 250px; height: 250px; }
.tp-overview-about-bottom { grid-template-columns: 1fr; gap: 40px; }
.tp-about-tech-visual { display: flex; justify-content: center; }
.tp-tech-circle { width: 300px; height: 300px; }
}

@media (max-width: 768px) {
.tp-overview-about-section { padding: 60px 0; }
.tp-about-title { font-size: 1.8rem; }
.tp-about-avatar { width: 200px; height: 200px; }
.tp-tech-circle { width: 250px; height: 250px; }
.tp-tech-phone { width: 120px; height: 210px; }
.tp-about-badge, .tp-founded-badge { flex-direction: column; text-align: center; gap: 8px; }
}
    
    
    .tp-overview-portal{line-height:1.6;color:#333}
.tp-overview-container{max-width:1200px;margin:0 auto;padding:0 20px}
.tp-overview-values-section{padding:80px 0;background:#fff}
.tp-overview-values-header{text-align:center;margin-bottom:60px}
.tp-overview-values-header h2{font-size:2.5rem;font-weight:700;margin-bottom:20px;color:#1e3a8a}
.tp-overview-values-header p{font-size:1.2rem;color:#7f8c8d}
.tp-overview-values-grid{display:grid;grid-template-columns:repeat(3,1fr);gap:40px}
.tp-overview-value-card{background:#fff;padding:40px 30px;border-radius:15px;text-align:center;box-shadow:0 10px 30px rgba(0,0,0,.1);transition:transform .3s ease;border-top:4px solid #1e3a8a}
.tp-overview-value-card:hover{transform:translateY(-10px)}
.tp-overview-value-icon{font-size:3rem;margin-bottom:20px}
.tp-overview-value-card h3{font-size:1.8rem;font-weight:700;margin-bottom:20px;color:#1e3a8a}
.tp-overview-value-card p{font-size:1rem;line-height:1.6;margin-bottom:30px;color:#7f8c8d}
.tp-overview-value-images{display:grid;grid-template-columns:1fr 1fr;gap:10px}
.tp-overview-value-images img{width:100%;height:80px;object-fit:cover;border-radius:8px}
.tp-overview-commitment-section{padding:80px 0;background:#f8f9fa}
.tp-overview-commitment-content{display:grid;grid-template-columns:2fr 1fr;gap:60px;align-items:center}
.tp-overview-commitment-text h2{font-size:2.5rem;font-weight:700;margin-bottom:30px;color:#1e3a8a}
.tp-overview-commitment-text p{font-size:1.1rem;line-height:1.7;margin-bottom:30px}
.tp-overview-commitment-list{margin-top:40px}
.tp-overview-commitment-item{display:flex;align-items:center;margin-bottom:15px}
.tp-overview-commitment-check{background:#2ecc71;color:#fff;width:25px;height:25px;border-radius:50%;display:flex;align-items:center;justify-content:center;font-size:.9rem;margin-right:15px;flex-shrink:0}
.tp-overview-person-avatar{text-align:center}
.tp-overview-person-avatar img{width:250px;height:250px;border-radius:50%;object-fit:cover;box-shadow:0 15px 40px rgba(0,0,0,.1)}
.tp-overview-tech-section{padding:80px 0;background:#fff}
.tp-overview-tech-content{display:grid;grid-template-columns:1fr 1fr;gap:60px;align-items:center}
.tp-overview-tech-image img{width:100%;height:auto;border-radius:15px;box-shadow:0 15px 40px rgba(0,0,0,.1)}
.tp-overview-tech-text h2{font-size:2.5rem;font-weight:700;margin-bottom:30px;color:#1e3a8a}
.tp-overview-tech-text p{font-size:1.1rem;line-height:1.7;margin-bottom:20px}
.tp-overview-cta-section{padding:0;position:relative;height:600px;overflow:hidden}
.tp-overview-cta-content{position:relative;height:100%;display:flex;align-items:center;justify-content:center}
.tp-overview-cta-images{position:absolute;top:0;left:0;width:100%;height:100%;display:grid;grid-template-columns:1fr 1fr}
.tp-overview-cta-images img{width:100%;height:100%;object-fit:cover}
.tp-overview-cta-overlay{position:relative;z-index:2;background:rgba(30,58,138,.9);color:#fff;padding:60px;border-radius:15px;text-align:center;max-width:600px;margin:0 20px}
.tp-overview-cta-overlay h2{font-size:2.5rem;font-weight:700;margin-bottom:20px}
.tp-overview-cta-overlay p{font-size:1.1rem;line-height:1.7;margin-bottom:20px}
.tp-overview-cta-btn{background:#2ecc71;color:#fff;padding:15px 40px;border:none;border-radius:25px;font-size:1.1rem;font-weight:600;cursor:pointer;transition:all .3s ease;margin-top:20px}
.tp-overview-cta-btn:hover{background:#27ae60;transform:translateY(-2px)}

    /* Timeline Section Styles */
.tp-overview-timeline-section { background: #1a2951; padding: 80px 0; color: white; }
.tp-overview-timeline-content { display: grid; grid-template-columns: 1fr 1fr; gap: 60px; align-items: center; margin-bottom: 60px; }
.tp-overview-timeline-left { padding-right: 40px; }
.tp-overview-timeline-title { font-size: 2.5rem; font-weight: 300; line-height: 1.2; margin-bottom: 24px; }
.tp-timeline-highlight { color: #e74c3c; }
.tp-overview-timeline-description { font-size: 1.1rem; line-height: 1.6; color: #b8c7d9; margin-bottom: 40px; }
.tp-overview-timeline-images { position: relative; height: 400px; }
.tp-timeline-image { position: absolute; border-radius: 20px; object-fit: cover; }
.tp-timeline-image-main { width: 280px; height: 350px; left: 50%; top: 50%; transform: translate(-50%, -50%); z-index: 2; }
.tp-timeline-image-1 { width: 120px; height: 120px; top: 20px; left: 20px; z-index: 3; }
.tp-timeline-image-2 { width: 100px; height: 100px; bottom: 80px; left: 10px; z-index: 1; }
.tp-timeline-image-3 { width: 100px; height: 100px; top: 40px; right: 30px; z-index: 1; }
.tp-timeline-image-4 { width: 120px; height: 120px; bottom: 20px; right: 20px; z-index: 3; }
.tp-overview-timeline-track { position: relative; padding-left: 40px; }
.tp-overview-timeline-track::before { content: ''; position: absolute; left: 15px; top: 0; bottom: 0; width: 2px; background: #34495e; }
.tp-timeline-item { position: relative; margin-bottom: 40px; }
.tp-timeline-item:last-child { margin-bottom: 0; }
.tp-timeline-dot { position: absolute; left: -32px; top: 8px; width: 16px; height: 16px; background: #34495e; border-radius: 50%; border: 3px solid #1a2951; z-index: 1; }
.tp-timeline-content { padding-left: 0; }
.tp-timeline-heading { font-size: 1.3rem; font-weight: 600; margin-bottom: 16px; color: white; }
.tp-timeline-profile { display: flex; align-items: flex-start; gap: 16px; }
.tp-timeline-avatar { width: 60px; height: 60px; border-radius: 50%; object-fit: cover; flex-shrink: 0; }
.tp-timeline-text { font-size: 0.95rem; line-height: 1.5; color: #b8c7d9; margin: 0; flex: 1; }
.tp-timeline-sme { color: #e74c3c; font-weight: 500; }
.tp-overview-timeline-cta { text-align: center; padding-top: 40px; border-top: 1px solid #34495e; }
.tp-timeline-cta-text { font-size: 1.5rem; font-weight: 500; margin-bottom: 24px; color: white; }
.tp-timeline-cta-button { background: linear-gradient(135deg, #2ecc71, #27ae60); color: white; padding: 16px 32px; border: none; border-radius: 8px; font-size: 1.1rem; font-weight: 600; cursor: pointer; transition: all 0.3s ease; }
.tp-timeline-cta-button:hover { transform: translateY(-2px); box-shadow: 0 8px 25px rgba(46, 204, 113, 0.3); }

@media (max-width: 768px) {
.tp-overview-timeline-content { grid-template-columns: 1fr; gap: 40px; }
.tp-overview-timeline-left { padding-right: 0; text-align: center; }
.tp-overview-timeline-title { font-size: 2rem; }
.tp-overview-timeline-images { height: 300px; }
.tp-timeline-image-main { width: 220px; height: 280px; }
.tp-timeline-image-1, .tp-timeline-image-2, .tp-timeline-image-3, .tp-timeline-image-4 { width: 80px; height: 80px; }
.tp-overview-timeline-track { padding-left: 30px; }
.tp-timeline-dot { left: -27px; }
.tp-timeline-profile { flex-direction: column; text-align: center; }
.tp-timeline-avatar { align-self: center; }
}


@media (max-width:768px){.tp-overview-group-content{grid-template-columns:1fr}.tp-overview-group-title{font-size:2rem}.tp-overview-values-grid{grid-template-columns:1fr}.tp-overview-commitment-content{grid-template-columns:1fr}.tp-overview-tech-content{grid-template-columns:1fr}.tp-overview-form-row{grid-template-columns:1fr}.tp-overview-cta-images{grid-template-columns:1fr}.tp-overview-cta-overlay{margin:0 10px;padding:40px 30px}.tp-overview-cta-overlay h2{font-size:2rem}}
    </style>
    
    <?php
    return ob_get_clean();
}

add_shortcode('travel_portal_overview', 'travel_portal_overview_shortcode');
?>