<?php
// Travel Portal Homepage Shortcode
function travel_portal_homepage_shortcode($atts) {
    $atts = shortcode_atts(array(
        'show_destinations' => 'true',
        'show_packages' => 'true'
    ), $atts);
    
    ob_start();
    ?>

    <div class="tp-homepage">
    
<!-- Hero Section -->
<section class="tp-hero-section">
    <div class="tp-container">
        <div class="tp-hero-content">
            <div class="tp-hero-text">
                <h1 class="tp-hero-title">
                    We take <span class="tp-highlight">care of your travel preparations,</span><br>
                    so you can focus <span class="tp-highlight">on your goals.</span>
                </h1>
                <p class="tp-hero-description">
                    Travel Portal provides comprehensive, seamless travel solutions for business and leisure. Our services include air ticketing, hotel bookings, airport transfers, and long-stay accommodations. We offer strategic planning and custom itineraries for corporate clients, along with 24/7 support and emergency assistance. By choosing 
                    <span class="tp-brand-highlight">Travel Portal</span>, for your travel management, you're assured of our expert team ensuring every trip is efficient, safe, and stress-free, handling all details with precision.
                </p>
            </div>
            <div class="tp-hero-visual">
                <div class="tp-mobile-phones">
                    <div class="tp-mobile-container tp-mobile-left">
                        <div class="tp-mobile-phone">
                            <div class="tp-mobile-screen">
                                <div class="tp-mobile-header">
                                    <div class="tp-status-bar">
                                        <span class="tp-time">9:41</span>
                                        <div class="tp-indicators">
                                            <span class="tp-signal"></span>
                                            <span class="tp-wifi"></span>
                                            <span class="tp-battery"></span>
                                        </div>
                                    </div>
                                    <div class="tp-app-header">
                                        <h4>Travel Portal</h4>
                                    </div>
                                </div>
                                <div class="tp-mobile-content">
                                    <div class="tp-booking-card">
                                        <div class="tp-destination">
                                            <span class="tp-from">NYC</span>
                                            <span class="tp-arrow">→</span>
                                            <span class="tp-to">LON</span>
                                        </div>
                                        <div class="tp-date">Dec 15, 2024</div>
                                        <div class="tp-price">$1,240</div>
                                    </div>
                                    <div class="tp-booking-options">
                                        <div class="tp-option">✈️ Flight</div>
                                        <div class="tp-option">🏨 Hotel</div>
                                        <div class="tp-option">🚗 Car</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="tp-mobile-container tp-mobile-right">
                        <div class="tp-mobile-phone">
                            <div class="tp-mobile-screen">
                                <div class="tp-mobile-header">
                                    <div class="tp-status-bar">
                                        <span class="tp-time">9:41</span>
                                        <div class="tp-indicators">
                                            <span class="tp-signal"></span>
                                            <span class="tp-wifi"></span>
                                            <span class="tp-battery"></span>
                                        </div>
                                    </div>
                                    <div class="tp-app-header">
                                        <h4>Travel Portal</h4>
                                    </div>
                                </div>
                                <div class="tp-mobile-content">
                                    <div class="tp-booking-progress">
                                        <div class="tp-step tp-step-active">1. Select</div>
                                        <div class="tp-step tp-step-active">2. Book</div>
                                        <div class="tp-step">3. Confirm</div>
                                    </div>
                                    <div class="tp-confirmation">
                                        <div class="tp-check">✓</div>
                                        <div class="tp-message">Booking Confirmed!</div>
                                        <div class="tp-details">Flight AA123 to London</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Services Section -->
<section class="tp-services-section">
    <div class="tp-container">
        <div class="tp-services-grid">
            <div class="tp-service-card">
                <div class="tp-service-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path>
                        <polyline points="7.5,4.21 12,6.81 16.5,4.21"></polyline>
                        <polyline points="7.5,19.79 7.5,14.6 3,12"></polyline>
                        <polyline points="21,12 16.5,14.6 16.5,19.79"></polyline>
                    </svg>
                </div>
                <h3>We look after the travellers</h3>
                <p>You may be out on the road every week or simply need to move around every now and then. Whatever the case, we'll book and manage your transport and accommodation – all you have to do is enjoy the ride.</p>
                <a href="#" class="tp-service-cta">Experience stress-free travel</a>
            </div>
            
            <div class="tp-service-card">
                <div class="tp-service-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <path d="M16 21v-2a4 4 0 0 0-4-4H6a4 4 0 0 0-4 4v2"></path>
                        <circle cx="9" cy="7" r="4"></circle>
                        <path d="m19 8 2 2-2 2"></path>
                        <path d="m17 12h4"></path>
                    </svg>
                </div>
                <h3>We partner the travel booker</h3>
                <p>Getting the best travel deals can be very hard work and requires a lot of time and focus. By choosing <span class="tp-brand-highlight">Travel Portal Management</span> as your business travel partner, we'll help you to reduce your travel costs and get more for your money.</p>
                <a href="#" class="tp-service-cta">Let's make your life easier</a>
            </div>
            
            <div class="tp-service-card">
                <div class="tp-service-icon">
                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                        <polyline points="22,12 18,12 15,21 9,3 6,12 2,12"></polyline>
                    </svg>
                </div>
                <h3>We delight the finance teams</h3>
                <p>Whether you're a department manager, administrator or personal assistant, we're ready to take a huge weight off your shoulders by planning and overseeing the entirety of your corporate travel requirements.</p>
                <a href="#" class="tp-service-cta">Reduce your travel costs</a>
            </div>
        </div>
    </div>
</section>

<!-- Travel Tips Section -->
<section class="tp-testimonial-section">
    <div class="tp-container">
        <h2 class="tp-testimonial-title">Travel Tips</h2>
        
        <?php
        $travel_tips = get_post_meta(get_the_ID(), '_travel_tips', true);
        
        if (!empty($travel_tips) && is_array($travel_tips)) {
            foreach ($travel_tips as $index => $tip) {
                if (!empty(trim($tip))) {
                    ?>
                    <div class="tp-testimonial-content" style="display:<?php echo $index === 0 ? 'flex' : 'none'; ?>;">
                        <div class="tp-testimonial-quote">
                            <div class="tp-quote-marks">"</div>
                            <blockquote><?php echo wp_kses_post($tip); ?></blockquote>
                        </div>
                    </div>
                    <?php
                }
            }
        } else {
            ?>
            <div class="tp-testimonial-content">
                <div class="tp-testimonial-quote">
                    <div class="tp-quote-marks">"</div>
                    <blockquote>Add your travel tips in the page editor to display them here.</blockquote>
                </div>
            </div>
            <?php
        }
        ?>
        
        <?php if (!empty($travel_tips) && count(array_filter($travel_tips)) > 1) : ?>
        <div class="tp-testimonial-indicators">
            <?php foreach (array_filter($travel_tips) as $index => $tip) : ?>
                <span class="tp-indicator <?php echo $index === 0 ? 'active' : ''; ?>"></span>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
    </div>
</section>

<!-- Travel Solutions Gallery -->
<section class="tp-solutions-gallery">
    <div class="tp-gallery-grid">
        <div class="tp-gallery-item">
            <img src="https://i.pinimg.com/736x/e4/13/6c/e4136c6857a9914b81a7298a766e9844.jpg" alt="Airport Services" class="tp-gallery-image">
            <div class="tp-gallery-overlay">
                <h4>Airport Services</h4>
                <p>Premium lounges & fast-track</p>
            </div>
        </div>
        <div class="tp-gallery-item">
            <img src="https://i.pinimg.com/736x/f3/28/ac/f328acadb73c977e6de7291abeed1b73.jpg" alt="Meeting Venues" class="tp-gallery-image">
            <div class="tp-gallery-overlay">
                <h4>Meeting Venues</h4>
                <p>Conference & event spaces</p>
            </div>
        </div>
        <div class="tp-gallery-item">
            <img src="https://i.pinimg.com/736x/ac/1b/32/ac1b32f72296d862fd20406d90a22a87.jpg" alt="Premium Hotels" class="tp-gallery-image">
            <div class="tp-gallery-overlay">
                <h4>Premium Hotels</h4>
                <p>Corporate accommodation</p>
            </div>
        </div>
        <div class="tp-gallery-item">
            <img src="https://images.unsplash.com/photo-1544620347-c4fd4a3d5957?w=400&auto=format&fit=crop&q=60" alt="Ground Transport" class="tp-gallery-image">
            <div class="tp-gallery-overlay">
                <h4>Ground Transport</h4>
                <p>Cars, transfers & chauffeurs</p>
            </div>
        </div>
    </div>
</section>

<?php if ($atts['show_packages'] === 'true'): ?>
<!-- Exclusive Packages Section -->
<section class="tp-packages-section">
    <div class="tp-container">
        <div class="tp-section-header">
            <h2 class="tp-section-title">Our Exclusive Packages</h2>
            <p class="tp-section-subtitle">Discover extraordinary destinations with our carefully curated travel experiences</p>
        </div>
        
        <?php echo do_shortcode('[romantic_packages id="460" limit="4"]'); ?>
        
        <div class="tp-packages-cta">
            <p>Looking for custom solutions? We specialize in tailored travel packages.</p>
            <a href="https://lwegatech.net/beaute-sauvage-safaris/packages" class="tp-primary-button">View All Packages</a>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Dynamic FAQ Section -->
<?php echo tp_display_homepage_accordion(); ?>

<!-- CTA Section -->
<div class="destination-cta-section" style="background-image:url('https://images.unsplash.com/photo-1469854523086-cc02fe5d8800?w=1920');">
    <div class="destination-cta-overlay"></div>
    <div class="destination-cta-content">
        <div class="destination-cta-icon">
            <i class="fas fa-compass"></i>
        </div>
        <h2 class="destination-cta-title">Ready for Your Next Adventure?</h2>
        <p class="destination-cta-subtitle">Explore our handcrafted packages designed for unforgettable experiences</p>
        <div class="destination-cta-buttons">
            <a href="https://lwegatech.net/beaute-sauvage-safaris/packages/" class="destination-cta-btn destination-cta-primary">
                <i class="fas fa-suitcase-rolling"></i>
                <span>Explore Travel Packages</span>
            </a>
            <a href="https://lwegatech.net/beaute-sauvage-safaris/honeymoon-getaways/" class="destination-cta-btn destination-cta-secondary">
                <i class="fas fa-heart"></i>
                <span>Honeymoon Getaways</span>
            </a>
        </div>
    </div>
</div>

    <style>
    :root{--tp-primary:#1e3a8a;--tp-primary-light:#2d4da8;--tp-secondary:#f3f4f6;--tp-accent:#f59e0b;--tp-text:#1f2937;--tp-text-light:#6b7280;--tp-white:#ffffff}
    .tp-homepage{color:var(--tp-text);line-height:1.6}
    .tp-container{max-width:1200px;margin:0 auto;padding:0 20px}
    .tp-hero-section{background:linear-gradient(135deg,var(--tp-white) 0%,#f8fafc 100%);padding:10px 0;overflow:hidden}
    .tp-hero-content{display:flex;align-items:center;justify-content:space-between;gap:60px}
    .tp-hero-text{flex:1;max-width:600px}
    .tp-hero-title{font-size:2.5rem;font-weight:300;line-height:1.2;margin-bottom:30px;color:var(--tp-text)}
    .tp-highlight{color:var(--tp-accent);font-weight:400}
    .tp-hero-description{font-size:1.1rem;line-height:1.7;color:var(--tp-text-light);margin-bottom:0}
    .tp-brand-highlight{color:var(--tp-accent);font-weight:500}
    .tp-hero-visual{position:relative;flex:0 0 400px;height:400px}
    .tp-mobile-phones{position:relative;width:400px;height:400px}
    .tp-mobile-container{position:absolute}
    .tp-mobile-left{top:40px;left:0;transform:rotate(-15deg);z-index:1}
    .tp-mobile-right{top:20px;right:0;transform:rotate(10deg);z-index:2}
    .tp-mobile-phone{width:180px;height:320px;background:#1f2937;border-radius:25px;padding:8px;box-shadow:0 10px 30px rgba(0,0,0,0.3)}
    .tp-mobile-screen{width:100%;height:100%;background:var(--tp-white);border-radius:18px;overflow:hidden;display:flex;flex-direction:column}
    .tp-mobile-header{background:var(--tp-primary);color:var(--tp-white);padding:8px 0}
    .tp-status-bar{display:flex;justify-content:space-between;align-items:center;padding:0 15px;font-size:0.7rem;margin-bottom:8px}
    .tp-time{font-weight:600}
    .tp-indicators{display:flex;gap:4px}
    .tp-signal,.tp-wifi,.tp-battery{width:12px;height:8px;background:var(--tp-white);border-radius:2px}
    .tp-app-header{text-align:center;padding:0 15px}
    .tp-app-header h4{margin:0;font-size:0.9rem;font-weight:600}
    .tp-mobile-content{flex:1;padding:20px 15px;display:flex;flex-direction:column;justify-content:center}
    .tp-booking-card{background:#f8fafc;border-radius:12px;padding:20px;margin-bottom:15px;text-align:center}
    .tp-destination{font-size:1.2rem;font-weight:700;color:var(--tp-primary);margin-bottom:8px}
    .tp-from,.tp-to{color:var(--tp-primary)}
    .tp-arrow{margin:0 8px;color:var(--tp-accent)}
    .tp-date{font-size:0.8rem;color:var(--tp-text-light);margin-bottom:8px}
    .tp-price{font-size:1.1rem;font-weight:600;color:var(--tp-accent)}
    .tp-booking-options{display:flex;justify-content:space-between}
    .tp-option{background:var(--tp-primary);color:var(--tp-white);padding:8px 12px;border-radius:8px;font-size:0.7rem;text-align:center;flex:1;margin:0 2px}
    .tp-booking-progress{display:flex;justify-content:space-between;margin-bottom:20px}
    .tp-step{font-size:0.7rem;color:var(--tp-text-light)}
    .tp-step-active{color:var(--tp-primary);font-weight:600}
    .tp-confirmation{text-align:center;background:#f0fdf4;border-radius:12px;padding:20px}
    .tp-check{font-size:2rem;color:#10b981;margin-bottom:8px}
    .tp-message{font-size:0.9rem;font-weight:600;color:var(--tp-primary);margin-bottom:5px}
    .tp-details{font-size:0.7rem;color:var(--tp-text-light)}
    .tp-services-section{background-color:var(--tp-primary);padding:40px 0;color:var(--tp-white)}
    .tp-services-grid{display:grid;grid-template-columns:repeat(3,1fr);gap:30px}
    .tp-service-card{background:rgba(255,255,255,0.05);padding:30px 25px;border-radius:12px;text-align:left;backdrop-filter:blur(10px);border:1px solid rgba(255,255,255,0.1);display:flex;flex-direction:column;height:100%}
    .tp-service-icon{width:60px;height:60px;margin-bottom:20px;color:#ff8e8e}
    .tp-service-icon svg{width:100%;height:100%}
    .tp-service-card h3{font-size:1.4rem;font-weight:600;margin-bottom:15px;color:var(--tp-white);line-height:1.3}
    .tp-service-card p{font-size:1rem;line-height:1.6;color:rgba(255,255,255,0.8);margin-bottom:20px;flex-grow:1}
    .tp-service-cta{display:inline-block;background:#25D366;color:var(--tp-white);padding:12px 20px;border-radius:5px;text-decoration:none;font-weight:500;font-size:0.9rem;transition:all 0.3s ease;align-self:flex-start;margin-top:auto}
    .tp-service-cta:hover{background:#00c19a;transform:translateY(-2px)}
    .tp-testimonial-section{padding:20px 0;background-color:var(--tp-secondary)}
    .tp-testimonial-title{font-size:2.5rem;color:var(--tp-primary);text-align:center;margin-bottom:40px;font-weight:700}
    .tp-testimonial-content{display:flex;align-items:center;gap:60px;justify-content:center}
    .tp-testimonial-quote{flex:2;max-width:800px;text-align:center}
    .tp-quote-marks{font-size:5rem;color:var(--tp-primary);line-height:1;margin-bottom:20px}
    .tp-testimonial-quote blockquote{font-size:1.5rem;font-weight:500;margin-bottom:24px;line-height:1.4}
    .tp-testimonial-indicators{display:flex;justify-content:center;gap:12px;margin-top:40px}
    .tp-indicator{width:12px;height:12px;border-radius:50%;background-color:#d1d5db;cursor:pointer}
    .tp-indicator.active{background-color:var(--tp-primary)}
    .tp-solutions-gallery{margin:0;padding:0}
    .tp-gallery-grid{display:grid;grid-template-columns:repeat(4,1fr);gap:0}
    .tp-gallery-item{position:relative;overflow:hidden;aspect-ratio:1/1}
    .tp-gallery-image{width:100%;height:100%;object-fit:cover;transition:transform 0.5s;border-radius:0}
    .tp-gallery-item:hover .tp-gallery-image{transform:scale(1.1)}
    .tp-gallery-overlay{position:absolute;bottom:0;left:0;right:0;background:linear-gradient(to top,rgba(30,58,138,0.9) 0%,transparent 100%);color:white;padding:30px 20px 20px;transform:translateY(100%);transition:transform 0.3s}
    .tp-gallery-item:hover .tp-gallery-overlay{transform:translateY(0)}
    .tp-gallery-overlay h4{margin-bottom:8px;font-size:1.2rem}
    .tp-section-header{text-align:center;margin-bottom:60px}
    .tp-section-title{font-size:3rem;font-weight:700;color:var(--tp-primary);margin-bottom:20px;text-align:center}
    .tp-section-subtitle{font-size:1.3rem;color:var(--tp-text-light);max-width:600px;margin:0 auto;text-align:center}
    .tp-primary-button{display:inline-block;background:var(--tp-primary);color:white;padding:15px 30px;border-radius:6px;text-decoration:none;font-weight:600;font-size:1.1rem;transition:all 0.3s ease}
    .tp-primary-button:hover{background:var(--tp-primary-light);transform:translateY(-2px);box-shadow:0 8px 25px rgba(37,99,235,0.3)}
    .tp-packages-section{padding:40px 0;background:linear-gradient(135deg,#f8fafc 0%,#e2e8f0 100%)}
    .tp-packages-cta{text-align:center;margin-top:60px}
    .tp-packages-cta p{margin-bottom:25px;font-size:1.3rem;color:var(--tp-text-light)}
    .destination-cta-section{position:relative;min-height:400px;display:flex;align-items:center;justify-content:center;background-size:cover;background-position:center;border-radius:25px 0 25px;background-attachment:fixed;overflow:hidden;margin:60px 0 0}
    .destination-cta-overlay{position:absolute;top:0;left:0;width:100%;height:100%;background:linear-gradient(135deg,rgba(0,0,0,0.75) 0%,rgba(0,51,102,0.8) 100%);z-index:1}
    .destination-cta-content{position:relative;z-index:2;text-align:center;padding:60px 20px;max-width:800px;animation:fadeInUp 1s ease}
    .destination-cta-icon{font-size:3.5rem;color:#fff;margin-bottom:20px;animation:pulse 2s infinite}
    .destination-cta-icon i{filter:drop-shadow(0 4px 8px rgba(0,0,0,0.3))}
    .destination-cta-title{font-size:2.5rem;color:#fff;margin:0 0 15px;font-weight:700;text-shadow:2px 2px 8px rgba(0,0,0,0.5);letter-spacing:-0.5px}
    .destination-cta-subtitle{font-size:1.2rem;color:#e0e0e0;margin:0 0 40px;font-weight:300;text-shadow:1px 1px 4px rgba(0,0,0,0.5)}
    .destination-cta-buttons{display:flex;gap:20px;border-radius:10px;justify-content:center;flex-wrap:wrap}
    .destination-cta-btn{display:inline-flex;align-items:center;gap:12px;padding:16px 32px;font-size:1rem;font-weight:600;text-decoration:none;border-radius:50px;transition:all 0.4s ease;box-shadow:0 8px 25px rgba(0,0,0,0.3);position:relative;overflow:hidden}
    .destination-cta-btn::before{content:'';position:absolute;top:50%;left:50%;width:0;height:0;border-radius:10px;background:rgba(255,255,255,0.2);transform:translate(-50%,-50%);transition:width 0.6s,height 0.6s}
    .destination-cta-btn:hover::before{width:400px;height:400px}
    .destination-cta-btn i{font-size:1.2rem;transition:transform 0.3s ease}
    .destination-cta-btn:hover i{transform:scale(1.2) rotate(5deg)}
    .destination-cta-primary{background:linear-gradient(135deg,#ff6b35 0%,#f7931e 100%);color:#fff;border:2px solid transparent}
    .destination-cta-primary:hover{transform:translateY(-3px);box-shadow:0 12px 35px rgba(255,107,53,0.5)}
    .destination-cta-secondary{background:transparent;color:#fff;border:2px solid #fff;backdrop-filter:blur(5px)}
    .destination-cta-secondary:hover{background:rgba(255,255,255,0.15);transform:translateY(-3px);box-shadow:0 12px 35px rgba(255,255,255,0.3)}
    /* ===== FIXED FAQ ACCORDION SECTION ===== */
    .faq-section { 
        padding: 80px 20px; 
        background: #f8f9fa; 
        clear: both;
    }
    
    .faq-header { 
        text-align: center; 
        margin-bottom: 60px; 
    }
    
    .faq-title { 
        font-size: 2.5rem; 
        color: #ff6b35; 
        margin-bottom: 40px; 
        font-weight: 700;
    }
    
    .faq-intro { 
        display: grid; 
        grid-template-columns: 1fr 2fr; 
        gap: 60px; 
        align-items: center; 
        margin-bottom: 60px; 
    }
    
    .faq-visual { 
        display: flex; 
        justify-content: center; 
        align-items: center; 
        position: relative; 
    }
    
    .faq-circle { 
        width: 300px; 
        height: 300px; 
        border-radius: 50%; 
        overflow: hidden; 
        background: #ff6b35; 
        display: flex; 
        align-items: center; 
        justify-content: center; 
        position: relative; 
    }
    
    .faq-person { 
        width: 240px; 
        height: 240px; 
        border-radius: 50%; 
        object-fit: cover; 
        border: 8px solid white; 
    }
    
    .faq-decorations { 
        position: absolute; 
        top: 0; 
        left: 0; 
        width: 100%; 
        height: 100%; 
        pointer-events: none; 
    }
    
    .faq-float { 
        position: absolute; 
        background: #2d1b69; 
        border-radius: 50%; 
        opacity: 0.8; 
    }
    
    .faq-float:nth-child(1) { 
        width: 40px; 
        height: 40px; 
        top: 20px; 
        right: -10px; 
    }
    
    .faq-float:nth-child(2) { 
        width: 30px; 
        height: 30px; 
        bottom: 40px; 
        left: -15px; 
    }
    
    .faq-container { 
        display: flex; 
        justify-content: center; 
        align-items: center; 
    }
    
    .faq-text { 
        background: rgba(255, 235, 205, 0.7); 
        padding: 40px 30px; 
        border-radius: 10px; 
        width: 100%; 
        max-width: 600px; 
        position: relative; 
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1); 
    }
    
    .faq-text::before { 
        content: """; 
        position: absolute; 
        top: 15px; 
        left: 15px; 
        font-size: 60px; 
        color: rgba(139, 69, 19, 0.2); 
        font-family: Georgia, serif; 
    }
    
    .faq-text p { 
        font-size: 1.1rem; 
        line-height: 1.8; 
        color: #333; 
        margin: 0 0 15px 0; 
        font-style: italic; 
        text-align: center; 
    }
    
    .quote-author { 
        text-align: right; 
        font-weight: 600; 
        color: #8B4513; 
        font-style: normal; 
    }
    
    /* ACCORDION STYLES */
    .faq-accordion { 
        max-width: 800px; 
        margin: 0 auto; 
    }
    
    .faq-item { 
        background: white; 
        margin-bottom: 15px; 
        border-radius: 8px; 
        overflow: hidden; 
        box-shadow: 0 2px 10px rgba(0,0,0,0.1); 
        transition: all 0.3s ease;
    }
    
    .faq-question { 
        width: 100%; 
        background: #2d1b69; 
        color: white; 
        border: none; 
        padding: 20px 25px; 
        text-align: left; 
        font-size: 1.1rem; 
        font-weight: 600; 
        cursor: pointer; 
        display: flex; 
        justify-content: space-between; 
        align-items: center; 
        transition: background 0.3s ease;
        position: relative;
    }
    
    .faq-question:hover { 
        background: #3d2b79; 
    }
    
    .faq-question-text {
        flex: 1;
        padding-right: 20px;
    }
    
    .faq-icon { 
        font-size: 1rem;
        transition: transform 0.3s ease;
        display: inline-block;
        line-height: 1;
    }
    
    .faq-item.active .faq-icon { 
        transform: rotate(180deg); 
    }
    
    .faq-answer { 
        max-height: 0;
        overflow: hidden; 
        transition: max-height 0.4s ease, padding 0.4s ease;
        background: white; 
    }
    
    .faq-item.active .faq-answer { 
        max-height: 500px;
        padding: 25px;
    }
    
    .faq-answer-content {
        color: #666; 
        line-height: 1.8;
        font-size: 1rem;
    }
    
    .faq-answer-content p { 
        margin: 0 0 15px 0; 
    }
    
    .faq-answer-content p:last-child {
        margin-bottom: 0;
    }
    
    /* Responsive Styles for FAQ */
    @media (max-width: 992px) {
        .faq-intro {
            grid-template-columns: 1fr;
            gap: 40px;
        }
        
        .faq-visual {
            display: none;
        }
    }
    
    @media (max-width: 768px) { 
        .faq-section {
            padding: 60px 15px;
        }
        
        .faq-title {
            font-size: 2rem;
        }
        
        .faq-text { 
            width: 100%; 
            padding: 30px 25px; 
        }
        
        .faq-text p { 
            font-size: 1rem; 
        }
        
        .faq-text::before { 
            font-size: 50px; 
        }
        
        .faq-question {
            font-size: 1rem;
            padding: 18px 20px;
        }
        
        .faq-item.active .faq-answer {
            padding: 20px;
        }
    }
    
    @media (max-width: 480px) { 
        .faq-text { 
            display: none; 
        }
        
        .faq-question {
            font-size: 0.95rem;
            padding: 15px 18px;
        }
    }
    @media (max-width:1024px){.tp-hero-content{flex-direction:column;gap:40px;text-align:center}.tp-hero-visual{flex:none}.tp-services-grid{grid-template-columns:1fr}.tp-hero-title{font-size:2.5rem}.faq-intro{grid-template-columns:1fr;gap:40px}.faq-visual{display:none}}
    @media (max-width:992px){.tp-services-grid{grid-template-columns:repeat(2,1fr);gap:25px}.tp-testimonial-content{flex-direction:column}.tp-gallery-grid{grid-template-columns:repeat(2,1fr)}}
    @media (max-width:768px){.tp-services-grid,.tp-gallery-grid{grid-template-columns:1fr}.tp-hero-title{font-size:2.2rem}.tp-section-title{font-size:2.2rem}.tp-section-subtitle{font-size:1.1rem}.faq-section{padding:60px 15px}.faq-title{font-size:2rem}.faq-text{width:100%;padding:30px 25px}.faq-text p{font-size:1rem}.faq-text::before{font-size:50px}.faq-question{font-size:1rem;padding:18px 20px}.faq-item.active .faq-answer{padding:20px}}
    @media (max-width:480px){.faq-text{display:none}.faq-question{font-size:0.95rem;padding:15px 18px}}
    @keyframes fadeInUp{from{opacity:0;transform:translateY(30px)}to{opacity:1;transform:translateY(0)}}
    @keyframes pulse{0%,100%{transform:scale(1)}50%{transform:scale(1.1)}}
    </style>

    <script>
    jQuery(document).ready(function($) {
        // Testimonial carousel
        var testimonialIndex = 0;
        var testimonials = $('.tp-testimonial-content');
        var indicators = $('.tp-indicator');
        
        if (testimonials.length > 0) {
            function showTestimonial(index) {
                testimonials.hide();
                $(testimonials[index]).fadeIn(500);
                indicators.removeClass('active');
                $(indicators[index]).addClass('active');
            }
            
            showTestimonial(testimonialIndex);
            
            indicators.click(function() {
                testimonialIndex = $(this).index();
                showTestimonial(testimonialIndex);
            });
            
            if (testimonials.length > 1) {
                setInterval(function() {
                    testimonialIndex = (testimonialIndex + 1) % testimonials.length;
                    showTestimonial(testimonialIndex);
                }, 5000);
            }
        }
        
        // FAQ Accordion
        $('.faq-question').on('click', function(e) {
            e.preventDefault();
            var $faqItem = $(this).closest('.faq-item');
            var isActive = $faqItem.hasClass('active');
            $('.faq-item').removeClass('active');
            if (!isActive) {
                $faqItem.addClass('active');
            }
        });
        
        $('.faq-item').first().addClass('active');
        
        // Scroll animations
        function animateOnScroll() {
            $('.tp-section-title, .tp-section-subtitle, .tp-service-card, .tp-package-card').each(function() {
                var position = $(this).offset().top;
                var scroll = $(window).scrollTop();
                var windowHeight = $(window).height();
                if (scroll + windowHeight > position + 100) {
                    $(this).css({'opacity':'1','transform':'translateY(0)'});
                }
            });
        }
        
        $('.tp-section-title, .tp-section-subtitle, .tp-service-card, .tp-package-card').css({'opacity':'0','transform':'translateY(30px)','transition':'all 0.5s ease'});
        animateOnScroll();
        $(window).scroll(animateOnScroll);
        
        // Parallax effect
        $(window).on('scroll', function() {
            var scrolled = $(window).scrollTop();
            $('.destination-cta-section').css('background-position', 'center ' + (scrolled * 0.5) + 'px');
        });
    });
    </script>

    <?php
    return ob_get_clean();
}
add_shortcode('travel_portal_homepage', 'travel_portal_homepage_shortcode');

/**
 * HOMEPAGE ACCORDION METABOX
 */
function tp_homepage_accordion_metabox() {
    add_meta_box('tp_home_accordion','Homepage Accordion Items','tp_homepage_accordion_html','page','advanced','high');
}
add_action('add_meta_boxes', 'tp_homepage_accordion_metabox');

function tp_homepage_accordion_html($post) {
    wp_nonce_field('tp_accordion_nonce', 'tp_accordion_nonce_field');
    $accordions = get_post_meta($post->ID, '_tp_homepage_accordions', true);
    $accordions = is_array($accordions) ? $accordions : array();
    ?>
    <div id="tp-accordion-repeater">
        <?php if (!empty($accordions)) : ?>
            <?php foreach ($accordions as $index => $accordion) : ?>
                <div class="tp-accordion-item">
                    <p><label><strong>Question:</strong></label>
                    <input type="text" name="tp_accordion_question[]" value="<?php echo esc_attr($accordion['question']); ?>" style="width:100%;" placeholder="Enter the question here" /></p>
                    <p><label><strong>Answer:</strong></label>
                    <textarea name="tp_accordion_answer[]" style="width:100%; height:100px;" placeholder="Enter the answer here"><?php echo esc_textarea($accordion['answer']); ?></textarea></p>
                    <button type="button" class="tp-remove-accordion button">Remove Item</button><hr>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
    <button type="button" id="tp-add-accordion" class="button">Add New Accordion Item</button>
    <script>
    jQuery(document).ready(function($) {
        $('#tp-add-accordion').on('click', function() {
            var newItem = '<div class="tp-accordion-item"><p><label><strong>Question:</strong></label><input type="text" name="tp_accordion_question[]" style="width:100%;" placeholder="Enter the question here" /></p><p><label><strong>Answer:</strong></label><textarea name="tp_accordion_answer[]" style="width:100%; height:100px;" placeholder="Enter the answer here"></textarea></p><button type="button" class="tp-remove-accordion button">Remove Item</button><hr></div>';
            $('#tp-accordion-repeater').append(newItem);
        });
        $(document).on('click', '.tp-remove-accordion', function() {
            $(this).closest('.tp-accordion-item').remove();
        });
    });
    </script>
    <?php
}

function tp_save_homepage_accordion_meta($post_id) {
    if (!isset($_POST['tp_accordion_nonce_field']) || !wp_verify_nonce($_POST['tp_accordion_nonce_field'], 'tp_accordion_nonce')) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_page', $post_id)) return;
    
    if (isset($_POST['tp_accordion_question']) && isset($_POST['tp_accordion_answer'])) {
        $questions = $_POST['tp_accordion_question'];
        $answers = $_POST['tp_accordion_answer'];
        $accordions_data = array();
        
        for ($i = 0; $i < count($questions); $i++) {
            if (!empty(trim($questions[$i]))) {
                $accordions_data[] = array('question' => sanitize_text_field($questions[$i]),'answer' => wp_kses_post($answers[$i]));
            }
        }
        update_post_meta($post_id, '_tp_homepage_accordions', $accordions_data);
    }
}
add_action('save_post_page', 'tp_save_homepage_accordion_meta');

function tp_display_homepage_accordion() {
    $current_page_id = get_the_ID();
    $accordions = get_post_meta($current_page_id, '_tp_homepage_accordions', true);
    if (empty($accordions)) return '';
    ob_start();
    ?>
    <section class="faq-section">
        <div class="tp-container">
            <div class="faq-header">
                <h2 class="faq-title">Frequently Asked Questions</h2>
                <div class="faq-intro">
                    <div class="faq-visual">
                        <div class="faq-circle">
                            <img src="https://lwegatech.net/beaute-sauvage-safaris/wp-content/uploads/2025/10/tp-faq.jpg" class="faq-person">
                            <div class="faq-decorations">
                                <div class="faq-float"></div>
                                <div class="faq-float"></div>
                            </div>
                        </div>
                    </div>
                    <div class="faq-container">
                        <div class="faq-text">
                            <p>"Check out the answers to some of our most frequently asked questions below. Feel free to get in touch with our team directly and we'd be happy to answer any queries you have."</p>
                            <div class="quote-author">- Customer Support Team</div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="faq-accordion">
                <?php foreach ($accordions as $index => $accordion) : ?>
                <div class="faq-item <?php echo $index === 0 ? 'active' : ''; ?>">
                    <button class="faq-question" type="button">
                        <span class="faq-question-text"><?php echo ($index + 1) . '. ' . esc_html($accordion['question']); ?></span>
                        <span class="faq-icon">▼</span>
                    </button>
                    <div class="faq-answer">
                        <div class="faq-answer-content">
                            <?php echo wpautop(wp_kses_post($accordion['answer'])); ?>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
    <?php
    return ob_get_clean();
}

/**
 * TRAVEL TIPS METABOX
 */
function tp_travel_tips_metabox() {
    add_meta_box('tp_travel_tips','Travel Tips','tp_travel_tips_html','page','advanced','high');
}
add_action('add_meta_boxes', 'tp_travel_tips_metabox');

function tp_travel_tips_html($post) {
    wp_nonce_field('tp_travel_tips_nonce', 'tp_travel_tips_nonce_field');
    $travel_tips = get_post_meta($post->ID, '_travel_tips', true);
    $travel_tips = is_array($travel_tips) ? $travel_tips : array();
    while (count($travel_tips) < 3) {
        $travel_tips[] = '';
    }
    ?>
    <div id="tp-travel-tips-repeater">
        <p><strong>Enter up to 3 travel tips that will be displayed in the Travel Tips section:</strong></p>
        <?php for ($i = 0; $i < 3; $i++) : ?>
            <div class="tp-travel-tip-item">
                <p><label><strong>Travel Tip <?php echo $i + 1; ?>:</strong></label>
                <textarea name="travel_tips[]" style="width:100%; height:80px;" placeholder="Enter travel tip text here..."><?php echo isset($travel_tips[$i]) ? esc_textarea($travel_tips[$i]) : ''; ?></textarea></p>
                <?php if ($i < 2) : ?><hr style="margin: 20px 0;"><?php endif; ?>
            </div>
        <?php endfor; ?>
    </div>
    <p><em>Leave a field empty if you don't want to display that tip. If all fields are empty, a default message will be shown.</em></p>
    <?php
}

function tp_save_travel_tips_meta($post_id) {
    if (!isset($_POST['tp_travel_tips_nonce_field']) || !wp_verify_nonce($_POST['tp_travel_tips_nonce_field'], 'tp_travel_tips_nonce')) return;
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;
    if (!current_user_can('edit_page', $post_id)) return;
    
    if (isset($_POST['travel_tips'])) {
        $travel_tips = array_map('sanitize_textarea_field', $_POST['travel_tips']);
        $travel_tips = array_filter($travel_tips, function($tip) {
            return !empty(trim($tip));
        });
        $travel_tips = array_values($travel_tips);
        update_post_meta($post_id, '_travel_tips', $travel_tips);
    }
}
add_action('save_post_page', 'tp_save_travel_tips_meta');

add_filter('acf/settings/remove_wp_meta_box', '__return_false');
?>