<?php
function travel_services_shortcode() {
    $options = get_option('travel_services_options');
    ob_start(); ?>
    
    <style>
        .ticketing-services-content .ticketing-content-wrapper h1, .ticketing-services-content .ticketing-content-wrapper h2, .ticketing-services-content .ticketing-content-wrapper h3, .ticketing-services-content .ticketing-content-wrapper h4, .ticketing-services-content .ticketing-content-wrapper h5, .ticketing-services-content .ticketing-content-wrapper h6 { color: #1e3a8a; font-weight: 600; line-height: 1.4; margin: 20px 0 15px 0; border-bottom: 2px solid #e5e7eb; padding-bottom: 8px; }
.ticketing-services-content .ticketing-content-wrapper h1 { font-size: 24px; }
.ticketing-services-content .ticketing-content-wrapper h2 { font-size: 22px; }
.ticketing-services-content .ticketing-content-wrapper h3 { font-size: 20px; }
.ticketing-services-content .ticketing-content-wrapper h4 { font-size: 18px; }
.ticketing-services-content .ticketing-content-wrapper h5 { font-size: 16px; }
.ticketing-services-content .ticketing-content-wrapper h6 { font-size: 14px; }
.ticketing-services-content .ticketing-content-wrapper p { line-height: 1.8; margin: 0 0 16px 0; color: #374151; font-size: 17px; text-align: justify; word-spacing: 0.1em; }
.ticketing-services-content .ticketing-content-wrapper ul { margin: 16px 0; padding-left: 0; list-style: none; }
.ticketing-services-content .ticketing-content-wrapper ul li { position: relative; padding-left: 25px; margin-bottom: 8px; line-height: 1.6; color: #374151; font-size: 17px; }
.ticketing-services-content .ticketing-content-wrapper ul li::before { content: "★"; color: #fbbf24; font-size: 17px; position: absolute; left: 0; top: 0; }
.ticketing-services-content .ticketing-content-wrapper ol { margin: 16px 0; padding-left: 20px; counter-reset: item; }
.ticketing-services-content .ticketing-content-wrapper ol li { display: block; margin-bottom: 8px; padding-left: 15px; line-height: 1.6; color: #374151; font-size: 17px; position: relative; counter-increment: item; }
.ticketing-services-content .ticketing-content-wrapper ol li::before { content: counter(item) "."; color: #1e3a8a; font-weight: bold; position: absolute; left: -15px; top: 0; }
.ticketing-services-content .ticketing-content-wrapper ul ul li::before { content: "☆"; color: #94a3b8; }
.ticketing-services-content .ticketing-content-wrapper strong, .ticketing-services-content .ticketing-content-wrapper b { color: #1e3a8a; font-weight: 600; }
.ticketing-services-content .ticketing-content-wrapper em, .ticketing-services-content .ticketing-content-wrapper i { color: #6b7280; font-style: italic; }
.ticketing-services-content .ticketing-content-wrapper a { color: #2563eb; text-decoration: none; border-bottom: 1px solid transparent; transition: all 0.2s ease; }
.ticketing-services-content .ticketing-content-wrapper a:hover { color: #1d4ed8; border-bottom-color: #1d4ed8; }
.ticketing-services-content .ticketing-content-wrapper blockquote { border-left: 4px solid #1e3a8a; margin: 20px 0; padding: 15px 20px; background: #f8fafc; font-style: italic; color: #4b5563; border-radius: 0 4px 4px 0; }
.ticketing-services-content .ticketing-content-wrapper table { width: 100%; border-collapse: collapse; margin: 20px 0; font-size: 17px; }
.ticketing-services-content .ticketing-content-wrapper table th, .ticketing-services-content .ticketing-content-wrapper table td { border: 1px solid #e5e7eb; padding: 10px; text-align: left; }
.ticketing-services-content .ticketing-content-wrapper table th { background-color: #1e3a8a; color: white; font-weight: 600; }
.ticketing-services-content .ticketing-content-wrapper table tr:nth-child(even) { background-color: #f9fafb; }
.ticketing-services-content .ticketing-content-wrapper code { background-color: #f3f4f6; color: #dc2626; padding: 2px 6px; border-radius: 3px; font-family: 'Courier New', monospace; font-size: 17px; }
.ticketing-services-content .ticketing-content-wrapper pre { background-color: #1f2937; color: #f9fafb; padding: 15px; border-radius: 5px; overflow-x: auto; margin: 20px 0; font-family: 'Courier New', monospace; font-size: 17px; line-height: 1.4; }
.ticketing-services-content .ticketing-content-wrapper img { max-width: 100%; height: auto; border-radius: 5px; margin: 10px 0; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
.ticketing-services-content .ticketing-content-wrapper hr { border: none; height: 2px; background: linear-gradient(90deg, #1e3a8a, transparent); margin: 25px 0; }
.ticketing-services-content .ticketing-content-wrapper .wp-caption-text { font-size: 17px; color: #6b7280; font-style: italic; text-align: center; margin-top: 5px; }
.destination-cta-section{position:relative;min-height:400px;display:flex;align-items:center;justify-content:center;background-size:cover;background-position:center; border-radius:25px 0 25px; background-attachment:fixed;overflow:hidden;margin:60px 0 0}
.destination-cta-overlay{position:absolute;top:0;left:0;width:100%;height:100%;background:linear-gradient(135deg,rgba(0,0,0,0.75) 0%,rgba(0,51,102,0.8) 100%);z-index:1}
.destination-cta-content{position:relative;z-index:2;text-align:center;padding:60px 20px;max-width:800px;animation:fadeInUp 1s ease}
.destination-cta-icon{font-size:3.5rem;color:#fff;margin-bottom:20px;animation:pulse 2s infinite}
.destination-cta-icon i{filter:drop-shadow(0 4px 8px rgba(0,0,0,0.3))}
.destination-cta-title{font-size:2.5rem;color:#fff;margin:0 0 15px;font-weight:700;text-shadow:2px 2px 8px rgba(0,0,0,0.5);letter-spacing:-0.5px}
.destination-cta-subtitle{font-size:1.2rem;color:#e0e0e0;margin:0 0 40px;font-weight:300;text-shadow:1px 1px 4px rgba(0,0,0,0.5)}
.destination-cta-buttons{display:flex;gap:20px; border-radius:10px; justify-content:center;flex-wrap:wrap}
.destination-cta-btn{display:inline-flex;align-items:center;gap:12px;padding:16px 32px;font-size:1rem;font-weight:600;text-decoration:none;border-radius:50px;transition:all 0.4s ease;box-shadow:0 8px 25px rgba(0,0,0,0.3);position:relative;overflow:hidden}
.destination-cta-btn::before{content:'';position:absolute;top:50%;left:50%;width:0;height:0;border-radius:10px;background:rgba(255,255,255,0.2);transform:translate(-50%,-50%);transition:width 0.6s,height 0.6s}
.destination-cta-btn:hover::before{width:400px;height:400px}
.destination-cta-btn i{font-size:1.2rem;transition:transform 0.3s ease}
.destination-cta-btn:hover i{transform:scale(1.2) rotate(5deg)}
.destination-cta-primary{background:linear-gradient(135deg,#ff6b35 0%,#f7931e 100%);color:#fff;border:2px solid transparent}
.destination-cta-primary:hover{transform:translateY(-3px);box-shadow:0 12px 35px rgba(255,107,53,0.5)}
.destination-cta-secondary{background:transparent;color:#fff;border:2px solid #fff;backdrop-filter:blur(5px)}
.destination-cta-secondary:hover{background:rgba(255,255,255,0.15);transform:translateY(-3px);box-shadow:0 12px 35px rgba(255,255,255,0.3)}

    </style>
    
    <div class="ticketing-travel-services-panel">
        <div class="ticketing-services-sidebar">
            <div class="ticketing-sidebar-item ticketing-active" data-tab="air-ticketing">
                <i class="fas fa-plane-departure"></i>
                <span>Air Ticketing and Hotel Booking</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="travel-coordination">
                <i class="fas fa-suitcase-rolling"></i>
                <span>Travel Planning & Coordination</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="leisure-travel">
                <i class="fas fa-calendar-day"></i>
                <span>Leisure Travel Management</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="travel-insurance">
                <i class="fas fa-plane"></i>
                <span>Travel Insurance Arrangement</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="traveler-profiling">
                <i class="fas fa-plane"></i>
                <span>Traveler Profiling</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="support-alerting">
                <i class="fas fa-plane"></i>
                <span>24/7 Support and Alerting</span>
            </div>
            <div class="ticketing-sidebar-item" data-tab="visa-support" data-url="https://lwegatech.net/beaute-sauvage-safaris/visa-support-services/">
                <i class="fas fa-plane"></i>
                <span>Visa Support</span>
            </div>
        </div>
        
        <div class="ticketing-services-content">
            <div id="air-ticketing" class="ticketing-content-item ticketing-active">
                <h3><?php echo esc_html($options['air_ticketing_title'] ?? 'Air Ticketing and Hotel Booking'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['air_ticketing_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>
            
            <div id="travel-coordination" class="ticketing-content-item">
                <h3><?php echo esc_html($options['travel_coordination_title'] ?? 'Travel Coordination'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['travel_coordination_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>
            
            <div id="leisure-travel" class="ticketing-content-item">
                <h3><?php echo esc_html($options['leisure_travel_title'] ?? 'Leisure Travel Management'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['leisure_travel_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>
            
            <div id="travel-insurance" class="ticketing-content-item">
                <h3><?php echo esc_html($options['travel_insurance_title'] ?? 'Travel Insurance Arrangement'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['travel_insurance_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>

            <div id="traveler-profiling" class="ticketing-content-item">
                <h3><?php echo esc_html($options['traveler_profiling_title'] ?? 'Traveler Profiling'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['traveler_profiling_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>

            <div id="support-alerting" class="ticketing-content-item">
                <h3><?php echo esc_html($options['support_alerting_title'] ?? '24/7 Support and Alerting'); ?></h3>
                <div class="ticketing-content-wrapper">
                    <?php echo wp_kses_post(wpautop($options['support_alerting_content'] ?? 'Content coming soon...')); ?>
                </div>
            </div>
        </div>
    </div>
    
    <!-- CTA SECTION WITH TWO BUTTONS -->
<div class="destination-cta-section" style="background-image:url('https://images.unsplash.com/photo-1469854523086-cc02fe5d8800?w=1920');">
    <div class="destination-cta-overlay"></div>
    <div class="destination-cta-content">
        <div class="destination-cta-icon">
            <i class="fas fa-compass"></i>
        </div>
        <h2 class="destination-cta-title">Ready for Your Next Adventure?</h2>
        <p class="destination-cta-subtitle">Explore our handcrafted packages designed for unforgettable experiences</p>
        <div class="destination-cta-buttons">
            <a href="https://lwegatech.net/beaute-sauvage-safaris/packages/" class="destination-cta-btn destination-cta-primary">
                <i class="fas fa-suitcase-rolling"></i>
                <span>Explore Travel Packages</span>
            </a>
            <a href="https://lwegatech.net/beaute-sauvage-safaris/honeymoon-getaways/" class="destination-cta-btn destination-cta-secondary">
                <i class="fas fa-heart"></i>
                <span>Honeymoon Getaways</span>
            </a>
        </div>
    </div>
</div>

    
    <script>
        jQuery(document).ready(function($) {
            $('.ticketing-sidebar-item').on('click', function() {
                // Check if this item has a URL (for visa support)
                var url = $(this).data('url');
                if (url) {
                    window.location.href = url;
                    return;
                }

                $('.ticketing-sidebar-item').removeClass('ticketing-active');
                $(this).addClass('ticketing-active');
                $('.ticketing-content-item').removeClass('ticketing-active');
                var tabId = $(this).data('tab');
                $('#' + tabId).addClass('ticketing-active');
                $('.ticketing-services-content').scrollTop(0);
            });
        });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('travel_services', 'travel_services_shortcode');


// Admin Settings Page
function travel_services_admin_menu() {
    add_options_page(
        'Travel Services Settings',
        'Travel Services',
        'manage_options',
        'travel-services-settings',
        'travel_services_admin_page'
    );
}
add_action('admin_menu', 'travel_services_admin_menu');

function travel_services_admin_page() {
    if (!current_user_can('manage_options')) {
        return;
    }
    ?>
    <div class="wrap">
        <h1>Travel Services Settings</h1>
        <form method="post" action="options.php">
            <?php
            settings_fields('travel_services_options');
            do_settings_sections('travel-services-settings');
            submit_button('Save Settings');
            ?>
        </form>
    </div>
    <?php
}

function travel_services_settings_init() {
    register_setting(
        'travel_services_options',
        'travel_services_options',
        [
            'sanitize_callback' => 'travel_services_sanitize_options',
            'default' => [
                'air_ticketing_title' => 'Air Ticketing and Hotel Booking',
                'travel_coordination_title' => 'Travel Coordination',
                'leisure_travel_title' => 'Leisure Travel Management',
                'travel_insurance_title' => 'Travel Insurance Arrangement',
                'traveler_profiling_title' => 'Traveler Profiling',
                'support_alerting_title' => '24/7 Support and Alerting'
            ]
        ]
    );

    // Sections
    $sections = [
        'air_ticketing' => 'Air Ticketing and Hotel Booking',
        'travel_coordination' => 'Travel Coordination',
        'leisure_travel' => 'Leisure Travel Management',
        'travel_insurance' => 'Travel Insurance Arrangement',
        'traveler_profiling' => 'Traveler Profiling',
        'support_alerting' => '24/7 Support and Alerting'
    ];

    foreach ($sections as $id => $title) {
        add_settings_section(
            "travel_services_{$id}",
            $title,
            null,
            'travel-services-settings'
        );

        add_settings_field(
            "{$id}_title",
            'Title',
            'travel_services_text_field',
            'travel-services-settings',
            "travel_services_{$id}",
            ['name' => "{$id}_title"]
        );

        add_settings_field(
            "{$id}_content",
            'Content',
            'travel_services_editor_field',
            'travel-services-settings',
            "travel_services_{$id}",
            ['name' => "{$id}_content"]
        );
    }
}
add_action('admin_init', 'travel_services_settings_init');

function travel_services_text_field($args) {
    $options = get_option('travel_services_options');
    $value = $options[$args['name']] ?? '';
    ?>
    <input type="text" class="regular-text" name="travel_services_options[<?php echo esc_attr($args['name']); ?>]" 
           value="<?php echo esc_attr($value); ?>">
    <?php
}

function travel_services_editor_field($args) {
    $options = get_option('travel_services_options');
    $content = $options[$args['name']] ?? '';
    wp_editor(
        wp_kses_post($content),
        'travel_services_' . sanitize_key($args['name']),
        [
            'textarea_name' => 'travel_services_options[' . $args['name'] . ']',
            'textarea_rows' => 10,
            'media_buttons' => true,
            'teeny' => false,
            'wpautop' => true
        ]
    );
}

function travel_services_sanitize_options($input) {
    $sanitized = [];
    
    foreach ($input as $key => $value) {
        if (strpos($key, 'content') !== false) {
            $sanitized[$key] = wp_kses_post($value);
        } else {
            $sanitized[$key] = sanitize_text_field($value);
        }
    }
    
    return $sanitized;
}

// Enqueue assets
function travel_services_enqueue_assets() {
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css', [], '5.15.4');
    wp_enqueue_style('travel-services-fonts', 'https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');
    
    if (!wp_script_is('jquery', 'enqueued')) {
        wp_enqueue_script('jquery');
    }
}
add_action('wp_enqueue_scripts', 'travel_services_enqueue_assets');
?>