<!Doctype html>
<html <?php language_attributes(); ?> class="no-js">
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<title>
			<?php
                $seo_title = get_post_meta(get_the_ID(), '_seo_title', true);
                if (!empty($seo_title)) {
                    echo esc_html($seo_title);
                } else {
                    echo wp_title('|', false, 'right') . get_bloginfo('name');
                }
                ?>

		</title>
		<meta name="description" content="
		<?php
		$seo_description = get_post_meta(get_the_ID(), '_seo_description', true);
		if (!empty($seo_description)) { echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());}
		?>
		">
		<meta name="keywords" content="
		<?php
		$seo_keywords = get_post_meta(get_the_ID(), '_seo_keywords', true);
		if (!empty($seo_keywords)) {echo esc_html($seo_keywords);} else {echo esc_html('Inyana International School,IIS,Christian based school in Uganda, EYFS British Curriculum, Early Years Foundation Stage, Uganda education, Christian school, holistic development, Kampala international');}
		?>
		">
		<meta property="og:title" content="
		<?php
			if (!empty($seo_title)) {echo esc_html($seo_title);} else {echo esc_html(get_the_title());}
		?>
		"/>
		<meta property="og:description" content="
		<?php
			if (!empty($seo_description)) {echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());}
		?>
		"/>
		<meta property="og:image" content="
		<?php
		$featured_image = get_the_post_thumbnail_url();
		$default_image=  get_template_directory() . '/assets/images/africa-coffee-bureau-bridging-the-gap.jpg'; 
		if (!empty($featured_image)) {echo esc_url($featured_image);} else {echo esc_url($default_image);}
		?>
		" />
		<meta property="og:url" content="<?php the_permalink(); ?>" />
		<meta name="twitter:title" content="
		<?php
		if (!empty($seo_title)) {echo esc_html($seo_title);} else {echo esc_html(get_the_title());}
		?>
		"/>
		<meta name="twitter:description" content="
		<?php
		if (!empty($seo_description)) {echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());} 
		?>
		"/>
		<meta name="twitter:image" content="
		<?php
		if (!empty($featured_image)) {echo esc_url($featured_image);} else {echo esc_url($default_image);}
		?>
		"/>
		<meta name="google-site-verification" content="Sk61s_LXBI0q4E5gbDGbnmSTqiUJFFC1zBgwWLIXQ64" />
		<link href="//www.google-analytics.com" rel="dns-prefetch">
        
        <?php
        // Get the site icon from WordPress settings
        $site_icon_id = get_option('site_icon');
        if ($site_icon_id) {
            // Use WordPress site icon
            $site_icon_url = wp_get_attachment_image_url($site_icon_id, 'full');
            $site_icon_32 = wp_get_attachment_image_url($site_icon_id, array(32, 32));
            $site_icon_16 = wp_get_attachment_image_url($site_icon_id, array(16, 16));
            $site_icon_96 = wp_get_attachment_image_url($site_icon_id, array(96, 96));
            $site_icon_192 = wp_get_attachment_image_url($site_icon_id, array(192, 192));
        } else {
            // Fallback to theme favicon
            $site_icon_url = get_template_directory_uri() . '/favicon.png';
            $site_icon_32 = $site_icon_url;
            $site_icon_16 = $site_icon_url;
            $site_icon_96 = $site_icon_url;
            $site_icon_192 = $site_icon_url;
        }
        ?>
        
        <link href="<?php echo esc_url($site_icon_url); ?>" rel="shortcut icon">
        <link rel="icon" type="image/png" sizes="32x32" href="<?php echo esc_url($site_icon_32); ?>">
        <link rel="icon" type="image/png" sizes="96x96" href="<?php echo esc_url($site_icon_96); ?>">
        <link rel="icon" type="image/png" sizes="16x16" href="<?php echo esc_url($site_icon_16); ?>">
        <link rel="icon" type="image/png" sizes="192x192" href="<?php echo esc_url($site_icon_192); ?>">
        
        <?php if ($site_icon_id): ?>
        <!-- Apple Touch Icons using WordPress site icon -->
        <link rel="apple-touch-icon" sizes="57x57" href="<?php echo esc_url(wp_get_attachment_image_url($site_icon_id, array(57, 57))); ?>">
        <link rel="apple-touch-icon" sizes="60x60" href="<?php echo esc_url(wp_get_attachment_image_url($site_icon_id, array(60, 60))); ?>">
        <link rel="apple-touch-icon" sizes="72x72" href="<?php echo esc_url(wp_get_attachment_image_url($site_icon_id, array(72, 72))); ?>">
        <link rel="apple-touch-icon" sizes="76x76" href="<?php echo esc_url(wp_get_attachment_image_url($site_icon_id, array(76, 76))); ?>">
        <link rel="apple-touch-icon" sizes="114x114" href="<?php echo esc_url(wp_get_attachment_image_url($site_icon_id, array(114, 114))); ?>">
        <link rel="apple-touch-icon" sizes="120x120" href="<?php echo esc_url(wp_get_attachment_image_url($site_icon_id, array(120, 120))); ?>">
        <link rel="apple-touch-icon" sizes="144x144" href="<?php echo esc_url(wp_get_attachment_image_url($site_icon_id, array(144, 144))); ?>">
        <link rel="apple-touch-icon" sizes="152x152" href="<?php echo esc_url(wp_get_attachment_image_url($site_icon_id, array(152, 152))); ?>">
        <link rel="apple-touch-icon" sizes="180x180" href="<?php echo esc_url(wp_get_attachment_image_url($site_icon_id, array(180, 180))); ?>">
        <meta name="msapplication-TileImage" content="<?php echo esc_url(wp_get_attachment_image_url($site_icon_id, array(144, 144))); ?>">
        <?php else: ?>
        <!-- Fallback Apple Touch Icons -->
        <link rel="apple-touch-icon" sizes="57x57" href="/apple-icon-57x57.png">
        <link rel="apple-touch-icon" sizes="60x60" href="/apple-icon-60x60.png">
        <link rel="apple-touch-icon" sizes="72x72" href="/apple-icon-72x72.png">
        <link rel="apple-touch-icon" sizes="76x76" href="/apple-icon-76x76.png">
        <link rel="apple-touch-icon" sizes="114x114" href="/apple-icon-114x114.png">
        <link rel="apple-touch-icon" sizes="120x120" href="/apple-icon-120x120.png">
        <link rel="apple-touch-icon" sizes="144x144" href="/apple-icon-144x144.png">
        <link rel="apple-touch-icon" sizes="152x152" href="/apple-icon-152x152.png">
        <link rel="apple-touch-icon" sizes="180x180" href="/apple-icon-180x180.png">
        <meta name="msapplication-TileImage" content="/ms-icon-144x144.png">
        <?php endif; ?>
        
        <link rel="manifest" href="/manifest.json">
        <meta name="msapplication-TileColor" content="#ffffff">
        <meta name="theme-color" content="#ffffff">
        
        <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=5.0, user-scalable=yes">
        <meta name="theme-color" content="#1e3a8a">
        <meta name="apple-mobile-web-app-capable" content="yes">
        <meta name="apple-mobile-web-app-status-bar-style" content="default">
        
        <!--Thanks to Google Fonts -->
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&family=Playfair+Display:ital,wght@0,400..900;1,400..900&family=Raleway:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">

        <!-- Add the Font Awesome CSS -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
		<!--Popup Modal-->
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
        <!-- Include Magnific Popup -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/magnific-popup.min.css">
        <script src="https://cdnjs.cloudflare.com/ajax/libs/magnific-popup.js/1.1.0/jquery.magnific-popup.min.js"></script>
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/glightbox/dist/css/glightbox.min.css" />
        <script src="https://cdn.jsdelivr.net/gh/mcstudios/glightbox/dist/js/glightbox.min.js"></script>  
        <script src="/assets/js/main.js"></script>
        
    
    <!-- Preloader CSS -->
    <style>
        #preloader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(180deg, #87CEEB 0%, #E0F7FA 100%);
            z-index: 9999;
            display: flex;
            justify-content: center;
            align-items: center;
            overflow: hidden;
        }
        
        .island {
            position: relative;
            width: 220px;
            height: 120px;
        }
        
        .sand {
            position: absolute;
            bottom: 0;
            width: 100%;
            height: 60px;
            background: #F4E7C3;
            border-radius: 50% 50% 0 0;
            box-shadow: 0 -8px 12px rgba(0,0,0,0.1);
        }
        
        .palm-trees {
            position: absolute;
            bottom: 50px;
            width: 100%;
            display: flex;
            justify-content: center;
            gap: 10px; /* Reduced gap between trees */
            z-index: 2;
            padding: 0 20px;
        }
        
        .palm-tree {
            font-size: 42px;
            animation: sway 1.8s ease-in-out infinite alternate;
            transform-origin: bottom center;
            margin: 0 -10px; /* Overlapping trees */
        }
        
        .palm-tree:nth-child(1) { animation-delay: 0.3s; }
        .palm-tree:nth-child(2) { animation-delay: 0.6s; }
        .palm-tree:nth-child(3) { animation-delay: 0s; }
        
        .airplane {
            position: absolute;
            font-size: 36px;
            bottom: 80px;
            left: -40px;
            animation: takeoff 1.5s ease-out forwards;
            z-index: 3;
            transform: rotate(10deg);
        }
        
        .brand-name {
            position: absolute;
            bottom: 20px;
            width: 100%;
            text-align: center;
            font-family: 'Montserrat', sans-serif;
            font-weight: 700;
            font-size: 20px;
            color: #5D4037;
            text-shadow: 1px 1px 2px rgba(255,255,255,0.5);
            letter-spacing: 1px;
        }
        
        @keyframes sway {
            0% { transform: rotate(-3deg); }
            100% { transform: rotate(3deg); }
        }
        
        @keyframes takeoff {
            0% { transform: translateX(0) translateY(0) rotate(10deg); }
            60% { transform: translateX(120px) translateY(-30px) rotate(0deg); }
            100% { transform: translateX(250px) translateY(-60px) rotate(-10deg); opacity: 0; }
        }
        
        .wave {
            position: absolute;
            bottom: 50px;
            width: 100%;
            height: 15px;
            background: url('data:image/svg+xml;utf8,<svg viewBox="0 0 120 12" xmlns="http://www.w3.org/2000/svg"><path d="M0,0V6c12,2,24,4,40,4s32-2,40-4s24-2,40-2s32,2,40,4V0Z" fill="%23F4E7C3" opacity=".3"/></svg>');
            background-size: cover;
        }
    </style>
</head>
<body <?php body_class(); ?>>
    <!-- Enhanced Preloader -->
    <div id="preloader">
        <div class="island">
            <div class="sand"></div>
            <div class="wave"></div>
            <div class="palm-trees">
                <div class="palm-tree">🌴</div>
                <div class="palm-tree">🌴</div>
                <div class="palm-tree">🌴</div>
            </div>
            <div class="airplane">✈️</div>
            <div class="brand-name">Travel Portal</div>
        </div>
    </div>

        
        <?php wp_head(); ?>
	</head>
	<body <?php body_class(); ?>>
	    
	     <!-- Preloader JavaScript -->
     <script>
        document.addEventListener("DOMContentLoaded", function() {
            // Hide preloader when main content loads
            setTimeout(function() {
                document.getElementById('preloader').style.opacity = '0';
                setTimeout(function() {
                    document.getElementById('preloader').style.display = 'none';
                }, 300);
            }, 1500); // Total duration matches animation
            
            // Force hide after 3s max as fallback
            setTimeout(function() {
                if(document.getElementById('preloader')) {
                    document.getElementById('preloader').style.display = 'none';
                }
            }, 3000);
        });
    </script>