document.addEventListener("DOMContentLoaded", () => {
    const preview = document.querySelector(".photo-preview img");
    const thumbnails = document.querySelectorAll(".thumbnail img");
    const prevButton = document.querySelector(".photo-prev");
    const nextButton = document.querySelector(".photo-next");
  
    let currentIndex = 0;
  
    thumbnails.forEach((thumbnail, index) => {
      thumbnail.addEventListener("click", () => {
        preview.src = thumbnail.src;
        thumbnails.forEach(t => t.classList.remove("active"));
        thumbnail.classList.add("active");
        currentIndex = index;
      });
    });
  
    if (thumbnails.length > 0) {
      thumbnails[0].classList.add("active");
    }
  
    prevButton.addEventListener("click", () => {
      currentIndex--;
      if (currentIndex < 0) {
        currentIndex = thumbnails.length - 1;
      }
      preview.src = thumbnails[currentIndex].src;
      thumbnails.forEach(t => t.classList.remove("active"));
      thumbnails[currentIndex].classList.add("active");
    });
  
    nextButton.addEventListener("click", () => {
      currentIndex++;
      if (currentIndex >= thumbnails.length) {
        currentIndex = 0;
      }
      preview.src = thumbnails[currentIndex].src;
      thumbnails.forEach(t => t.classList.remove("active"));
      thumbnails[currentIndex].classList.add("active");
    });
  
    preview.addEventListener("mousemove", (e) => {
      const x = e.offsetX / preview.clientWidth;
      const y = e.offsetY / preview.clientHeight;
      preview.style.transform = `scale(1.2) translate(-${x * 10}px, -${y * 10}px)`;
    });
  
    preview.addEventListener("mouseleave", () => {
      preview.style.transform = "scale(1) translate(0, 0)";
    });
  });


  //Products corousel - slides
const sliderContainer = document.querySelector('.slider-container');
const sliderWidth = sliderContainer.offsetWidth;
const sliderHeight = sliderContainer.offsetHeight;

// Set the width and height of the slider wrapper and items
const sliderWrapper = document.querySelector('.slider-wrapper');
const sliderItems = document.querySelectorAll('.slider-item');
sliderWrapper.style.width = sliderWidth + 'px';
sliderWrapper.style.height = sliderHeight + 'px';
sliderItems.forEach(item => {
  item.style.width = sliderWidth + 'px';
  item.style.height = sliderHeight / 2 + 'px';
});

// Add event listeners to pause and resume the slider animation on mouseenter and mouseleave
sliderWrapper.addEventListener('mouseenter', () => {
  sliderWrapper.classList.add('slider-paused');
});

sliderWrapper.addEventListener('mouseleave', () => {
  sliderWrapper.classList.remove('slider-paused');
});