
/**===============================================================
 * Delete User
 =================================================================*/
 function delete_user(id, name)
 {
    // Show the delete confirmation modal (id used in modal view: #deleteUserModal)
    $("#deleteUserModal").modal('show');
    $("#deleteUserName").html(name);
    $("#deleteUserId").val(id);

    // Unbind previous click handlers to avoid duplicates, then bind
    $("#confirmDeleteBtn").off('click').on('click', function(){
      $.ajax({
        url : base_url+"/administrator/users/delete/"+id,
        type: "POST",
        dataType: "JSON",
        headers: {'X-Requested-With': 'XMLHttpRequest'},
        success: function(data)
        {
          $("#deleteUserModal").modal('hide');
          html = '<div class="alert alert-danger" role="alert">'+data.msg+'</div>';
          document.getElementById('showMsg').innerHTML = html;
          setTimeout(function(){
           location.href = base_url+"/administrator/users";
          },800);
        },
        error: function(xhr, status, err) {
          $("#deleteUserModal").modal('hide');
          alert('Error deleting user');
        }
      });
    });
 }

 //Change User Password
 function change_pwd(id)
 {
  // Show change password modal (id used in modal view: #changePasswordModal)
  $("#changePasswordModal").modal("show");
  // Set the hidden user id field value in the modal
  $('#changePasswordUserId').val(id);

  // Handle form submit via AJAX
  $('#changePasswordForm').off('submit').on('submit', function(e){
    e.preventDefault();
    var userId = $('#changePasswordUserId').val();
    var newPwd = $('#newPassword').val();
    var confirm = $('#confirmPassword').val();

    if(newPwd !== confirm){
      alert('Passwords do not match');
      return;
    }

    $.ajax({
      url: base_url + '/administrator/users/changePwd',
      type: 'POST',
      dataType: 'json',
      data: { id: userId, password: newPwd, cpass: confirm },
      headers: {'X-Requested-With': 'XMLHttpRequest'},
      success: function(res){
        $('#changePasswordModal').modal('hide');
        if(res && res.error){
          alert(res.msg || 'Error updating password');
        } else {
          // show success and reload
          alert(res.msg || 'Password updated');
          location.reload();
        }
      },
      error: function(){
        $('#changePasswordModal').modal('hide');
        alert('Server error while updating password');
      }
    });
  });
 }

// Cascading dropdowns for user forms using local filtering
$(document).ready(function() {
    // Country change event for user forms
    $(document).on('change', '#country_id', function() {
        var countryId = $(this).val();
        console.log('Country changed to:', countryId);
        filterUserStates(countryId);
        // Reset city dropdown
        $('#city_id').html('<option value="">Select City</option>');
    });

    // State change event for user forms
    $(document).on('change', '#state_id', function() {
        var stateId = $(this).val();
        console.log('State changed to:', stateId);
        filterUserCities(stateId);
    });
});

function filterUserStates(countryId) {
    var stateSelect = $('#state_id');
    stateSelect.html('<option value="">Select State</option>');

    if (!countryId || countryId == 0) {
        return;
    }

    // Filter states based on data-country-id attribute
    $('#state_id option').each(function() {
        var option = $(this);
        var stateCountryId = option.data('country-id');
        if (stateCountryId == countryId) {
            option.show();
        } else {
            option.hide();
        }
    });
}

function filterUserCities(stateId) {
    var citySelect = $('#city_id');
    citySelect.html('<option value="">Select City</option>');

    if (!stateId || stateId == 0) {
        return;
    }

    // Filter cities based on data-state-id attribute
    $('#city_id option').each(function() {
        var option = $(this);
        var cityStateId = option.data('state-id');
        if (cityStateId == stateId) {
            option.show();
        } else {
            option.hide();
        }
    });
}
