//TEAM MEMBER 
// Auto expand the Text Area as content increases   
$("textarea").each(function () {
    this.setAttribute("style", "height:" + (this.scrollHeight) + "px;overflow-y:hidden;border:1px solid #ced4da;");
  }).on("input", function () {
    this.style.height = "auto";
    this.style.height = (this.scrollHeight) + "px";
  }).on("click", function () {
    // Display the entire content when clicked to edit
    this.style.height = (this.scrollHeight) + "px";
  });

// Lightweight helper fallbacks used across admin modules
// These mirror the small helpers defined in other admin scripts (setText, bindClick, showModal, hideModal)
if (typeof setText === 'undefined') {
  window.setText = function(selector, text) {
    try {
      if (window.jQuery && typeof $(selector).text === 'function') {
        $(selector).text(text);
        return;
      }
      var el = document.querySelector(selector);
      if (!el) return;
      el.textContent = text;
    } catch (e) { console && console.warn && console.warn('setText fallback error', e); }
  };
}

if (typeof bindClick === 'undefined') {
  window.bindClick = function(selector, handler) {
    try {
      if (window.jQuery) {
        $(selector).off('click').on('click', handler);
        return;
      }
      var el = document.querySelector(selector);
      if (!el) return;
      // Replace node to remove previous listeners
      var newEl = el.cloneNode(true);
      el.parentNode.replaceChild(newEl, el);
      newEl.addEventListener('click', handler);
    } catch (e) { console && console.warn && console.warn('bindClick fallback error', e); }
  };
}

if (typeof showModal === 'undefined') {
  window.showModal = function(selector) {
    try {
      if (window.jQuery && typeof $(selector).modal === 'function') { $(selector).modal('show'); return; }
      if (window.bootstrap && typeof bootstrap.Modal === 'function') {
        var el = document.querySelector(selector);
        if (!el) return;
        var inst = bootstrap.Modal.getInstance(el) || new bootstrap.Modal(el);
        inst.show();
        return;
      }
      // fallback: show confirm dialog with the element's text
      var elText = document.querySelector(selector) ? (document.querySelector(selector).textContent || '') : '';
      if (!confirm('Are you sure? ' + elText)) return;
    } catch (e) { console && console.warn && console.warn('showModal fallback error', e); }
  };
}

if (typeof hideModal === 'undefined') {
  window.hideModal = function(selector) {
    try {
      if (window.jQuery && typeof $(selector).modal === 'function') { $(selector).modal('hide'); return; }
      if (window.bootstrap && typeof bootstrap.Modal === 'function') {
        var el = document.querySelector(selector);
        if (!el) return;
        var inst = bootstrap.Modal.getInstance(el);
        if (inst) inst.hide();
        return;
      }
      // Nothing to do for fallback
    } catch (e) { console && console.warn && console.warn('hideModal fallback error', e); }
  };
}


function delete_teamCategory(id, name){
  // Use shared modal if available (delCatModal) else fallback to confirm
  if (document.querySelector('#delCatModal')){
    setText('#catname', name);
    bindClick('#del-Catbtn', function(){
      window.location.href = base_url + ('administrator/team/categories/delete/')+ id;
    });
    showModal('#delCatModal');
    return;
  }
  if (confirm('Are you sure you want to delete '+ name +' page?')){
    window.location.href = base_url + ('administrator/team/categories/delete/')+ id;
  }
}

function delete_member(id, name){
  // Use team modal if available
  if (document.querySelector('#delTeamModal')){
    setText('#membername', name);
    bindClick('#del-Teambtn', function(){
      window.location.href = base_url + ('administrator/team/member/delete/')+ id;
    });
    showModal('#delTeamModal');
    return;
  }
  // Fallback to confirm
  if (confirm('Are you sure you want to delete '+ name +' profile?')){
    window.location.href = base_url + ('administrator/team/member/delete/')+ id;
  }
}