var save_method;
/** ========================================================================
 * Posts and Categories
 * ========================================================================**/
// Post form submission

// Image preview functionality
$(document).ready(function() {
    // Handle image preview on file selection
    $('#post_image').on('change', function() {
        var file = this.files[0];
        if (file) {
            var reader = new FileReader();
            reader.onload = function(e) {
                $('#postImgPreview').html('<img src="' + e.target.result + '" class="img-fluid" style="max-height: 150px; border: 1px solid #ddd; border-radius: 5px;">');
            };
            reader.readAsDataURL(file);
        } else {
            $('#postImgPreview').html('<small class="d-flex text-muted p-2">Add Photo to post</small>');
        }
    });

    // Auto-generate alias from title
    $('#title').on('input', function() {
        var title = $(this).val();
        var alias = title.toLowerCase()
                         .replace(/[^a-z0-9\s-]/g, '')
                         .replace(/\s+/g, '-')
                         .replace(/-+/g, '-')
                         .trim('-');
        $('#alias').val(alias);
    });

    // Form validation enhancement
    $('#post-form').on('submit', function(e) {
        var title = $('#title').val().trim();
        var excerpt = $('#excerpt').val().trim();
        var metadesc = $('#metadesc').val().trim();
        var metakey = $('#metakey').val().trim();

        if (!title) {
            e.preventDefault();
            toastr.error('Post title is required');
            $('#title').focus();
            return false;
        }

        if (!excerpt) {
            e.preventDefault();
            toastr.error('Post excerpt is required');
            $('#excerpt').focus();
            return false;
        }

        if (!metadesc) {
            e.preventDefault();
            toastr.error('SEO description is required');
            $('#metadesc').focus();
            return false;
        }

        if (!metakey) {
            e.preventDefault();
            toastr.error('SEO keywords are required');
            $('#metakey').focus();
            return false;
        }

        // Show loading state
        $('button[type="submit"]').prop('disabled', true).html('<i class="fas fa-spinner fa-spin"></i> Saving...');
    });

    // Character counter for excerpt
    $('#excerpt').on('input', function() {
        var length = $(this).val().length;
        var maxLength = 300;
        var remaining = maxLength - length;

        if (remaining < 0) {
            $(this).val($(this).val().substring(0, maxLength));
            remaining = 0;
        }

        $('#excerpt-counter').text(remaining + ' characters remaining');
    });

    // Character counter for meta description
    $('#metadesc').on('input', function() {
        var length = $(this).val().length;
        var maxLength = 150;
        var remaining = maxLength - length;

        if (remaining < 0) {
            $(this).val($(this).val().substring(0, maxLength));
            remaining = 0;
        }

        $('#metadesc-counter').text(remaining + ' characters remaining');
    });
});

//Delete Post
 function delete_post(id, name){
  var confirmation = confirm('Are you sure you want to delete '+ name +' post?');
  if(confirmation == true){
      window.location.href = base_url + ('administrator/posts/delete/')+ id;
  }
}

//Delete Block Post
function delete_block_post(id, name){
  var confirmation = confirm('Are you sure you want to delete '+ name +' post?');
  if(confirmation == true){
      window.location.href = base_url + ('administrator/posts/block-post/delete/')+ id;
  }
}
/**===============================================================
 * Delete Post Category
 =================================================================*/
 function delete_postCategory(id, name){
  var confirmation = confirm('Are you sure you want to delete '+ name +' page?');
  if(confirmation == true){
      window.location.href = base_url + ('administrator/posts/delete/')+ id;
  }
}


 /**===============================================================
 * POST COMMENTS
 =================================================================*/

  function add_postcomment(id)
  {
    save_method = 'add';
    var form = $('#comment-form')[0].reset();

    $("#comment_PostModal").modal("show");
    $(".modal-title").text("Add Comment!");
    $(".stbtn").text("Save Comment")
    
    $('[name="post_id"]').val(id);
  }

  function edit_postcomment(id)
  {
    save_method = "update";
    var form = $('#comment-form')[0].reset();

    $.ajax({
      url: base_url + 'administrator/posts/comment/edit/' + id,
      type: "GET",
      dataType: "JSON",
      success: function(data)
      {
        $('[name = "id"]').val(data.id);
        $('[name="post_id"]').val(data.post_id);
        $('[name="description"]').val(data.description);
        $('[name="user_id"]').val(data.user_id);

        $('#comment_PostModal').modal('show');
        $('.modal-title').text('Update Comment');
        $('.stbtn').text('Update'); 
      }
    })
  }

  function save_postcomment()
  {
    var form = $('#comment-form')[0];
    var url;
    if(save_method == 'add'){
      url = base_url + 'administrator/posts/comment/add'
    }else{
     url = base_url + 'administrator/posts/comment/update'
    }

    $.ajax({
      type: "post",
      url: url,
      data: new FormData(form),
      processData: false,
      contentType: false,
      headers: {'X-Requested-With': 'XMLHttpRequest'},
      success: function (data) {
        if (data.success == true) {
          $('#comment_PostModal').modal('hide');
          if(save_method == 'add')
            {
                toastr.success(data.msg);
            }else{
                toastr.info(data.msg);
            }
           $('#comment-form')[0].reset();
        } else {
            toastr.error(data.msg);
        }
        window.location.reload();
      },
      error: function (xhr, status, error) {
        console.error(xhr, status, error);
      }
    });
  }
  function delete_postcomment(id){
    var confirmation = confirm('Are you sure you want to delete this COMMENT');
    if(confirmation == true){
        window.location.href = base_url + ('administrator/posts/comment/delete/')+ id;
    }
  }