// Downloads module JS - delete category and download handling
$(document).ready(function() {
    
    // Event delegation for delete download links
    $(document).on('click', '.delete-download-link', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        var name = $(this).data('name');
        delete_downloads(id, name);
    });

    // Event delegation for delete category links
    $(document).on('click', '.delete-category-link', function(e) {
        e.preventDefault();
        var id = $(this).data('id');
        var name = $(this).data('name');
        deleteCategory(id, name);
    });

});

// Delete category function
function deleteCategory(id, name) {
    // show modal (Bootstrap 5 or jQuery fallback)
    var modalEl = document.getElementById('delCategoryModal');
    if (modalEl) {
        // set name in modal
        var $nameSpan = $('#catname');
        if ($nameSpan.length) $nameSpan.html(name);

        // use Bootstrap API if available
        if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
            var bs = bootstrap.Modal.getOrCreateInstance(modalEl);
            bs.show();
        } else {
            $('#delCategoryModal').modal('show');
        }
    }

    // bind one-time click handler to confirm button
    $('#del-Catbtn').off('click').one('click', function () {
        // prepare post data
        var postData = {};

        // prefer module/global csrf token name/value if present
        if (window.csrfTokenName && window.csrfTokenValue) {
            postData[window.csrfTokenName] = window.csrfTokenValue;
        } else if (typeof csrfToken !== 'undefined') {
            // fallback: include token in a common default field name (csrf_test_name) if server uses that
            postData['csrf_test_name'] = csrfToken;
        }

        // add extra payload if needed
        postData['id'] = id;

        // AJAX POST to delete endpoint
        // include CSRF both as a POST field (fallback) and as the X-CSRF-TOKEN header (preferred for AJAX)
        var headers = {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json, text/plain, */*'
        };
        if (window.csrfTokenValue) {
            headers['X-CSRF-TOKEN'] = window.csrfTokenValue;
        } else if (typeof csrfToken !== 'undefined') {
            headers['X-CSRF-TOKEN'] = csrfToken;
        }

        $.ajax({
            url: base_url + '/administrator/downloads/categories/delete/' + id,
            type: 'POST',
            data: postData,
            dataType: 'text', // accept text so we can handle debug HTML appended by CI debugbar
            headers: headers,
            success: function (text) {
                // Try to parse JSON out of the response body. Some debug/debugbar HTML
                // may be appended to the response which would break a strict JSON parse.
                var data = null;
                try {
                    data = JSON.parse(text);
                } catch (e) {
                    // Attempt to extract a JSON object between the first '{' and the last '}'
                    var start = text.indexOf('{');
                    var end = text.lastIndexOf('}');
                    if (start !== -1 && end !== -1 && end > start) {
                        try {
                            data = JSON.parse(text.substring(start, end + 1));
                        } catch (e2) {
                            data = null;
                        }
                    }
                }

                // Hide modal
                if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
                    var bs = bootstrap.Modal.getOrCreateInstance(modalEl);
                    bs.hide();
                } else {
                    $('#delCategoryModal').modal('hide');
                }

                if (data && data.msg) {
                    $('#showMsg').html('<div class="alert alert-success" role="alert">' + data.msg + '</div>');
                } else {
                    // If no JSON msg found, log debug output for diagnosis
                    console.warn('Delete response did not contain JSON msg. Response body:', text);
                }

                // redirect back to categories list or reload
                setTimeout(function () {
                    window.location.href = base_url + '/administrator/downloads/categories';
                }, 700);
            },
            error: function (xhr) {
                // Try to parse JSON from xhr.responseText (same tolerant strategy)
                var resp = xhr.responseText || '';
                var parsed = null;
                try { parsed = JSON.parse(resp); } catch (e) {
                    var s = resp.indexOf('{'), eidx = resp.lastIndexOf('}');
                    if (s !== -1 && eidx !== -1 && eidx > s) {
                        try { parsed = JSON.parse(resp.substring(s, eidx + 1)); } catch (e2) { parsed = null; }
                    }
                }
                if (parsed && parsed.msg) {
                    alert(parsed.msg);
                } else {
                    console.error('Delete failed, XHR:', xhr);
                    alert('Failed to delete category. See console for details.');
                }
            }
        });
    });
}

// Delete downloads function
function delete_downloads(id, name) {
    // show modal
    var modalEl = document.getElementById('delDownloadModal');
    if (modalEl) {
        // set name in modal
        var $nameSpan = $('#downloadname');
        if ($nameSpan.length) $nameSpan.html(name);

        // use Bootstrap API if available
        if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
            var bs = bootstrap.Modal.getOrCreateInstance(modalEl);
            bs.show();
        } else {
            $('#delDownloadModal').modal('show');
        }
    }

    // bind one-time click handler to confirm button
    $('#del-Downloadbtn').off('click').one('click', function () {
        // prepare post data
        var postData = {};

        // prefer module/global csrf token name/value if present
        if (window.csrfTokenName && window.csrfTokenValue) {
            postData[window.csrfTokenName] = window.csrfTokenValue;
        } else if (typeof csrfToken !== 'undefined') {
            // fallback: include token in a common default field name (csrf_test_name) if server uses that
            postData['csrf_test_name'] = csrfToken;
        }

        // add extra payload if needed
        postData['id'] = id;

        // AJAX POST to delete endpoint
        var headers = {
            'X-Requested-With': 'XMLHttpRequest',
            'Accept': 'application/json, text/plain, */*'
        };
        if (window.csrfTokenValue) {
            headers['X-CSRF-TOKEN'] = window.csrfTokenValue;
        } else if (typeof csrfToken !== 'undefined') {
            headers['X-CSRF-TOKEN'] = csrfToken;
        }

        $.ajax({
            url: base_url + '/administrator/downloads/delete/' + id,
            type: 'POST',
            data: postData,
            dataType: 'text',
            headers: headers,
            success: function (text) {
                // Try to parse JSON out of the response body
                var data = null;
                try {
                    data = JSON.parse(text);
                } catch (e) {
                    // Attempt to extract a JSON object between the first '{' and the last '}'
                    var start = text.indexOf('{');
                    var end = text.lastIndexOf('}');
                    if (start !== -1 && end !== -1 && end > start) {
                        try {
                            data = JSON.parse(text.substring(start, end + 1));
                        } catch (e2) {
                            data = null;
                        }
                    }
                }

                // Hide modal
                if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
                    var bs = bootstrap.Modal.getOrCreateInstance(modalEl);
                    bs.hide();
                } else {
                    $('#delDownloadModal').modal('hide');
                }

                if (data && data.msg) {
                    $('#showMsg').html('<div class="alert alert-success" role="alert">' + data.msg + '</div>');
                } else {
                    console.warn('Delete response did not contain JSON msg. Response body:', text);
                }

                // redirect back to downloads list or reload
                setTimeout(function () {
                    window.location.href = base_url + '/administrator/downloads';
                }, 700);
            },
            error: function (xhr) {
                // Try to parse JSON from xhr.responseText
                var resp = xhr.responseText || '';
                var parsed = null;
                try { parsed = JSON.parse(resp); } catch (e) {
                    var s = resp.indexOf('{'), eidx = resp.lastIndexOf('}');
                    if (s !== -1 && eidx !== -1 && eidx > s) {
                        try { parsed = JSON.parse(resp.substring(s, eidx + 1)); } catch (e2) { parsed = null; }
                    }
                }
                if (parsed && parsed.msg) {
                    alert(parsed.msg);
                } else {
                    console.error('Delete failed, XHR:', xhr);
                    alert('Failed to delete download. See console for details.');
                }
            }
        });
    });
}

// expose globally for inline handlers (backward compatibility)
window.deleteCategory = deleteCategory;
window.delete_downloads = delete_downloads;