<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>


<section  style="background: linear-gradient(90deg, rgba(25, 69, 157, 0.98), rgba(21, 57, 134, 0.1)), url('<?= $pg->photo; ?>') no-repeat center center; min-height: 400px;  background-size: cover;">
    <div class="overlay"></div>
    <div class="container intro-area">
        <div class="row align-items-end" style="height: 330px;">
            <div class="col-lg-6" data-aos="fade-up">
            <h2 class="text-white"><?= $pg->title;?></h2>
            <p class="text-white"><?= $pg->excerpt;?></p>
            </div>
            <div class="col-lg-6 d-none d-md-block"></div>
        </div>
    </div>
</section>

<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-8" data-aos="fade-up" data-aos-delay="250">
                <!-- Main Post Image -->
                <div class="post-featured-image mb-4">
                    <img src="<?= $pg->photo; ?>" alt="<?= $pg->title; ?>" class="img-fluid rounded shadow">
                </div>

                <!-- Post Meta Information -->
                <div class="post-meta mb-4 d-flex align-items-center gap-3">
                    <span class="badge bg-primary px-3 py-2">
                        <i class="fas fa-tag me-1"></i><?= $pg->category_name ?? 'Uncategorized'; ?>
                    </span>
                    <span class="text-muted">
                        <i class="fas fa-calendar-alt me-1"></i>
                        <?= date('F j, Y', strtotime($pg->created_at)); ?>
                    </span>
                    <?php if(isset($pg->first_name) && isset($pg->last_name)): ?>
                    <span class="text-muted">
                        <i class="fas fa-user me-1"></i>
                        By <?= $pg->first_name . ' ' . $pg->last_name; ?>
                    </span>
                    <?php endif; ?>
                </div>

                <!-- Post Content -->
                <div class="post-content">
                    <?php
                    // Process content to ensure proper image paths and HTML rendering
                    $content = $pg->content;

                    // If content is empty or null, show excerpt as fallback
                    if (empty(trim($content))) {
                        $content = '<p>' . ($pg->excerpt ?? 'No content available.') . '</p>';
                    }

                    // Ensure images have proper paths (if they use relative paths)
                    $content = preg_replace('/src="([^"]*uploads\/)/', 'src="' . base_url('uploads/'), $content);
                    $content = preg_replace("/src='([^']*uploads\/)/", "src='" . base_url('uploads/'), $content);

                    // Output the processed content
                    echo $content;
                    ?>
                </div>
            </div>

            <!-- Sidebar -->
            <div class="col-lg-4" data-aos="fade-up" data-aos-delay="250">
                <!-- Recent Posts Widget -->
                <div class="sidebar-widget mb-4">
                    <div class="widget-header mb-3">
                        <h4 class="widget-title mb-0">
                            <i class="fas fa-clock me-2 text-primary"></i>Recent Posts
                        </h4>
                    </div>
                    <div class="recent-posts">
                        <?php foreach($posts as $p): ?>
                        <div class="recent-post-item mb-3 pb-3 border-bottom">
                            <a href="<?= base_url('news').'/'.$p['alias']; ?>" class="text-decoration-none d-flex align-items-start">
                                <div class="post-thumbnail me-3 flex-shrink-0">
                                    <img src="<?= $p['photo']; ?>" alt="<?= $p['title']; ?>" class="rounded" width="80" height="60" style="object-fit: cover;">
                                </div>
                                <div class="post-info flex-grow-1">
                                    <h6 class="post-title mb-1 text-dark line-clamp-2 small">
                                        <?= $p['title']; ?>
                                    </h6>
                                    <small class="text-muted">
                                        <i class="fas fa-calendar-alt me-1"></i>
                                        <?= date('M j, Y', strtotime($p['created_at'])); ?>
                                    </small>
                                </div>
                            </a>
                        </div>
                        <?php endforeach;?>
                    </div>
                </div>

                <!-- Categories Widget -->
                <div class="sidebar-widget">
                    <div class="widget-header mb-3">
                        <h4 class="widget-title mb-0">
                            <i class="fas fa-tags me-2 text-primary"></i>Categories
                        </h4>
                    </div>
                    <div class="categories-list">
                        <?php
                        // Get categories for sidebar
                        foreach($categories as $category):
                            if($category['post_count'] > 0):
                        ?>
                        <a href="<?= base_url('news?category=' . $category['id']); ?>" class="category-link d-flex justify-content-between align-items-center py-2 px-3 mb-2 rounded text-decoration-none">
                            <span class="category-name"><?= $category['name']; ?></span>
                            <span class="badge bg-light text-dark"><?= $category['post_count']; ?></span>
                        </a>
                        <?php
                            endif;
                        endforeach;
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<?= $this->endSection() ?>

