<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<section class="py-5">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <!-- Category Filter -->
                <div class="category-filter mb-4">
                    <div class="d-flex flex-wrap align-items-center gap-3">
                        <h5 class="mb-0 me-3">Filter by Category:</h5>
                        <a href="<?= base_url('news'); ?>" class="btn btn-outline-primary <?= !$currentCategory ? 'active' : ''; ?>">
                            All Posts
                        </a>
                        <?php foreach($categories as $category): ?>
                            <?php if($category['post_count'] > 0): ?>
                                <a href="<?= base_url('news?category=' . $category['id']); ?>" class="btn btn-outline-primary <?= $currentCategory == $category['id'] ? 'active' : ''; ?>">
                                    <?= $category['name']; ?> (<?= $category['post_count']; ?>)
                                </a>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>

                <div class="row mt-3">
                    <?php foreach($posts as $acct): ?>
                    <div class="col-lg-4 col-md-6 col-12 mb-4"> <!-- Changed from col-md-4 to col-lg-4 col-md-6 -->
                        <a href="<?= base_url('news').'/'.$acct['alias']; ?>" class="text-decoration-none">
                        <div class="card card-body p-0 border border-0 shadow-sm mb-3 other-loans h-100" data-aos="fade-up" style="min-height: 480px;"> <!-- Added h-100 and min-height -->
                            <img src="<?= $acct['photo']; ?>" class="img-fluid w-100" alt="<?= $acct['title']; ?>" style="height: 220px; object-fit: cover;"> <!-- Increased image height and added object-fit -->
                            <div class="p-3 d-flex flex-column flex-grow-1"> <!-- Added flex classes -->
                                <h5 class="card-title"><?= $acct['title']; ?></h5>
                                <div class="card-meta mb-2">
                                    <span class="cat"><?= $acct['category_name']; ?></span> 
                                    &nbsp;&nbsp; 
                                    <small class="post_created">
                                        <i class="fas fa-calendar-alt me-1"></i>
                                        <?= date('jS M Y', strtotime($acct['created_at'])); ?>
                                    </small>
                                </div>
                                <p class="text-dark py-2 card-excerpt flex-grow-1"><?= $acct['excerpt']; ?></p> <!-- Added flex-grow-1 -->
                                <div class="mt-auto"> <!-- Added mt-auto to push read more to bottom -->
                                    <span class="read-more-link">Read More...</span>
                                </div>
                            </div>
                        </div>
                        </a>
                    </div>
                    <?php endforeach; ?>
                </div>

                <!-- Pagination -->
                <?php if(isset($pager) && $pager->getPageCount() > 1): ?>
                <div class="pagination-wrapper mt-5">
                    <nav aria-label="News pagination">
                        <ul class="pagination justify-content-center">
                            <?php if($pager->hasPrevious()): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?= $pager->getPreviousPage(); ?>" aria-label="Previous">
                                        <span aria-hidden="true">&laquo;</span>
                                    </a>
                                </li>
                            <?php endif; ?>

                            <?php foreach($pager->links() as $link): ?>
                                <li class="page-item <?= $link['active'] ? 'active' : ''; ?>">
                                    <a class="page-link" href="<?= $link['uri']; ?>">
                                        <?= $link['title']; ?>
                                    </a>
                                </li>
                            <?php endforeach; ?>

                            <?php if($pager->hasNext()): ?>
                                <li class="page-item">
                                    <a class="page-link" href="<?= $pager->getNextPage(); ?>" aria-label="Next">
                                        <span aria-hidden="true">&raquo;</span>
                                    </a>
                                </li>
                            <?php endif; ?>
                        </ul>
                    </nav>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</section>

<?= $this->endSection() ?>