<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized( $hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Team Section -->
<section class="team-section" id="team">
    <div class="container">
        <?php if(!empty($templateData['team_title'])): ?>
            <h2 class="section-title"><?= renderEmphasized(
                $templateData['team_title'],
                $templateData['team_title_emphasized'] ?? null
            ) ?></h2>
        <?php endif; ?>
        
        <?php if(!empty($templateData['team_description'])): ?>
            <p class="team-description"><?= esc($templateData['team_description']) ?></p>
        <?php endif; ?>
        
        

      

        <?php if (!empty($templateData['team_members_management'])): ?>
            <div class="team-grid management-team">
                <?php foreach ($templateData['team_members_management'] as $member): ?>
                    <div class="team-card">
                        <div class="card-image">
                            <?php
                                $img = $member['image'] ?? '';
                                $imgSrc = (strpos($img, 'http') === 0 || strpos($img, '//') === 0) ? $img : ($img ? base_url('media/files/' . $img) : base_url('assets/images/default-avatar.jpg'));
                            ?>
                            <img src="<?= esc($imgSrc) ?>" alt="<?= esc($member['name']) ?>">
                            <div class="card-gradient"></div>
                        </div>
                        <div class="card-content">
                            <h3 class="card-name"><?= esc($member['name']) ?></h3>
                            <p class="card-title"><?= esc($member['position']) ?></p>
                            <?php if(!empty($member['modal_id'])): ?>
                                <?php
                                    // Ensure we always emit a numeric member id for the frontend JS.
                                    $mId = isset($member['id']) ? $member['id'] : null;
                                    if (empty($mId) && !empty($member['modal_id'])) {
                                        if (preg_match('/(\d+)/', $member['modal_id'], $pm)) {
                                            $mId = $pm[1];
                                        }
                                    }
                                ?>
                                <button class="card-button btn btn-outline-primary" data-modal="<?= esc($member['modal_id']) ?>" data-member-id="<?= esc($mId) ?>">Full Profile</button>
                            <?php endif; ?>
                        </div>
                                        </div>

                                        <!-- Inline modal for this management member -->
                                        <?php if (!empty($member['modal_id'])): ?>
                                                <div id="<?= esc($member['modal_id']) ?>" class="modal" aria-hidden="true" style="display:none;">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h2 class="modal-title"><?= esc($member['name']) ?></h2>
                                                            <button class="close-modal" aria-label="Close">&times;</button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="profile-main">
                                                                <div class="profile-image">
                                                                    <?php $img = $member['image'] ?? ''; $imgSrc = (strpos($img, 'http') === 0 || strpos($img, '//') === 0) ? $img : ($img ? base_url('media/files/' . $img) : base_url('assets/images/default-avatar.jpg')); ?>
                                                                    <img src="<?= esc($imgSrc) ?>" alt="<?= esc($member['name']) ?>">
                                                                </div>
                                                                <div class="profile-info">
                                                                    <h2 class="profile-name"><?= esc($member['name']) ?></h2>
                                                                    <p class="profile-role"><?= esc($member['position']) ?></p>
                                                                    <?php if(!empty($member['excerpt'])): ?>
                                                                        <p class="profile-bio"><?= esc($member['excerpt']) ?></p>
                                                                    <?php elseif(!empty($member['content'])): ?>
                                                                        <p class="profile-bio"><?= esc(strip_tags($member['content'])) ?></p>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                        <?php endif; ?>

                                <?php endforeach; ?>
                        </div>
        <?php endif; ?>

        <?php if (!empty($templateData['team_members_board'])): ?>
            <div class="team-grid board-of-directors">
                <?php foreach ($templateData['team_members_board'] as $member): ?>
                    <div class="team-card">
                        <div class="card-image">
                            <?php
                                $img = $member['image'] ?? '';
                                $imgSrc = (strpos($img, 'http') === 0 || strpos($img, '//') === 0) ? $img : ($img ? base_url('media/files/' . $img) : base_url('assets/images/default-avatar.jpg'));
                            ?>
                            <img src="<?= esc($imgSrc) ?>" alt="<?= esc($member['name']) ?>">
                            <div class="card-gradient"></div>
                        </div>
                        <div class="card-content">
                            <h3 class="card-name"><?= esc($member['name']) ?></h3>
                            <p class="card-title"><?= esc($member['position']) ?></p>
                            <?php if(!empty($member['modal_id'])): ?>
                                <?php
                                    $mId = isset($member['id']) ? $member['id'] : null;
                                    if (empty($mId) && !empty($member['modal_id'])) {
                                        if (preg_match('/(\d+)/', $member['modal_id'], $pm)) {
                                            $mId = $pm[1];
                                        }
                                    }
                                ?>
                                <button class="card-button btn btn-outline-primary" data-modal="<?= esc($member['modal_id']) ?>" data-member-id="<?= esc($mId) ?>">Full Profile</button>
                            <?php endif; ?>
                        </div>
                                        </div>

                                        <!-- Inline modal for this board member -->
                                        <?php if (!empty($member['modal_id'])): ?>
                                                <div id="<?= esc($member['modal_id']) ?>" class="modal" aria-hidden="true" style="display:none;">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h2 class="modal-title"><?= esc($member['name']) ?></h2>
                                                            <button class="close-modal" aria-label="Close">&times;</button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="profile-main">
                                                                <div class="profile-image">
                                                                    <?php $img = $member['image'] ?? ''; $imgSrc = (strpos($img, 'http') === 0 || strpos($img, '//') === 0) ? $img : ($img ? base_url('media/files/' . $img) : base_url('assets/images/default-avatar.jpg')); ?>
                                                                    <img src="<?= esc($imgSrc) ?>" alt="<?= esc($member['name']) ?>">
                                                                </div>
                                                                <div class="profile-info">
                                                                    <h2 class="profile-name"><?= esc($member['name']) ?></h2>
                                                                    <p class="profile-role"><?= esc($member['position']) ?></p>
                                                                    <?php if(!empty($member['excerpt'])): ?>
                                                                        <p class="profile-bio"><?= esc($member['excerpt']) ?></p>
                                                                    <?php elseif(!empty($member['content'])): ?>
                                                                        <p class="profile-bio"><?= esc(strip_tags($member['content'])) ?></p>
                                                                    <?php endif; ?>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                        <?php endif; ?>

                                <?php endforeach; ?>
                        </div>
        <?php endif; ?>
        

        <!-- Member modals -->
        <?php
            // Collect unique members from groups to render modals (include current group names)
            $allMembers = [];
            foreach (['team_members_all','team_members_board','team_members_management'] as $g) {
                if (!empty($templateData[$g])) {
                    foreach ($templateData[$g] as $m) {
                        // Ensure modal_id exists
                        if (!empty($m['modal_id'])) {
                            $allMembers[$m['modal_id']] = $m;
                        }
                    }
                }
            }
        ?>

        

        <!-- Modal and gradient styles are expected to be in your external CSS. This template only outputs classed HTML. -->

        <!-- Inline modal CSS to ensure overlay sits above navbar and other content -->
        <style>
            /* Scope to team section so we don't affect other pages */
            .team-section .modal {
                position: fixed;
                inset: 0; /* top:0; right:0; bottom:0; left:0; */
                display: none;
                align-items: center;
                justify-content: center;
                background: rgba(0,0,0,0.6);
                z-index: 99999; /* very high to be above navbars/toolbars */
                padding: 20px;
            }

            .team-section .modal.open,
            .team-section .modal.active,
            .team-section .modal.show,
            .team-section .modal[aria-hidden="false"] {
                display: flex !important;
            }

            .team-section .modal .modal-content {
                background: #fff;
                border-radius: 8px;
                max-width: 900px;
                width: 100%;
                max-height: 90vh;
                overflow-y: auto;
                position: relative;
                z-index: 100000;
                box-shadow: 0 20px 40px rgba(0,0,0,0.3);
                padding: 20px;
            }

            .team-section .modal .close-modal {
                position: absolute;
                top: 48px; /* moved down slightly from 10px */
                right: 48px;
                background: transparent;
                border: 0;
                font-size: 28px;
                line-height: 1;
                cursor: pointer;
            }
        </style>

        <script>
            // Base URL for AJAX calls (includes app subfolder if any)
            var siteBase = '<?= rtrim(base_url(), '/') ?>';
            // Robust modal behavior: delegated open/close, aria attributes, and display toggles
            (function(){
                var section = document.querySelector('.team-section');
                var root = section || document;

                // Use delegated click handling on the nearest scope (section when available)
                root.addEventListener('click', function(e){
                    try {
                        // Open modal when clicking any element with data-modal (delegated)
                        var btn = e.target.closest && e.target.closest('[data-modal]');
                            if (btn && (!section || section.contains(btn))){
                            var id = btn.getAttribute('data-modal');
                            if (!id) return;
                            var selector = id.charAt(0) === '#' ? id : ('#' + id);
                            var modal = document.querySelector(selector);
                            if (!modal) {
                                console && console.warn && console.warn('Modal not found for', selector);
                                return;
                            }
                            // Remove focus from the triggering element to avoid aria-hidden warnings
                            try {
                                if (document.activeElement && document.activeElement !== document.body) {
                                    document.activeElement.blur && document.activeElement.blur();
                                }
                            } catch (ignore) {}
                            modal.classList.add('open','active','show');
                            modal.setAttribute('aria-hidden','false');
                            // ensure visible if CSS hides by default
                            modal.style.display = 'block';
                            // If the button had a member id, call the hit increment endpoint
                            try {
                                var memberId = btn.getAttribute('data-member-id') || btn.dataset.memberId;
                                // Fallback: try to extract numeric id from modal id (e.g. teamModal-123)
                                if (!memberId) {
                                    var mid = id.replace(/^#/, '');
                                    var parts = mid.split(/-|_/);
                                    for (var i = parts.length - 1; i >= 0; i--) {
                                        if (/^\d+$/.test(parts[i])) { memberId = parts[i]; break; }
                                    }
                                }

                                if (memberId) {
                                    // Prevent duplicate increments by marking the button
                                    if (btn.dataset._hit) {
                                        console && console.debug && console.debug('Hit already fired for', memberId);
                                    } else {
                                        btn.dataset._hit = '1';
                                        console && console.debug && console.debug('Team modal open - increment hit for member', memberId);
                                        // Call the front endpoint to increment hits; fire-and-forget
                                        fetch(siteBase + '/team/hit/' + encodeURIComponent(memberId), { method: 'GET', credentials: 'same-origin' })
                                            .then(function(res){ /* ignore response */ })
                                            .catch(function(err){ console && console.warn && console.warn('Hit increment failed', err); });
                                    }
                                } else {
                                    console && console.debug && console.debug('Team modal open - no memberId found for', id);
                                }
                            } catch (e) {
                                console && console.warn && console.warn('Hit increment error', e);
                            }
                            // focus first focusable element for accessibility
                            var focusable = modal.querySelector('button, [href], input, select, textarea, [tabindex]');
                            if (focusable) focusable.focus();
                            return;
                        }

                        // Close when clicking the close button
                        if (e.target.matches && e.target.matches('.close-modal')){
                            var modal = e.target.closest('.modal');
                            if (modal) {
                                modal.classList.remove('open','active','show');
                                modal.setAttribute('aria-hidden','true');
                                modal.style.display = '';
                            }
                            return;
                        }

                        // Close when clicking the modal backdrop (ensure exact target is the modal overlay)
                        if (e.target.classList && e.target.classList.contains('modal')){
                            var modal = e.target;
                            modal.classList.remove('open','active','show');
                            modal.setAttribute('aria-hidden','true');
                            modal.style.display = '';
                        }
                    } catch (err) {
                        console && console.error && console.error('Modal handler error:', err);
                    }
                });

                // ESC to close any open modal (global)
                document.addEventListener('keydown', function(e){
                    if (e.key === 'Escape' || e.key === 'Esc'){
                        document.querySelectorAll('.modal.open, .modal.active, .modal.show').forEach(function(m){
                            m.classList.remove('open','active','show');
                            m.setAttribute('aria-hidden','true');
                            m.style.display = '';
                        });
                    }
                });
            })();

            // Helper: increment team member hit via fetch (fire-and-forget). Separated so we can reuse it.
            function incrementTeamHit(memberId, modalId) {
                try {
                    if (!memberId) {
                        console && console.debug && console.debug('incrementTeamHit: no memberId for modal', modalId);
                        return;
                    }
                    console && console.debug && console.debug('incrementTeamHit: calling hit endpoint for', memberId);
                    fetch(siteBase + '/team/hit/' + encodeURIComponent(memberId), { method: 'GET', credentials: 'same-origin' })
                        .then(function(res){ /* no-op */ })
                        .catch(function(err){ console && console.warn && console.warn('Hit increment failed', err); });
                } catch (err) {
                    console && console.warn && console.warn('incrementTeamHit error', err);
                }
            }

            // Backup: attach direct click listeners to any [data-modal] buttons in case delegated handler doesn't run
            try {
                document.querySelectorAll('[data-modal]').forEach(function(btn){
                    btn.addEventListener('click', function(e){
                        try {
                            // Skip if delegated handler already fired and marked this button
                            if (btn.dataset._hit) return;
                            var memberId = btn.getAttribute('data-member-id') || btn.dataset.memberId;
                            var id = btn.getAttribute('data-modal') || btn.dataset.modal;
                            if (!memberId && id) {
                                var mid = (id.charAt(0) === '#') ? id.slice(1) : id;
                                var parts = mid.split(/-|_/);
                                for (var i = parts.length - 1; i >= 0; i--) {
                                    if (/^\d+$/.test(parts[i])) { memberId = parts[i]; break; }
                                }
                            }
                            // Mark it so the delegated handler (or this backup) won't double-fire
                            btn.dataset._hit = '1';
                            incrementTeamHit(memberId, id);
                        } catch (e) {
                            console && console.warn && console.warn('data-modal click listener error', e);
                        }
                    });
                });
            } catch (e) {
                console && console.warn && console.warn('Failed to attach backup data-modal listeners', e);
            }
        </script>
    </div>
</section>

<!-- Additional Content -->
<?php if(isset($templateData['additional_content'])): ?>
<section class="additional-content">
    <div class="container">
        <?= $templateData['additional_content'] ?>
    </div>
</section>
<?php endif; ?>

<?= $this->endSection(); ?>