<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized( $hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Overview Section with Side Image -->
<section class="overview-section-image">
    <div class="container">
        <div class="side-image-layout">
            <!-- Content Side -->
            <div class="content-side">
                <h2><?= renderEmphasized(
                    $templateData['overview_title'] ?? 'What is this Account?',
                    $templateData['overview_title_emphasized'] ?? null
                ) ?></h2>
                <p><?= $templateData['overview_content'] ?? $page['content'] ?></p>
                
                <?php if (!empty($templateData['info_cards'])): ?>
                <div class="info-cards-grid">
                    <?php foreach ($templateData['info_cards'] as $item): ?>
                    <div class="info-card">
                        <div class="info-card-icon">
                            <i class="<?= esc($item['icon']) ?>"></i>
                        </div>
                        <h3><?= esc($item['title']) ?></h3>
                        <p><?= esc($item['description']) ?></p>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>
            </div>
            
            <!-- Image Side - Dynamic -->
            <div class="image-side">
                <img src="<?= isset($templateData['overview_image']) ? base_url('media/files/' . $templateData['overview_image']) : base_url('media/files/safe.jpg') ?>">
            </div>
        </div>
    </div>
</section>

<!-- Combined Qualifications Section -->
<?php if(isset($templateData['qualifications']) || isset($templateData['visual'])): ?>
<section class="qualifications-section show">
    <div class="container">
        <div class="section-header">
            <h2><?= renderEmphasized(
                $templateData['qualifications']['title'] ?? 'Eligibility Requirements',
                $templateData['qualifications']['title_emphasized'] ?? 'Requirements'
            ) ?></h2>
            <p><?= esc($templateData['qualifications']['description'] ?? '') ?></p>
        </div>
        
        <div class="qualifications-content">
            <?php if(isset($templateData['qualifications']) && !empty($templateData['qualifications']['items'])): ?>
            <div class="qualifications-list">
                <?php foreach($templateData['qualifications']['items'] as $index => $item): ?>
                <div class="qualification-item">
                    <div class="qualification-number"><?= $index + 1 ?></div>
                    <div class="qualification-details">
                        <h3><?= esc($item['title']) ?></h3>
                        <?php if(!empty($item['description'])): ?>
                            <p><?= esc($item['description']) ?></p>
                        <?php endif; ?>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
            <?php endif; ?>

            <?php if(isset($templateData['visual'])): ?>
            <div class="qualifications-visual">
                <?php $visual = $templateData['visual']; ?>
                <?php if (!empty($visual['balance']['bars'])): ?>
                <div class="balance-visualization">
                    <?php if (!empty($visual['balance']['title'])): ?>
                        <h3><?= esc($visual['balance']['title']) ?></h3>
                    <?php endif; ?>
                    <?php foreach ($visual['balance']['bars'] as $bar): ?>
                    <div class="balance-bar show">
                        <?php if (!empty($bar['label'])): ?>
                            <div class="bar-label"><?= esc($bar['label']) ?></div>
                        <?php endif; ?>
                        <div class="bar-container">
                            <div class="bar <?= esc($bar['class'] ?? '') ?>" data-width="<?= esc($bar['width'] ?? '0%') ?>" style="width: 0"><?= esc($bar['text'] ?? '') ?></div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <?php if (!empty($visual['interest']['items'])): ?>
                <div class="interest-comparison">
                    <?php if (!empty($visual['interest']['title'])): ?>
                        <h3><?= esc($visual['interest']['title']) ?></h3>
                    <?php endif; ?>
                    <div class="interest-visual">
                        <?php foreach ($visual['interest']['items'] as $i => $it): ?>
                            <div class="interest-item <?= esc($it['class'] ?? '') ?>">
                                <?php if (!empty($it['label'])): ?><div class="interest-type"><?= esc($it['label']) ?></div><?php endif; ?>
                                <?php if (!empty($it['rate'])): ?><div class="interest-rate"><?= esc($it['rate']) ?></div><?php endif; ?>
                            </div>
                            <?php if ($i < count($visual['interest']['items']) - 1): ?>
                                <div class="interest-arrow">
                                    <i class="fas fa-long-arrow-alt-right"></i>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                    <?php if (!empty($visual['interest']['note'])): ?>
                        <p class="interest-note"><?= esc($visual['interest']['note']) ?></p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>
            <?php endif; ?>
        </div>
    </div>
</section>

<!-- Add animation script -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Add animation for bars
    const bars = document.querySelectorAll('.bar');
    bars.forEach(bar => {
        const targetWidth = bar.getAttribute('data-width');
        setTimeout(() => {
            bar.style.width = targetWidth;
        }, 500);
    });
});
</script>
<?php endif; ?>
<?= $this->endSection(); ?>



