<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img 
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>" 
        alt="<?= esc($hero_banner['name']) ?>" 
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Saving Products Grid -->
<?php if (!empty($saving_products)): ?>
<section class="cards-container" style="margin:45px ;">
    <?php foreach ($saving_products as $product): ?>
    <div class="banking-card">
        <div class="card-image">
            <img src="<?= !empty($product['photo']) ? base_url('media/files/' . $product['photo']) : 'https://images.unsplash.com/photo-1454165804606-c3d57bc86b40?auto=format&fit=crop&w=1170&q=80' ?>" 
                 alt="<?= esc($product['title']) ?>">
            <div class="card-category">Savings</div>
            <div class="card-overlay">
                <h3 class="card-title"><?= esc($product['title']) ?></h3>
                <a href="<?= site_url('personal/' . $product['alias']) ?>" class="card-button">Learn More</a>
            </div>
        </div>
    </div>
    <?php endforeach; ?>
</section>
<?php endif; ?>

<?= $this->endSection() ?>