<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Requirements Section -->
<?php if (!empty($templateData['requirements']['items'])): ?>
<section class="requirements-section" id="requirements">
    <div class="container">
        <div class="requirements-tabs">
            <div class="tab-headers">
                <?php
                $accountTypes = [
                    'savings_requirement' => 'Savings Account',
                    'current_requirement' => 'Current Account', 
                    'foreign_requirement' => 'Foreign Currency',
                    'student_requirement' => 'Student Account'
                ];
                
                $first = true;
                foreach ($accountTypes as $type => $label): 
                    $hasItems = false;
                    foreach ($templateData['requirements']['items'] as $item) {
                        if ($item['account_type'] === $type) {
                            $hasItems = true;
                            break;
                        }
                    }
                    if ($hasItems):
                ?>
                    <button class="tab-header <?= $first ? 'active' : '' ?>" data-tab="<?= $type ?>">
                        <?= $label ?>
                    </button>
                <?php 
                        $first = false;
                    endif;
                endforeach; 
                ?>
            </div>
            
            <?php
            $first = true;
            foreach ($accountTypes as $type => $label): 
                $hasItems = false;
                $typeItems = [];
                foreach ($templateData['requirements']['items'] as $item) {
                    if ($item['account_type'] === $type) {
                        $hasItems = true;
                        $typeItems[] = $item;
                    }
                }
                if ($hasItems):
            ?>
                <div class="tab-content <?= $first ? 'active' : '' ?>" id="<?= $type ?>">
                    <h3><?= $label ?> Requirements</h3>
                    <div class="requirements-list">
                        <?php foreach ($typeItems as $item): ?>
                            <div class="requirement">
                                <i class="fas fa-check-circle"></i>
                                <span><?= esc($item['description']) ?></span>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php 
                    $first = false;
                endif;
            endforeach; 
            ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Application Options Section -->
<?php if (!empty($templateData['application_methods']['items'])): ?>
<section class="application-options-section">
    <div class="container">
        <div class="section-header">
            <h2><?= esc($templateData['application_methods']['title']) ?></h2>
            <p><?= esc($templateData['application_methods']['subtitle']) ?></p>
        </div>
        
        <div class="application-methods">
            <?php foreach ($templateData['application_methods']['items'] as $method): ?>
                <div class="application-method">
                    <?php if (!empty($method['icon'])): ?>
                    <div class="method-icon">
                        <i class="<?= esc($method['icon']) ?>"></i>
                    </div>
                    <?php endif; ?>
                    <h3><?= esc($method['title']) ?></h3>
                    <p><?= esc($method['description']) ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<!-- FAQ Section -->
<?php if (!empty($templateData['faq']['items'])): ?>
<section class="faq-section">
    <div class="container">
        <div class="section-header">
            <h2><?= esc($templateData['faq']['title']) ?></h2>
            <p><?= esc($templateData['faq']['subtitle']) ?></p>
        </div>
        
        <div class="faq-container">
            <?php foreach ($templateData['faq']['items'] as $faq): ?>
                <div class="faq-item">
                    <div class="faq-question">
                        <h3><?= esc($faq['question']) ?></h3>
                        <i class="fas fa-chevron-down"></i>
                    </div>
                    <div class="faq-answer">
                        <p><?= esc($faq['answer']) ?></p>
                    </div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<?= $this->endSection() ?>