<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized( $hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Features Section -->
<?php if(isset($templateData['feature_highlights'])): ?>
<section class="features-section">
    <div class="container">
        <div class="features-content">
            <div class="features-image">
                <img src="<?= isset($templateData['overview_image']) ? base_url('media/files/' . $templateData['overview_image']) : base_url('media/files/safe.jpg') ?>"
                     alt="<?= esc($page['title']) ?>"
                     style="width:100%; height:650px; object-fit:cover; border-radius:8px;">
            </div>
            
            <div class="features-details">
                <h2 class="section-title">Key <span>Features</span></h2>
                
                <ul class="features-list">
                    <?php foreach($templateData['feature_highlights'] as $feature): ?>
                        <li><i class="<?= $feature['icon'] ?? 'fas fa-check-circle' ?>"></i> <?= $feature['text'] ?? $feature['title'] ?? '' ?></li>
                    <?php endforeach; ?>
                </ul>
                
                <a href="#" class="btn btn-primary" style="margin-top: 30px;">Apply for Loan</a>
            </div>
        </div>
    </div>
</section>
<?php endif; ?>
<!-- How It Works -->
<section class="process-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title" style="color: white;">How It <span style="color: #87CEEB;">Works</span></h2>
            <p class="section-subtitle" style="color: rgba(255,255,255,0.9);"><?= $templateData['process_subtitle'] ?? 'A simple process to help you get financial support when you need it' ?></p>
        </div>

        <div class="process-container">
            <?php if(isset($templateData['process_steps'])): ?>
                <?php foreach($templateData['process_steps'] as $index => $step): ?>
                    <div class="process-step">
                        <div class="step-number"><?= $index + 1 ?></div>
                        <h3 class="step-title"><?= $step['title'] ?? '' ?></h3>
                        <p><?= $step['description'] ?? '' ?></p>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div><p style="color: white;">No process steps defined.</p></div>

            <?php endif; ?>
        </div>
    </div>
</section>

<!-- Benefits Section -->
<?php if(isset($templateData['benefits'])): ?>
<section class="benefits-section">
    <div class="container">
        <div class="section-header">
            <h2 class="section-title">Why Choose Our <span><?= esc($page['title']) ?></span></h2>
            <p class="section-subtitle"><?= $templateData['benefits_subtitle'] ?? 'Convenient solutions to support your personal and family needs' ?></p>
        </div>
        
        <div class="benefits-grid">
            <?php foreach($templateData['benefits']['items'] as $benefit): ?>
                <div class="benefit-card">
                    <div class="benefit-icon">
                        <i class="<?= $benefit['icon'] ?? 'fas fa-star' ?>"></i>
                    </div>
                    <h3 class="benefit-title"><?= $benefit['title'] ?? '' ?></h3>
                    <p class="benefit-desc"><?= $benefit['description'] ?? '' ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>
<?php endif; ?>

<?= $this->endSection(); ?>