<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img 
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>" 
        alt="<?= esc($hero_banner['name']) ?>" 
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Loan Calculator Section -->
<section class="loan-calculator-section" id="calculator">
    <div class="container">
        <div class="calculator-container">
            <div class="calculator-form">
                <div class="form-row">
                    <div class="form-group">
                        <label for="loan-amount">Loan Amount (UGX)</label>
                        <input type="number" id="loan-amount" min="100000" max="1000000000" step="100000" value="5000000">
                        <input type="range" id="loan-amount-range" min="100000" max="1000000000" step="100000" value="5000000">
                    </div>
                    
                    <div class="form-group">
                        <label for="loan-term">Loan Term (Months)</label>
                        <input type="number" id="loan-term" min="6" max="240" step="6" value="36">
                        <input type="range" id="loan-term-range" min="6" max="240" step="6" value="36">
                    </div>
                </div>
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="interest-rate">Interest Rate (% per annum)</label>
                        <input type="number" id="interest-rate" min="1" max="30" step="0.1" value="15">
                        <input type="range" id="interest-rate-range" min="1" max="30" step="0.1" value="15">
                    </div>
                    
                    <div class="form-group">
                        <label for="loan-type">Loan Type</label>
                        <select id="loan-type">
                            <option value="personal">Personal Loan</option>
                            <option value="mortgage">Mortgage Loan</option>
                            <option value="business">Business Loan</option>
                            <option value="education">Education Loan</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                </div>
                
                <div class="form-submit">
                    <button type="button" id="calculate-btn" class="btn btn-primary">Calculate</button>
                    <button type="button" id="reset-btn" class="btn btn-secondary">Reset</button>
                </div>
            </div>
            
            <div class="calculator-results">
                <h3>Loan Summary</h3>
                
                <div class="result-cards">
                    <div class="result-card">
                        <div class="result-icon">
                            <i class="fas fa-calendar-check"></i>
                        </div>
                        <div class="result-content">
                            <h4>Monthly Payment</h4>
                            <div class="result-value" id="monthly-payment">UGX 0</div>
                        </div>
                    </div>
                    
                    <div class="result-card">
                        <div class="result-icon">
                            <i class="fas fa-money-bill-wave"></i>
                        </div>
                        <div class="result-content">
                            <h4>Total Payment</h4>
                            <div class="result-value" id="total-payment">UGX 0</div>
                        </div>
                    </div>
                    
                    <div class="result-card">
                        <div class="result-icon">
                            <i class="fas fa-percentage"></i>
                        </div>
                        <div class="result-content">
                            <h4>Total Interest</h4>
                            <div class="result-value" id="total-interest">UGX 0</div>
                        </div>
                    </div>
                </div>
                
                <div class="amortization-table" id="amortization-table" style="display: none;">
                    <h4>Payment Schedule</h4>
                    <div class="table-container">
                        <table>
                            <thead>
                                <tr>
                                    <th>Month</th>
                                    <th>Payment</th>
                                    <th>Principal</th>
                                    <th>Interest</th>
                                    <th>Balance</th>
                                </tr>
                            </thead>
                            <tbody id="amortization-body">
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>



<?= $this->endSection() ?>