<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<!-- Hero Section - Using Banner -->
<?php if (!empty($hero_banner)): ?>
<section class="hero-section">
    <img
        src="<?= base_url('media/files/' . $hero_banner['photo']) ?>"
        alt="<?= esc($hero_banner['name']) ?>"
        class="hero-bg"
    >
    <div class="container hero-content">
        <h1><?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?></h1>
        <p><?= esc($hero_banner['description']) ?></p>
        <div class="cta-buttons">
        </div>
    </div>
</section>
<?php endif; ?>

<!-- Governance Content -->
<section class="governance-content">
    <div class="container">
        
        <!-- Respective Responsibilities -->
        <?php if(!empty($templateData['responsibilities'])): ?>
        <h2 class="section-title"><?= renderEmphasized(
            $templateData['responsibilities']['title'] ?? 'Respective Responsibilities',
            $templateData['responsibilities']['title_emphasized'] ?? 'Responsibilities'
        ) ?></h2>
        
        <div class="responsibilities-section">
            <?php if(isset($templateData['responsibilities']['items'][0])): ?>
            <div class="responsibility-card">
                <h3><i class="<?= esc($templateData['responsibilities']['items'][0]['icon'] ?? 'fas fa-star') ?>"></i> <?= esc($templateData['responsibilities']['items'][0]['title']) ?></h3>
                <p><?= esc($templateData['responsibilities']['items'][0]['description']) ?></p>
            </div>
            <?php endif; ?>
            
            <?php if(isset($templateData['responsibilities']['items'][1])): ?>
            <div class="responsibility-card">
                <h3><i class="<?= esc($templateData['responsibilities']['items'][1]['icon'] ?? 'fas fa-star') ?>"></i> <?= esc($templateData['responsibilities']['items'][1]['title']) ?></h3>
                <p><?= esc($templateData['responsibilities']['items'][1]['description']) ?></p>
            </div>
            <?php endif; ?>
        </div>
        <?php endif; ?>
        
        <!-- Board of Directors -->
        <?php if(!empty($templateData['board_directors'])): ?>
        <h2 class="section-title"><?= renderEmphasized(
            $templateData['board_directors']['title'] ?? 'Board of Directors',
            $templateData['board_directors']['title_emphasized'] ?? 'Directors'
        ) ?></h2>
        
        <div class="board-section">
            <div class="board-info">
                <?php if(!empty($templateData['board_directors']['content'])): ?>
                    <?php 
                    // Convert line breaks to paragraphs
                    $paragraphs = preg_split('/\r\n|\r|\n/', $templateData['board_directors']['content']);
                    foreach ($paragraphs as $paragraph) {
                        if (trim($paragraph) !== '') {
                            echo '<p>' . esc($paragraph) . '</p>';
                        }
                    }
                    ?>
                <?php endif; ?>
            </div>
            
            <div class="board-highlights">
                <?php if(!empty($templateData['board_directors']['highlights'])): ?>
                    <?php foreach($templateData['board_directors']['highlights'] as $highlight): ?>
                    <div class="highlight-item">
                        <div class="highlight-icon">
                            <i class="<?= esc($highlight['icon'] ?? 'fas fa-star') ?>"></i>
                        </div>
                        <h4><?= esc($highlight['title']) ?></h4>
                        <p><?= esc($highlight['description']) ?></p>
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
        
        <!-- Governance Principles -->
        <?php if(!empty($templateData['principles'])): ?>
        <h2 class="section-title"><?= renderEmphasized(
            $templateData['principles']['title'] ?? 'Governance Principles',
            $templateData['principles']['title_emphasized'] ?? 'Principles'
        ) ?></h2>
        
        <div class="principles-section">
            <div class="principles-grid">
                <?php if(!empty($templateData['principles']['items'])): ?>
                    <?php foreach($templateData['principles']['items'] as $principle): ?>
                    <div class="principle-card">
                        <div class="principle-icon">
                            <i class="<?= esc($principle['icon'] ?? 'fas fa-star') ?>"></i>
                        </div>
                        <h3><?= esc($principle['title']) ?></h3>
                        <p><?= esc($principle['description']) ?></p>
                    </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>
    </div>
</section>

<?= $this->endSection(); ?>