<?= $this->extend('App\Views\website\index') ?>
<?= $this->section('content') ?>

<style>
/* ===== VARIABLES ===== */
:root {
    --primary-color: #1e3c72;
    --primary-dark: #152a57;
    --secondary-color: #6c757d;
    --success-color: #28a745;
    --warning-color: #ffc107;
    --light-color: #f8f9fa;
    --dark-color: #343a40;
    --border-radius: 12px;
    --box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
    --transition: all 0.3s ease;
}

/* ===== HERO SECTION ===== */
.careers-hero {
    background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
    color: white;
    padding: 80px 0;
    position: relative;
    overflow: hidden;
}

.careers-hero.dynamic-banner {
    background: linear-gradient(135deg, rgba(30, 60, 114, 0.9) 0%, rgba(21, 42, 87, 0.9) 100%);
}

.careers-hero.dynamic-banner::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    right: 0;
    bottom: 0;
    background-size: cover;
    background-position: center;
    z-index: -1;
}

.hero-content {
    position: relative;
    z-index: 2;
}

.hero-title {
    font-size: 3.5rem;
    font-weight: 700;
    margin-bottom: 1.5rem;
    line-height: 1.2;
}

.hero-subtitle {
    font-size: 1.4rem;
    margin-bottom: 2.5rem;
    opacity: 0.95;
    line-height: 1.6;
}

.hero-cta {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.hero-icon {
    animation: float 3s ease-in-out infinite;
}

@keyframes float {
    0%, 100% { transform: translateY(0); }
    50% { transform: translateY(-10px); }
}

/* ===== SECTIONS ===== */
.section-padding {
    padding: 80px 0;
}

.section-title {
    font-size: 2.5rem;
    font-weight: 700;
    color: var(--primary-color);
    margin-bottom: 1rem;
    text-align: center;
}

.section-subtitle {
    font-size: 1.2rem;
    color: var(--secondary-color);
    text-align: center;
    margin-bottom: 3rem;
}

/* ===== WHY JOIN US ===== */
.why-join-section {
    background-color: var(--light-color);
}

.feature-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 2.5rem 1.5rem;
    text-align: center;
    box-shadow: var(--box-shadow);
    transition: var(--transition);
    height: 100%;
    border: 1px solid rgba(0, 0, 0, 0.05);
}

.feature-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 12px 35px rgba(0, 0, 0, 0.15);
}

.feature-icon {
    margin-bottom: 1.5rem;
    color: var(--primary-color);
}

.feature-card h4 {
    font-size: 1.4rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: var(--dark-color);
}

.feature-card p {
    color: var(--secondary-color);
    line-height: 1.6;
    margin: 0;
}

/* ===== JOB OPENINGS ===== */
.job-openings-section {
    background: white;
}

.jobs-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(450px, 1fr));
    gap: 1.5rem;
    margin-top: 2rem;
}

.job-card {
    background: white;
    border: 1px solid #e9ecef;
    border-radius: var(--border-radius);
    padding: 2rem;
    transition: var(--transition);
    box-shadow: 0 2px 10px rgba(0, 0, 0, 0.04);
    height: 100%;
    display: flex;
    flex-direction: column;
}

.job-card:hover {
    border-color: var(--primary-color);
    box-shadow: 0 8px 30px rgba(30, 60, 114, 0.15);
    transform: translateY(-5px);
}

.job-card-header {
    display: flex;
    justify-content: space-between;
    align-items: flex-start;
    margin-bottom: 1.5rem;
    gap: 1rem;
}

.job-title {
    font-size: 1.4rem;
    font-weight: 600;
    color: var(--primary-color);
    margin: 0;
    line-height: 1.3;
    flex: 1;
}

.job-type-badge {
    background: var(--success-color);
    color: white;
    padding: 0.4rem 1rem;
    border-radius: 50px;
    font-size: 0.8rem;
    font-weight: 600;
    white-space: nowrap;
}

.job-meta {
    display: flex;
    flex-wrap: wrap;
    gap: 0.5rem;
    margin-bottom: 1.5rem;
}

.job-meta-badge {
    display: inline-flex;
    align-items: center;
    padding: 0.4rem 0.8rem;
    background: var(--light-color);
    color: var(--dark-color);
    border-radius: 6px;
    font-size: 0.8rem;
    font-weight: 500;
    gap: 0.3rem;
}

.job-meta-badge i {
    font-size: 0.7rem;
}

.job-description {
    color: var(--secondary-color);
    line-height: 1.6;
    margin-bottom: 2rem;
    flex: 1;
    display: -webkit-box;
    -webkit-line-clamp: 3;
    -webkit-box-orient: vertical;
    overflow: hidden;
}

.job-actions {
    display: flex;
    gap: 0.75rem;
    margin-top: auto;
}

.btn-view-details {
    background: transparent;
    border: 2px solid var(--primary-color);
    color: var(--primary-color);
    padding: 0.75rem 1.5rem;
    border-radius: var(--border-radius);
    font-weight: 600;
    text-decoration: none;
    transition: var(--transition);
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    flex: 1;
    justify-content: center;
}

.btn-view-details:hover {
    background: var(--primary-color);
    color: white;
    transform: translateY(-2px);
}

.btn-download-jd {
    background: var(--primary-color);
    color: white;
    border: 2px solid var(--primary-color);
    padding: 0.75rem 1.5rem;
    border-radius: var(--border-radius);
    font-weight: 600;
    text-decoration: none;
    transition: var(--transition);
    display: inline-flex;
    align-items: center;
    gap: 0.5rem;
    flex: 1;
    justify-content: center;
}

.btn-download-jd:hover {
    background: var(--primary-dark);
    border-color: var(--primary-dark);
    color: white;
    transform: translateY(-2px);
}

/* ===== HOW TO APPLY ===== */
.how-to-apply-section {
    background: var(--light-color);
}

.steps-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 2rem;
    margin-top: 2rem;
}

.step-card {
    background: white;
    border-radius: var(--border-radius);
    padding: 2.5rem 1.5rem;
    text-align: center;
    box-shadow: var(--box-shadow);
    transition: var(--transition);
    border: 1px solid rgba(0, 0, 0, 0.05);
}

.step-card:hover {
    transform: translateY(-5px);
}

.step-number {
    width: 60px;
    height: 60px;
    background: var(--primary-color);
    color: white;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 1.5rem;
    font-weight: 700;
    margin: 0 auto 1.5rem;
}

.step-card h5 {
    font-size: 1.3rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: var(--dark-color);
}

.step-card p {
    color: var(--secondary-color);
    line-height: 1.6;
    margin: 0;
}

/* ===== CONTACT SECTION ===== */
.contact-section {
    background: white;
}

.contact-content {
    display: flex;
    align-items: center;
    gap: 3rem;
}

.contact-info {
    flex: 1;
}

.contact-icon {
    flex-shrink: 0;
}

.contact-item {
    display: flex;
    align-items: center;
    gap: 1rem;
    margin-bottom: 1.5rem;
    font-size: 1.1rem;
}

.contact-item i {
    color: var(--primary-color);
    font-size: 1.3rem;
    width: 24px;
}

/* ===== EMPTY STATE ===== */
.empty-state {
    text-align: center;
    padding: 4rem 2rem;
}

.empty-state-icon {
    margin-bottom: 2rem;
    opacity: 0.3;
}

.empty-state h3 {
    color: var(--secondary-color);
    margin-bottom: 1rem;
    font-weight: 600;
}

.empty-state p {
    color: var(--secondary-color);
    margin-bottom: 2rem;
    font-size: 1.1rem;
}

/* ===== JOB MODAL ===== */
.job-modal {
    z-index: 99999 !important;
}

.job-modal .modal-dialog {
    max-width: 900px;
    margin: 2rem auto;
}

.job-modal .modal-content {
    border: none;
    border-radius: var(--border-radius);
    box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
    overflow: hidden;
}

.job-modal .modal-header {
    background: var(--primary-color);
    color: white;
    border-bottom: none;
    padding: 2rem;
}

.job-modal .modal-title {
    font-size: 1.8rem;
    font-weight: 700;
    margin: 0;
    color: white;
}

.job-modal .btn-close {
    filter: invert(1);
    opacity: 0.8;
}

.job-modal .btn-close:hover {
    opacity: 1;
}

.job-modal .modal-body {
    padding: 2.5rem;
    max-height: 70vh;
    overflow-y: auto;
}

.job-details-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1.5rem;
    margin-bottom: 2.5rem;
    padding: 1.5rem;
    background: var(--light-color);
    border-radius: var(--border-radius);
}

.job-detail-item {
    display: flex;
    align-items: center;
    gap: 0.75rem;
}

.job-detail-item i {
    color: var(--primary-color);
    font-size: 1.1rem;
    width: 20px;
}

.job-detail-item strong {
    color: var(--dark-color);
    font-weight: 600;
}

.job-detail-item span {
    color: var(--secondary-color);
}

.job-description-content {
    margin-bottom: 2.5rem;
}

.job-description-content h5 {
    font-size: 1.3rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: var(--dark-color);
}

.job-description-content div {
    line-height: 1.7;
    color: var(--secondary-color);
}

.contact-info-card {
    background: var(--light-color);
    padding: 2rem;
    border-radius: var(--border-radius);
    border-left: 4px solid var(--primary-color);
}

.contact-info-card h5 {
    font-size: 1.3rem;
    font-weight: 600;
    margin-bottom: 1rem;
    color: var(--dark-color);
}

.contact-details p {
    margin-bottom: 0.5rem;
    color: var(--secondary-color);
}

.contact-details strong {
    color: var(--dark-color);
}

.job-modal .modal-footer {
    border-top: 1px solid #e9ecef;
    padding: 1.5rem 2.5rem;
}

/* ===== RESPONSIVE DESIGN ===== */
@media (max-width: 1200px) {
    .hero-title {
        font-size: 3rem;
    }
    
    .jobs-grid {
        grid-template-columns: repeat(auto-fit, minmax(400px, 1fr));
    }
}

@media (max-width: 992px) {
    .careers-hero {
        padding: 60px 0;
    }
    
    .hero-title {
        font-size: 2.5rem;
    }
    
    .hero-subtitle {
        font-size: 1.2rem;
    }
    
    .jobs-grid {
        grid-template-columns: 1fr;
    }
    
    .contact-content {
        flex-direction: column;
        text-align: center;
        gap: 2rem;
    }
    
    .job-card-header {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .job-type-badge {
        align-self: flex-start;
    }
}

@media (max-width: 768px) {
    .section-padding {
        padding: 60px 0;
    }
    
    .section-title {
        font-size: 2rem;
    }
    
    .hero-title {
        font-size: 2rem;
    }
    
    .hero-cta {
        flex-direction: column;
        align-items: center;
    }
    
    .hero-cta .btn {
        width: 100%;
        max-width: 300px;
        justify-content: center;
    }
    
    .job-modal .modal-body {
        padding: 1.5rem;
    }
    
    .job-details-grid {
        grid-template-columns: 1fr;
        gap: 1rem;
    }
    
    .job-actions {
        flex-direction: column;
    }
    
    .steps-grid {
        grid-template-columns: 1fr;
    }
}

@media (max-width: 576px) {
    .careers-hero {
        padding: 50px 0;
    }
    
    .hero-title {
        font-size: 1.8rem;
    }
    
    .section-title {
        font-size: 1.8rem;
    }
    
    .job-card {
        padding: 1.5rem;
    }
    
    .feature-card,
    .step-card {
        padding: 2rem 1rem;
    }
    
    .job-modal .modal-dialog {
        margin: 1rem;
    }
}

/* ===== UTILITY CLASSES ===== */
.text-primary {
    color: var(--primary-color) !important;
}

.bg-light {
    background-color: var(--light-color) !important;
}

.btn {
    padding: 0.75rem 2rem;
    font-weight: 600;
    border-radius: var(--border-radius);
    text-decoration: none;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    transition: var(--transition);
    border: 2px solid transparent;
}

.btn-lg {
    padding: 1rem 2.5rem;
    font-size: 1.1rem;
}

.btn-light {
    background: white;
    color: var(--primary-color);
    border-color: white;
}

.btn-light:hover {
    background: transparent;
    color: white;
    border-color: white;
    transform: translateY(-2px);
}

.btn-outline-light {
    background: transparent;
    color: white;
    border-color: white;
}

.btn-outline-light:hover {
    background: white;
    color: var(--primary-color);
    transform: translateY(-2px);
}

.btn-primary {
    background: var(--primary-color);
    color: white;
    border-color: var(--primary-color);
}

.btn-primary:hover {
    background: var(--primary-dark);
    border-color: var(--primary-dark);
    color: white;
    transform: translateY(-2px);
}

.btn-secondary {
    background: var(--secondary-color);
    color: white;
    border-color: var(--secondary-color);
}

.btn-secondary:hover {
    background: #5a6268;
    border-color: #5a6268;
    color: white;
    transform: translateY(-2px);
}
</style>

<!-- Dynamic Hero Section -->
<section class="careers-hero <?= !empty($hero_banner) ? 'dynamic-banner' : '' ?>" 
         <?php if (!empty($hero_banner)): ?>
         style="background: linear-gradient(135deg, rgba(30, 60, 114, 0.9) 0%, rgba(21, 42, 87, 0.9) 100%), url('<?= base_url('media/files/' . $hero_banner['photo']) ?>') center/cover;"
         <?php endif; ?>>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-8">
                <div class="hero-content">
                    <h1 class="hero-title">
                        <?php if (!empty($hero_banner)): ?>
                            <?= renderEmphasized($hero_banner['name'], $hero_banner['title_emphasized'] ?? null) ?>
                        <?php else: ?>
                            Careers at <span class="text-warning">ABC Capital Bank</span>
                        <?php endif; ?>
                    </h1>
                    <p class="hero-subtitle">
                        <?php if (!empty($hero_banner)): ?>
                            <?= esc($hero_banner['description']) ?>
                        <?php else: ?>
                            Join Uganda's leading financial institution and build a rewarding career in banking. We're committed to developing talent and fostering professional growth.
                        <?php endif; ?>
                    </p>
                    <div class="hero-cta">
                        <a href="#job-openings" class="btn btn-light btn-lg">
                            <i class="bi bi-briefcase me-2"></i>View Open Positions
                        </a>
                        <a href="#why-join-us" class="btn btn-outline-light btn-lg">
                            <i class="bi bi-info-circle me-2"></i>Why Join Us
                        </a>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 text-center">
                <div class="hero-icon">
                    <i class="bi bi-briefcase display-1 text-warning"></i>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Why Join Us Section -->
<section id="why-join-us" class="section-padding why-join-section">
    <div class="container">
        <div class="row mb-5">
            <div class="col-12 text-center">
                <h2 class="section-title">Why Join ABC Capital Bank?</h2>
                <p class="section-subtitle">We offer more than just a job - we offer a career path with purpose</p>
            </div>
        </div>
        <div class="row g-4">
            <div class="col-md-4">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="bi bi-graph-up-arrow display-4"></i>
                    </div>
                    <h4>Career Growth</h4>
                    <p>Structured career development programs and opportunities for advancement within Uganda's banking sector.</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="bi bi-award display-4"></i>
                    </div>
                    <h4>Professional Training</h4>
                    <p>Comprehensive training in banking operations, customer service, and financial products specific to Uganda's market.</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="bi bi-people display-4"></i>
                    </div>
                    <h4>Team Environment</h4>
                    <p>Collaborative work culture that values Ugandan diversity and promotes teamwork across all branches.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Current Job Openings -->
<section id="job-openings" class="section-padding job-openings-section">
    <div class="container">
        <div class="row mb-5">
            <div class="col-12 text-center">
                <h2 class="section-title">Current Job Openings</h2>
                <p class="section-subtitle">Explore opportunities to join our team across Uganda</p>
            </div>
        </div>

        <?php if (!empty($jobs)): ?>
            <div class="jobs-grid">
                <?php foreach ($jobs as $job): ?>
                    <div class="job-card">
                        <div class="job-card-header">
                            <h3 class="job-title"><?= esc($job->title) ?></h3>
                            <span class="job-type-badge"><?= esc($job->job_type) ?></span>
                        </div>
                        
                        <div class="job-meta">
                            <?php if ($job->positions): ?>
                                <span class="job-meta-badge">
                                    <i class="bi bi-people"></i><?= $job->positions ?> Position(s)
                                </span>
                            <?php endif; ?>
                            <span class="job-meta-badge">
                                <i class="bi bi-geo-alt"></i><?= esc($job->address ?? 'Kampala, Uganda') ?>
                            </span>
                            <span class="job-meta-badge">
                                <i class="bi bi-clock"></i>Apply by: <?= date('M d, Y', strtotime($job->deadline_date)) ?>
                            </span>
                        </div>

                        <?php if (!empty($job->description)): ?>
                            <div class="job-description">
                                <?= character_limiter(strip_tags($job->description), 150) ?>
                            </div>
                        <?php endif; ?>

                        <div class="job-actions">
                            <button class="btn-view-details" 
                                    onclick="viewJobDetails(<?= htmlspecialchars(json_encode($job), ENT_QUOTES, 'UTF-8') ?>)">
                                <i class="bi bi-eye"></i>View Details
                            </button>
                            <?php if (!empty($job->file)): ?>
                                <a href="<?= base_url('media/downloads/documents/' . $job->file) ?>" 
                                   class="btn-download-jd" 
                                   target="_blank">
                                    <i class="bi bi-download"></i>Download JD
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php else: ?>
            <div class="empty-state">
                <div class="empty-state-icon">
                    <i class="bi bi-briefcase display-1 text-muted"></i>
                </div>
                <h3>No Current Openings</h3>
                <p>There are no job openings at the moment. Please check back later for new opportunities.</p>
                <button class="btn btn-primary btn-lg" onclick="subscribeToJobAlerts()">
                    <i class="bi bi-bell me-2"></i>Get Job Alerts
                </button>
            </div>
        <?php endif; ?>
    </div>
</section>

<!-- How to Apply Section -->
<section class="section-padding how-to-apply-section">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 mx-auto">
                <div class="text-center mb-5">
                    <h2 class="section-title">How to Apply</h2>
                    <p class="section-subtitle">Follow these steps to submit your application</p>
                </div>
                
                <div class="steps-grid">
                    <div class="step-card">
                        <div class="step-number">1</div>
                        <h5>Review Requirements</h5>
                        <p>Carefully read the job description and ensure you meet the qualifications.</p>
                    </div>
                    <div class="step-card">
                        <div class="step-number">2</div>
                        <h5>Prepare Documents</h5>
                        <p>Update your CV and prepare a cover letter tailored to the position.</p>
                    </div>
                    <div class="step-card">
                        <div class="step-number">3</div>
                        <h5>Submit Application</h5>
                        <p>Send your application to the email provided in the job posting.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- Job Details Modal -->
<div class="modal fade job-modal" id="jobModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title" id="modalJobTitle"></h4>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <div class="job-details-grid">
                    <div class="job-detail-item">
                        <i class="bi bi-briefcase"></i>
                        <strong>Job Type:</strong>
                        <span id="modalJobType"></span>
                    </div>
                    <div class="job-detail-item">
                        <i class="bi bi-calendar-event"></i>
                        <strong>Deadline:</strong>
                        <span id="modalJobDeadline"></span>
                    </div>
                    <div class="job-detail-item">
                        <i class="bi bi-people"></i>
                        <strong>Positions:</strong>
                        <span id="modalJobPositions"></span>
                    </div>
                    <div class="job-detail-item">
                        <i class="bi bi-geo-alt"></i>
                        <strong>Location:</strong>
                        <span id="modalJobLocation"></span>
                    </div>
                </div>

                <div class="job-description-content">
                    <h5>Job Description</h5>
                    <div id="modalJobDescription"></div>
                </div>

                <div class="contact-info-card">
                    <h5>How to Apply</h5>
                    <div id="modalJobContact"></div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                <a href="#" id="modalJobDownload" class="btn btn-primary" target="_blank" style="display: none;">
                    <i class="bi bi-download me-2"></i>Download Job Description
                </a>
            </div>
        </div>
    </div>
</div>

<script>
function viewJobDetails(job) {
    // Populate modal with job data
    document.getElementById('modalJobTitle').textContent = job.title;
    document.getElementById('modalJobType').textContent = job.job_type;
    document.getElementById('modalJobDeadline').textContent = new Date(job.deadline_date).toLocaleDateString('en-US', {
        year: 'numeric',
        month: 'long',
        day: 'numeric'
    });
    document.getElementById('modalJobPositions').textContent = job.positions || '1';
    document.getElementById('modalJobLocation').textContent = job.address || 'Kampala, Uganda';
    document.getElementById('modalJobDescription').innerHTML = job.description || '<p class="text-muted">No detailed description provided.</p>';
    
    // Set download link
    if (job.file) {
        const downloadLink = document.getElementById('modalJobDownload');
        downloadLink.href = '<?= base_url('media/downloads/documents/') ?>' + job.file;
        downloadLink.style.display = 'inline-block';
    } else {
        document.getElementById('modalJobDownload').style.display = 'none';
    }
    
    // Build contact information
    let contactHtml = '<div class="contact-details">';
    if (job.email) {
        contactHtml += `<p><strong>Email:</strong> ${job.email}</p>`;
    }
    if (job.phone) {
        contactHtml += `<p><strong>Phone:</strong> ${job.phone}</p>`;
    }
    if (job.address) {
        contactHtml += `<p><strong>Location:</strong> ${job.address}</p>`;
    }
    contactHtml += '</div>';
    
    document.getElementById('modalJobContact').innerHTML = contactHtml;
    
    // Show modal
    const jobModal = new bootstrap.Modal(document.getElementById('jobModal'));
    jobModal.show();
}

function subscribeToJobAlerts() {
    const email = prompt('Enter your email address to receive job alerts from ABC Capital Bank:');
    if (email && email.includes('@')) {
        alert('Thank you for subscribing to job alerts! We will notify you when new positions become available at ABC Capital Bank.');
        // Here you would typically send this to your server
    } else if (email) {
        alert('Please enter a valid email address.');
    }
}

// Add hover effects to job cards
document.addEventListener('DOMContentLoaded', function() {
    const jobCards = document.querySelectorAll('.job-card');
    
    jobCards.forEach(card => {
        card.addEventListener('mouseenter', function() {
            this.style.transform = 'translateY(-5px)';
        });
        
        card.addEventListener('mouseleave', function() {
            this.style.transform = 'translateY(0)';
        });
    });
});
</script>

<?= $this->endSection() ?>