<?= $this->extend('website/layout'); ?>

<?= $this->section('content'); ?>

<!-- Page Header -->
<section class="page-header">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <div class="page-header-content" data-aos="fade-up">
                    <h1><?= esc($page_title) ?></h1>
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?= base_url() ?>">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page"><?= esc($breadcrumb) ?></li>
                        </ol>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Page Content -->
<section class="page-content">
    <div class="container">
        <div class="row">
            <div class="col-lg-8">
                <div class="content-wrapper" data-aos="fade-up">
                    <?= $this->renderSection('page_content') ?>
                </div>
            </div>
            <div class="col-lg-4">
                <div class="sidebar" data-aos="fade-up" data-aos-delay="200">
                    <!-- Quick Links Sidebar -->
                    <div class="sidebar-widget">
                        <h3 class="widget-title">Quick Links</h3>
                        <ul class="quick-links">
                            <li><a href="<?= base_url('careers') ?>"><i class="fas fa-chevron-right"></i> Careers</a></li>
                            <li><a href="<?= base_url('news') ?>"><i class="fas fa-chevron-right"></i> News & Updates</a></li>
                            <li><a href="<?= base_url('faqs') ?>"><i class="fas fa-chevron-right"></i> FAQs</a></li>
                            <li><a href="<?= base_url('reports') ?>"><i class="fas fa-chevron-right"></i> Annual Reports</a></li>
                            <li><a href="<?= base_url('bids') ?>"><i class="fas fa-chevron-right"></i> Bids and Tenders</a></li>
                        </ul>
                    </div>

                    <!-- Banking Services Sidebar -->
                    <div class="sidebar-widget">
                        <h3 class="widget-title">Banking Services</h3>
                        <ul class="quick-links">
                            <li><a href="<?= base_url('personal') ?>"><i class="fas fa-chevron-right"></i> Personal Banking</a></li>
                            <li><a href="<?= base_url('business') ?>"><i class="fas fa-chevron-right"></i> Business Banking</a></li>
                            <li><a href="<?= base_url('loans') ?>"><i class="fas fa-chevron-right"></i> Loans & Mortgages</a></li>
                            <li><a href="<?= base_url('savings') ?>"><i class="fas fa-chevron-right"></i> Saving Accounts</a></li>
                            <li><a href="<?= base_url('banking-ways') ?>"><i class="fas fa-chevron-right"></i> Ways to Bank</a></li>
                        </ul>
                    </div>

                    <!-- Contact Info Sidebar -->
                    <div class="sidebar-widget contact-widget">
                        <h3 class="widget-title">Contact Us</h3>
                        <div class="contact-info">
                            <p><i class="fas fa-map-marker-alt"></i> 123 Financial Street, Banking District, BC 10001</p>
                            <p><i class="fas fa-phone-alt"></i> +1 (800) 123-4567</p>
                            <p><i class="fas fa-envelope"></i> info@abccapitalbank.com</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?= $this->endSection(); ?>
