<?php
// Define variables passed from the controller
$clientName     = isset($clientName) ? $clientName : '';
$clientEmail    = isset($clientEmail) ? $clientEmail : '';
$subject        = isset($subject) ? $subject : '';
$message        = isset($message) ? $message : '';
$messageId      = isset($messageId) ? $messageId : '';
$phone          = isset($phone) ? $phone : '';
$accountType    = isset($accountType) ? $accountType : '';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Roboto:wght@100;300;400;500;700&family=Montserrat:wght@200;300;400;500;600;700;800&display=swap" rel="stylesheet">

    <title>New Contact Form Message - ABC Capital Bank</title>
	<style>
	html,body{font-family: "Montserrat", sans-serif !important;font-size:14px;color:#333 !important;padding-top:2%;background:#dee8f1;}
	.pdetails{border: 0px;width:100%;font-size:13px;}
	.pdetails td{line-height:24px;border-bottom: 1px solid #ede3e3;}
	.container{margin:0 auto; width:70%;min-width:360px;padding:15px;background:#fff;border-top:3px solid #ba2d2d;}
	a{text-decoration: none;}
	.btn{display: inline-block; background:#ba2d2d;color:#fff;font-size:16px;padding:10px;border-radius:10px;border:0px;width:40%;text-align:center;}
	.message-box{background:#f8f9fa;padding:15px;border-left:4px solid #ba2d2d;margin:15px 0;}
	</style>
</head>
<body>
	<div class="container" style="background:#fff;padding: 20px;">
		<div style="margin-bottom:5px;"><a href="https://www.abccapitalbank.co.ug" target="_blank"><img src="https://abccapitalbank.co.ug/logo-mobile.png" height="50px"/></a></div>
		<div style="padding: 20px;">
				<h3 style="font-size:18px;font-weight:600">New Contact Form Message Received</h3>
				<hr/>

				<p>A new message has been submitted through the contact form on the ABC Capital Bank website.</p>

				<table class="pdetails">
					<tr><td><strong>Message ID:</strong></td><td><?php echo htmlspecialchars($messageId); ?></td></tr>
					<tr><td><strong>Name:</strong></td><td><?php echo htmlspecialchars($clientName); ?></td></tr>
					<tr><td><strong>Email:</strong></td><td><?php echo htmlspecialchars($clientEmail); ?></td></tr>
					<tr><td><strong>Phone:</strong></td><td><?php echo htmlspecialchars($phone); ?></td></tr>
					<tr><td><strong>Subject:</strong></td><td><?php echo htmlspecialchars($subject); ?></td></tr>
					<tr><td><strong>Account Type:</strong></td><td><?php echo htmlspecialchars($accountType); ?></td></tr>
				</table>

				<div class="message-box">
					<strong>Message:</strong><br/>
					<?php echo nl2br(htmlspecialchars($message)); ?>
				</div>

				

				<div style="margin-top:20px;padding:15px;background:#f5f5f5;border-left:3px solid #ba2d2d;">
					<p style="margin:5px 0;"><strong>Action Required:</strong></p>
					<p style="margin:5px 0;">Please respond to this inquiry within 24-48 hours.</p>
					<p style="margin:5px 0;">Log in to the admin panel to view and respond to this message.</p>
				</div>

				<p style="color: #555;font-size:12px;margin-top:20px;">
				ABC Capital Bank System Notification<br/>
				<small><?= date('jS, M Y H:i:s');?></small>
				</p>
		</div>
	</div>
</div>
</body>
</html>
