<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Team Member Profiles</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- print success message !-->
<div class="row">
    <div class="col">
		<!-- print success message !-->
		<?php if(session()->getTempdata('success')): ?>
			<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
		<?php endif;?>
		<!-- print failure message !-->
		<?php if(session()->getTempdata('error')): ?>
			<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
		<?php endif;?>
        <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
		<?= $validation->listErrors()?>
		</div>
        <?php endif;?>
        <div id="showMsg"></div>
</div></div>
<!-- Show All Posts !-->
<div class="card card-body">
    <div class="d-flex bd-highlight mb-3">
        <div class="p-2 bd-highlight">
        <a href="<?= base_url('administrator/team/member/add'); ?>" class="btn btn-sm btn-success w-100"><i class="bi bi-plus"></i> Add New</a>
        </div>
        <div class="p-2 bd-highlight">
        <a href="<?= base_url('administrator/team/categories'); ?>" class="btn btn-sm btn-primary w-100"><i class="bi bi-plus"></i> Categories</a>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-pencil-square"></i></button>
                <a href="#" class="btn btn-sm btn-light">Edit</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-check-lg text-success"></i></button>
                <a href="#" class="btn btn-sm btn-light">Publish</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-x-circle-fill text-danger"></i></button>
                <a href="#" class="btn btn-sm btn-light">Unpublish</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-hdd-fill"></i></button>
                <a href="#" class="btn btn-sm btn-light">Arhived</a>
            </div>
        </div>
        <div class="p-2 bd-highlight">
            <div class="btn-group border">
                <button type="button" class="btn bg-secondary bg-opacity-25 rounded-0"><i class="bi bi-trash-fill"></i></button>
                <a href="#" class="btn btn-sm btn-light">Trashed</a>
            </div>
        </div>
        <div class="p-2 bd-grow-1 bd-highlight"> &nbsp;</div>
    </div>
    <div class="table-responsive">
        <table id="Teamslist" class="table table-stripped table-hover">
            <thead class="bg-primary bg-opacity-10" style="font-size: 14px"><tr>
                <th>#</th>
                <th></th>
                <th>Name</th>
                <th>Position</th>
                <th>Category</th>
                <th>Birthday</th>
                <th>Relationship</th>
                <th>Hits</th>
                <th>Status</th>
                <th></th>
            </tr></thead>
            <tbody>
                <?php foreach($team_members as $member): ?>
                    <tr>
                        <td><span class="badge bg-info"><?= $member->id ?></span></td>
                        <td>
                            <?php if(!empty($member->photo_url)):?>
                                <img src="<?= esc($member->photo_url); ?>" height="50px" />
                            <?php else: ?>
                                <img src="<?= base_url('assets/images/placeholder.png'); ?>" height="50px" />
                            <?php endif; ?>
                        </td>
                        <td><a href="<?= base_url('administrator/team/member/view/'.$member->id); ?>"><?= $member->title; ?></a></td>
                        <td><?= $member->position; ?></td>
                        <td><?= $member->category_name; ?></td>
                        <td><?php if($member->birthday):?><?= date('jS M Y', strtotime($member->birthday)); ?><?php endif;?></td>
                        <td><?= $member->relationship_status; ?></td>
                        <td><span class="badge bg-danger bg-opacity-25 text-dark"><?= $member->hits; ?></span></td>
                        <td>
                        <?php if($member->status == 'published'):?>
                            <span class="badge rounded-pill bg-success"><?= $member->status ?></span> 
                        <?php elseif($member->status == 'unpublished'):?>
                            <span class="badge rounded-pill bg-danger"><?= $member->status ?></span>
                        <?php elseif($member->status == 'archived'):?>
                            <span class="badge rounded-pill bg-info"><?= $member->status ?></span>
                        <?php else:?>
                            <span class="badge rounded-pill bg-secodary"><?= $member->status ?></span>
                        <?php endif;?>
                        </td>
                        <td>
                        <div class="btn-group dropstart">
                        <button type="button" class="btn btn-white p-1" data-bs-toggle="dropdown" aria-expanded="false">
                        <i class="bi bi-three-dots-vertical"></i>
                        </button>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="<?= base_url('administrator/team/member/view/').$member->id.'-'.$member->alias; ?>"><small>View</small></a></li>
                            <li><a class="dropdown-item" href="<?= base_url('administrator/team/member/edit/').$member->id.'-'.$member->alias; ?>"><small>Edit</small></a></li>
                            <li><a class="dropdown-item"  onclick="delete_member(<?= $member->id ?>, '<?= $member->title ?>')" style="cursor: pointer"><small>Delete</small></a></li>
                        </ul>
                        </div>
                        </td>
                    </tr>
                <?php endforeach;?>
            </tbody>
        </table>
    </div>

</div>
</div> <!-- Container!-->         
<!---- Modals --->
<?= view('Modules\Team\Views\modals\del_memberModal') ?>

<!---- JS --->
<script type="text/javascript">
      $(document).ready(function () {
          $('#Teamslist').DataTable({
            pageLength: 10,
            order: [[0, "Desc"]],
          });
      });

</script>               
<script src="<?= base_url();?>/assets/admin_assets/js/modules/teams.js"></script>   
<?= $this->endSection();?>