<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Team Categories</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/team/members') ?> ">Team Members</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- Post Category ADD/EDIT/DELETE/Detailed List !-->
<div class="row">
    <div class="col">

			<!-- print success message !-->
			<?php if(session()->getTempdata('success')): ?>
				<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
				<?php endif;?>
			<!-- print failure message !-->
			<?php if(session()->getTempdata('error')): ?>
				<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
			<?php endif;?>
            <div id="showMsg"></div>
            <?php if(isset($validation)): ?>
			<div class="alert alert-danger">
			<?= $validation->listErrors()?>
			</div>
            <?php endif;?>
</div></div>
<div class="row">
    <div class="col-lg-4"> 
        <div class="card">
                <?php if(!isset($singleCategory)):?>
				<div class="card-header"><h6 class="card-title fw-bold">Add Category</h6></div>
				<div class="card-body ">
                <!-- Add Category  !-->
                <form method="POST" action="<?= base_url('administrator/team/categories/add');?>">
                <?= csrf_field();?>
                <div class="row">
                    <div class="mb-3">
                        <label class="form-label">Category Name</label>
                        <input type="text" class="form-control" name="name">
                    </div>
                    <div class="mb-3">
                        <?php function generateSelectOptions($categories, $indent = '') { ?>
                            <?php foreach ($categories as $category) { ?>
                                <option value="<?= $category['id'] ?>"><?= $indent . $category['name'] ?></option>
                                <?php if (isset($category['subcategories']) && is_array($category['subcategories'])) { ?>
                                    <?php generateSelectOptions($category['subcategories'], $indent . '- '); ?>
                                <?php } ?>
                            <?php } ?>
                        <?php } ?>
                        <label class="form-label"><strong>Category</strong></label>
                        <select name="parent_category_id" class="form-select">
                            <option value="">Select Category</option>
                            <?php generateSelectOptions($categoryTree); ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" name="description" style="height: 80px;"></textarea>
                    </div>
                    <div class="mb-3">
                        <button type="submit" class="btn btn-outline-danger w-100" >Save</button>
                    </div>
                </div>
                </form>
            </div>
                <!-- End Add Category  !-->
                <?php else:?>
                <div class="card-header"><h6 class="card-title fw-bold">Edit Category</h6></div>
                <div class="card-body ">
                <!-- Edit Category  !-->
                    <form method="POST" action="<?= base_url('administrator/team/categories/update');?>">
                    <?= csrf_field(); ?>
                    <div class="row">
                        <div class="mb-3">
                            <label class="form-label">Category Name</label>
                            <input type="text" class="form-control" name="name" value="<?= $singleCategory['name']; ?>">
                        </div>
                        <div class="mb-3">
                        <label class="form-label">Parent Category</label>
                            <select name="parent_category_id" class="form-select">
                                <option value="">Select Parent Category</option>
                                <?php foreach($team_categories as $c): ?>
                                <option value="<?= $c->id;?>" <?php if($c->id == $singleCategory['parent_category_id']) echo "selected"; ?> ><?= $c->name;?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" style="height: 80px;"><?= $singleCategory['description']; ?></textarea>
                        </div>
                        <div class="mb-3">
                            <input type="hidden" name="id" value="<?= $singleCategory['id']; ?>" >
                            <button type="submit" class="btn btn-outline-danger w-100" >Edit</button>
                        </div>
                    </div>
                    </form>
                <!-- End Edit Category  !-->
                </div>
                <?php endif; ?>
        </div>
    </div>
    <div class="col-lg-8 "> 
        <!-- Display all categories !-->
        <div class="card">
        <div class="card-header"><h6 class="card-title fw-bold">Team Categories <a href="<?= base_url('administrator/team/members') ?>" class="btn btn-sm btn-secondary float-md-end">Back to Team</a></h6></div> 
            <div class="card-body">
        <div class="table-responsive">
            <table id="catlist" class="table table-hover">
                <thead class="bg-primary bg-opacity-10" style="font-size: 14px;">
                    <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>Parent Category</th>
                    <th><i class="bi bi-check-lg text-success fw-bold"></i></th>
                    <th><i class="bi bi-x-circle-fill text-danger"></i></th>
                    <th><i class="bi bi-hdd-fill"></i></th>
                    
                    <th>Action</th>
                    </tr>
                </thead>
                <tbody style="font-size: 13px">
                    <?php foreach($team_categories as $c): ?>
                        <tr>
                        <td><?= $c->id; ?></td>
                        <td><?= $c->name; ?> <small class="text-muted"> (<?= $c->alias; ?>)</small></td>
                        <td> <?php echo isset($masterCategories[$c->id]) ? $masterCategories[$c->id] : ''; ?> </td>
                        <td> <span class="badge rounded-pill bg-success"> - </span> </td>
                        <td> <span class="badge rounded-pill bg-danger"> - </span> </td>
                        <td> <span class="badge rounded-pill bg-secondary"> - </span> </td>
                        
                        <td>
                        <div class="btn-group" role="group" aria-label="edit category">
                        <a href="<?= base_url('administrator/team/categories/edit/').$c->id; ?>" type="button" class="btn btn-success p-1 rounded-left"><small><i class="bi bi-pencil-square mx-0 "></i></small></a>
                        <a  class="btn btn-danger p-1 rounded-right" onclick="delete_teamCategory(<?= $c->id ?>, '<?= $c->name ?>')"><small><i class="bi bi-trash mx-0" ></i></small></a>
                        </div>
                        </td>
                        </tr>
                    <?php endforeach;?>
                </tbody>
            </table>
        </div>
    </div></div>
            
<!-- END Post Category ADD/EDIT/DELETE/Detailed List !-->
<!-- Modals !-->
<?= view('Modules\Team\Views\modals\del_categoryModal') ?>
<?= view('Modules\Team\Views\modals\del_memberModal') ?>

<!---- JS --->  
<script type="text/javascript">
    $(document).ready(function () {
    $('#catlist').DataTable({
        pageLength: 10,
        order: [[0, "Desc"]],
    });
    });

</script>  
<script src="<?= base_url();?>/assets/admin_assets/js/modules/teams.js"></script>  
<?= $this->endSection();?>