<?php

namespace Modules\Team\Controllers;

use App\Controllers\Auth\AuthController;
use Modules\Posts\Models\PostsCategoryModel;
use Modules\Posts\Models\PostsModel;
use Modules\Team\Models\TeamModel;
use Modules\Team\Models\TeamCategoryModel;
use Modules\Team\Models\TeamMemberGalleryModel;

class Team extends AuthController
{
    public function initController($request, $response, $logger)
    {
        // Call parent initController
        parent::initController($request, $response, $logger);

        $this->postscategoryModel = new PostsCategoryModel();
        $this->postsModel = new PostsModel();
        $this->teamModel = new TeamModel();
        $this->teamcategoryModel = new TeamCategoryModel();
        $this->teammembergalleryModel = new TeamMemberGalleryModel();
        $this->data['categoryTree'] = $this->teamcategoryModel->getCategoryList();
    }

  /**
   * Build a full photo URL from a stored photo value.
   * - If the stored value is already a full URL (http/https or //), return as-is.
   * - If empty, return an empty string.
   * - Otherwise assume it's a filename and construct URL under /media/files.
   */
  private function buildPhotoUrl($photo)
  {
    if (empty($photo)) {
      return '';
    }
    // If already a full URL, return
    if (strpos($photo, 'http://') === 0 || strpos($photo, 'https://') === 0 || strpos($photo, '//') === 0) {
      return $photo;
    }
    // Trim leading slashes then build URL
    $photo = ltrim($photo, '/');
    return base_url('/media/files') . '/' . $photo;
  }


  public function index()
  {
	  $this->data['title'] = "Team Member Profiles";
    $this->data['bcrumb'] = "Team Member Profiles";

    $this->data['team_members'] = $this->teamModel->getAll();
  // Ensure each member has a resolved photo_url (views should use this)
  if (!empty($this->data['team_members'])) {
    foreach ($this->data['team_members'] as $m) {
      $m->photo_url = $this->buildPhotoUrl(isset($m->photo) ? $m->photo : '');
    }
  }
  
	  return View('Modules\Team\Views\index', $this->data);
  }

  public function addMember()
  {
    $this->data['title'] = "Add Member";
    $this->data['bcrumb'] = "Add Member";
    
    
    $admins = $this->usersModel->getAdminUsers();
    if($this->request->getMethod() == 'POST'){

      $rules = [
        'title' => ['label'=>'Member Name', 'rules'=>'required'],
        'position'=>['label'=>'Job Title', 'rules'=>'required'],
        'category_id'=>['label'=>'Category', 'rules'=>'required'],
      ];
      $photoRules = [
        'photo' => [
            'label' => 'Image File',
            'rules' => 'uploaded[photo]'
                . '|is_image[photo]'
                . '|mime_in[photo,image/jpg,image/jpeg,image/gif,image/png,image/webp]'
                . '|max_size[photo,2024]'
        ],
      ];

      if($this->validate($rules))
      {

        $file1 = $this->request->getFile('photo');
        $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('title'))));
        
        if($this->validate($photoRules))
        { 
              $newName4 = $file1->getRandomName();
              $file1->move(ROOTPATH . 'media/files', $newName4);
                // Save only the filename in DB. Views will construct full URL via buildPhotoUrl().
                $nwn1 = $newName4;

              $teamData = [
                'title'       => $this->request->getVar('title'),
                'alias'       => $slug,
                'photo'       => $nwn1,
                'category_id' => $this->request->getVar('category_id'),
                'position'    => $this->request->getVar('position'),
                'excerpt'     => $this->request->getVar('excerpt'),
                'content'     => $this->request->getVar('content'),
                'birthday'    => $this->request->getVar('birthday'),
                'died_at'     => $this->request->getVar('died_at'),
                'achievements'  => $this->request->getVar('achievements'),
                'relationship_status' => $this->request->getVar('relationship_status'),
                'urls'        => $this->request->getVar('urls'),
                'facebook'    => $this->request->getVar('facebook'),
                'twitter'     => $this->request->getVar('twitter'),
                'instagram'   => $this->request->getVar('instagram'),
                'tiktok'      => $this->request->getVar('tiktok'),
                'linkedin'    => $this->request->getVar('linkedin'),
                'snapchat'    => $this->request->getVar('snapchat'),
                'metadesc'    => $this->request->getVar('metadesc'),
                'status'      => $this->request->getVar('status'),
                'metakey'     => $this->request->getVar('metakey'),
                'ordering'    => $this->request->getVar('ordering'),
                'created_by'  => $this->userdata->user_id,
              ];

              $results = $this->teamModel->save($teamData);
              if($results){

                // Enhanced notification for team member creation
                $title = $this->request->getVar("title");
                $adminmessage = 'New Team Member Added: ' . $title;
                $notificationType = 'team';
                $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

                // Keep existing notification system for admins
                // $message = 'New Team Member: '.$title.' CREATED';
                // foreach($admins as $m)
                // {
                //     $userz =[
                //     'message' 				=> $message,
                //     'user_id'		      => $m->id,
                //     'notification_type' => 'content',
                //     'created_by'      => $this->userdata->user_id,
                // ];
                // $this->notificationsModel->save($userz);	
                // }

                session()->setTempdata('success', 'Member added successfully', 3);
                return redirect()->to('administrator/team/members');
              }else{
                session()->setTempdata('error', 'Member NOT added', 3);
                return redirect()->to('administrator/team/members');
              }

        }else{
          $this->data['validation'] = $this->validator;
        }
      }else{
        $this->data['validation'] = $this->validator;
      }

    }

    return View('Modules\Team\Views\add_member', $this->data);
  }
  
  public function editMember($member = null)
  {
    $this->data['title'] = 'Edit Member Details';
    $this->data['bcrumb'] = 'Edit Member Details';

    $this->data['member'] = $this->teamModel->getSingleMember($member);
    // Add resolved photo URL for the view
    if (!empty($this->data['member'])) {
        $this->data['member']->photo_url = $this->buildPhotoUrl(isset($this->data['member']->photo) ? $this->data['member']->photo : '');
    }

    return View('Modules\Team\Views\edit_member', $this->data);
  }

  public function updateMember()
  {
    $this->data['title'] = 'Edit Member Details'; 
    $this->data['bcrumb'] = 'Edit Member Details';
    
    
    $admins = $this->usersModel->getAdminUsers();
    $id = $this->request->getVar('id');
    $this->data['member'] = $this->teamModel->getSingleMember($id);
    if($this->request->getMethod() == 'POST')
    {
      $rules = [
        'title'       => ['label'=>'Member Name', 'rules'=>'required'],
        'position'    =>['label'=>'Job Title', 'rules'=>'required'],
        'category_id' =>['label'=>'Category', 'rules'=>'required'],
      ];
      $photoRules = [
        'photo' => [
            'label' => 'Image File',
            'rules' => 'uploaded[photo]'
                . '|is_image[photo]'
                . '|mime_in[photo,image/jpg,image/jpeg,image/gif,image/png,image/webp]'
                . '|max_size[photo,2024]'
        ],
      ];

      if($this->validate($rules))
      {
        
        $file1 = $this->request->getFile('photo');
        $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('title'))));
        // If a new file was uploaded and is valid, move it and store the filename
        if ($file1 && $file1->isValid())
        {
          if($this->validate($photoRules))
          {
            $newName4 = $file1->getRandomName();
            $file1->move(ROOTPATH . 'media/files', $newName4);
            $nwn1 = $newName4; // store only filename
            $teamData = [
              'title'       => $this->request->getVar('title'),
              'alias'       => $slug,
              'photo'       => $nwn1,
              'category_id' => $this->request->getVar('category_id'),
              'position'    => $this->request->getVar('position'),
              'excerpt'     => $this->request->getVar('excerpt'),
              'content'     => $this->request->getVar('content'),
              'birthday'    => $this->request->getVar('birthday'),
              'died_at'     => $this->request->getVar('died_at'),
              'achievements'  => $this->request->getVar('achievements'),
              'relationship_status' => $this->request->getVar('relationship_status'),
              'urls'        => $this->request->getVar('urls'),
              'facebook'    => $this->request->getVar('facebook'),
              'twitter'     => $this->request->getVar('twitter'),
              'instagram'   => $this->request->getVar('instagram'),
              'tiktok'      => $this->request->getVar('tiktok'),
              'linkedin'    => $this->request->getVar('linkedin'),
              'snapchat'    => $this->request->getVar('snapchat'),
              'metadesc'    => $this->request->getVar('metadesc'),
              'status'      => $this->request->getVar('status'),
              'metakey'     => $this->request->getVar('metakey'),
              'ordering'    => $this->request->getVar('ordering'),
              'created_by'  => $this->userdata->user_id,
            ];
            $results = $this->teamModel->update($id, $teamData);

          }else{
            $this->data['validation'] = $this->validator;
          }
        }else{
          $teamData = [
            'title'       => $this->request->getVar('title'),
            'alias'       => $slug,
            'category_id' => $this->request->getVar('category_id'),
            'position'    => $this->request->getVar('position'),
            'excerpt'     => $this->request->getVar('excerpt'),
            'content'     => $this->request->getVar('content'),
            'birthday'    => $this->request->getVar('birthday'),
            'died_at'     => $this->request->getVar('died_at'),
            'achievements'  => $this->request->getVar('achievements'),
            'relationship_status' => $this->request->getVar('relationship_status'),
            'urls'        => $this->request->getVar('urls'),
            'facebook'    => $this->request->getVar('facebook'),
            'twitter'     => $this->request->getVar('twitter'),
            'instagram'   => $this->request->getVar('instagram'),
            'tiktok'      => $this->request->getVar('tiktok'),
            'linkedin'    => $this->request->getVar('linkedin'),
            'snapchat'    => $this->request->getVar('snapchat'),
            'metadesc'    => $this->request->getVar('metadesc'),
            'status'      => $this->request->getVar('status'),
            'metakey'     => $this->request->getVar('metakey'),
            'ordering'    => $this->request->getVar('ordering'),
            'created_by'  => $this->userdata->user_id,
          ];
          $results = $this->teamModel->update($id, $teamData);
        }

        if($results){

          // Enhanced notification for team member update
          $title = $this->request->getVar("title");
          $adminmessage = 'Team Member Updated: ' . $title;
          $notificationType = 'team';
          $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

          // Keep existing notification system for admins
          // $message = ' Team Member: '.$title.'  UPDATED';
          // foreach($admins as $m)
          // {
          //     $userz =[
          //     'message' 				=> $message,
          //     'user_id'		      => $m->id,
          //     'notification_type' => 'content',
          //     'created_by'      => $this->userdata->user_id,
          // ];
          // $this->notificationsModel->save($userz);	
          // }

          session()->setTempdata('success', 'Member updated successfully', 3);
          return redirect()->to('administrator/team/members');
        }else{
          session()->setTempdata('error', 'Member NOT added', 3);
          return redirect()->to('administrator/team/members');
        }

      }else{
        $this->data['validation'] = $this->validator;
      }
    }
    return View('Modules\Team\Views\edit_member', $this->data);
  }


  public function viewMember($member)
  {
    $memberDetails = $this->teamModel->getSingleMember($member);
    $this->data['title'] = 'Member Details';
    $this->data['bcrumb'] = 'Member Details';

    //Capture Hits per Member
    $current_hits = $memberDetails->hits;
    $new_hits = $current_hits + 1;
    $this->teamModel->update($member, ['hits' => $new_hits]);
   
    $this->data['member'] = $this->teamModel->getSingleMember($member);

  // Add resolved photo URL for the view
  if (!empty($this->data['member'])) {
    $this->data['member']->photo_url = $this->buildPhotoUrl(isset($this->data['member']->photo) ? $this->data['member']->photo : '');
  }

  return View('Modules\Team\Views\view_member', $this->data);
  }

  public function deleteMember($id)
  {
  // Allow id in the form "123-alias" or just "123"
  $realId = $id;
  if (strpos($id, '-') !== false) {
    $parts = explode('-', $id);
    $realId = (int)$parts[0];
  }

  $admins = $this->usersModel->getAdminUsers();
  $member = $this->teamModel->getSingleMember($realId);

  if (empty($member)) {
    // Not found
    if ($this->request->isAJAX()) {
      return $this->response->setJSON(['success' => false, 'msg' => 'Member not found']);
    }
    session()->setFlashdata('error', 'Member not found');
    return redirect()->to('administrator/team/members');
  }

  // Use model delete (handles soft deletes if enabled)
  $deleted = $this->teamModel->delete($realId);

  // If deletion was successful, optionally remove local photo file
  if ($deleted) {
    // Attempt to unlink local photo if it's a filename (not a URL)
    if (!empty($member->photo) && strpos($member->photo, 'http') !== 0 && strpos($member->photo, '//') !== 0) {
      $photoPath = ROOTPATH . 'media/files/' . ltrim($member->photo, '/');
      if (is_file($photoPath)) {
        @unlink($photoPath);
      }
    }

    // Enhanced notification for team member deletion
    $title = $member->title;
    $adminmessage = 'Team Member Deleted: ' . $title;
    $notificationType = 'team';
    $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

    // Keep existing notification system for admins
    // $message = ' Team Member: ' . $title . ' DELETED ';
    // foreach ($admins as $m) {
    //   $userz = [
    //     'message' => $message,
    //     'user_id' => $m->id,
    //     'notification_type' => 'content',
    //     'created_by' => $this->userdata->user_id,
    //   ];
    //   $this->notificationsModel->save($userz);
    // }

    if ($this->request->isAJAX()) {
      return $this->response->setJSON(['success' => true, 'msg' => 'Member deleted successfully']);
    }

    session()->setFlashdata('success', 'Member deleted successfully');
    return redirect()->to('administrator/team/members');
  }

  // Deletion failed
  if ($this->request->isAJAX()) {
    return $this->response->setJSON(['success' => false, 'msg' => 'Member could not be deleted']);
  }
  session()->setFlashdata('error', 'Member could not be deleted');
  return redirect()->to('administrator/team/members');
  }

/** ===================================================================
   * CATEGORIES ADD/EDIT/DELETE
*======================================================================*/
  public function categories()
  {
    $this->data['title'] = "Team Categories";
    $this->data['bcrumb'] = "Categories";


    $categories = $this->teamcategoryModel->getAll();
    $masterCategories = [];
    foreach ($categories as $cat) {
        $masterCategory = $this->teamcategoryModel->getParentCategory($cat->id);
        if ($masterCategory !== null) {
            $masterCategories[$cat->id] = $masterCategory->name;
        }
    }
    $this->data['masterCategories'] = $masterCategories;
    $this->data['team_categories'] = $this->teamcategoryModel->getAll();

	  return View('Modules\Team\Views\category', $this->data);
  }

  public function addCategory()
  {
    $this->data['title'] = "Team Categories";
    $this->data['bcrumb'] = "Categories";
    $this->data['team_categories'] = $this->teamcategoryModel->getAll();

    if($this->request->getMethod() == 'POST')
    {
      $rules = [
        'name' => ['label'=>'Category Name', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {
        $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('name'))));
        $parentId = $this->request->getVar('parent_category_id');
        if($parentId){
          $catData = [
            'name'                => $this->request->getVar('name'),
            'alias'               => $slug,
            'description'         => $this->request->getVar('description'),
            'parent_category_id'  => $parentId,
            'created_by'          => $this->userdata->user_id,
          ];
          $results = $this->teamcategoryModel->save($catData);
        }else{
          $catData = [
            'name'                => $this->request->getVar('name'),
            'alias'               => $slug,
            'description'         => $this->request->getVar('description'),
            'parent_category_id'  => NULL,
            'created_by'          => $this->userdata->user_id,
          ];
          $results = $this->teamcategoryModel->save($catData);
        }

        if($results){
          // Enhanced notification for category creation
          $title = $this->request->getVar("name");
          $adminmessage = 'New Team Category Created: ' . $title;
          $notificationType = 'team';
          $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

          // Keep existing notification system for admins
          // $admins = $this->usersModel->getAdminUsers();
          // $message = 'Team Category: '.$title.'  CREATED';
          // foreach($admins as $m)
          // {
          //         $userz =[
          //         'message' 				=> $message,
          //         'user_id'		      => $m->id,
          //         'notification_type' => 'content',
          //         'created_by'      => $this->userdata->user_id,
          //     ];
          //     $this->notificationsModel->save($userz);	
          // }

          session()->setTempdata('success', 'Category created successfully');
          return redirect()->to(base_url('administrator/team/categories'));
        }else{
          session()->setTempdata('success', 'Category NOT created successfully');
          return redirect()->to(base_url('administrator/team/categories'));
        }
      }else{
        $this->data['validation'] = $this->validator;
      }

    }
    return View('Modules\Team\Views\category', $this->data);
  }
  public function editCategory($id = null)
  {
    $this->data['title'] = "Team Categories";
    $this->data['bcrumb'] = "Categories";

    $this->data['team_categories'] = $this->teamcategoryModel->getAll();
    $this->data['singleCategory'] = $this->teamcategoryModel->where('id', $id)->first($id);

    return View('Modules\Team\Views\category', $this->data);
  }
  public function updateCategory()
  {
    $this->data['title'] = "Team Categories";
    $this->data['bcrumb'] = "Categories";
    $this->data['team_categories'] = $this->teamcategoryModel->getAll();

    $id = $this->request->getVar('id');
    if($this->request->getMethod() == 'POST')
    {
      $rules = [
        'name' => ['label'=>'Category Name', 'rules'=>'required'],
      ];

      if($this->validate($rules))
      {
        $slug = preg_replace('/[^a-z0-9]+/i', '-', trim(strtolower($this->request->getVar('name'))));
        $parentId = $this->request->getVar('parent_category_id');
        if($parentId){
          $catData = [
            'name'                => $this->request->getVar('name'),
            'alias'               => $slug,
            'description'         => $this->request->getVar('description'),
            'parent_category_id'  => $parentId,
            'updated_by'          => $this->userdata->user_id,
          ];
          $results = $this->teamcategoryModel->update($id, $catData);
        }else{
          $catData = [
            'name'                => $this->request->getVar('name'),
            'alias'               => $slug,
            'description'         => $this->request->getVar('description'),
            'parent_category_id'  => NULL,
            'updated_by'          => $this->userdata->user_id,
          ];
          $results = $this->teamcategoryModel->update($id, $catData);
        }

        if($results){
          // Enhanced notification for category update
          $title = $this->request->getVar("name");
          $adminmessage = 'Team Category Updated: ' . $title;
          $notificationType = 'team';
          $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

          // Keep existing notification system for admins
          // $admins = $this->usersModel->getAdminUsers();
          // $message = 'Team Category: '.$title.'  UPDATED';
          // foreach($admins as $m)
          // {
          //         $userz =[
          //         'message' 				=> $message,
          //         'user_id'		      => $m->id,
          //         'notification_type' => 'content',
          //         'created_by'      => $this->userdata->user_id,
          //     ];
          //     $this->notificationsModel->save($userz);	
          // }

          session()->setTempdata('success', 'Category updated successfully');
          return redirect()->to(base_url('administrator/team/categories'));
        }else{
          session()->setTempdata('success', 'Category NOT updated');
          return redirect()->to(base_url('administrator/team/categories'));
        }
      }else{
        $this->data['validation'] = $this->validator;
      }

    }
    return View('Modules\Team\Views\category', $this->data);
  }
  public function delCategory($id)
  {
    $admins = $this->usersModel->getAdminUsers();
    $t = $this->teamcategoryModel->where('id', $id)->first($id);

    $this->teamcategoryModel->where('id', $id)->delete($id);
    
    // Enhanced notification for category deletion
    $categoryName = $t ? $t['name'] : 'Unknown Category';
    $adminmessage = 'Team Category Deleted: ' . $categoryName;
    $notificationType = 'team';
    $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);
        
    // Keep existing notification system for admins
    // $message = 'Team Category: '.$t['name'].'  DELETED';
    // foreach($admins as $m)
    // {
    //   $userz =[
    //     'message' 				=> $message,
    //     'user_id'		      => $m->id,
    //     'notification_type' => 'content',
    //     'created_by'      => $this->userdata->user_id,
    //   ];
    //   $this->notificationsModel->save($userz);	
    // }
      
    session()->setFlashdata('error', 'Category deleted successfully', 3);
		return redirect()->to('administrator/team/categories');
  }

  // Bulk operations for team members
  public function bulkMemberAction()
  {
      if ($this->request->getMethod() == 'POST') {
          $action = $this->request->getVar('action');
          $memberIds = $this->request->getVar('member_ids');

          if (empty($memberIds)) {
              if($this->request->isAJAX()) {
                  return $this->response->setJSON(['success' => false, 'message' => 'No team members selected']);
              } else {
                  session()->setTempdata('error', 'No team members selected', 3);
                  return redirect()->to('administrator/team/members');
              }
          }

          $successCount = 0;
          $failedCount = 0;

          foreach ($memberIds as $memberId) {
              $member = $this->teamModel->find($memberId);
              if (!$member) {
                  $failedCount++;
                  continue;
              }

              switch ($action) {
                  case 'activate':
                      if ($this->teamModel->update($memberId, ['status' => 1])) {
                          $successCount++;
                      } else {
                          $failedCount++;
                      }
                      break;
                  
                  case 'deactivate':
                      if ($this->teamModel->update($memberId, ['status' => 0])) {
                          $successCount++;
                      } else {
                          $failedCount++;
                      }
                      break;
                  
                  case 'delete':
                      // Delete member photo and record
                      if ($member && !empty($member['photo']) && strpos($member['photo'], 'http') !== 0 && strpos($member['photo'], '//') !== 0) {
                          $photoPath = ROOTPATH . 'media/files/' . ltrim($member['photo'], '/');
                          if (is_file($photoPath)) {
                              @unlink($photoPath);
                          }
                      }
                      if ($this->teamModel->delete($memberId)) {
                          $successCount++;
                      } else {
                          $failedCount++;
                      }
                      break;
                  
                  default:
                      $failedCount++;
                      break;
              }
          }

          if ($successCount > 0) {
              // Send notification for bulk action
              $adminmessage = 'Bulk Team Member Action: ' . $action . ' performed on ' . $successCount . ' members';
              $notificationType = 'team';
              $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

              if($this->request->isAJAX()) {
                  return $this->response->setJSON([
                      'success' => true,
                      'message' => $successCount . ' team members processed successfully'
                  ]);
              } else {
                  session()->setTempdata('success', $successCount . ' team members processed successfully', 3);
              }
          }

          if ($failedCount > 0) {
              if($this->request->isAJAX()) {
                  return $this->response->setJSON([
                      'success' => false,
                      'message' => $failedCount . ' team members failed to process'
                  ]);
              } else {
                  session()->setTempdata('error', $failedCount . ' team members failed to process', 3);
              }
          }
      }

      return redirect()->to('administrator/team/members');
  }

  // Bulk operations for categories
  public function bulkCategoryAction()
  {
      if ($this->request->getMethod() == 'POST') {
          $action = $this->request->getVar('action');
          $categoryIds = $this->request->getVar('category_ids');

          if (empty($categoryIds)) {
              if($this->request->isAJAX()) {
                  return $this->response->setJSON(['success' => false, 'message' => 'No categories selected']);
              } else {
                  session()->setTempdata('error', 'No categories selected', 3);
                  return redirect()->to('administrator/team/categories');
              }
          }

          $successCount = 0;
          $failedCount = 0;

          foreach ($categoryIds as $categoryId) {
              $category = $this->teamcategoryModel->find($categoryId);
              if (!$category) {
                  $failedCount++;
                  continue;
              }

              switch ($action) {
                  case 'delete':
                      if ($this->teamcategoryModel->delete($categoryId)) {
                          $successCount++;
                      } else {
                          $failedCount++;
                      }
                      break;
                  
                  default:
                      $failedCount++;
                      break;
              }
          }

          if ($successCount > 0) {
              // Send notification for bulk action
              $adminmessage = 'Bulk Team Category Action: ' . $action . ' performed on ' . $successCount . ' categories';
              $notificationType = 'team';
              $this->sendAdminNotifications($adminmessage, $notificationType, $this->userdata->user_id);

              if($this->request->isAJAX()) {
                  return $this->response->setJSON([
                      'success' => true,
                      'message' => $successCount . ' categories processed successfully'
                  ]);
              } else {
                  session()->setTempdata('success', $successCount . ' categories processed successfully', 3);
              }
          }

          if ($failedCount > 0) {
              if($this->request->isAJAX()) {
                  return $this->response->setJSON([
                      'success' => false,
                      'message' => $failedCount . ' categories failed to process'
                  ]);
              } else {
                  session()->setTempdata('error', $failedCount . ' categories failed to process', 3);
              }
          }
      }

      return redirect()->to('administrator/team/categories');
  }
}