<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Slider Categories</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/sliders/dashboard') ?> ">Slider's Dashboard</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
		<!-- End Breadcrumb !-->
	</div>
</div>
<!-- Slider Category ADD/EDIT/DELETE/Detailed List !-->
<div class="row mb-2">
    <div class="col">

			<!-- print success message !-->
			<?php if(session()->getTempdata('success')): ?>
				<div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
				<?php endif;?>
			<!-- print failure message !-->
			<?php if(session()->getTempdata('error')): ?>
				<div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
			<?php endif;?>
            <div id="showMsg"></div>
            <div ><a href="<?= base_url('administrator/sliders/add');?>" title="Add Slider" class="btn btn-sm btn-warning float-end rounded-0">Add Slide</a> <a href="<?= base_url('administrator/sliders/dashboard'); ?>" class="btn btn-sm btn-primary rounded-0 float-md-end">Back to Dashboard</a></div>
</div></div>

<div class="row">
    <div class="col-lg-4"> 
        <div class="card">
                <?php if(!isset($singleCategory)):?>
				<div class="card-header"><h6 class="card-title fw-bold">Add Category</h6></div>
				<div class="card-body ">
                <!-- Add Category  !-->
                <form method="POST" action="<?= base_url('administrator/sliders/category/add');?>">
                <?= csrf_field();?>
                <div class="row">
                    <div class="mb-3">
                        <label class="form-label">Category Name</label>
                        <input type="text" class="form-control" name="name">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Description</label>
                        <textarea class="form-control" name="description" style="height: 80px;"></textarea>
                    </div>
                    <div class="mb-3">
                        <button type="submit" class="btn btn-outline-danger w-100" >Save</button>
                    </div>
                </div>
                </form>
            </div>
                <!-- End Add Category  !-->
                <?php else:?>
                <div class="card-header"><h6 class="card-title fw-bold">Edit Category</h6></div>
                <div class="card-body ">
                <!-- Edit Category  !-->
                    <form method="POST" action="<?= base_url('administrator/sliders/category/update');?>">
                    <?= csrf_field();?>
                    <div class="row">
                        <div class="mb-3">
                            <label class="form-label">Category Name</label>
                            <input type="text" class="form-control" name="name" value="<?= $singleCategory['name']; ?>">
                        </div>
                        <div class="mb-3">
                            <label class="form-label">Description</label>
                            <textarea class="form-control" name="description" style="height: 80px;"><?= $singleCategory['description']; ?></textarea>
                        </div>
                        <div class="mb-3">
                            <input type="hidden" name="id" value="<?= $singleCategory['id']; ?>" >
                            <button type="submit" class="btn btn-outline-danger w-100" >Edit</button>
                        </div>
                    </div>
                    </form>
                <!-- End Edit Category  !-->
                </div>
                <?php endif; ?>
        </div>
    </div>
    <div class="col-lg-8 "> 
        <!-- Display all categories !-->
        <div class="card">
        <div class="card-header"><h6 class="card-title fw-bold">Slider Categories</h6></div> 
            <div class="card-body">
        <div class="table-responsive">
            <table id="catlist" class="table table-hover">
                <thead class="bg-primary bg-opacity-10" style="font-size: 14px;">
                    <tr>
                    <th>#</th>
                    <th>Title</th>
                    <th>Description</th>
                    <th>Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($slider_categories as $c): ?>
                        <tr>
                        <td><?= $c->id; ?></td>
                        <td><?= $c->name; ?> <small class="text-muted"> (<?= $c->alias; ?>)</small></td>
                        <td> <small class="text-muted"><small><?= $c->description; ?></small> </td>
                        <td>
                        <div class="btn-group" role="group" aria-label="edit category">
                        <a href="<?= base_url('administrator/sliders/category/edit/').'/'.$c->id; ?>" type="button" class="btn btn-success p-1 rounded-left"><small><i class="bi bi-pencil-square mx-0 "></i></small></a>
                        <a  class="btn btn-danger p-1 rounded-right" onclick="delete_sliderCategory(<?= $c->id ?>, '<?= $c->name ?>')"><small><i class="bi bi-trash mx-0" ></i></small></a>
                        </div>
                        </td>
                        </tr>
                    <?php endforeach;?>
                </tbody>
            </table>
        </div>
    </div></div>
            
<!-- END Post Category ADD/EDIT/DELETE/Detailed List !-->
<!-- Modals !-->
<?= view('Modules\Posts\Views\\modals\\del_categoryModal') ?>
<!---- JS --->  
<script type="text/javascript">
    $(document).ready(function () {
    $('#catlist').DataTable({
        pageLength: 10,
        order: [[0, "Desc"]],
    });
    });

</script>        
<script src="<?= base_url();?>/assets/admin_assets/js/modules/sliders.js"></script>  
<?= $this->endSection();?>