<?= $this->extend('Modules\Admin\Views\index'); ?>
<?= $this->section('content');?>
<div class="container-fluid">
<div class="row mb-md-3">
	<div class="col">
		<h4>Add Slide</h4>
		<!-- Breadcrumb !-->
		<nav aria-label="breadcrumb"><small>
			<ol class="breadcrumb mb-0">
				<li class="breadcrumb-item"><a href="<?= base_url('administrator') ?> ">Home</a></li>
                <li class="breadcrumb-item"><a href="<?= base_url('administrator/sliders/all') ?> ">All Slides</a></li>
				<li class="breadcrumb-item active" aria-current="page"><?= esc($bcrumb) ?> </li>
			</ol></small>
		</nav>
	</div>
</div>

<!-- Messages -->
<div class="row">
    <div class="col">
        <?php if(session()->getTempdata('success')): ?>
            <div class="alert alert-success" role="alert"><?= session()->getTempdata('success');?></div>
        <?php endif;?>
        <?php if(session()->getTempdata('error')): ?>
            <div class="alert alert-danger" role="alert"><?= session()->getTempdata('error');?></div>
        <?php endif;?>
        <?php if(isset($validation)): ?>
            <div class="alert alert-danger"><?= $validation->listErrors()?></div>
        <?php endif;?>
        <div id="showMsg"></div>
    </div>
</div>

<!-- Create Slide Form -->
<form method="POST" action="<?= base_url('administrator/sliders/add')?>" enctype="multipart/form-data">
<?= csrf_field();?>
    <div class="card rounded-0 shadow-sm">
        <div class="card-header bg-light bg-opacity-100">
            <div class="d-flex bd-highlight align-items-center">
                <div class="p-1 bd-highlight align-items-center">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-success rounded-0"><i class="bi bi-plus-lg text-white"></i></button>
                        <button type="submit" class="btn btn-sm btn-success align-items-center"> &nbsp; Save &nbsp;</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-danger bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                        <button type="reset" class="btn btn-sm btn-danger">Reset</button>
                    </div>
                </div>
                <div class="p-1 bd-highlight">
                    <div class="btn-group border shadow-sm">
                        <button type="button" class="btn bg-primary bg-opacity-25 rounded-0"><i class="bi bi-x-lg"></i></button>
                        <a href="<?= base_url('administrator/sliders/all') ?>" class="btn btn-sm btn-primary">Back to Slides</a>
                    </div>
                </div>
            </div>
        </div>
        <div class="card-body">
            <!-- Row 1: Basic Info and Links -->
            <div class="row mb-4">
                <!-- Basic Information Section -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-primary text-white">
                            <strong><i class="fas fa-info-circle"></i> Basic Information</strong>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label"><strong>Title</strong></label>
                                <input type="text" name="title" class="form-control" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label"><strong>Category</strong></label>
                                <select name="category_id" class="form-select" required>
                                    <option value="">Select Category</option>
                                    <?php foreach($categories as $cat): ?>
                                        <option value="<?= $cat->id;?>"><?= $cat->name;?></option>
                                    <?php endforeach;?>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label"><strong>Description</strong></label>
                                <textarea name="description" class="form-control" rows="3" placeholder="Write description text here.."></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Links Section -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-info text-white">
                            <strong><i class="fas fa-link"></i> Links Configuration</strong>
                        </div>
                        <div class="card-body">
                            <!-- Primary Link -->
                            <div class="mb-4">
                                <label class="form-label"><strong>Primary Link</strong></label>
                                <div class="row g-2">
                                    <div class="col-md-4">
                                        <input type="text" name="link_text" class="form-control" placeholder="Link Text">
                                    </div>
                                    <div class="col-md-4">
                                        <div class="position-relative">
                                            <input type="text" name="link" id="link" class="form-control" placeholder="Link URL" autocomplete="off">
                                            <div id="linkSearchResults" class="list-group" style="z-index:1050; position: absolute; left: 0; right: 0; display: none;"></div>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <select name="link_icon" class="form-select">
                                            <option value="fas fa-info-circle">Info Circle</option>
                                            <option value="fas fa-user-plus">User Plus</option>
                                            <option value="fas fa-rocket">Rocket</option>
                                            <option value="fas fa-bank">Bank</option>
                                            <option value="fas fa-credit-card">Credit Card</option>
                                            <option value="fas fa-money-bill">Money</option>
                                            <option value="fas fa-chart-line">Chart</option>
                                        </select>
                                    </div>
                                </div>
                                <input type="hidden" name="selected_link_id" id="selected_link_id">
                                <input type="hidden" name="selected_link_type" id="selected_link_type">
                            </div>

                            <!-- Secondary Link -->
                            <div class="mb-3">
                                <label class="form-label"><strong>Secondary Link</strong></label>
                                <div class="row g-2">
                                    <div class="col-md-4">
                                        <input type="text" name="link_2_text" class="form-control" placeholder="Link Text">
                                    </div>
                                    <div class="col-md-4">
                                        <input type="text" name="link_2" class="form-control" placeholder="Link URL">
                                    </div>
                                    <div class="col-md-4">
                                        <select name="link_2_icon" class="form-select">
                                            <option value="fas fa-phone-alt">Phone</option>
                                            <option value="fas fa-envelope">Envelope</option>
                                            <option value="fas fa-compass">Compass</option>
                                            <option value="fas fa-concierge-bell">Service Bell</option>
                                            <option value="fas fa-handshake">Handshake</option>
                                            <option value="fas fa-comments">Comments</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Row 2: Classification and Media -->
            <div class="row mb-4">
                <!-- Classification Section -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-success text-white">
                            <strong><i class="fas fa-tags"></i> Classification</strong>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Service Group</strong></label>
                                        <select name="service_group" class="form-select">
                                            <option value="general">General</option>
                                            <option value="current">Current Account</option>
                                            <option value="saving">Savings</option>
                                            <option value="loans">Loans</option>
                                            <option value="investing">Investing</option>
                                            <option value="insurance">Insurance</option>
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Navigation Context</strong></label>
                                        <select name="nav_context" class="form-select">
                                            <option value="personal">Personal Banking</option>
                                            <option value="business">Business Banking</option>
                                            <option value="forex">Forex Trading</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="form-label"><strong>Template Group</strong></label>
                                <input type="text" name="template_group" class="form-control" value="default">
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Media Section -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-info text-white">
                            <strong><i class="fas fa-images"></i> Media</strong>
                        </div>
                        <div class="card-body">
                            <!-- Main Image -->
                            <div class="mb-3">
                                <label class="form-label"><strong>Main Image</strong></label>
                                <div class="image-preview-container" style="height: 200px; background: #F2F9FF; border-radius: 5px; position: relative; overflow: hidden; cursor: pointer;">
                                    <div id="postImgPreview" style="width: 100%; height: 100%; display: flex; align-items: center; justify-content: center; color: #666; font-size: 14px;">
                                        <div class="text-center">
                                            <i class="fas fa-cloud-upload-alt fa-2x mb-2"></i><br>
                                            <span>Click to select image or<br>drag and drop</span>
                                        </div>
                                    </div>
                                </div>
                                <input type="file" name="photo" id="post_image" class="postImg upload-photo" accept=".jpg, .gif, .png, .tiff, .jpeg, .webp" required style="display: none;">
                                <div class="d-grid gap-2 mt-2">
                                    <button type="button" class="btn btn-outline-primary btn-sm" onclick="document.getElementById('post_image').click()">
                                        <i class="fas fa-image"></i> Choose Main Image
                                    </button>
                                </div>
                            </div>

                            <!-- Background Image -->
                            <div class="mb-3">
                                <label class="form-label"><strong>Background Image</strong> <small class="text-muted">(Optional)</small></label>
                                <input type="file" name="background-img" class="form-control form-control-sm" accept=".jpg, .gif, .png, .tiff, .jpeg, .webp">
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Row 3: Publishing Options and Extra Info -->
            <div class="row">
                <!-- Publishing Options -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-warning">
                            <strong><i class="fas fa-cog"></i> Publishing Options</strong>
                        </div>
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label"><strong>Status</strong></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-toggle-on"></i></span>
                                    <select name="status" class="form-select">
                                        <option value="published" class="text-success">Published</option>
                                        <option value="unpublished" class="text-warning">Unpublished</option>
                                        <option value="archived" class="text-secondary">Archived</option>
                                        <option value="trashed" class="text-danger">Trashed</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label"><strong>Access Level</strong></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-lock"></i></span>
                                    <select name="access" class="form-select">
                                        <option value="public">Public</option>
                                        <option value="admin">Admin Only</option>
                                        <option value="user">Registered Users</option>
                                    </select>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label"><strong>Display Order</strong></label>
                                <div class="input-group">
                                    <span class="input-group-text"><i class="fas fa-sort-numeric-down"></i></span>
                                    <select name="ordering" class="form-select">
                                        <?php for($i = 1; $i <= 10; $i++): ?>
                                            <option value="<?= $i ?>"><?= $i ?></option>
                                        <?php endfor; ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Extra Information -->
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-header bg-secondary text-white">
                            <strong><i class="fas fa-plus-circle"></i> Extra Information</strong>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Extra Text 1</strong></label>
                                        <input type="text" name="extra_1" class="form-control">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Extra Text 2</strong></label>
                                        <input type="text" name="extra_2" class="form-control">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Extra Text 3</strong></label>
                                        <input type="text" name="extra_3" class="form-control">
                                    </div>
                                    <div class="mb-3">
                                        <label class="form-label"><strong>Extra Text 4</strong></label>
                                        <input type="text" name="extra_4" class="form-control">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</form>

<!---- JS --->
<script src="<?= base_url();?>/assets/admin_assets/js/modules/sliders.js"></script>  
<?= $this->endSection();?>